/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.jcomm.Serial4610ConnectionClient;
import com.ibm.jpos.services.jcomm.Serial4610Const;
import com.ibm.jpos.services.jcomm.Serial4610Event;
import com.ibm.jpos.services.jcomm.SerialPortFactory;
import com.ibm.jpos.util.BooleanMonitor;
import com.ibm.jpos.util.Tracer;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;
import jpos.JposConst;
import jpos.JposException;
import jpos.POSPrinterConst;

class Serial4610Connection
implements JposConst,
POSPrinterConst,
Serial4610Const {
    private static final String className = "Serial4610Connection";
    private static Vector connectionVector = new Vector();
    private Thread serialEventThread = null;
    private int defaultCodePage = -1;
    private int codePage = -1;
    private SerialPort serialPort = null;
    private Vector clientVector = new Vector();
    private BooleanMonitor deviceOnline = new BooleanMonitor(false);
    private BooleanMonitor mctValueAvailable = new BooleanMonitor(false);
    private int mctValue = 0;
    private String portName = "COM1";
    private byte[] printerID = new byte[5];
    private byte[] status = null;
    private Object clientThreadLock = new Object();
    private PushbackInputStream serialPortInputStream = null;

    private Serial4610Connection(String string, int n) throws JposException {
        Tracer.trace(4, className, "Serial4610Connection(\"" + string + "\", " + Integer.toString(n) + ")", "Entry");
        this.portName = string;
        try {
            this.serialPort = SerialPortFactory.open(string, n, 8, 1, 0, 12);
            this.serialPortInputStream = new PushbackInputStream(this.serialPort.getInputStream(), 2);
        }
        catch (NoSuchPortException noSuchPortException) {
            throw new JposException(108, string + ": no such port", noSuchPortException);
        }
        catch (PortInUseException portInUseException) {
            throw new JposException(111, string + ": port in use", portInUseException);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new JposException(111, string + ": unsupported comm operation", unsupportedCommOperationException);
        }
        catch (IOException iOException) {
            Tracer.trace(4, className, "Serial4610Connection()", "*** ERROR: can't create pushback stream");
        }
        catch (Exception exception) {
            throw new JposException(111, exception.getMessage(), exception);
        }
        if (!this.serialPort.isDSR()) {
            this.serialPort.close();
            this.serialPort = null;
            throw new JposException(108);
        }
        try {
            this.serialPort.addEventListener(new SerialPortEventManager());
        }
        catch (TooManyListenersException tooManyListenersException) {
            Tracer.trace(6, className, "Serial4610Connection()", "*** ERROR: Caught TooManyListenersException");
        }
        try {
            this.write(new byte[]{16, 5, 64});
            this.milliSleep(3000);
            this.serialPort.notifyOnDSR(true);
            this.serialPort.notifyOnDataAvailable(true);
            this.setDefaultCodePage();
            this.configureDevice();
            this.deviceOnline.waitForTrue(3000);
        }
        catch (Exception exception) {
            this.serialPort.close();
            this.serialPort = null;
            this.serialPortInputStream = null;
            throw new JposException(108);
        }
        Tracer.trace(4, className, "Serial4610Connection()", "Exit");
    }

    private int getMctValue(int n) throws JposException, IOException {
        Tracer.trace(4, className, "getMctValue()", "Entry");
        this.mctValueAvailable.set(false);
        this.write(new byte[]{27, 83, (byte)n});
        this.mctValueAvailable.waitFor(true, 2000);
        Tracer.trace(4, className, "getMctValue()", "0x" + (n < 16 ? "0" : "") + Integer.toHexString(n & 0xFF) + " == 0x" + ((this.mctValue | 0xF000) == 0 ? "0" : "") + ((this.mctValue | 0xFF00) == 0 ? "0" : "") + ((this.mctValue | 0xFFF0) == 0 ? "0" : "") + Integer.toHexString(this.mctValue & 0xFFFF));
        Tracer.trace(4, className, "getMctValue()", "Exit");
        return this.mctValue;
    }

    private void setMctValue(int n, int n2) throws JposException {
        Tracer.trace(4, className, "setMctValue()", "Entry");
        this.write(new byte[]{27, 77, (byte)n, (byte)(n2 >> 8), (byte)n2});
        Tracer.trace(4, className, "setMctValue()", "Exit");
    }

    public static Serial4610Connection open(Serial4610ConnectionClient serial4610ConnectionClient) throws JposException {
        Object object;
        Enumeration enumeration;
        Object object2;
        Tracer.trace(4, className, "open()", "Entry");
        String string = "COM1";
        int n = 19200;
        try {
            object2 = serial4610ConnectionClient.getJposEntry();
            enumeration = object2.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (((String)object).equalsIgnoreCase("commComPort")) {
                    string = object2.getPropertyValue((String)object).toString();
                    continue;
                }
                if (!((String)object).equalsIgnoreCase("commBaudRate")) continue;
                n = Integer.parseInt(object2.getPropertyValue((String)object).toString());
            }
        }
        catch (Exception exception) {
            throw new JposException(111, "JPOS_E_FAILURE: bad configuration", exception);
        }
        object2 = null;
        object = connectionVector;
        synchronized (object) {
            enumeration = connectionVector.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Serial4610Connection)enumeration.nextElement();
                if (super.getPortName().equals(string)) break;
                object2 = null;
            }
            if (object2 == null) {
                object2 = new Serial4610Connection(string, n);
                connectionVector.addElement(object2);
            }
            ((Serial4610Connection)object2).clientVector.addElement(serial4610ConnectionClient);
        }
        Tracer.trace(4, className, "open()", "Exit");
        return object2;
    }

    public void close(Serial4610ConnectionClient serial4610ConnectionClient) {
        Tracer.trace(4, className, "close()", "Entry");
        Object object = this.clientThreadLock;
        synchronized (object) {
            Vector vector = connectionVector;
            synchronized (vector) {
                Tracer.trace(5, className, "close()", "D0");
                if (this.clientVector.contains(serial4610ConnectionClient)) {
                    this.clientVector.removeElement(serial4610ConnectionClient);
                    if (this.clientVector.size() == 0) {
                        connectionVector.removeElement(this);
                        try {
                            try {
                                Tracer.trace(4, className, "close()", "Closing serialPort");
                                this.serialPort.close();
                                Tracer.trace(4, className, "close()", "serialPort now closed");
                            }
                            catch (Exception exception) {
                                Tracer.trace(4, className, "close()", "Exception while closing serialPort:");
                                if (Tracer.getTraceLevel() >= 4) {
                                    exception.printStackTrace();
                                }
                                Object var6_5 = null;
                                this.serialPort = null;
                                this.serialPortInputStream = null;
                            }
                            Object var6_4 = null;
                            this.serialPort = null;
                            this.serialPortInputStream = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            this.serialPort = null;
                            this.serialPortInputStream = null;
                            throw throwable;
                        }
                    }
                }
            }
            Tracer.trace(4, className, "close()", "Exit");
        }
    }

    private int write(byte[] byArray, int n) throws JposException {
        Tracer.trace(4, className, "write()", "Entry");
        Object object = this.clientThreadLock;
        synchronized (object) {
            if (Tracer.getTraceLevel() >= 4) {
                StringBuffer stringBuffer = new StringBuffer("bytes (hex): [");
                int n2 = 0;
                while (n2 < n) {
                    if (n2 != 0) {
                        stringBuffer.append(" ");
                    }
                    if ((byArray[n2] & 0xFFFFFFF0) == 0) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(Integer.toHexString(byArray[n2] & 0xFF));
                    ++n2;
                }
                stringBuffer.append("]");
                Tracer.trace(4, className, "write()", stringBuffer.toString());
            }
            try {
                this.serialPort.getOutputStream().write(byArray, 0, n);
            }
            catch (IOException iOException) {
                throw new JposException(111, "JPOS_E_FAILURE: I/O Exception", iOException);
            }
            Tracer.trace(4, className, "write()", "Exit");
            int n3 = n;
            return n3;
        }
    }

    private int write(byte[] byArray) throws JposException {
        return this.write(byArray, byArray.length);
    }

    public int write(Serial4610ConnectionClient serial4610ConnectionClient, byte[] byArray) throws JposException {
        return this.write(serial4610ConnectionClient, byArray, byArray.length);
    }

    public int write(Serial4610ConnectionClient serial4610ConnectionClient, byte[] byArray, int n) throws JposException {
        if (!this.clientVector.contains(serial4610ConnectionClient)) {
            Tracer.trace(4, className, "write()", "Entry");
            throw new JposException(101);
        }
        if (!this.isOnline()) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isOnline()) {
                throw new JposException(108);
            }
        }
        return this.write(byArray, n);
    }

    public boolean isOnline(Serial4610ConnectionClient serial4610ConnectionClient) throws JposException {
        Object object = this.clientThreadLock;
        synchronized (object) {
            if (!this.clientVector.contains(serial4610ConnectionClient)) {
                Tracer.trace(4, className, "isOnline()", "Entry");
                throw new JposException(101);
            }
            boolean bl = this.isOnline();
            return bl;
        }
    }

    private boolean isOnline() {
        Tracer.trace(4, className, "isOnline()", "Entry");
        boolean bl = this.deviceOnline.is(true);
        Tracer.trace(4, className, "isOnline()", "Returning " + (bl ? "true" : "false"));
        return bl;
    }

    public byte[] getPrinterID(Serial4610ConnectionClient serial4610ConnectionClient) throws JposException {
        if (!this.clientVector.contains(serial4610ConnectionClient)) {
            throw new JposException(101);
        }
        try {
            this.deviceOnline.waitFor(true, 2000);
        }
        catch (JposException jposException) {
            throw new JposException(108);
        }
        byte[] byArray = new byte[this.printerID.length];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = this.printerID[n];
            ++n;
        }
        return byArray;
    }

    private void milliSleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void finalize() {
        try {
            try {
                this.serialPort.close();
            }
            catch (Exception exception) {
                Object var3_2 = null;
                this.serialPort = null;
                this.serialPortInputStream = null;
            }
            Object var3_1 = null;
            this.serialPort = null;
            this.serialPortInputStream = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.serialPort = null;
            this.serialPortInputStream = null;
            throw throwable;
        }
    }

    private void setDefaultCodePage() throws JposException {
        Tracer.trace(4, className, "setDefaultCodePage()", "Entry");
        try {
            this.setCodePage(this.getMctValue(80));
        }
        catch (Exception exception) {
            this.setCodePage(858);
        }
        this.defaultCodePage = this.codePage;
        Tracer.trace(4, className, "setDefaultCodePage()", "Exit");
    }

    public int getDefaultCodePage(Serial4610ConnectionClient serial4610ConnectionClient) throws JposException {
        Tracer.trace(4, className, "getDefaultCodePage()", "Entry");
        if (!this.clientVector.contains(serial4610ConnectionClient)) {
            throw new JposException(101);
        }
        Tracer.trace(4, className, "getDefaultCodePage()", "Returning " + Integer.toString(this.defaultCodePage));
        return this.defaultCodePage;
    }

    public int getCodePage(Serial4610ConnectionClient serial4610ConnectionClient) throws JposException {
        Tracer.trace(4, className, "getCodePage()", "Entry");
        if (!this.clientVector.contains(serial4610ConnectionClient)) {
            throw new JposException(101);
        }
        Tracer.trace(4, className, "getCodePage()", "Returning " + Integer.toString(this.codePage));
        return this.codePage;
    }

    public void setCodePage(Serial4610ConnectionClient serial4610ConnectionClient, int n) throws JposException {
        Tracer.trace(6, className, "setCodePage(client, codePage)", "Entry");
        Object object = this.clientThreadLock;
        synchronized (object) {
            if (!this.clientVector.contains(serial4610ConnectionClient)) {
                throw new JposException(101);
            }
            this.setCodePage(n);
            Tracer.trace(6, className, "setCodePage()", "Exit");
        }
    }

    private void setCodePage(int n) throws JposException {
        Tracer.trace(4, className, "setCodePage(" + Integer.toString(n) + ")", "Entry");
        try {
            byte[] byArray = new byte[]{27, 37, 0, 27, 116, 0};
            switch (n) {
                case 865: {
                    byArray[5] = (byte)(byArray[5] + 1);
                }
                case 860: {
                    byArray[5] = (byte)(byArray[5] + 1);
                }
                case 863: {
                    byArray[5] = (byte)(byArray[5] + 1);
                }
                case 858: {
                    byArray[5] = (byte)(byArray[5] + 1);
                }
                case 437: {
                    this.write(byArray);
                    break;
                }
                case 932: 
                case 949: 
                case 950: 
                case 1381: {
                    byArray[2] = (byte)(byArray[2] + 1);
                    if (this.serialEventThread != null && this.serialEventThread != Thread.currentThread() && ((this.getMctValue(16) & 0x80) != 0 || this.getMctValue(80) != n)) {
                        throw new JposException(106, "JPOS_E_ILLEGAL: unsupported character set");
                    }
                    this.write(byArray, 3);
                    break;
                }
                default: {
                    throw new JposException(106, "JPOS_E_ILLEGAL: unsupported character set");
                }
            }
            this.codePage = n;
        }
        catch (IOException iOException) {
            throw new JposException(111, "JPOS_E_FAILURE: I/O Exception", iOException);
        }
    }

    public byte[] getStatus(Serial4610ConnectionClient serial4610ConnectionClient) throws JposException {
        Tracer.trace(4, className, "getStatus()", "Entry");
        if (!this.clientVector.contains(serial4610ConnectionClient)) {
            throw new JposException(101);
        }
        byte[] byArray = new byte[8];
        System.arraycopy(this.status, 0, byArray, 0, 8);
        Tracer.trace(4, className, "getStatus()", "Exit");
        return byArray;
    }

    public Object getIOSemaphore() {
        return this.clientThreadLock;
    }

    private String getPortName() {
        return this.portName;
    }

    private void configureDevice() throws JposException {
        Tracer.trace(4, className, "configureDevice()", "Entry");
        Object object = this.clientThreadLock;
        synchronized (object) {
            this.deviceOnline.set(false);
            this.setCodePage(this.codePage);
            this.write(new byte[]{27, 56, 1, 27, 41, 80, 16, 5, 65, 27, 83, 1, 27, 83, 16, 27, 83, 80, 29, 73, 1});
        }
        if (this.serialEventThread == null) {
            Tracer.trace(4, className, "configureDevice()", "serialEventThread is null");
        }
        if (this.serialEventThread == Thread.currentThread()) {
            Tracer.trace(4, className, "configureDevice()", "context is serialEventThread");
        }
        if (this.serialEventThread != null && this.serialEventThread != Thread.currentThread()) {
            try {
                Tracer.trace(4, className, "configureDevice()", "waiting for online");
            }
            catch (Exception exception) {
                Tracer.trace(4, className, "configureDevice()", "timed out");
            }
        }
        Tracer.trace(4, className, "configureDevice()", "Exit");
    }

    static /* synthetic */ Thread access$300(Serial4610Connection serial4610Connection) {
        return serial4610Connection.serialEventThread;
    }

    static /* synthetic */ Thread access$302(Serial4610Connection serial4610Connection, Thread thread) {
        serial4610Connection.serialEventThread = thread;
        return serial4610Connection.serialEventThread;
    }

    static /* synthetic */ BooleanMonitor access$400(Serial4610Connection serial4610Connection) {
        return serial4610Connection.deviceOnline;
    }

    static /* synthetic */ void access$500(Serial4610Connection serial4610Connection, int n) {
        serial4610Connection.milliSleep(n);
    }

    static /* synthetic */ void access$600(Serial4610Connection serial4610Connection) throws JposException {
        serial4610Connection.configureDevice();
    }

    static /* synthetic */ SerialPort access$700(Serial4610Connection serial4610Connection) {
        return serial4610Connection.serialPort;
    }

    static /* synthetic */ Vector access$800(Serial4610Connection serial4610Connection) {
        return serial4610Connection.clientVector;
    }

    static /* synthetic */ PushbackInputStream access$900(Serial4610Connection serial4610Connection) {
        return serial4610Connection.serialPortInputStream;
    }

    static /* synthetic */ byte[] access$1000(Serial4610Connection serial4610Connection) {
        return serial4610Connection.status;
    }

    static /* synthetic */ byte[] access$1002(Serial4610Connection serial4610Connection, byte[] byArray) {
        serial4610Connection.status = byArray;
        return byArray;
    }

    static /* synthetic */ BooleanMonitor access$1100(Serial4610Connection serial4610Connection) {
        return serial4610Connection.mctValueAvailable;
    }

    static /* synthetic */ int access$1202(Serial4610Connection serial4610Connection, int n) {
        serial4610Connection.mctValue = n;
        return serial4610Connection.mctValue;
    }

    static /* synthetic */ int access$1300(Serial4610Connection serial4610Connection, byte[] byArray) throws JposException {
        return serial4610Connection.write(byArray);
    }

    static /* synthetic */ byte[] access$1402(Serial4610Connection serial4610Connection, byte[] byArray) {
        serial4610Connection.printerID = byArray;
        return byArray;
    }

    private class SerialPortEventManager
    implements SerialPortEventListener {
        private static final String className = "SerialPortEventManager";
        private SerialPortEventQueue serialPortEventQueue = new SerialPortEventQueue();
        private Runnable runnableImpl = new RunnableImpl();
        private Thread thread = new Thread(this.runnableImpl);

        public SerialPortEventManager() {
            this.thread.start();
        }

        public void serialEvent(SerialPortEvent serialPortEvent) {
            Tracer.trace(3, className, "serialEvent()", "Entry");
            this.serialPortEventQueue.add(serialPortEvent);
            Tracer.trace(3, className, "serialEvent()", "Exit");
        }

        static /* synthetic */ SerialPortEventQueue access$000(SerialPortEventManager serialPortEventManager) {
            return serialPortEventManager.serialPortEventQueue;
        }

        static /* synthetic */ Thread access$102(SerialPortEventManager serialPortEventManager, Thread thread) {
            serialPortEventManager.thread = thread;
            return serialPortEventManager.thread;
        }

        static /* synthetic */ Thread access$100(SerialPortEventManager serialPortEventManager) {
            return serialPortEventManager.thread;
        }

        static /* synthetic */ Serial4610Connection access$200(SerialPortEventManager serialPortEventManager) {
            return serialPortEventManager.Serial4610Connection.this;
        }

        private class SerialPortEventQueue {
            private ArrayList list = new ArrayList();

            private SerialPortEventQueue() {
            }

            public synchronized SerialPortEvent remove() throws InterruptedException {
                while (this.list.isEmpty()) {
                    this.wait();
                }
                return (SerialPortEvent)this.list.remove(0);
            }

            public synchronized void add(SerialPortEvent serialPortEvent) {
                this.list.add(serialPortEvent);
                this.notify();
            }

            public final synchronized void clear() {
                try {
                    this.list.clear();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }

            public final int size() {
                return this.list.size();
            }

            public boolean isEmpty() {
                return this.list.isEmpty();
            }
        }

        private class RunnableImpl
        implements Runnable {
            private static final String className = "SerialPortEventManager.RunnableImpl";

            private RunnableImpl() {
            }

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block48: {
                    var1_1 = null;
                    var2_2 = null;
                    while (true) {
                        try {
                            var1_1 = SerialPortEventManager.access$000(SerialPortEventManager.this).remove();
                        }
                        catch (InterruptedException var3_4) {
                            SerialPortEventManager.access$102(SerialPortEventManager.this, null);
                        }
                        if (SerialPortEventManager.access$100(SerialPortEventManager.this) == null) {
                            return;
                        }
                        if (Serial4610Connection.access$300(SerialPortEventManager.access$200(SerialPortEventManager.this)) == null) {
                            Serial4610Connection.access$302(SerialPortEventManager.access$200(SerialPortEventManager.this), Thread.currentThread());
                        }
                        block12 : switch (var1_1.getEventType()) {
                            case 4: {
                                Tracer.trace(4, "SerialPortEventManager.RunnableImpl", "run()", "EventType == DSR");
                                if (var1_1.getNewValue()) {
                                    Tracer.trace(4, "SerialPortEventManager.RunnableImpl", "run()", "DSR is asserted");
                                    if (!Serial4610Connection.access$400(SerialPortEventManager.access$200(SerialPortEventManager.this)).is(false)) break;
                                    Serial4610Connection.access$500(SerialPortEventManager.access$200(SerialPortEventManager.this), 3000);
                                    try {
                                        Serial4610Connection.access$600(SerialPortEventManager.access$200(SerialPortEventManager.this));
                                    }
                                    catch (Exception var3_5) {}
                                    break;
                                }
                                Tracer.trace(4, "SerialPortEventManager.RunnableImpl", "run()", "DSR is not asserted");
                                Serial4610Connection.access$500(SerialPortEventManager.access$200(SerialPortEventManager.this), 500);
                                if (Serial4610Connection.access$700(SerialPortEventManager.access$200(SerialPortEventManager.this)).isDSR()) {
                                    Tracer.trace(4, "SerialPortEventManager.RunnableImpl", "run()", "DSR is asserted (transient drop)");
                                    break;
                                }
                                Serial4610Connection.access$400(SerialPortEventManager.access$200(SerialPortEventManager.this)).set(false);
                                var3_3 /* !! */  = (byte[])Serial4610Connection.access$800(SerialPortEventManager.access$200(SerialPortEventManager.this));
                                synchronized (var3_3 /* !! */ ) {
                                    var4_7 = Serial4610Connection.access$800(SerialPortEventManager.access$200(SerialPortEventManager.this)).elements();
                                    while (true) {
                                        if (!var4_7.hasMoreElements()) {
                                            break block12;
                                        }
                                        try {
                                            ((Serial4610ConnectionClient)var4_7.nextElement()).serial4610EventOccurred(new Serial4610Event(1));
                                        }
                                        catch (Exception var5_11) {
                                            // empty catch block
                                        }
                                    }
                                }
                            }
                            case 1: {
                                Tracer.trace(4, "SerialPortEventManager.RunnableImpl", "run()", "EventType == DATA_AVAILABLE");
                                try lbl-1000:
                                // 3 sources

                                {
                                    while (true) {
                                        if (Serial4610Connection.access$900(SerialPortEventManager.access$200(SerialPortEventManager.this)).available() < 10) break block12;
                                        var3_3 /* !! */  = new byte[2];
                                        Serial4610Connection.access$900(SerialPortEventManager.access$200(SerialPortEventManager.this)).read(var3_3 /* !! */ , 0, 2);
                                        var4_8 = var3_3 /* !! */ [0] * 256 + (var3_3 /* !! */ [1] & 255) - 2;
                                        Tracer.trace(4, "SerialPortEventManager.RunnableImpl", "run()", "payload length: " + Integer.toString(var4_8));
                                        if (var4_8 < 8 || var4_8 > 253) {
                                            Tracer.trace(4, "SerialPortEventManager.RunnableImpl", "run()", "invalid payload length; flushing stream");
                                            Serial4610Connection.access$900(SerialPortEventManager.access$200(SerialPortEventManager.this)).skip(Serial4610Connection.access$900(SerialPortEventManager.access$200(SerialPortEventManager.this)).available());
                                            break block12;
                                        }
                                        if (Serial4610Connection.access$900(SerialPortEventManager.access$200(SerialPortEventManager.this)).available() < var4_8) {
                                            Tracer.trace(4, "SerialPortEventManager.RunnableImpl", "run()", "insufficient count of bytes available; pushing back partial message (2 bytes) and returning");
                                            Serial4610Connection.access$900(SerialPortEventManager.access$200(SerialPortEventManager.this)).unread(var3_3 /* !! */ );
                                            break block12;
                                        }
                                        var5_10 = new byte[8];
                                        Serial4610Connection.access$900(SerialPortEventManager.access$200(SerialPortEventManager.this)).read(var5_10, 0, 8);
                                        var6_12 = Serial4610Connection.access$1000(SerialPortEventManager.access$200(SerialPortEventManager.this));
                                        Serial4610Connection.access$1002(SerialPortEventManager.access$200(SerialPortEventManager.this), var5_10);
                                        var7_13 = new byte[var4_8 - 8];
                                        Serial4610Connection.access$900(SerialPortEventManager.access$200(SerialPortEventManager.this)).read(var7_13, 0, var7_13.length);
                                        if (Tracer.getTraceLevel() < 4) break block48;
                                        var8_14 = new StringBuffer("status (hex): [");
                                        var9_17 = 0;
                                        while (true) {
                                            if (var9_17 < var5_10.length) ** GOTO lbl84
                                            var8_14.append("]");
                                            Tracer.trace(4, "SerialPortEventManager.RunnableImpl", "run()", var8_14.toString());
                                            var8_14 = new StringBuffer("data (hex)  : [");
                                            var9_17 = 0;
                                            if (true) ** GOTO lbl112
lbl84:
                                            // 1 sources

                                            if (var9_17 != 0) {
                                                var8_14.append(" ");
                                            }
                                            if ((var5_10[var9_17] & -16) == 0) {
                                                var8_14.append("0");
                                            }
                                            var8_14.append(Integer.toHexString(var5_10[var9_17] & 255));
                                            ++var9_17;
                                        }
                                        break;
                                    }
                                }
                                catch (IOException var3_6) {
                                    Tracer.trace(4, "SerialPortEventManager.RunnableImpl", "run()", "*** ERROR: IOException while reading input stream.");
                                    break;
                                }
                                catch (Exception var4_9) {
                                    Tracer.trace(4, "SerialPortEventManager.RunnableImpl", "run()", "*** ERROR: Exception: " + var4_9.getMessage());
                                    break;
                                }
                            }
                        }
                        Tracer.trace(4, "SerialPortEventManager.RunnableImpl", "run()", "Exit");
                    }
                    do {
                        if (var9_17 != 0) {
                            var8_14.append(" ");
                        }
                        if ((var7_13[var9_17] & -16) == 0) {
                            var8_14.append("0");
                        }
                        var8_14.append(Integer.toHexString(var7_13[var9_17] & 255));
                        ++var9_17;
lbl112:
                        // 2 sources

                    } while (var9_17 < var7_13.length);
                    var8_14.append("]");
                    Tracer.trace(4, "SerialPortEventManager.RunnableImpl", "run()", var8_14.toString());
                }
                if ((var5_10[4] & 8) != 0 && var7_13.length == 2 && Serial4610Connection.access$1100(SerialPortEventManager.access$200(SerialPortEventManager.this)).is(false)) {
                    Serial4610Connection.access$1202(SerialPortEventManager.access$200(SerialPortEventManager.this), var7_13[0] << 8 & 65280 | var7_13[1] & 255);
                    Serial4610Connection.access$1100(SerialPortEventManager.access$200(SerialPortEventManager.this)).set(true);
                }
                if ((var5_10[4] & 1) != 0 && Serial4610Connection.access$400(SerialPortEventManager.access$200(SerialPortEventManager.this)).is(false)) {
                    if (var2_2 == null) {
                        var2_2 = new ArrayList<byte[]>(10);
                    }
                    var8_15 = 0;
                    var9_17 = 0;
                    while (var9_17 < var2_2.size()) {
                        if (var7_13[2] == ((byte[])var2_2.get(var9_17))[2] && var7_13[3] == ((byte[])var2_2.get(var9_17))[3]) {
                            ++var8_15;
                        }
                        ++var9_17;
                    }
                    if (var8_15 < 3) {
                        var2_2.add(var7_13);
                        Serial4610Connection.access$500(SerialPortEventManager.access$200(SerialPortEventManager.this), 200);
                        Serial4610Connection.access$1300(SerialPortEventManager.access$200(SerialPortEventManager.this), new byte[]{29, 73, 1});
                    } else {
                        var2_2 = null;
                        Serial4610Connection.access$1402(SerialPortEventManager.access$200(SerialPortEventManager.this), var7_13);
                        Serial4610Connection.access$400(SerialPortEventManager.access$200(SerialPortEventManager.this)).set(true);
                        var10_19 = new Serial4610Event(2);
                        var11_20 = Serial4610Connection.access$800(SerialPortEventManager.access$200(SerialPortEventManager.this));
                        synchronized (var11_20) {
                            var12_22 = Serial4610Connection.access$800(SerialPortEventManager.access$200(SerialPortEventManager.this)).elements();
                            while (var12_22.hasMoreElements()) {
                                try {
                                    ((Serial4610ConnectionClient)var12_22.nextElement()).serial4610EventOccurred((Serial4610Event)var10_19);
                                }
                                catch (Exception var13_23) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                if (!Serial4610Connection.access$400(SerialPortEventManager.access$200(SerialPortEventManager.this)).isTrue()) ** GOTO lbl-1000
                var8_16 = new Serial4610Event(3, Serial4610Connection.access$1000(SerialPortEventManager.access$200(SerialPortEventManager.this)), var7_13);
                var9_18 = Serial4610Connection.access$800(SerialPortEventManager.access$200(SerialPortEventManager.this));
                synchronized (var9_18) {
                    var10_19 = Serial4610Connection.access$800(SerialPortEventManager.access$200(SerialPortEventManager.this)).elements();
                    while (var10_19.hasMoreElements()) {
                        try {
                            ((Serial4610ConnectionClient)var10_19.nextElement()).serial4610EventOccurred(var8_16);
                        }
                        catch (Exception var11_21) {
                            // empty catch block
                        }
                    }
                }
                ** while (true)
            }
        }
    }
}

