/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.LineDisplayServiceState;
import com.ibm.jpos.services.jcomm.CommApi4840LineDisplayConnection;
import com.ibm.jpos.services.jcomm.CommApiDeviceConnection;
import com.ibm.jpos.services.jcomm.CommApiLineDisplayServiceImp;
import com.ibm.jpos.util.ByteEncoder;
import com.ibm.jpos.util.Tracer;
import java.io.UnsupportedEncodingException;
import jpos.JposException;
import jpos.services.EventCallbacks;

public class IBM4840VFDImp
extends CommApiLineDisplayServiceImp {
    private CommApi4840LineDisplayConnection ibm4840LDConnection = null;
    LineDisplayServiceState serviceState;
    private static final byte[] LC_EMULATION_MODE = new byte[]{0, 0};
    private static final byte[] IBM_EMULATION_MODE = new byte[]{0, 1};
    private static final byte[] CHARACTER_SET_SELECT = new byte[]{2, 0};
    private static final byte[] USER_DEFINED_CHAR = new byte[]{3};
    private static final byte[] BRIGHTNESS_CONTROL = new byte[]{4, -1};
    private static final byte[] HORIZ_MSG_SCROLL = new byte[]{5};
    private static final byte[] TEST = new byte[]{15};
    private static final byte[] NORM_SCROLL_CTRL_MODE = new byte[]{17};
    private static final byte[] VERT_SCROLL_CTRL_MODE = new byte[]{18};
    private static final byte[] CURSOR_ON = new byte[]{19};
    private static final byte[] CURSOR_OFF = new byte[]{20};
    private static final byte[] RESET = new byte[]{31};
    private static final byte[] CURSOR_HOME = new byte[]{16, 0};
    byte[][] displayBuffer;
    ByteEncoder displayBE;
    String cursorState = new String("ON");
    private static final String className = "IBM4840VFDImp";

    protected IBM4840VFDImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open('" + string + "', " + eventCallbacks + ")", "Entry");
        try {
            if (this.getJposEntry() != null) {
                if (this.getJposEntry().hasPropertyWithName("commCursorState")) {
                    this.cursorState = this.getJposEntry().getPropertyValue("commCursorState").toString();
                }
                this.getJposEntry().addProperty("commComPort", "COM4");
            }
        }
        catch (Exception exception) {
            Tracer.trace(4, className, "open()", "JposEntry Exceptition is " + exception);
            throw new JposException(111);
        }
        this.comPort = "COM4";
        this.baudRate = "9600";
        this.flowControl = "NONE";
        Tracer.trace(4, className, "open()", "Finished scanning JposEntry" + this.comPort + ", " + this.baudRate + ", " + this.flowControl);
        this.serviceState = (LineDisplayServiceState)this.getDeviceServiceState();
        try {
            this.ibm4840LDConnection = (CommApi4840LineDisplayConnection)CommApi4840LineDisplayConnection.open(this.comPort, new Integer(this.baudRate), this.flowControl, 8, 1, 0);
            this.ibm4840LDConnection.write(RESET);
            this.ibm4840LDConnection.write(IBM_EMULATION_MODE);
            this.ibm4840LDConnection.write(NORM_SCROLL_CTRL_MODE);
            if (this.cursorState.equalsIgnoreCase("OFF")) {
                this.ibm4840LDConnection.write(CURSOR_OFF);
            }
            this.displayBuffer = new byte[this.serviceState.getRows()][this.serviceState.getColumns()];
            int n = this.serviceState.getCharacterSet();
            this.displayBE = new ByteEncoder(n == 998 ? 437 : n);
            this.clearText();
        }
        catch (Exception exception) {
            Tracer.trace(1, className, "open", "exception is " + exception);
            throw new JposException(108);
        }
    }

    public void close() throws JposException {
        Tracer.trace(4, className, "close()", "Entry");
        try {
            this.ibm4840LDConnection.close();
            this.ibm4840LDConnection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Tracer.trace(4, className, "close()", "Exit");
    }

    public synchronized void deleteImp() throws JposException {
        super.deleteImp();
    }

    public void setCharacterSet(int n) throws JposException {
        int[] nArray = this.serviceState.getValidCharacterSets();
        Tracer.trace(4, className, "setCharacterSet()", "characterSet = " + new Integer(n).toString());
        int n2 = -1;
        byte[] byArray = CHARACTER_SET_SELECT;
        if (n == 998) {
            n2 = 0;
        } else {
            int n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] == n) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
        }
        if (n2 == -1) {
            throw new JposException(106);
        }
        byArray[1] = (byte)n2;
        this.ibm4840LDConnection.write(byArray);
        try {
            this.displayBE = new ByteEncoder(n == 998 ? 437 : n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JposException(111, "JPOS_E_FAILURE: Unsupported code page: " + n);
        }
        Tracer.trace(4, className, "setCharacterSet()", "Exit");
    }

    public void setCurrentWindow(int n) throws JposException {
        if (n != 0) {
            throw new JposException(106);
        }
    }

    public void setCursorUpdate(boolean bl) throws JposException {
    }

    public void setDeviceBrightness(int n) throws JposException {
        block5: {
            byte[][] byArray;
            block6: {
                int n2 = this.serviceState.getDeviceBrightness();
                byte[] byArray2 = BRIGHTNESS_CONTROL;
                byArray = new byte[this.serviceState.getRows()][this.serviceState.getColumns()];
                Tracer.trace(4, className, "setDeviceBrightness()", "Brightness = " + new Integer(n).toString());
                if (n == n2) break block5;
                if (n == 0) break block6;
                byArray2[1] = n <= 20 && n > 0 ? 32 : (n <= 40 ? 64 : (n <= 60 ? 96 : -1));
                Tracer.trace(4, className, "setDeviceBrightness()", "Brightness Cmd= [" + Integer.toHexString(new Byte(byArray2[0]).intValue()) + Integer.toHexString(new Byte(byArray2[1]).intValue()) + "]");
                this.ibm4840LDConnection.write(byArray2);
                if (n2 != 0) break block5;
                this.updateDisplayFromBuffer();
                if (!this.cursorState.equalsIgnoreCase("ON")) break block5;
                this.ibm4840LDConnection.write(CURSOR_ON);
                break block5;
            }
            int n3 = 0;
            while (n3 < this.serviceState.getDeviceRows()) {
                int n4 = 0;
                while (n4 < this.serviceState.getDeviceColumns()) {
                    byArray[n3][n4] = this.displayBuffer[n3][n4];
                    this.displayBuffer[n3][n4] = 32;
                    ++n4;
                }
                ++n3;
            }
            this.updateDisplayFromBuffer();
            if (this.cursorState.equalsIgnoreCase("ON")) {
                this.ibm4840LDConnection.write(CURSOR_OFF);
            }
            int n5 = 0;
            while (n5 < this.serviceState.getDeviceRows()) {
                int n6 = 0;
                while (n6 < this.serviceState.getDeviceColumns()) {
                    this.displayBuffer[n5][n6] = byArray[n5][n6];
                    ++n6;
                }
                ++n5;
            }
        }
        Tracer.trace(4, className, "setDeviceBrightness()", "Exit");
    }

    public void setInterCharacterWait(int n) throws JposException {
        throw new JposException(106);
    }

    public void setMarqueeFormat(int n) throws JposException {
        throw new JposException(106);
    }

    public void setMarqueeRepeatWait(int n) throws JposException {
        throw new JposException(106);
    }

    public void setMarqueeType(int n) throws JposException {
        throw new JposException(106);
    }

    public void setMarqueeUnitWait(int n) throws JposException {
        throw new JposException(106);
    }

    public void clearDescriptors() throws JposException {
        throw new JposException(106);
    }

    public void clearText() throws JposException {
        Tracer.trace(4, className, "clearText()", "Enter");
        boolean bl = false;
        byte[] byArray = this.displayBE.getBytes(" ");
        int n = 0;
        while (n < this.serviceState.getDeviceRows()) {
            int n2 = 0;
            while (n2 < this.serviceState.getDeviceColumns()) {
                this.displayBuffer[n][n2] = byArray[0];
                ++n2;
            }
            ++n;
        }
        this.updateDisplayFromBuffer();
        this.ibm4840LDConnection.write(CURSOR_HOME);
        this.setCursorRow(0);
        this.setCursorColumn(0);
        Tracer.trace(4, className, "clearText()", "Exit");
    }

    public void createWindow(int n, int n2, int n3, int n4, int n5, int n6) throws JposException {
        throw new JposException(106);
    }

    public void destroyWindow() throws JposException {
        throw new JposException(106);
    }

    public void displayText(String string, int n) throws JposException {
        int n2 = this.serviceState.getRows();
        int n3 = this.serviceState.getColumns();
        int n4 = this.serviceState.getCursorRow();
        int n5 = this.serviceState.getCursorColumn();
        int n6 = n4;
        int n7 = n5;
        Tracer.trace(4, className, "displayText()", "Text = " + string);
        byte[] byArray = new byte[]{};
        byArray = this.displayBE.getBytes(string);
        Tracer.trace(4, className, "displayText()", "Text Length = " + new Integer(byArray.length).toString());
        int n8 = 0;
        while (n8 < byArray.length) {
            if (n5 == n3) {
                if (n4 < n2 - 1) {
                    ++n4;
                } else {
                    this.scrollText(1, 1);
                }
                n5 = 0;
            }
            if (byArray[n8] >= 0 && byArray[n8] <= 31) {
                if (byArray[n8] == 13) {
                    n5 = 0;
                } else if (byArray[n8] == 10) {
                    n5 = n3 + 1;
                }
            } else {
                this.displayBuffer[n4][n5] = byArray[n8];
                ++n5;
            }
            if (n5 > n3) {
                if (n4 < n2 - 1) {
                    ++n4;
                    n5 = 0;
                } else if (n8 != string.length() - 1) {
                    this.scrollText(1, 1);
                    n5 = 0;
                }
            }
            ++n8;
        }
        if (0 != this.serviceState.getDeviceBrightness()) {
            this.updateDisplayFromBuffer();
        }
        if (this.serviceState.getCursorUpdate()) {
            this.setCursorRow(n4);
            this.setCursorColumn(n5);
        } else {
            this.setCursorRow(n6);
            this.setCursorColumn(n7);
        }
        Tracer.trace(4, className, "displayText()", "Exit");
    }

    public void displayTextAt(int n, int n2, String string, int n3) throws JposException {
    }

    public void refreshWindow(int n) throws JposException {
        if (n != 0) {
            throw new JposException(106);
        }
    }

    public void setCursorColumn(int n) throws JposException {
        int n2 = this.serviceState.getCursorRow();
        byte[] byArray = CURSOR_HOME;
        Tracer.trace(4, className, "setCursorColumn()", "cursorColumn = " + new Integer(n).toString());
        if (n >= this.serviceState.getColumns() && n2 + 1 >= this.serviceState.getRows()) {
            if (this.cursorState.equalsIgnoreCase("ON")) {
                this.ibm4840LDConnection.write(CURSOR_OFF);
            }
        } else {
            byArray[1] = n2 == 0 ? (byte)n : (byte)(n + 20);
            Tracer.trace(4, className, "setCursorColumn()", "Cursor Position Cmd= [" + Integer.toHexString(new Byte(byArray[0]).intValue()) + Integer.toHexString(new Byte(byArray[1]).intValue()) + "]");
            this.ibm4840LDConnection.write(byArray);
            if (this.cursorState.equalsIgnoreCase("ON")) {
                this.ibm4840LDConnection.write(CURSOR_ON);
            }
        }
        this.serviceState.setCursorColumn(n);
    }

    public void setCursorRow(int n) throws JposException {
        int n2 = this.serviceState.getCursorColumn();
        byte[] byArray = CURSOR_HOME;
        Tracer.trace(4, className, "setCursorRow()", "cursorRow = " + new Integer(n).toString());
        if (n2 >= this.serviceState.getColumns() && n + 1 >= this.serviceState.getRows()) {
            if (this.cursorState.equalsIgnoreCase("ON")) {
                this.ibm4840LDConnection.write(CURSOR_OFF);
            }
        } else {
            byArray[1] = n == 0 ? (byte)n2 : (byte)(n2 + 20);
            Tracer.trace(4, className, "setCursorRow()", "Cursor Position Cmd= [" + Integer.toHexString(new Byte(byArray[0]).intValue()) + Integer.toHexString(new Byte(byArray[1]).intValue()) + "]");
            this.ibm4840LDConnection.write(byArray);
            if (this.cursorState.equalsIgnoreCase("ON")) {
                this.ibm4840LDConnection.write(CURSOR_ON);
            }
        }
        this.serviceState.setCursorRow(n);
    }

    public void scrollText(int n, int n2) throws JposException {
        int n3 = this.serviceState.getRows();
        int n4 = this.serviceState.getColumns();
        Tracer.trace(4, className, "scrollText()", "Entry");
        switch (n) {
            case 1: {
                Tracer.trace(4, className, "scrollText()", "DISP_ST_UP");
                int n5 = 0;
                while (n5 < n2) {
                    int n6 = 0;
                    while (n6 < n3 - 1) {
                        int n7 = 0;
                        while (n7 < n4) {
                            this.displayBuffer[n6][n7] = this.displayBuffer[n6 + 1][n7];
                            ++n7;
                        }
                        ++n6;
                    }
                    int n8 = 0;
                    while (n8 < n4) {
                        this.displayBuffer[n3 - 1][n8] = 32;
                        ++n8;
                    }
                    ++n5;
                }
                break;
            }
            case 2: {
                Tracer.trace(4, className, "scrollText()", "DISP_ST_DOWN");
                int n9 = 0;
                while (n9 < n2) {
                    int n10 = n3 - 1;
                    while (n10 > 0) {
                        int n11 = 0;
                        while (n11 < n4) {
                            this.displayBuffer[n10][n11] = this.displayBuffer[n10 - 1][n11];
                            ++n11;
                        }
                        --n10;
                    }
                    int n12 = 0;
                    while (n12 < n4) {
                        this.displayBuffer[0][n12] = 32;
                        ++n12;
                    }
                    ++n9;
                }
                break;
            }
            case 3: {
                Tracer.trace(4, className, "scrollText()", "DISP_ST_LEFT");
                int n13 = 0;
                while (n13 < n2) {
                    int n14 = 0;
                    while (n14 < n3) {
                        int n15 = 0;
                        while (n15 < n4 - 1) {
                            this.displayBuffer[n14][n15] = this.displayBuffer[n14][n15 + 1];
                            ++n15;
                        }
                        this.displayBuffer[n14][n15] = 32;
                        ++n14;
                    }
                    ++n13;
                }
                break;
            }
            case 4: {
                Tracer.trace(4, className, "scrollText()", "DISP_ST_RIGHT");
                int n16 = 0;
                while (n16 < n2) {
                    int n17 = 0;
                    while (n17 < n3) {
                        int n18 = n4 - 1;
                        while (n18 > 0) {
                            this.displayBuffer[n17][n18] = this.displayBuffer[n17][n18 - 1];
                            --n18;
                        }
                        this.displayBuffer[n17][n18] = 32;
                        ++n17;
                    }
                    ++n16;
                }
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
        this.updateDisplayFromBuffer();
    }

    public void setDescriptor(int n, int n2) throws JposException {
        throw new JposException(106);
    }

    protected CommApiDeviceConnection getDeviceConnection() {
        return this.ibm4840LDConnection;
    }

    private void updateDisplayFromBuffer() throws JposException {
        int n = this.serviceState.getCursorRow();
        int n2 = this.serviceState.getCursorColumn();
        Tracer.trace(4, className, "updateDisplayFromBuffer()", "Entry");
        byte[] byArray = new byte[this.serviceState.getColumns()];
        int n3 = 0;
        while (n3 < this.serviceState.getRows()) {
            int n4 = 0;
            while (n4 < this.serviceState.getColumns()) {
                byArray[n4] = this.displayBuffer[n3][n4];
                ++n4;
            }
            Tracer.trace(4, className, "updateDisplayFromBuffer()", "Row = " + new Integer(n3).toString());
            this.setCursorRow(n3);
            this.setCursorColumn(0);
            this.ibm4840LDConnection.write(byArray);
            ++n3;
        }
        this.setCursorRow(n);
        this.setCursorColumn(n2);
        Tracer.trace(4, className, "updateDisplayFromBuffer()", "Exit");
    }
}

