/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.CashDrawerServiceState;
import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.jcomm.CommApi4840LineDisplayConnection;
import com.ibm.jpos.services.jcomm.CommApiCashDrawerServiceImp;
import com.ibm.jpos.services.jcomm.CommApiDeviceConnection;
import com.ibm.jpos.services.jcomm.IBM4840CashDrawerEvent;
import com.ibm.jpos.services.jcomm.IBM4840CashDrawerEventListener;
import com.ibm.jpos.util.Tracer;
import jpos.JposException;
import jpos.events.StatusUpdateEvent;
import jpos.services.EventCallbacks;

public class IBM4840CashDrawerImp
extends CommApiCashDrawerServiceImp
implements IBM4840CashDrawerEventListener {
    private static final byte[] TOGGLE_UNSOLICITED_STATUS = new byte[]{27, 6};
    private static final byte[] REQUEST_STATUS = new byte[]{6};
    private static final byte[] OPEN_CASH_DRAWER_1 = new byte[]{7};
    private static final byte[] OPEN_CASH_DRAWER_2 = new byte[]{27, 7};
    private static final int STATUS_UNSOLICITED_STATUS_ON = 4;
    private static final int STATUS_CD2_PRESENT = 8;
    private static final int STATUS_CD1_PRESENT = 16;
    private static final int STATUS_CD2_OPEN = 32;
    private static final int STATUS_CD1_OPEN = 64;
    private CommApi4840LineDisplayConnection ibm4840LDConnection = null;
    CashDrawerServiceState serviceState;
    int drawerNumber = 1;
    private boolean fDrawerOpened;
    private boolean fDrawerAttached;
    private boolean fUnsolicitedStatusOn;
    byte statusByte;
    private static final String className = "IBM4840CashDrawerImp";

    protected IBM4840CashDrawerImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
    }

    public void IBM4840CashDrawerEventOccurred(IBM4840CashDrawerEvent iBM4840CashDrawerEvent) {
        StatusUpdateEvent statusUpdateEvent;
        Tracer.trace(4, className, "IBM4840CashDrawerEventOccurred", "data = " + iBM4840CashDrawerEvent.getEventData());
        this.statusByte = iBM4840CashDrawerEvent.getEventData();
        if ((this.statusByte & 4) == 4) {
            if (!this.fUnsolicitedStatusOn) {
                Tracer.trace(2, className, "checkCashDrawerStatus", "Unsolicited Status ON");
                this.fUnsolicitedStatusOn = true;
            }
        } else {
            if (this.fUnsolicitedStatusOn) {
                Tracer.trace(2, className, "checkCashDrawerStatus", "Unsolicited Status OFF");
                this.fUnsolicitedStatusOn = false;
            }
            try {
                this.ibm4840LDConnection.write(TOGGLE_UNSOLICITED_STATUS);
            }
            catch (Exception exception) {
                Tracer.trace(1, className, "write()", "write exception is " + exception);
            }
        }
        if (this.drawerNumber == 1) {
            if ((this.statusByte & 0x10) == 16) {
                if (!this.fDrawerAttached) {
                    Tracer.trace(2, className, "IBM4840CashDrawerEventOccurred", "Drawer 1 now present");
                    this.fDrawerAttached = true;
                }
            } else if (this.fDrawerAttached) {
                Tracer.trace(2, className, "IBM4840CashDrawerEventOccurred", "Drawer 1 now gone");
                this.fDrawerAttached = false;
            }
            if ((this.statusByte & 0x40) == 64) {
                if (!this.fDrawerOpened) {
                    Tracer.trace(2, className, "IBM4840CashDrawerEventOccurred", "Drawer 1 now opened");
                    this.fDrawerOpened = true;
                    this.serviceState.setDrawerOpened(true);
                    try {
                        statusUpdateEvent = new StatusUpdateEvent(this.getDeviceServiceAbstraction().getEventSource(), 1);
                        this.getDeviceServiceAbstraction().getEventQueueManager().postEvent(statusUpdateEvent);
                    }
                    catch (JposException jposException) {}
                }
            } else if (this.fDrawerOpened) {
                Tracer.trace(2, className, "IBM4840CashDrawerEventOccurred", "Drawer 1 now closed");
                this.fDrawerOpened = false;
                this.serviceState.setDrawerOpened(false);
                try {
                    statusUpdateEvent = new StatusUpdateEvent(this.getDeviceServiceAbstraction().getEventSource(), 0);
                    this.getDeviceServiceAbstraction().getEventQueueManager().postEvent(statusUpdateEvent);
                }
                catch (JposException jposException) {
                    // empty catch block
                }
            }
        }
        if (this.drawerNumber == 2) {
            if ((this.statusByte & 8) == 8) {
                if (!this.fDrawerAttached) {
                    Tracer.trace(2, className, "IBM4840CashDrawerEventOccurred", "Drawer 2 now present");
                    this.fDrawerAttached = true;
                }
            } else if (this.fDrawerAttached) {
                Tracer.trace(2, className, "IBM4840CashDrawerEventOccurred", "Drawer 2 now gone");
                this.fDrawerAttached = false;
            }
            if ((this.statusByte & 0x20) == 32) {
                if (!this.fDrawerOpened) {
                    Tracer.trace(2, className, "checkCashDrawerStatus", "Drawer 2 now opened");
                    this.fDrawerOpened = true;
                    this.serviceState.setDrawerOpened(true);
                    try {
                        statusUpdateEvent = new StatusUpdateEvent(this.getDeviceServiceAbstraction().getEventSource(), 1);
                        this.getDeviceServiceAbstraction().getEventQueueManager().postEvent(statusUpdateEvent);
                    }
                    catch (JposException jposException) {}
                }
            } else if (this.fDrawerOpened) {
                Tracer.trace(2, className, "checkCashDrawerStatus", "Drawer 2 now closed");
                this.fDrawerOpened = false;
                this.serviceState.setDrawerOpened(false);
                try {
                    statusUpdateEvent = new StatusUpdateEvent(this.getDeviceServiceAbstraction().getEventSource(), 0);
                    this.getDeviceServiceAbstraction().getEventQueueManager().postEvent(statusUpdateEvent);
                }
                catch (JposException jposException) {
                    // empty catch block
                }
            }
        }
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open('" + string + "', " + eventCallbacks + ")", "Entry");
        try {
            if (this.getJposEntry() != null) {
                if (this.getJposEntry().hasPropertyWithName("commDrawerNumber")) {
                    this.drawerNumber = new Integer(this.getJposEntry().getPropertyValue("commDrawerNumber").toString());
                }
                this.getJposEntry().addProperty("commComPort", "COM4");
            }
        }
        catch (Exception exception) {
            Tracer.trace(4, className, "open()", "JposEntry Exceptition is " + exception);
            throw new JposException(111);
        }
        this.comPort = "COM4";
        this.baudRate = "9600";
        this.flowControl = "NONE";
        Tracer.trace(4, className, "open()", "Finished scanning JposEntry" + this.comPort + ", " + this.baudRate + ", " + this.flowControl);
        this.serviceState = (CashDrawerServiceState)this.getDeviceServiceState();
        try {
            this.ibm4840LDConnection = (CommApi4840LineDisplayConnection)CommApi4840LineDisplayConnection.open(this.comPort, new Integer(this.baudRate), this.flowControl, 8, 1, 0);
            CommApi4840LineDisplayConnection.addEventListener(this);
            this.ibm4840LDConnection.write(REQUEST_STATUS);
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            Tracer.trace(1, className, "open", "exception is " + exception);
            throw new JposException(108);
        }
        if (!this.isOnline()) {
            Tracer.trace(4, className, "open()", "Cash Drawer is close");
            throw new JposException(108);
        }
        Tracer.trace(4, className, "open()", "Exit");
    }

    public void close() throws JposException {
        Tracer.trace(4, className, "close()", "Entry");
        try {
            this.ibm4840LDConnection.close();
            this.ibm4840LDConnection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Tracer.trace(4, className, "close()", "Exit");
    }

    public boolean isOnline() {
        boolean bl = false;
        Tracer.trace(4, className, "isOnline()", "Entry");
        bl = super.isOnline();
        if (bl) {
            Tracer.trace(4, className, "isOnline()", "super.isOnline() = TRUE");
            bl = this.fDrawerAttached;
        }
        Tracer.trace(4, className, "isOnline()", "Exit - rc =" + bl);
        return bl;
    }

    public synchronized void deleteImp() throws JposException {
        super.deleteImp();
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        super.setDeviceEnabled(bl);
        if (bl) {
            this.initStatus();
        }
    }

    public void openDrawer() throws JposException {
        Tracer.trace(4, className, "openDrawer()", "Entry");
        if (this.drawerNumber > 1) {
            try {
                this.ibm4840LDConnection.write(OPEN_CASH_DRAWER_2);
            }
            catch (Exception exception) {
                Tracer.trace(1, className, "write()", "write exception is " + exception);
            }
        } else {
            try {
                this.ibm4840LDConnection.write(OPEN_CASH_DRAWER_1);
            }
            catch (Exception exception) {
                Tracer.trace(1, className, "write()", "write exception is " + exception);
            }
        }
        Tracer.trace(4, className, "openDrawer()", "drawerNumber = " + this.drawerNumber);
        try {
            Thread.currentThread();
            Thread.sleep(this.getOpenDrawerWaitTime());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Tracer.trace(4, className, "openDrawer()", "exit");
    }

    protected void initStatus() throws JposException {
        CashDrawerServiceState cashDrawerServiceState = (CashDrawerServiceState)this.getDeviceServiceState();
        cashDrawerServiceState.setDrawerOpened(this.fDrawerOpened);
    }

    protected CommApiDeviceConnection getDeviceConnection() {
        return this.ibm4840LDConnection;
    }
}

