/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.LineDisplayServiceState;
import com.ibm.jpos.services.jcomm.CommApi4840LineDisplayConnection;
import com.ibm.jpos.services.jcomm.CommApiDeviceConnection;
import com.ibm.jpos.services.jcomm.CommApiLineDisplayServiceImp;
import com.ibm.jpos.util.ByteEncoder;
import com.ibm.jpos.util.Tracer;
import java.io.UnsupportedEncodingException;
import jpos.JposException;
import jpos.services.EventCallbacks;

public class IBM4840APAImp
extends CommApiLineDisplayServiceImp {
    private CommApi4840LineDisplayConnection ibm4840LDConnection = null;
    LineDisplayServiceState serviceState;
    private static final byte[] CLEAR_DISPLAY = new byte[]{27, 91, 50, 74};
    private static final byte[] CURSOR_HOME = new byte[]{27, 91, 72, 39};
    private static final byte[] CURSOR_POS_LT_10 = new byte[]{27, 91, 48, 59, 48, 72};
    private static final byte[] CURSOR_POS_GT_10 = new byte[]{27, 91, 48, 59, 49, 48, 72};
    private static final byte[] CHARACTER_SET_SELECT = new byte[]{27, 83, 48};
    private static final byte[] BRIGHTNESS_CONTROL = new byte[]{27, 92, 63, 76, 68, 53};
    private static final byte[] CURSOR_MODE = new byte[]{27, 92, 63, 76, 67, 50};
    private static final byte[] SCREEN_MODE = new byte[]{27, 92, 63, 76, 83, 56};
    private static final byte[] DISPLAY_MODE = new byte[]{27, 91, 48, 109};
    byte[][] displayBuffer;
    ByteEncoder displayBE;
    String cursorState = new String("ON");
    int numberOfRows = 2;
    private static final String className = "IBM4840AllPtsAddrDispImp";

    protected IBM4840APAImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open('" + string + "', " + eventCallbacks + ")", "Entry");
        try {
            if (this.getJposEntry() != null) {
                if (this.getJposEntry().hasPropertyWithName("commCursorState")) {
                    this.cursorState = this.getJposEntry().getPropertyValue("commCursorState").toString();
                    Tracer.trace(4, className, "open()", "JposEntry: commCursorState is " + this.cursorState);
                }
                if (this.getJposEntry().hasPropertyWithName("commNumberOfRows")) {
                    this.numberOfRows = new Integer(this.getJposEntry().getPropertyValue("commNumberOfRows").toString());
                    Tracer.trace(4, className, "open()", "JposEntry: commNumberOfRows is " + new Integer(this.numberOfRows).toString());
                }
                this.getJposEntry().addProperty("commComPort", "COM4");
            }
        }
        catch (Exception exception) {
            Tracer.trace(4, className, "open()", "JposEntry Exceptition is " + exception);
            throw new JposException(111);
        }
        this.comPort = "COM4";
        this.baudRate = "9600";
        this.flowControl = "RTS/CTS";
        Tracer.trace(4, className, "open()", "Finished scanning JposEntry" + this.comPort + ", " + this.baudRate + ", " + this.flowControl);
        this.serviceState = (LineDisplayServiceState)this.getDeviceServiceState();
        try {
            this.ibm4840LDConnection = (CommApi4840LineDisplayConnection)CommApi4840LineDisplayConnection.open(this.comPort, new Integer(this.baudRate), this.flowControl, 8, 1, 0);
            byte[] byArray = SCREEN_MODE;
            if (this.numberOfRows == 5 || this.numberOfRows == 4 || this.numberOfRows == 2) {
                this.changeValidCharacterSets(this.numberOfRows);
                byArray[5] = this.numberOfRows == 4 ? 54 : (this.numberOfRows == 5 ? 55 : 56);
            }
            this.ibm4840LDConnection.write(BRIGHTNESS_CONTROL);
            this.ibm4840LDConnection.write(byArray);
            byte[] byArray2 = CURSOR_MODE;
            byArray2[5] = this.cursorState.equalsIgnoreCase("ON") && this.numberOfRows > 2 ? 50 : 48;
            this.ibm4840LDConnection.write(byArray2);
            this.serviceState.setRows(this.numberOfRows);
            this.serviceState.setDeviceRows(this.numberOfRows);
            Tracer.trace(4, className, "open()", "setRows: number of rows now = " + new Integer(this.serviceState.getRows()).toString());
            this.displayBuffer = new byte[this.serviceState.getRows()][this.serviceState.getColumns()];
            int n = this.serviceState.getCharacterSet();
            this.displayBE = new ByteEncoder(n == 998 ? 437 : n);
            this.clearText();
        }
        catch (Exception exception) {
            Tracer.trace(1, className, "open", "exception is " + exception);
            throw new JposException(108);
        }
    }

    public void close() throws JposException {
        Tracer.trace(4, className, "close()", "Entry");
        try {
            this.ibm4840LDConnection.close();
            this.ibm4840LDConnection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Tracer.trace(4, className, "close()", "Exit");
    }

    public synchronized void deleteImp() throws JposException {
        super.deleteImp();
    }

    public synchronized void setCharacterSet(int n) throws JposException {
        int[] nArray = this.serviceState.getValidCharacterSets();
        Tracer.trace(4, className, "setCharacterSet()", "characterSet = " + new Integer(n).toString());
        int n2 = -1;
        byte[] byArray = CHARACTER_SET_SELECT;
        if (n == 998) {
            n2 = 0;
        } else {
            int n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] == n) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
        }
        Tracer.trace(4, className, "setCharacterSet()", "deviceCharSet = " + new Integer(n2).toString());
        if (n2 == -1) {
            throw new JposException(106);
        }
        byArray[2] = (byte)(n2 + 48);
        this.ibm4840LDConnection.write(byArray);
        try {
            this.displayBE = new ByteEncoder(n == 998 ? 437 : n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tracer.trace(4, className, "setCharacterSet()", "Unsupported Code Page (ByteEncoder)");
            throw new JposException(111, "JPOS_E_FAILURE: Unsupported code page: " + n);
        }
        Tracer.trace(4, className, "setCharacterSet()", "Exit");
    }

    public void setCurrentWindow(int n) throws JposException {
        if (n != 0) {
            throw new JposException(106);
        }
    }

    public void setCursorUpdate(boolean bl) throws JposException {
    }

    public void setDeviceBrightness(int n) throws JposException {
        int n2 = this.serviceState.getDeviceBrightness();
        byte[] byArray = BRIGHTNESS_CONTROL;
        Tracer.trace(4, className, "setDeviceBrightness()", "Brightness = " + new Integer(n).toString());
        if (n != n2) {
            byArray[5] = n <= 0 ? 48 : (n <= 32 ? 49 : (n <= 45 ? 50 : (n <= 59 ? 51 : (n <= 80 ? 52 : 53))));
            Tracer.trace(4, className, "setDeviceBrightness()", "Brightness Cmd= [" + Integer.toHexString(new Byte(byArray[0]).intValue()) + Integer.toHexString(new Byte(byArray[1]).intValue()) + Integer.toHexString(new Byte(byArray[2]).intValue()) + Integer.toHexString(new Byte(byArray[3]).intValue()) + Integer.toHexString(new Byte(byArray[4]).intValue()) + Integer.toHexString(new Byte(byArray[5]).intValue()) + "]");
            this.ibm4840LDConnection.write(byArray);
        }
        Tracer.trace(4, className, "setDeviceBrightness()", "Exit");
    }

    public void setInterCharacterWait(int n) throws JposException {
        throw new JposException(106);
    }

    public void setMarqueeFormat(int n) throws JposException {
        throw new JposException(106);
    }

    public void setMarqueeRepeatWait(int n) throws JposException {
        throw new JposException(106);
    }

    public void setMarqueeType(int n) throws JposException {
        throw new JposException(106);
    }

    public void setMarqueeUnitWait(int n) throws JposException {
        throw new JposException(106);
    }

    public void clearDescriptors() throws JposException {
        throw new JposException(106);
    }

    public void clearText() throws JposException {
        boolean bl = false;
        byte[] byArray = this.displayBE.getBytes(" ");
        Tracer.trace(4, className, "clearText()", "Enter");
        this.ibm4840LDConnection.write(CLEAR_DISPLAY);
        int n = 0;
        while (n < this.serviceState.getDeviceRows()) {
            int n2 = 0;
            while (n2 < this.serviceState.getDeviceColumns()) {
                this.displayBuffer[n][n2] = byArray[0];
                ++n2;
            }
            ++n;
        }
        this.setCursorRow(0);
        this.setCursorColumn(0);
        Tracer.trace(4, className, "clearText()", "Exit");
    }

    public void createWindow(int n, int n2, int n3, int n4, int n5, int n6) throws JposException {
        throw new JposException(106);
    }

    public void destroyWindow() throws JposException {
        throw new JposException(106);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void directIO(int n, int[] nArray, Object object) throws JposException {
        try {
            Tracer.trace(4, className, "directIO()", "Entry");
            Tracer.trace(4, className, "directIO()", "command = " + n);
            if (nArray.length > 0) {
                Tracer.trace(4, className, "directIO()", "data[0] = " + nArray[0]);
            }
            this.serviceState.isOpen();
            switch (n) {
                case 0: {
                    Tracer.trace(4, className, "directIO()", "SELECT_APA_NUMBER_OF_ROWS");
                    byte[] byArray = SCREEN_MODE;
                    if (nArray.length <= 0 || nArray[0] != 5 && nArray[0] != 4 && nArray[0] != 2) throw new JposException(106, "JPOS_E_ILLEGAL: Invalid number of rows specified");
                    this.numberOfRows = nArray[0];
                    if ((5 != this.numberOfRows && 4 != this.numberOfRows || 437 != this.serviceState.getCharacterSet() && 998 != this.serviceState.getCharacterSet()) && 2 != this.numberOfRows) throw new JposException(106, "JPOS_E_ILLEGAL: Invalid character set specified");
                    this.changeValidCharacterSets(this.numberOfRows);
                    this.serviceState.setRows(this.numberOfRows);
                    this.serviceState.setDeviceRows(this.numberOfRows);
                    byArray[5] = this.numberOfRows == 2 ? 56 : (this.numberOfRows == 4 ? 54 : 55);
                    this.ibm4840LDConnection.write(byArray);
                    byte[] byArray2 = CURSOR_MODE;
                    if (this.cursorState.equalsIgnoreCase("ON") && this.numberOfRows > 2) {
                        this.ibm4840LDConnection.write(CURSOR_MODE);
                    } else {
                        byArray2[5] = 48;
                        this.ibm4840LDConnection.write(byArray2);
                    }
                    this.displayBuffer = new byte[this.serviceState.getRows()][this.serviceState.getColumns()];
                    int n2 = this.serviceState.getCharacterSet();
                    this.displayBE = new ByteEncoder(n2 == 998 ? 437 : n2);
                    this.clearText();
                    break;
                }
                default: {
                    throw new JposException(106);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tracer.trace(4, className, "directIO()", "UnsupportedEncoding Exceptioneption!");
            throw new JposException(111, "JPOS_E_FAILURE: Unsupported code page:" + this.serviceState.getCharacterSet());
        }
        catch (JposException jposException) {
            Tracer.trace(4, className, "directIO()", "Exception = " + jposException);
            throw jposException;
        }
        Tracer.trace(4, className, "directIO(" + n + ", data, string)", "Exit");
    }

    public void displayText(String string, int n) throws JposException {
        int n2 = this.serviceState.getRows();
        int n3 = this.serviceState.getColumns();
        int n4 = this.serviceState.getCursorRow();
        int n5 = this.serviceState.getCursorColumn();
        int n6 = n4;
        int n7 = n5;
        byte[] byArray = DISPLAY_MODE;
        Tracer.trace(4, className, "displayText()", "Entry");
        byArray[2] = n == 1 ? 53 : 48;
        this.ibm4840LDConnection.write(byArray);
        Tracer.trace(4, className, "displayText()", "Create tempBuffer");
        byte[] byArray2 = new byte[]{};
        Tracer.trace(4, className, "displayText()", "Before getBytes()");
        byArray2 = this.displayBE.getBytes(string);
        Tracer.trace(4, className, "displayText()", "(Byte) Text Length = " + new Integer(byArray2.length).toString());
        int n8 = 0;
        while (n8 < byArray2.length) {
            if (n5 == n3) {
                if (n4 < n2 - 1) {
                    ++n4;
                } else {
                    this.scrollText(1, 1);
                }
                n5 = 0;
            }
            if (byArray2[n8] >= 0 && byArray2[n8] <= 31) {
                if (byArray2[n8] == 13) {
                    n5 = 0;
                } else if (byArray2[n8] == 10) {
                    n5 = n3 + 1;
                }
            } else if (this.displayBE.isDBCSCodePage()) {
                if (this.displayBE.isDBCSLeadByte(byArray2[n8])) {
                    if (n5 + 1 >= n3) {
                        n5 = 0;
                        if (n4 < n2 - 1) {
                            ++n4;
                        } else {
                            this.scrollText(1, 1);
                        }
                    }
                    this.displayBuffer[n4][n5] = byArray2[n8];
                    this.displayBuffer[n4][n5 + 1] = byArray2[++n8];
                    n5 += 2;
                } else {
                    this.displayBuffer[n4][n5] = byArray2[n8];
                    ++n5;
                }
            } else {
                this.displayBuffer[n4][n5] = byArray2[n8];
                ++n5;
            }
            if (n5 > n3) {
                if (n4 < n2 - 1) {
                    ++n4;
                    n5 = 0;
                } else if (n8 != byArray2.length - 1) {
                    this.scrollText(1, 1);
                    n5 = 0;
                }
            }
            ++n8;
        }
        if (0 != this.serviceState.getDeviceBrightness()) {
            this.updateDisplayFromBuffer();
        }
        if (this.serviceState.getCursorUpdate()) {
            this.setCursorRow(n4);
            this.setCursorColumn(n5);
        } else {
            this.setCursorRow(n6);
            this.setCursorColumn(n7);
        }
        Tracer.trace(4, className, "displayText()", "Exit");
    }

    public void displayTextAt(int n, int n2, String string, int n3) throws JposException {
    }

    public void refreshWindow(int n) throws JposException {
        if (n != 0) {
            throw new JposException(106);
        }
    }

    public void setCursorColumn(int n) throws JposException {
        int n2 = this.serviceState.getCursorRow();
        Tracer.trace(4, className, "setCursorColumn()", "cursorColumn = " + new Integer(n).toString());
        if (n >= this.serviceState.getColumns() && n2 + 1 >= this.serviceState.getRows()) {
            if (this.cursorState.equalsIgnoreCase("ON") && this.numberOfRows > 2) {
                byte[] byArray = CURSOR_MODE;
                byArray[5] = 48;
                this.ibm4840LDConnection.write(byArray);
            }
        } else {
            byte[] byArray = this.formCursorCommand(n2, n);
            this.ibm4840LDConnection.write(byArray);
            if (this.cursorState.equalsIgnoreCase("ON") && this.numberOfRows > 2) {
                byte[] byArray2 = CURSOR_MODE;
                byArray2[5] = 50;
                this.ibm4840LDConnection.write(byArray2);
            }
        }
        this.serviceState.setCursorColumn(n);
    }

    public void setCursorRow(int n) throws JposException {
        int n2 = this.serviceState.getCursorColumn();
        Tracer.trace(4, className, "setCursorRow()", "cursorRow = " + new Integer(n).toString());
        if (n2 >= this.serviceState.getColumns() && n + 1 >= this.serviceState.getRows()) {
            if (this.cursorState.equalsIgnoreCase("ON") && this.numberOfRows > 2) {
                byte[] byArray = CURSOR_MODE;
                byArray[5] = 48;
                this.ibm4840LDConnection.write(byArray);
            }
        } else {
            byte[] byArray = this.formCursorCommand(n, n2);
            this.ibm4840LDConnection.write(byArray);
            if (this.cursorState.equalsIgnoreCase("ON") && this.numberOfRows > 2) {
                byte[] byArray2 = CURSOR_MODE;
                byArray2[5] = 50;
                this.ibm4840LDConnection.write(byArray2);
            }
        }
        this.serviceState.setCursorRow(n);
    }

    public void scrollText(int n, int n2) throws JposException {
        int n3 = this.serviceState.getRows();
        int n4 = this.serviceState.getColumns();
        Tracer.trace(4, className, "scrollText()", "Entry");
        switch (n) {
            case 1: {
                Tracer.trace(4, className, "scrollText()", "DISP_ST_UP");
                int n5 = 0;
                while (n5 < n2) {
                    int n6 = 0;
                    while (n6 < n3 - 1) {
                        int n7 = 0;
                        while (n7 < n4) {
                            this.displayBuffer[n6][n7] = this.displayBuffer[n6 + 1][n7];
                            ++n7;
                        }
                        ++n6;
                    }
                    int n8 = 0;
                    while (n8 < n4) {
                        this.displayBuffer[n3 - 1][n8] = 32;
                        ++n8;
                    }
                    ++n5;
                }
                break;
            }
            case 2: {
                Tracer.trace(4, className, "scrollText()", "DISP_ST_DOWN");
                int n9 = 0;
                while (n9 < n2) {
                    int n10 = n3 - 1;
                    while (n10 > 0) {
                        int n11 = 0;
                        while (n11 < n4) {
                            this.displayBuffer[n10][n11] = this.displayBuffer[n10 - 1][n11];
                            ++n11;
                        }
                        --n10;
                    }
                    int n12 = 0;
                    while (n12 < n4) {
                        this.displayBuffer[0][n12] = 32;
                        ++n12;
                    }
                    ++n9;
                }
                break;
            }
            case 3: {
                Tracer.trace(4, className, "scrollText()", "DISP_ST_LEFT");
                int n13 = 0;
                while (n13 < n2) {
                    int n14 = 0;
                    while (n14 < n3) {
                        int n15 = 0;
                        while (n15 < n4 - 1) {
                            this.displayBuffer[n14][n15] = this.displayBuffer[n14][n15 + 1];
                            ++n15;
                        }
                        this.displayBuffer[n14][n15] = 32;
                        ++n14;
                    }
                    ++n13;
                }
                break;
            }
            case 4: {
                Tracer.trace(4, className, "scrollText()", "DISP_ST_RIGHT");
                int n16 = 0;
                while (n16 < n2) {
                    int n17 = 0;
                    while (n17 < n3) {
                        int n18 = n4 - 1;
                        while (n18 > 0) {
                            this.displayBuffer[n17][n18] = this.displayBuffer[n17][n18 - 1];
                            --n18;
                        }
                        this.displayBuffer[n17][n18] = 32;
                        ++n17;
                    }
                    ++n16;
                }
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
        this.updateDisplayFromBuffer();
    }

    public void setDescriptor(int n, int n2) throws JposException {
        throw new JposException(106);
    }

    private void changeValidCharacterSets(int n) throws JposException {
        Tracer.trace(4, className, "changeValidCharacterSets()", "Entry");
        int[] nArray = new int[]{437, 932, 104, 936, 950, 998};
        int[] nArray2 = new int[]{437, 998};
        if (n == 2) {
            this.serviceState.setValidCharacterSets(nArray);
            this.serviceState.setCharacterSetList("437, 932, 104, 936, 950, " + String.valueOf(998));
        } else {
            this.serviceState.setValidCharacterSets(nArray2);
            this.serviceState.setCharacterSetList("437, " + String.valueOf(998));
        }
        Tracer.trace(4, className, "changeValidCharacterSets()", "Exit");
    }

    private byte[] formCursorCommand(int n, int n2) {
        byte[] byArray;
        if (n2 + 1 > this.serviceState.getColumns()) {
            n2 = 0;
            if (++n + 1 > this.serviceState.getRows()) {
                n = 0;
            }
        }
        if (n2 + 1 < 10) {
            byArray = CURSOR_POS_LT_10;
            byArray[2] = (byte)(n + 1 + 48);
            byArray[4] = (byte)(n2 + 1 + 48);
            Tracer.trace(4, className, "formCursorCommand()", "Cursor Position Cmd= [" + Integer.toHexString(new Byte(byArray[0]).intValue()) + Integer.toHexString(new Byte(byArray[1]).intValue()) + Integer.toHexString(new Byte(byArray[2]).intValue()) + Integer.toHexString(new Byte(byArray[3]).intValue()) + Integer.toHexString(new Byte(byArray[4]).intValue()) + Integer.toHexString(new Byte(byArray[5]).intValue()) + "]");
        } else {
            byArray = CURSOR_POS_GT_10;
            byArray[2] = (byte)(n + 1 + 48);
            if ((n2 + 1) / 10 == 1) {
                byArray[4] = 49;
            }
            if ((n2 + 1) / 10 == 2) {
                byArray[4] = 50;
            }
            byArray[5] = (n2 + 1) % 10 != 0 ? (int)((n2 + 1) % 10 + 48) : 48;
            Tracer.trace(4, className, "setCursorColumn()", "Cursor Position Cmd= [" + Integer.toHexString(new Byte(byArray[0]).intValue()) + Integer.toHexString(new Byte(byArray[1]).intValue()) + Integer.toHexString(new Byte(byArray[2]).intValue()) + Integer.toHexString(new Byte(byArray[3]).intValue()) + Integer.toHexString(new Byte(byArray[4]).intValue()) + Integer.toHexString(new Byte(byArray[5]).intValue()) + Integer.toHexString(new Byte(byArray[6]).intValue()) + "]");
        }
        return byArray;
    }

    protected CommApiDeviceConnection getDeviceConnection() {
        return this.ibm4840LDConnection;
    }

    private void updateDisplayFromBuffer() throws JposException {
        int n = this.serviceState.getCursorRow();
        int n2 = this.serviceState.getCursorColumn();
        Tracer.trace(4, className, "updateDisplayFromBuffer()", "Entry");
        byte[] byArray = new byte[this.serviceState.getColumns()];
        int n3 = 0;
        while (n3 < this.serviceState.getRows()) {
            int n4 = 0;
            while (n4 < this.serviceState.getColumns()) {
                byArray[n4] = this.displayBuffer[n3][n4];
                ++n4;
            }
            Tracer.trace(4, className, "updateDisplayFromBuffer()", "Row = " + new Integer(n3).toString());
            this.setCursorRow(n3);
            this.setCursorColumn(0);
            this.ibm4840LDConnection.write(byArray);
            ++n3;
        }
        this.setCursorRow(n);
        this.setCursorColumn(n2);
        Tracer.trace(4, className, "updateDisplayFromBuffer()", "Exit");
    }
}

