/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.CacheVector;
import com.ibm.jpos.services.ibmprinter.PrintBitmapUtil;
import com.ibm.jpos.services.ibmprinter.PrintDataParseException;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.ibmprinter.SetBitmapData;
import com.ibm.jpos.services.jcomm.Serial4610PrintDataCompiler;
import com.ibm.jpos.util.ByteBuffer;
import com.ibm.jpos.util.Tracer;
import jpos.JposException;
import jpos.POSPrinterConst;

public class IBM4610PrintDataCompiler
extends Serial4610PrintDataCompiler
implements POSPrinterConst {
    private static final String className = "IBM4610PrintDataCompiler";
    private PrinterFont selectedPrinterFont = null;

    IBM4610PrintDataCompiler(POSPrinterServiceState pOSPrinterServiceState) throws JposException {
        super(pOSPrinterServiceState);
    }

    public byte[] compile(int n, String string, int n2, PrintBitmapUtil printBitmapUtil, PrinterFont[] printerFontArray) throws JposException {
        return super.compile(n, string, n2, printBitmapUtil, printerFontArray);
    }

    public void validate(int n, String string, int n2, PrintBitmapUtil printBitmapUtil, PrinterFont[] printerFontArray) throws JposException {
        super.validate(n, string, n2, printBitmapUtil, printerFontArray);
    }

    public PrinterFont getSelectedPrinterFont() {
        return this.selectedPrinterFont;
    }

    protected byte[] getPrologueBytes() throws PrintDataParseException, JposException {
        Tracer.trace(4, className, "getPrologueBytes()", "Entry");
        PrinterFont[] printerFontArray = this.getPrinterFonts();
        ByteBuffer byteBuffer = new ByteBuffer();
        int n = this.getStation();
        int n2 = 0;
        int n3 = -1;
        block0 : switch (n) {
            case 2: {
                n2 = this.getServiceState().getRecLineChars();
                switch (this.getRotation()) {
                    case 1: {
                        break block0;
                    }
                }
                throw new JposException(111, "unsupported rotation");
            }
            case 4: {
                n2 = this.getServiceState().getSlpLineChars();
                switch (this.getRotation()) {
                    case 1: {
                        byteBuffer.append(27).append(99).append(49).append(4);
                        break block0;
                    }
                    case 258: {
                        this.reverseLines();
                        byteBuffer.append(27).append(99).append(49).append(8);
                        break block0;
                    }
                }
                throw new JposException(111, "unsupported rotation");
            }
            default: {
                throw new JposException(111);
            }
        }
        int n4 = 0;
        while (n4 < printerFontArray.length) {
            if (printerFontArray[n4].station == n) {
                if (printerFontArray[n4].lineChars == n2) {
                    n3 = n4;
                    break;
                }
                if (printerFontArray[n4].lineChars > n2 && (n3 == -1 || printerFontArray[n3].lineChars > printerFontArray[n4].lineChars)) {
                    n3 = n4;
                }
            }
            ++n4;
        }
        if (n3 == -1) {
            throw new JposException(111);
        }
        this.selectedPrinterFont = printerFontArray[n3];
        block11 : switch (n) {
            case 4: {
                if (this.selectedPrinterFont.diWidth == 0) {
                    byteBuffer.append(27).append(36).append(0).append(0);
                } else if (this.selectedPrinterFont.fontType == 2) {
                    byteBuffer.append(27).append(36).append(0).append(72);
                } else {
                    byteBuffer.append(27).append(36).append(0).append(90);
                }
                switch (this.selectedPrinterFont.fontType) {
                    case 2: {
                        byteBuffer.append(27).append(32).append(3);
                        this.setPrinterMode(1, true);
                        this.setPrinterMode(2, false);
                        Tracer.trace(4, className, "getPrologueBytes()", "using spread font");
                        break block11;
                    }
                    case 1: {
                        byteBuffer.append(27).append(32).append(3);
                        this.setPrinterMode(3, false);
                        Tracer.trace(4, className, "getPrologueBytes()", "using normal font");
                        break block11;
                    }
                    case 3: {
                        byteBuffer.append(27).append(32).append(2);
                        this.setPrinterMode(3, false);
                        Tracer.trace(4, className, "getPrologueBytes()", "using small font");
                        break block11;
                    }
                    case 5: {
                        byteBuffer.append(27).append(82).append(6);
                        break block11;
                    }
                    case 13: {
                        byteBuffer.append(27).append(32).append(4);
                        byteBuffer.append(27).append(82).append(8);
                        this.setPrinterMode(3, false);
                        break block11;
                    }
                    case 14: {
                        byteBuffer.append(27).append(32).append(3);
                        byteBuffer.append(27).append(82).append(6);
                        this.setPrinterMode(3, false);
                        break block11;
                    }
                    case 15: {
                        byteBuffer.append(27).append(32).append(2);
                        byteBuffer.append(27).append(82).append(4);
                        this.setPrinterMode(3, false);
                        break block11;
                    }
                    case 16: {
                        byteBuffer.append(27).append(32).append(1);
                        byteBuffer.append(27).append(82).append(2);
                        this.setPrinterMode(3, false);
                        break block11;
                    }
                    case 17: {
                        byteBuffer.append(27).append(32).append(0);
                        byteBuffer.append(27).append(82).append(0);
                        this.setPrinterMode(3, false);
                        break block11;
                    }
                }
                Tracer.trace(4, className, "getPrologueBytes()", "unrecognized font");
                throw new JposException(106);
            }
            case 2: {
                switch (this.selectedPrinterFont.fontType) {
                    case 2: {
                        byteBuffer.append(27).append(32).append(5);
                        this.setPrinterMode(1, true);
                        this.setPrinterMode(2, false);
                        break block11;
                    }
                    case 1: {
                        byteBuffer.append(27).append(32).append(3);
                        this.setPrinterMode(3, false);
                        break block11;
                    }
                    case 3: {
                        byteBuffer.append(27).append(32).append(2);
                        this.setPrinterMode(3, false);
                        break block11;
                    }
                    case 4: {
                        byteBuffer.append(27).append(32).append(2);
                        this.setPrinterMode(1, false);
                        this.setPrinterMode(2, true);
                        break block11;
                    }
                    case 5: {
                        byteBuffer.append(27).append(82).append(6);
                        break block11;
                    }
                    case 10: {
                        byteBuffer.append(27).append(32).append(3);
                        byteBuffer.append(27).append(82).append(6);
                        this.setPrinterMode(3, false);
                        break block11;
                    }
                    case 11: {
                        byteBuffer.append(27).append(32).append(1);
                        byteBuffer.append(27).append(82).append(2);
                        this.setPrinterMode(3, false);
                        break block11;
                    }
                    case 12: {
                        byteBuffer.append(27).append(32).append(0);
                        byteBuffer.append(27).append(82).append(0);
                        this.setPrinterMode(3, false);
                        break block11;
                    }
                }
                throw new JposException(111, "unrecognized font");
            }
            default: {
                Tracer.trace(4, className, "getPrologueBytes()", "non-supported station");
                throw new JposException(106);
            }
        }
        byteBuffer.append(27).append(33).append(this.getPrinterMode());
        Tracer.trace(4, className, "getPrologueBytes()", "Exit");
        return byteBuffer.getBytes();
    }

    protected byte[] getNewlineBytes() {
        return new byte[]{10};
    }

    protected byte[] getFeedPaperCutAndStampBytes(int n) throws PrintDataParseException, JposException {
        byte[] byArray = this.getFeedAndPaperCutBytes(n);
        byte[] byArray2 = this.getFireStampBytes();
        int n2 = byArray.length + byArray2.length;
        byte[] byArray3 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray3[n3] = n3 < byArray.length ? byArray[n3] : byArray2[n3 - byArray.length];
            ++n3;
        }
        return byArray3;
    }

    protected byte[] getFireStampBytes() throws PrintDataParseException, JposException {
        return this.getPrintBitmapBytes(1, -1);
    }

    protected byte[] getPrintBitmapBytes(int n, int n2) throws PrintDataParseException, JposException {
        byte by;
        byte[] byArray = new byte[]{};
        SetBitmapData setBitmapData = this.getSetBitmapData(this.getStation(), n);
        if (setBitmapData == null) {
            if (this.isValidating()) {
                throw new JposException(111);
            }
            return byArray;
        }
        switch (setBitmapData.getAlignment()) {
            case -2: {
                by = 1;
                break;
            }
            case -3: {
                by = 2;
                break;
            }
            default: {
                by = 0;
            }
        }
        try {
            byArray = by != 0 ? new byte[]{27, 97, by, 29, 47, 0, (byte)this.getPrintBitmapUtil().cacheVector.get((int)CacheVector.BITMAP, (int)this.getStation(), (int)n).index, 10, 27, 97, 0} : new byte[]{29, 47, 0, (byte)this.getPrintBitmapUtil().cacheVector.get((int)CacheVector.BITMAP, (int)this.getStation(), (int)n).index, 10};
        }
        catch (Exception exception) {
            throw new JposException(111);
        }
        return byArray;
    }

    protected byte[] getShadingBytes() throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getShadingBytes(int n) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getNormalBytes() {
        ByteBuffer byteBuffer = new ByteBuffer();
        byteBuffer.append(29).append(33).append(0);
        this.setPrinterMode(252, false);
        byteBuffer.append(27).append(33).append(this.getPrinterMode());
        this.setPrinterMode(252, false);
        return byteBuffer.getBytes();
    }
}

