/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.EventQueueManager;
import com.ibm.jpos.services.POSPrinterServiceImp;
import com.ibm.jpos.services.POSPrinterServiceMsg;
import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.DirectIOBitmapInfo;
import com.ibm.jpos.services.ibmprinter.DocumentManagementImplementor;
import com.ibm.jpos.services.ibmprinter.MapModeCalculator;
import com.ibm.jpos.services.ibmprinter.PrintBitmapData;
import com.ibm.jpos.services.ibmprinter.PrintBitmapImageInfo;
import com.ibm.jpos.services.ibmprinter.PrintBitmapUtil;
import com.ibm.jpos.services.ibmprinter.PrintBitmapUtilImplementor;
import com.ibm.jpos.services.ibmprinter.PrintData;
import com.ibm.jpos.services.ibmprinter.PrinterCommunicationsManager;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.ibmprinter.PrinterOutput;
import com.ibm.jpos.services.ibmprinter.SetBitmapData;
import com.ibm.jpos.services.ibmprinter.ValidateImplementor;
import com.ibm.jpos.services.ibmprinter.Validator;
import com.ibm.jpos.services.jcomm.CommApiDeviceServiceImp;
import com.ibm.jpos.util.Debug;
import com.ibm.jpos.util.JposEventContainer;
import com.ibm.jpos.util.Logger;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosException;
import com.ibm.poss.Printer;
import java.util.Vector;
import jpos.JposConst;
import jpos.JposException;
import jpos.POSPrinterConst;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.events.StatusUpdateEvent;
import jpos.services.EventCallbacks;

public abstract class CommApiPOSPrinterServiceImp
extends CommApiDeviceServiceImp
implements POSPrinterServiceImp,
JposConst,
Printer,
POSPrinterConst,
PrinterOutput,
ValidateImplementor,
DocumentManagementImplementor,
PrintBitmapUtilImplementor {
    POSPrinterServiceState serviceState = null;
    DeviceServiceAbstraction serviceAbstraction = null;
    EventQueueManager serviceEventQueueManager = null;
    EventCallbacks callbackHandler = null;
    PrinterCommunicationsManager printerManager;
    PrintBitmapUtil printBitmapUtil;
    int currentMapMode = 1;
    int[] currentLineSpacing = new int[]{-1, -1, -1, -1, -1};
    int[] printRotated = new int[]{1, 1, 1, 1, 1};
    boolean useChase = true;
    int lastPossStation = -1;
    boolean insertionMode = false;
    boolean removalMode = false;
    int currentAlignment = -1;
    int outputID = 0;
    int outputIDCounter = 0;
    int currentFeedDirection = 0;
    int currentRotateCR = 1;
    int currentRotateDI = 1;
    int currentNormalSpacing = 0;
    boolean[] slipInserted = new boolean[1];
    boolean[] slipReady = new boolean[1];
    boolean[] slipRemoved = new boolean[1];
    boolean[] firingComplete = new boolean[1];
    boolean[] printlineSyncMode = new boolean[5];
    boolean[] chaseComplete = new boolean[5];
    JposException errorEventException = null;
    PrinterFont[] printerFonts;
    Validator validator;
    MapModeCalculator mapModeCalc = new MapModeCalculator();
    Vector rotatedReceiptVector = new Vector();
    protected static Debug debugPrintBitmap = new Debug(false);
    protected static Debug debugInsertion = new Debug(false);
    protected static Debug debugRemoval = new Debug(false);
    protected static Debug debugStationSet = new Debug(false);
    protected static Debug debugPrintMessage = new Debug(false);
    protected static Debug debugPrintLine = new Debug(false);
    private static final String className = "CommApiPOSPrinterServiceImp";
    protected static final String INTERNAL_END_TRANSACTION_COMMAND = "\u001b\u001b\u0001";
    protected static final String INTERNAL_END_ROTATION_COMMAND = "\u001b\u001b\u0002";
    Logger log = Logger.getInstance();

    protected CommApiPOSPrinterServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        this.serviceState = (POSPrinterServiceState)deviceServiceAbstraction.getDeviceServiceState();
        this.serviceAbstraction = deviceServiceAbstraction;
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open(" + string + ", cb )", "Entry");
        super.open(string, eventCallbacks);
        this.callbackHandler = eventCallbacks;
        this.serviceState.setState(3);
        this.serviceState.setFlagWhenIdle(false);
        this.printerManager = new PrinterCommunicationsManager(this.serviceAbstraction, this);
        this.serviceState.setState(2);
        Tracer.trace(4, className, "open(" + string + ", cb )", "Exit");
    }

    public void claim(int n) throws JposException {
        Tracer.trace(4, className, "claim(" + n + ")", "Entry");
        super.claim(n);
        this.serviceEventQueueManager = this.serviceAbstraction.getEventQueueManager();
        Tracer.trace(4, className, "claim(" + n + ")", "Exit");
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        Tracer.trace(4, className, "setDeviceEnabled(" + bl + ")", "Entry");
        super.setDeviceEnabled(bl);
        Tracer.trace(4, className, "setDeviceEnabled(" + bl + ")", "Exit");
    }

    public void clearOutput() throws JposException {
        Tracer.trace(4, className, "clearOutput()", "Entry");
        this.printerManager.clearOutput();
        int n = 0;
        while (n < this.printRotated.length) {
            this.printRotated[n] = 1;
            ++n;
        }
        this.currentRotateCR = 1;
        this.currentRotateDI = 1;
        this.setIdle();
        this.serviceEventQueueManager.removeAllErrorEvent();
        boolean[] blArray = this.firingComplete;
        synchronized (blArray) {
            this.firingComplete[0] = false;
            this.firingComplete.notifyAll();
        }
        Tracer.trace(4, className, "clearOutput()", "Exit");
    }

    public void cutPaper(int n) throws JposException {
        Tracer.trace(4, className, "cutPaper(" + n + ")", "Entry");
        if (!this.serviceState.getAsyncMode() && !this.isOnline()) {
            throw new JposException(108);
        }
        this.doPrinting(2, "\u001b|P", null, 1, this.currentAlignment, true, false);
        Tracer.trace(4, className, "cutPaper(" + n + ")", "Exit");
    }

    public abstract void printBarCode(int var1, String var2, int var3, int var4, int var5, int var6, int var7) throws JposException;

    public void directIO(int n, int[] nArray, Object object) throws JposException {
        Tracer.trace(4, className, "directIO(" + n + ", data, string)", "Entry");
        this.serviceState.isOpenClaimEnable();
        switch (n) {
            case 0: {
                if (!this.isOnline()) {
                    throw new JposException(108);
                }
                if (this.serviceState.getSlpEmpty()) {
                    throw new JposException(114, 204);
                }
                this.doDirectIOFlipCheck();
                break;
            }
            case 1: {
                this.doDirectIODownloadBitmap(nArray[0], (DirectIOBitmapInfo)object);
                break;
            }
            case 2: {
                this.doDirectIOPrintDownloadedBitmap(nArray[0], (DirectIOBitmapInfo)object);
                break;
            }
            case 3: {
                this.doDirectIODownloadMessage(nArray[0], (String)object);
                break;
            }
            case 4: {
                this.doDirectIOPrintDownloadedMessage(nArray[0]);
                break;
            }
            case 5: {
                this.doDirectIOResetPrinter();
                break;
            }
            case 6: {
                this.doDirectIOSetChaseMode((Boolean)object);
                break;
            }
            case 7: {
                if (nArray == null || object == null) {
                    throw new JposException(106);
                }
                this.doDirectIOPrintUnvalidated(nArray[0], (String)object);
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
        Tracer.trace(4, className, "directIO(" + n + ", data, string)", "Exit");
    }

    abstract void doDirectIOFlipCheck() throws JposException;

    abstract void doDirectIOPrintDownloadedBitmap(int var1, DirectIOBitmapInfo var2) throws JposException;

    abstract void doDirectIOPrintDownloadedMessage(int var1) throws JposException;

    void doDirectIODownloadBitmap(int n, DirectIOBitmapInfo directIOBitmapInfo) throws JposException {
        Tracer.trace(4, className, "directIODownloadBitmap(" + n + ", bitmapInfo)", "Entry");
        if (n == 0 || n > 40) {
            throw new JposException(106);
        }
        this.setBitmap(n, directIOBitmapInfo.station, directIOBitmapInfo.fileName, directIOBitmapInfo.width, directIOBitmapInfo.alignment);
        Tracer.trace(4, className, "directIODownloadBitmap(" + n + ", bitmapInfo)", "Exit");
    }

    void doDirectIODownloadMessage(int n, String string) throws JposException {
        Tracer.trace(4, className, "directIODownloadMessage(" + n + ", " + string + ")", "Entry");
        if (n == 0 || n > 25) {
            throw new JposException(106);
        }
        if (this.printBitmapUtil == null) {
            this.printBitmapUtil = new PrintBitmapUtil(this.serviceAbstraction, this);
        }
        if (this.printBitmapUtil == null) {
            throw new JposException(111);
        }
        this.printBitmapUtil.doSetLogo(n, string);
        Tracer.trace(4, className, "directIODownloadMessage(" + n + ", " + string + ")", "Exit");
    }

    abstract void doDirectIOResetPrinter() throws JposException;

    void doDirectIOSetChaseMode(boolean bl) {
        this.useChase = bl;
    }

    void doDirectIOPrintUnvalidated(int n, String string) throws JposException {
        Tracer.trace(4, className, "directIOPrintUnvalidated(" + n + ", " + string + ")", "Entry");
        this.setPossStation(this.possStation(n), false);
        this.doPrinting(n, string, null, 1, this.currentAlignment, false, false);
        Tracer.trace(4, className, "directIOPrintUnvalidated(" + n + ", " + string + ")", "Exit");
    }

    abstract void setPossStation(int var1, boolean var2) throws JposException;

    public void printBitmap(int n, String string, int n2, int n3) throws JposException {
        Tracer.trace(4, className, "printBitmap(" + n + ", " + string + "," + n2 + "," + n3 + ")", "Entry");
        if (!this.serviceState.getAsyncMode() && !this.isOnline()) {
            throw new JposException(108);
        }
        if (this.printRotated[n] != 1) {
            throw new JposException(106);
        }
        if (this.printBitmapUtil == null) {
            this.printBitmapUtil = new PrintBitmapUtil(this.serviceAbstraction, this);
        }
        if (this.printBitmapUtil == null) {
            throw new JposException(111);
        }
        int n4 = this.calcStationWidth(n);
        if (n2 != -11 && n2 > n4) {
            throw new JposException(114, 206);
        }
        if (this.serviceState.getMapMode() != 1) {
            n4 = this.convertToDots(n4, n);
            if (n2 != -11) {
                n2 = this.convertToDots(n2, n);
            }
        }
        PrintBitmapData printBitmapData = new PrintBitmapData(n, string, n2, n3, this.serviceState.getAsyncMode(), null);
        this.printBitmapUtil.validateBitmap(printBitmapData, 2, n4);
        this.doPrinting(printBitmapData.getStation(), printBitmapData.getBitmapStream(), printBitmapData.getAlignment(), 2);
        Tracer.trace(4, className, "printBitmap(" + n + ", " + string + "," + n2 + "," + n3 + ")", "Exit");
    }

    public abstract void downloadData(int var1, int var2, String var3, int var4, int var5) throws JposException;

    public abstract void doPapercut(int var1, StringBuffer var2) throws JposException;

    public abstract void doFeedAndPapercut(int var1, StringBuffer var2) throws JposException;

    public abstract void doFeedPapercutAndStamp(int var1, StringBuffer var2) throws JposException;

    public abstract void doFireStamp(StringBuffer var1) throws JposException;

    public abstract void clearBitmaps() throws JposException;

    public abstract void clearMessages() throws JposException;

    public abstract int getStationMaxBitmapHeight(int var1);

    public abstract short getNextByteForStation(int var1, PrintBitmapImageInfo var2);

    public abstract void checkMode(int var1, int var2) throws JposException;

    public void printImmediate(int n, String string) throws JposException {
        Tracer.trace(4, className, "printImmediate(" + n + ", " + string + ")", "Entry");
        if (!this.isOnline()) {
            throw new JposException(108);
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.doValidateData(n, string, stringBuffer, false);
        try {
            this.directPrintLine(n, stringBuffer.toString(), 1, this.currentAlignment, this.printRotated[n]);
        }
        catch (JposException jposException) {
            if (this.serviceState.getCoverOpen()) {
                this.write("\u0010\u00052", 3);
                throw new JposException(114, 201);
            }
            throw jposException;
        }
        Tracer.trace(4, className, "printImmediate(" + n + ", " + string + ")", "Exit");
    }

    private int getLineChars(int n) {
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = this.serviceState.getRecLineChars();
                break;
            }
            case 1: {
                n2 = this.serviceState.getJrnLineChars();
                break;
            }
            case 4: {
                n2 = this.serviceState.getSlpLineChars();
            }
        }
        return n2;
    }

    public void printNormal(int n, String string) throws JposException {
        boolean bl;
        Tracer.trace(4, className, "printNormal (" + n + ", [" + string + "])", "Entry");
        boolean bl2 = bl = this.printRotated[n] != 258;
        if (!(this.serviceState.getAsyncMode() || this.isOnline() || this.printerManager.getRotateSidewaysMode(n) || this.printerManager.getTransactionMode(n))) {
            throw new JposException(108);
        }
        this.setPossStation(this.possStation(n), false);
        this.doPrinting(n, string, null, 1, this.currentAlignment, bl, false);
        Tracer.trace(4, className, "printNormal (" + n + ", [" + string + "])", "Exit");
    }

    public void printTwoNormal(int n, String string, String string2) throws JposException {
        Tracer.trace(4, className, "printTwoNormal(" + n + ", " + string + "," + string2 + ")", "Entry");
        if (!this.serviceState.getAsyncMode() && !this.isOnline()) {
            throw new JposException(108);
        }
        switch (n) {
            case 32771: {
                n = 3;
                String string3 = string;
                string = string2;
                string2 = string3;
                break;
            }
            case 32773: {
                n = 5;
                String string4 = string;
                string = string2;
                string2 = string4;
                break;
            }
            case 32774: {
                n = 6;
                String string5 = string;
                string = string2;
                string2 = string5;
            }
        }
        switch (n) {
            case 3: {
                if (this.serviceState.getCapConcurrentJrnRec()) break;
                throw new JposException(106);
            }
            case 5: {
                if (this.serviceState.getCapConcurrentJrnSlp()) break;
                throw new JposException(106);
            }
            case 6: {
                if (this.serviceState.getCapConcurrentRecSlp()) break;
                throw new JposException(106);
            }
        }
        this.doPrinting(n, string, string2, 1, this.currentAlignment, true, false);
        Tracer.trace(4, className, "printTwoNormal(" + n + ", " + string + "," + string2 + ")", "Exit");
    }

    public abstract void rotatePrint(int var1, int var2) throws JposException;

    public void setBitmap(int n, int n2, String string, int n3, int n4) throws JposException {
        Tracer.trace(4, className, "setBitmap(" + n + ", " + n2 + "," + string + "," + n3 + "," + n4 + ")", "Entry");
        if (!this.isOnline()) {
            throw new JposException(108);
        }
        if (this.printBitmapUtil == null) {
            this.printBitmapUtil = new PrintBitmapUtil(this.serviceAbstraction, this);
        }
        if (this.printBitmapUtil == null) {
            throw new JposException(111);
        }
        int n5 = this.calcStationWidth(n2);
        if (n3 != -11 && n3 > n5) {
            throw new JposException(114, 206);
        }
        if (this.serviceState.getMapMode() != 1) {
            n5 = this.convertToDots(n5, n2);
            if (n3 != -11) {
                n3 = this.convertToDots(n3, n2);
            }
        }
        SetBitmapData setBitmapData = new SetBitmapData(n, n2, string, n3, n4, null);
        this.printBitmapUtil.validateBitmap(setBitmapData, 16, n5);
        if (string.length() > 0) {
            this.printBitmapUtil.doSetBitmap(setBitmapData);
        }
        Tracer.trace(4, className, "setBitmap(" + n + ", " + n2 + "," + string + "," + n3 + "," + n4 + ")", "Exit");
    }

    public void setLogo(int n, String string) throws JposException {
        Tracer.trace(4, className, "setLogo(" + n + ", " + string + ")", "Entry");
        if (!this.isOnline()) {
            throw new JposException(108);
        }
        int n2 = 1;
        if (this.printBitmapUtil == null) {
            this.printBitmapUtil = new PrintBitmapUtil(this.serviceAbstraction, this);
        }
        if (this.printBitmapUtil == null) {
            throw new JposException(111);
        }
        if (n == 1) {
            n2 = 1;
        }
        if (n == 2) {
            n2 = 2;
        }
        this.printBitmapUtil.doSetLogo(n2, string);
        Tracer.trace(4, className, "setLogo(" + n + ", " + string + ")", "Exit");
    }

    public void transactionPrint(int n, int n2) throws JposException {
        Tracer.trace(4, className, "transactionPrint(" + n + ", " + n2 + ")", "Entry");
        if (!this.serviceState.getCapTransaction()) {
            throw new JposException(111);
        }
        boolean bl = n2 == 11;
        this.printerManager.setTransactionMode(n, bl);
        if (bl) {
            this.outputID = this.outputIDCounter++;
            this.serviceState.setOutputID(this.outputID);
        } else if (!this.serviceState.getAsyncMode()) {
            if (this.serviceState.getCoverOpen()) {
                this.write("\u0010\u00052", 3);
                throw new JposException(114, 201);
            }
            if (!this.isOnline()) {
                throw new JposException(108);
            }
            switch (n) {
                case 2: {
                    if (!this.serviceState.getRecEmpty()) break;
                    throw new JposException(114, 203);
                }
                case 1: {
                    if (!this.serviceState.getJrnEmpty()) break;
                    throw new JposException(114, 202);
                }
                case 4: {
                    if (!this.serviceState.getSlpEmpty()) break;
                    throw new JposException(114, 204);
                }
            }
        }
        Tracer.trace(4, className, "transactionPrint(" + n + ", " + n2 + ")", "Exit");
    }

    public void validateData(int n, String string) throws JposException {
        Tracer.trace(4, className, "validateData(" + n + ", " + string + ")", "Entry");
        StringBuffer stringBuffer = new StringBuffer();
        this.doValidateData(n, string, stringBuffer, true);
        Tracer.trace(4, className, "validateData(" + n + ", " + string + ")", "Exit");
    }

    public synchronized void setAsyncMode(boolean bl) throws JposException {
    }

    public synchronized void setCharacterSet(int n) throws JposException {
    }

    public synchronized void setFlagWhenIdle(boolean bl) throws JposException {
        Tracer.trace(4, className, "setFlagWhenIdle(" + bl + ")", "Entry");
        this.serviceState.setFlagWhenIdle(bl);
        this.setIdle();
        Tracer.trace(4, className, "setFlagWhenIdle(" + bl + ")", "Exit");
    }

    public synchronized void setMapMode(int n) throws JposException {
        int n2;
        int n3;
        int n4;
        int n5;
        Tracer.trace(4, className, "setMapMode(" + n + ")", "Entry");
        int n6 = this.serviceState.getMapMode();
        if (n6 == n) {
            return;
        }
        if (this.serviceState.getCapRecPresent()) {
            n5 = this.serviceState.getRecLineSpacing();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n5, this.getDotsPerInchHigh(2), this.getMicronsPerStep(2));
            n5 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(2), this.getMicronsPerStep(2));
            this.serviceState.setRecLineSpacing(n5);
            n3 = this.serviceState.getRecLineHeight();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n3, this.getDotsPerInchHigh(2), this.getMicronsPerStep(2));
            n3 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(2), this.getMicronsPerStep(2));
            this.serviceState.setRecLineHeight(n3);
            n2 = this.serviceState.getRecLineWidth();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n2, this.getDotsPerInchWide(2), this.getMicronsPerStep(2));
            n2 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchWide(2), this.getMicronsPerStep(2));
            this.serviceState.setRecLineWidth(n2);
        }
        if (this.serviceState.getCapJrnPresent()) {
            n5 = this.serviceState.getJrnLineSpacing();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n5, this.getDotsPerInchHigh(1), this.getMicronsPerStep(1));
            n5 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(1), this.getMicronsPerStep(1));
            this.serviceState.setJrnLineSpacing(n5);
            n3 = this.serviceState.getJrnLineHeight();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n3, this.getDotsPerInchHigh(1), this.getMicronsPerStep(1));
            n3 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(1), this.getMicronsPerStep(1));
            this.serviceState.setJrnLineHeight(n3);
            n2 = this.serviceState.getJrnLineWidth();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n2, this.getDotsPerInchWide(1), this.getMicronsPerStep(1));
            n2 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchWide(1), this.getMicronsPerStep(1));
            this.serviceState.setJrnLineWidth(n2);
        }
        if (this.serviceState.getCapSlpPresent()) {
            n5 = this.serviceState.getSlpLineSpacing();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n5, this.getDotsPerInchHigh(4), this.getMicronsPerStep(4));
            n5 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(4), this.getMicronsPerStep(4));
            this.serviceState.setSlpLineSpacing(n5);
            n3 = this.serviceState.getSlpLineHeight();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n3, this.getDotsPerInchHigh(4), this.getMicronsPerStep(4));
            n3 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(4), this.getMicronsPerStep(4));
            this.serviceState.setSlpLineHeight(n3);
            n2 = this.serviceState.getSlpLineWidth();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n2, this.getDotsPerInchWide(4), this.getMicronsPerStep(4));
            n2 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchWide(4), this.getMicronsPerStep(4));
            this.serviceState.setSlpLineWidth(n2);
        }
        Tracer.trace(4, className, "setMapMode(" + n + ")", "Exit");
    }

    public synchronized void setRotateSpecial(int n) throws JposException {
    }

    public synchronized void setJrnLetterQuality(boolean bl) throws JposException {
        if (bl) {
            throw new JposException(106);
        }
    }

    public synchronized void setJrnLineChars(int n) throws JposException {
        this.setStateLineChars(n, 1);
    }

    public synchronized void setJrnLineHeight(int n) throws JposException {
    }

    public synchronized void setJrnLineSpacing(int n) throws JposException {
    }

    public synchronized void setRecLetterQuality(boolean bl) throws JposException {
        if (bl) {
            throw new JposException(106);
        }
    }

    public synchronized void setRecLineChars(int n) throws JposException {
        this.setStateLineChars(n, 2);
    }

    public synchronized void setRecLineSpacing(int n) throws JposException {
    }

    public synchronized void setRecLineHeight(int n) throws JposException {
    }

    public synchronized void setSlpLetterQuality(boolean bl) throws JposException {
        if (bl) {
            throw new JposException(106);
        }
    }

    public synchronized void setSlpLineChars(int n) throws JposException {
        this.setStateLineChars(n, 4);
    }

    public synchronized void setSlpLineHeight(int n) throws JposException {
    }

    public synchronized void setSlpLineSpacing(int n) throws JposException {
    }

    public int getForcedBitmapHeight() {
        return -1;
    }

    public int getForcedBitmapWidth() {
        return -1;
    }

    public void setCartridgeNotify(int n) throws JposException {
        if (n != 0) {
            throw new JposException(106);
        }
    }

    public void setJrnCurrentCartridge(int n) throws JposException {
        if (n != 1) {
            throw new JposException(106);
        }
    }

    public void setRecCurrentCartridge(int n) throws JposException {
        if (n != 1) {
            throw new JposException(106);
        }
    }

    public void setSlpCurrentCartridge(int n) throws JposException {
        if (n != 1) {
            throw new JposException(106);
        }
    }

    public void changePrintSide(int n) throws JposException {
        throw new JposException(106);
    }

    public void markFeed(int n) throws JposException {
        throw new JposException(106);
    }

    public abstract void setPOSSLineChars(int var1, int var2) throws JposException;

    protected int calcStationWidth(int n) {
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = this.serviceState.getRecLineWidth();
                break;
            }
            case 4: {
                n2 = this.serviceState.getSlpLineWidth();
            }
        }
        return n2;
    }

    protected int convertToDots(int n, int n2) throws JposException {
        int n3 = this.serviceState.getMapMode();
        int n4 = this.mapModeCalc.convertFromMapModeToMicrons(n3, n, this.getDotsPerInchWide(n2), this.getMicronsPerStep(n2));
        return this.mapModeCalc.convertFromMicronsToMapMode(1, n4, this.getDotsPerInchWide(n2), this.getMicronsPerStep(n2));
    }

    int computeLineChars(int n, int n2) throws JposException {
        int n3;
        Tracer.trace(4, className, "computeLineChars(" + n + ", " + n2 + ")", "Entry");
        int n4 = 1000;
        int n5 = -1;
        int n6 = -1;
        boolean bl = false;
        if (n < 1) {
            throw new JposException(106);
        }
        int n7 = 0;
        while (n7 < this.printerFonts.length) {
            if (this.printerFonts[n7].station == n2 && this.printerFonts[n7].lineChars == n) {
                bl = true;
                break;
            }
            ++n7;
        }
        if (n7 >= this.printerFonts.length) {
            n7 = 0;
            while (n7 < this.printerFonts.length) {
                if (this.printerFonts[n7].station == n2) {
                    int n8;
                    if (this.printerFonts[n7].lineChars > n6) {
                        n6 = this.printerFonts[n7].lineChars;
                    }
                    if (this.printerFonts[n7].lineChars > n && (n8 = Math.abs(this.printerFonts[n7].lineChars - n)) < n4) {
                        n4 = n8;
                        n5 = n7;
                    }
                }
                ++n7;
            }
            if (n > n6) {
                throw new JposException(106);
            }
            if (n5 == -1) {
                throw new JposException(106);
            }
            n3 = this.printerFonts[n5].lineChars;
            n7 = n5;
        } else {
            n3 = n;
        }
        Tracer.trace(4, className, "computeLineChars() =  " + n3, "Entry");
        return n7;
    }

    public void setStateLineChars(int n, int n2) throws JposException {
        Tracer.trace(4, className, "setStateLineChars(" + n + ", " + n2 + ")", "Entry");
        int n3 = this.computeLineChars(n, n2);
        int n4 = this.printerFonts[n3].lineChars;
        int n5 = this.mapModeCalc.convertFromMapModeToMicrons(this.serviceState.getMapMode(), this.printerFonts[n3].lineDots, this.getDotsPerInchWide(n2), this.getMicronsPerStep(n2));
        int n6 = this.mapModeCalc.convertFromMicronsToMapMode(this.serviceState.getMapMode(), n5, this.getDotsPerInchWide(n2), this.getMicronsPerStep(n2));
        n5 = this.mapModeCalc.convertFromMapModeToMicrons(1, this.printerFonts[n3].lineSpacing, this.getDotsPerInchHigh(n2), this.getMicronsPerStep(n2));
        int n7 = this.mapModeCalc.convertFromMicronsToMapMode(this.serviceState.getMapMode(), n5, this.getDotsPerInchHigh(n2), this.getMicronsPerStep(n2));
        switch (n2) {
            case 2: {
                this.serviceState.setRecLineWidth(n6);
                this.serviceState.setRecLineChars(n);
                this.setRecLineSpacing(n7);
                break;
            }
            case 4: {
                this.serviceState.setSlpLineWidth(n6);
                this.serviceState.setSlpLineChars(n);
                break;
            }
            case 1: {
                this.serviceState.setJrnLineWidth(n6);
                this.serviceState.setJrnLineChars(n);
            }
        }
        Tracer.trace(4, className, "setStateLineChars()", "Exit");
    }

    int possStation(int n) throws JposException {
        Tracer.trace(4, className, "possStation(" + n + ")", "Entry");
        int n2 = 1;
        switch (n) {
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
        Tracer.trace(4, className, "possStation(" + n + ")", "Exit");
        return n2;
    }

    int jposStation(int n) {
        Tracer.trace(4, className, "jposStation(" + n + ")", "Entry");
        int n2 = 2;
        switch (n) {
            case 2: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 4;
            }
        }
        Tracer.trace(4, className, "jposStation(" + n + ")", "Exit");
        return n2;
    }

    void sleep(int n) {
        Tracer.trace(4, className, "sleep(" + n + ")", "Entry");
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Tracer.trace(4, className, "sleep(" + n + ")", "Exit");
    }

    public void doPrinting(int n, byte[] byArray, int n2, int n3) throws JposException {
        this.doPrinting(n, null, null, byArray, n3, n2, false, false, -1);
    }

    public void doPrinting(int n, String string, String string2, int n2, int n3, boolean bl, boolean bl2) throws JposException {
        this.doPrinting(n, string, string2, null, n2, n3, bl, bl2);
    }

    public void doPrinting(int n, String string, String string2, byte[] byArray, int n2, int n3, boolean bl, boolean bl2, int n4) throws JposException {
        this.doPrinting(n, string, string2, byArray, n2, n3, bl, bl2);
    }

    public void doPrinting(int n, String string, String string2, byte[] byArray, int n2, int n3, boolean bl, boolean bl2) throws JposException {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        boolean bl3 = string != null && string.indexOf("\u001b5") >= 0;
        boolean bl4 = string != null && string.indexOf(INTERNAL_END_ROTATION_COMMAND) >= 0;
        boolean bl5 = string != null && string.indexOf(INTERNAL_END_TRANSACTION_COMMAND) >= 0;
        boolean bl6 = this.serviceState.getAsyncMode();
        Tracer.trace(4, className, "doPrinting( " + n + ", [" + string + "], [" + string2 + "], " + n2 + ", " + n3 + ", " + bl + ", " + bl2 + ")", "Entry");
        if (bl4 || bl5) {
            string = "\u001bv";
        }
        if (n == 2 && !this.serviceState.getCapConcurrentRecSlp() && this.slipInserted[0]) {
            throw new JposException(114, 8);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        switch (n) {
            default: {
                n5 = n;
                n4 = this.getLineChars(n);
                if (n2 == 1) {
                    string = this.addLineFeeds(string, n4, n);
                }
                if (!bl) break;
                this.doValidateData(n, string, stringBuffer, false);
                break;
            }
            case 3: {
                n5 = 2;
                n10 = 1;
                n4 = this.getLineChars(2);
                n11 = this.getLineChars(1);
                if (n2 == 1) {
                    string = this.addLineFeeds(string, n4, n);
                    string2 = this.addLineFeeds(string2, n11, n);
                }
                if (!bl) break;
                this.doValidateData(1, string, stringBuffer, false);
                this.doValidateData(2, string2, stringBuffer2, false);
                break;
            }
            case 5: {
                n5 = 1;
                n10 = 4;
                n4 = this.getLineChars(1);
                n11 = this.getLineChars(4);
                if (n2 == 1) {
                    string = this.addLineFeeds(string, n4, n);
                    string2 = this.addLineFeeds(string2, n11, n);
                }
                if (!bl) break;
                this.doValidateData(1, string, stringBuffer, false);
                this.doValidateData(4, string2, stringBuffer2, false);
                break;
            }
            case 6: {
                n5 = 2;
                n10 = 4;
                n4 = this.getLineChars(2);
                n11 = this.getLineChars(4);
                if (n2 == 1) {
                    string = this.addLineFeeds(string, n4, n);
                    string2 = this.addLineFeeds(string2, n11, n);
                }
                if (!bl) break;
                this.doValidateData(2, string, stringBuffer, false);
                this.doValidateData(4, string2, stringBuffer2, false);
            }
        }
        if (!bl && string != null) {
            stringBuffer = new StringBuffer(string);
        }
        if (bl2) {
            this.serviceState.setAsyncMode(false);
        }
        if (this.serviceState.getAsyncMode() && !bl2 && !this.printerManager.getTransactionMode(n) && !this.printerManager.getRotateSidewaysMode(n)) {
            this.outputID = this.outputIDCounter++;
            this.serviceState.setOutputID(this.outputID);
        }
        if (n == 4 || n == 5 || n == 6) {
            int n12 = this.serviceState.getSlpLineChars();
            int n13 = 0;
            while (n13 < this.printerFonts.length) {
                if (this.printerFonts[n13].lineChars == n12 && this.printerFonts[n13].station == 4) {
                    n6 = this.printerFonts[n13].diWidth;
                }
                ++n13;
            }
        }
        n7 = this.serviceState.getRecLineSpacing();
        n8 = this.serviceState.getSlpLineSpacing();
        n9 = this.serviceState.getJrnLineSpacing();
        if (this.serviceState.getAsyncMode() || this.printerManager.getRotateSidewaysMode(n)) {
            PrintData printData = new PrintData(n, this.outputID, n3, n3, n2, n6, this.printRotated[n5], n7, n8, n9, 1, stringBuffer.toString(), stringBuffer2.toString(), byArray, bl2, this.serviceState.getAsyncMode(), n4, n11, 0);
            this.printerManager.addData(printData);
        } else {
            if (!this.printerManager.getTransactionMode(n)) {
                if (this.serviceState.getCoverOpen()) {
                    this.serviceState.setAsyncMode(bl6);
                    throw new JposException(114, 201);
                }
                if (!this.isOnline()) {
                    this.serviceState.setAsyncMode(bl6);
                    throw new JposException(108);
                }
                switch (n5) {
                    case 2: {
                        if (!this.serviceState.getRecEmpty()) break;
                        this.serviceState.setAsyncMode(bl6);
                        throw new JposException(114, 203);
                    }
                    case 1: {
                        if (!this.serviceState.getJrnEmpty()) break;
                        this.serviceState.setAsyncMode(bl6);
                        throw new JposException(114, 202);
                    }
                    case 4: {
                        if (!this.serviceState.getSlpEmpty()) break;
                        this.serviceState.setAsyncMode(bl6);
                        throw new JposException(114, 204);
                    }
                }
                switch (n10) {
                    case 2: {
                        if (!this.serviceState.getRecEmpty()) break;
                        this.serviceState.setAsyncMode(bl6);
                        throw new JposException(114, 203);
                    }
                    case 1: {
                        if (!this.serviceState.getJrnEmpty()) break;
                        this.serviceState.setAsyncMode(bl6);
                        throw new JposException(114, 202);
                    }
                    case 4: {
                        if (!this.serviceState.getSlpEmpty()) break;
                        this.serviceState.setAsyncMode(bl6);
                        throw new JposException(114, 204);
                    }
                }
            }
            PrintData printData = new PrintData(n5, this.outputID, n3, n3, n2, n6, this.printRotated[n5], n7, n8, n9, 1, stringBuffer.toString(), stringBuffer2.toString(), byArray, bl2, this.serviceState.getAsyncMode(), n4, n11, 0);
            if (this.printerManager.getTransactionMode(n) && n2 != 16) {
                this.printerManager.addData(printData);
            } else {
                int n14;
                boolean[] blArray = printData.printlineSyncMode;
                synchronized (blArray) {
                    try {
                        printData.printlineSyncMode[n5] = false;
                        this.printerManager.addData(printData);
                        int n15 = (printData.data1.length() + printData.data2.length()) * 25 + 5000;
                        if (bl3) {
                            n15 = 11500;
                        } else if (bl4) {
                            n15 = 60000;
                        } else if (n2 != 1) {
                            n15 = 50000;
                        }
                        int n16 = Math.min(2000, n15 / 10);
                        n14 = 0;
                        Tracer.trace(3, className, "doPrinting()", "waiting for printlineSyncMode for " + n15);
                        while (n14 < n15 && !printData.printlineSyncMode[n5]) {
                            printData.printlineSyncMode.wait(n16);
                            if (!printData.printlineSyncMode[n5]) {
                                if (this.serviceState.getCoverOpen()) break;
                                switch (n5) {
                                    case 2: {
                                        if (!this.serviceState.getRecEmpty()) break;
                                        throw new JposException(114, 203);
                                    }
                                    case 1: {
                                        if (!this.serviceState.getJrnEmpty()) break;
                                        throw new JposException(114, 202);
                                    }
                                    case 4: {
                                        if (!this.serviceState.getSlpEmpty()) break;
                                        throw new JposException(114, 204);
                                    }
                                }
                            }
                            n14 += n16;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!printData.printlineSyncMode[n5]) {
                        Tracer.trace(4, className, "doPrinting()", "waiting for printLineSyncMode timed out");
                        if (this.errorEventException == null) {
                            if (this.serviceState.getCoverOpen()) {
                                this.errorEventException = new JposException(114, 201);
                                this.write("\u0010\u00052", 3);
                            } else {
                                this.errorEventException = new JposException(111);
                            }
                        }
                    }
                    if (this.errorEventException != null) {
                        JposException jposException = this.errorEventException;
                        this.errorEventException = null;
                        this.serviceState.setAsyncMode(bl6);
                        throw jposException;
                    }
                }
                if (n10 > 0) {
                    PrintData printData2 = new PrintData(n10, this.outputID, n3, n2, n6, this.printRotated[n10], n7, n8, n9, 2, stringBuffer.toString(), stringBuffer2.toString(), bl2, this.serviceState.getAsyncMode(), n4, n11);
                    boolean[] blArray2 = printData2.printlineSyncMode;
                    synchronized (blArray2) {
                        try {
                            printData2.printlineSyncMode[n5] = false;
                            this.printerManager.addData(printData2);
                            Tracer.trace(3, className, "doPrinting()", "waiting for printlineSyncMode for 20000");
                            n14 = 2000;
                            int n17 = 0;
                            while (n17 < 20000 && !printData2.printlineSyncMode[n10]) {
                                printData2.printlineSyncMode.wait(n14);
                                if (!printData2.printlineSyncMode[n10]) {
                                    if (this.serviceState.getCoverOpen()) break;
                                    switch (n10) {
                                        case 2: {
                                            if (!this.serviceState.getRecEmpty()) break;
                                            throw new JposException(114, 203);
                                        }
                                        case 1: {
                                            if (!this.serviceState.getJrnEmpty()) break;
                                            throw new JposException(114, 202);
                                        }
                                        case 4: {
                                            if (!this.serviceState.getSlpEmpty()) break;
                                            throw new JposException(114, 204);
                                        }
                                    }
                                }
                                n17 += n14;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!printData2.printlineSyncMode[n10]) {
                        Tracer.trace(4, className, "doPrinting()", "waiting for printLineSyncMode station 2 timed out");
                        if (this.errorEventException == null) {
                            this.errorEventException = new JposException(111);
                        }
                    }
                    if (this.errorEventException != null) {
                        JposException jposException = this.errorEventException;
                        this.errorEventException = null;
                        this.serviceState.setAsyncMode(bl6);
                        throw jposException;
                    }
                }
            }
        }
        this.serviceState.setAsyncMode(bl6);
        Tracer.trace(4, className, "doPrinting( " + n + ", [" + string + "], [" + string2 + "], " + n2 + ", " + n3 + ", " + bl + ", " + bl2 + ")", "Exit");
    }

    /*
     * Unable to fully structure code
     */
    public String addLineFeeds(String var1_1, int var2_2, int var3_3) {
        Tracer.trace(4, "CommApiPOSPrinterServiceImp", "addLineFeeds(\"" + var1_1 + "\", " + var2_2 + ", " + var3_3 + ")", "Entry");
        var4_4 = 1;
        var5_5 = 1;
        var6_6 = new StringBuffer("");
        var7_7 = var1_1.length();
        var8_8 = 0;
        if (var3_3 == 4 && this.printRotated[var3_3] == 258) {
            var2_2 = this.serviceState.getSlpSidewaysMaxChars();
        }
        var9_9 = 0;
        var10_10 = 0;
        var11_11 = var7_7;
        while (var9_9 < var11_11) {
            block108: {
                try {
                    block2 : switch (var1_1.charAt(var10_10++)) {
                        case '\u001b': {
                            switch (var1_1.charAt(var10_10++)) {
                                case '|': {
                                    switch (var1_1.charAt(var10_10++)) {
                                        case 'N': {
                                            var5_5 = 1;
                                            var4_4 = 1;
                                        }
                                        case 'P': {
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 'b': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case 'C': 
                                                case 'L': 
                                            }
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 'c': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case 'A': 
                                            }
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 'f': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case 'P': 
                                            }
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 'i': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case 'C': 
                                            }
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 'l': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case 'F': 
                                            }
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 'r': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case 'A': 
                                                case 'C': 
                                                case 'F': {
                                                    var6_6.append(var1_1.substring(var9_9, var10_10));
                                                    break block2;
                                                }
                                                case 'v': 
                                            }
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case 'C': 
                                            }
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 's': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case 'C': 
                                                case 'L': 
                                                case 'P': 
                                            }
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 't': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case 'L': 
                                            }
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 'u': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case 'C': 
                                                case 'F': 
                                            }
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                    }
                                    if (var1_1.charAt(--var10_10) == '-') {
                                        ++var10_10;
                                    }
                                    if (var1_1.charAt(var10_10) >= '0' && var1_1.charAt(var10_10) <= '9') ** GOTO lbl112
                                    var10_10 = var9_9 + 1;
                                    break block2;
lbl-1000:
                                    // 1 sources

                                    {
                                        ++var10_10;
lbl112:
                                        // 2 sources

                                        ** while (var1_1.charAt((int)var10_10) >= '0' && var1_1.charAt((int)var10_10) <= '9')
                                    }
lbl113:
                                    // 1 sources

                                    switch (var1_1.charAt(var10_10++)) {
                                        case 'B': 
                                        case 'P': {
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 'C': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case '1': {
                                                    var5_5 = 1;
                                                    var6_6.append(var1_1.substring(var9_9, var10_10));
                                                    break block2;
                                                }
                                                case '2': {
                                                    var5_5 = 2;
                                                    var6_6.append(var1_1.substring(var9_9, var10_10));
                                                    break block2;
                                                }
                                                case '3': {
                                                    var6_6.append(var1_1.substring(var9_9, var10_10));
                                                    break block2;
                                                }
                                                case '4': 
                                            }
                                            var5_5 = 2;
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 'f': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case 'P': 
                                                case 'T': 
                                            }
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 'h': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                    var6_6.append(var1_1.substring(var9_9, var10_10));
                                                    break block2;
                                                }
                                                case 'C': 
                                            }
                                            var12_12 = var9_9 + 2;
                                            while (Character.isDigit(var1_1.charAt(var12_12)) && var12_12 < var1_1.length()) {
                                                ++var12_12;
                                            }
                                            try {
                                                var4_4 = Integer.parseInt(var1_1.substring(var9_9 + 2, var12_12));
                                            }
                                            catch (NumberFormatException var13_14) {
                                                // empty catch block
                                            }
                                            if (var4_4 > 8) {
                                                var4_4 = 8;
                                            }
                                            if (var4_4 < 1) {
                                                var4_4 = 1;
                                            }
                                            if (var4_4 > 1 && var3_3 == 4) {
                                                var4_4 = this.serviceState.getCapSlpDwide() != false ? 2 : 1;
                                            }
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 'l': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case 'F': 
                                            }
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 's': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case 'C': 
                                                case 'P': 
                                            }
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 'r': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case 'F': 
                                            }
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 'u': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case 'C': 
                                                case 'F': 
                                            }
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                            break block2;
                                        }
                                        case 'v': {
                                            switch (var1_1.charAt(var10_10++)) {
                                                default: {
                                                    var10_10 = var9_9 + 1;
                                                }
                                                case 'C': 
                                            }
                                            var6_6.append(var1_1.substring(var9_9, var10_10));
                                        }
                                    }
                                    break block2;
                                }
                            }
                            var10_10 = var9_9 + 1;
                            var6_6.append(var1_1.substring(var9_9, var10_10));
                            break;
                        }
                        case '\r': {
                            if (var10_10 >= var11_11 || var1_1.charAt(var10_10) == '\n') {
                                // empty if block
                            }
                        }
                        case '\n': {
                            var6_6.append("\n");
                            var8_8 = 0;
                            break;
                        }
                        default: {
                            if (Character.isISOControl(var1_1.charAt(var9_9))) {
                                var6_6.append(var1_1.charAt(var9_9));
                                var10_10 = var9_9 + 1;
                                break;
                            }
                            var10_10 = var9_9;
                            while (var10_10 < var11_11) {
                                var13_15 = var1_1.charAt(var10_10);
                                if (var13_15 != '\r' && var13_15 != '\n' && var13_15 != '\u001b') {
                                    if (!Character.isISOControl(var13_15)) {
                                        if (var8_8 + var5_5 * var4_4 > var2_2) {
                                            var6_6.append("\n");
                                            var8_8 = 0;
                                        }
                                        var6_6.append(var1_1.charAt(var10_10));
                                        var8_8 += var5_5 * var4_4;
                                        ++var10_10;
                                        continue;
                                    }
                                }
                                break block108;
                            }
                            break;
                        }
                    }
                }
                catch (IndexOutOfBoundsException var12_13) {
                    var6_6.append(var1_1.substring(var9_9, var10_10 - 1));
                    var10_10 = var11_11;
                }
            }
            var9_9 = ++var10_10;
        }
        Tracer.trace(4, "CommApiPOSPrinterServiceImp", "addLineFeeds()", "Exit: \"" + var6_6.toString() + "\"");
        return var6_6.toString();
    }

    public void setIdle() throws JposException {
        Tracer.trace(4, className, "setIdle()", "Entry");
        if (!(this.printerManager.outputPending(2) || this.printerManager.outputPending(4) || this.printerManager.outputPending(2))) {
            this.serviceState.setState(2);
            if (this.serviceState.getFlagWhenIdle()) {
                this.serviceState.setFlagWhenIdle(false);
                StatusUpdateEvent statusUpdateEvent = new StatusUpdateEvent(this.serviceAbstraction, 1001);
                this.serviceEventQueueManager.postEvent(statusUpdateEvent);
            }
        }
        Tracer.trace(4, className, "setIdle()", "Exit");
    }

    int directPrintLine(int n, String string, int n2, int n3) throws JposException {
        PrintData printData = new PrintData(n, -1, n3, n2, 0, 1, this.serviceState.getRecLineSpacing(), this.serviceState.getSlpLineSpacing(), this.serviceState.getJrnLineSpacing(), 1, string, null, true, false, this.getLineChars(n), 0);
        return this.printLine(n, printData);
    }

    int directPrintLine(int n, String string, int n2, int n3, int n4) throws JposException {
        PrintData printData = new PrintData(n, -1, n3, n2, 0, n4, this.serviceState.getRecLineSpacing(), this.serviceState.getSlpLineSpacing(), this.serviceState.getJrnLineSpacing(), 1, string, null, true, false, this.getLineChars(n), 0);
        return this.printLine(n, printData);
    }

    void handlePrintLineError() throws JposException {
        this.handlePossError();
    }

    public abstract int printLine(int var1, PrintData var2) throws JposException;

    abstract void setLineSpacing(int var1, int var2) throws JposException;

    public abstract int getDotsPerInchHigh(int var1) throws JposException;

    public abstract int getDotsPerInchWide(int var1) throws JposException;

    public abstract int getMicronsPerStep(int var1) throws JposException;

    public abstract int getMaxBytesPerWrite(int var1) throws JposException;

    public abstract byte[] getBitmapHeader(int var1) throws JposException;

    public abstract boolean requiresLinefeed(int var1);

    public abstract void doPrintlinePrintBitmap(int var1, byte[] var2) throws JposException;

    public void doValidateData(int n, String string, StringBuffer stringBuffer, boolean bl) throws JposException {
        Tracer.trace(4, className, "doValidateData(" + n + "," + string + "," + stringBuffer.toString() + "," + bl + ")", "Entry");
        if (this.validator == null) {
            this.validator = new Validator(this.serviceState, this);
            if (this.validator == null) {
                throw new JposException(111);
            }
        }
        this.validator.validateData(n, string, stringBuffer, bl);
        Tracer.trace(4, className, "doValidateData(" + n + "," + string + "," + stringBuffer.toString() + "," + bl + ")", "Exit");
    }

    public abstract void doPrintBitmap(int var1, int var2, StringBuffer var3) throws JposException;

    public abstract void doPrintTopLogo(StringBuffer var1) throws JposException;

    public abstract void doPrintBottomLogo(StringBuffer var1) throws JposException;

    public abstract void doBold(StringBuffer var1) throws JposException;

    public abstract void doUnderline(StringBuffer var1) throws JposException;

    public abstract void doReverseVideo(StringBuffer var1) throws JposException;

    public abstract void doSizeDoubleWide(StringBuffer var1) throws JposException;

    public abstract void doSizeDoubleHigh(StringBuffer var1) throws JposException;

    public abstract void doSizeDoubleHighDoubleWide(StringBuffer var1) throws JposException;

    public abstract void doSizeNormal(StringBuffer var1) throws JposException;

    public abstract void doNormal(StringBuffer var1, int var2) throws JposException;

    public void doAlignRight(StringBuffer stringBuffer) {
        this.currentAlignment = -3;
    }

    public void doAlignCenter(StringBuffer stringBuffer) {
        this.currentAlignment = -2;
    }

    public void doAlignLeft(StringBuffer stringBuffer) {
        this.currentAlignment = -1;
    }

    public void doShading(int n, StringBuffer stringBuffer) throws JposException {
        throw new JposException(111);
    }

    public int asyncModeErrorCheck(int n) {
        return 0;
    }

    protected void handlePossError() throws JposException {
        Tracer.trace(4, className, "handlePossError()", "Entry");
        if (this.serviceState.getAsyncMode()) {
            this.posmPrnPrinterError((short)-1, 0);
        } else {
            this.errorEventException = new JposException(111);
        }
        Tracer.trace(4, className, "handlePossError()", "Exit");
    }

    void setFeedDirection(int n) throws JposException {
        this.currentFeedDirection = n;
    }

    public abstract int doRegisterDocument() throws JposException;

    public abstract int doEjectDocument() throws JposException;

    public int getCurrentStation() throws PosException {
        return this.lastPossStation;
    }

    public void setStation(int n, boolean bl) throws JposException {
        this.setPossStation(n, bl);
    }

    public int getErrorNo() throws JposException {
        return -1;
    }

    public PrinterCommunicationsManager getPrinterManager() throws JposException {
        return this.printerManager;
    }

    protected long posmPrnPrinterError(short s, int n) {
        int n2 = 0;
        int n3 = 0;
        String string = POSPrinterServiceMsg.UNKNOWN;
        int n4 = 0;
        int n5 = 111;
        int n6 = 0;
        Tracer.trace(4, className, "posmPrnPrinterError(" + s + "," + n + ")", "Entry");
        if (s == -1) {
            this.errorEventException = new JposException(111);
            n2 = 2;
            n3 = 2;
            string = POSPrinterServiceMsg.DEVICE_WRITE_FAILURE;
        }
        if (s == 1) {
            this.errorEventException = new JposException(114, 201);
            n2 = 2;
            n3 = 2;
            string = POSPrinterServiceMsg.COVER_OPEN;
            n5 = 114;
            n6 = 201;
        } else if (s == 2) {
            n2 = 2;
            n3 = 2;
            string = POSPrinterServiceMsg.TRANSPORT_ERROR;
        } else if (s == 3) {
            n2 = 2;
            n3 = 2;
            string = POSPrinterServiceMsg.PRINT_HEAD_OPEN;
        } else if (s == 4) {
            n2 = 2;
            n3 = 1;
            string = POSPrinterServiceMsg.JOURNAL_PAPER_ERROR;
        } else if (s == 5) {
            n2 = 2;
            n3 = 1;
            string = POSPrinterServiceMsg.JOURNAL_PRINT_HEAD_OPEN;
        } else if (s == 8) {
            n2 = 2;
            n3 = 4;
            string = POSPrinterServiceMsg.DOCUMENT_INSERTED;
        } else if (s == 16) {
            this.errorEventException = new JposException(114, 204);
            n2 = 2;
            n3 = 4;
            string = POSPrinterServiceMsg.DOCUMENT_NOT_INSERTED;
            n5 = 114;
            n6 = 204;
        } else if (s == 32) {
            this.errorEventException = new JposException(114, 204);
            n2 = 2;
            n3 = 4;
            string = POSPrinterServiceMsg.DOCUMENT_NOT_READY;
            n5 = 114;
            n6 = 204;
        } else if (s == 64) {
            this.errorEventException = new JposException(114, 205);
            n2 = 2;
            n3 = 4;
            string = POSPrinterServiceMsg.DOCUMENT_NOT_EJECTED;
            n5 = 114;
            n6 = 205;
        } else if (s == 128) {
            n2 = 2;
            n3 = 4;
            string = POSPrinterServiceMsg.MICR_ERROR;
        } else if (s == 256) {
            n2 = 2;
            n3 = 2;
            string = POSPrinterServiceMsg.PAPER_ERROR;
            n5 = 114;
            n6 = 203;
        } else if (s == 512) {
            n2 = 2;
            n3 = 2;
            string = POSPrinterServiceMsg.EEPROM_LOAD_ERROR;
        } else if (s == 1024) {
            n2 = 2;
            n3 = 2;
            string = POSPrinterServiceMsg.EEPROM_FULL;
        } else if (s == 4096) {
            n2 = 2;
            n3 = 2;
            string = POSPrinterServiceMsg.INTERNAL_COMMUNICATION_ERROR;
        } else if (s == 8192) {
            n2 = 2;
            n3 = 4;
            string = POSPrinterServiceMsg.SLIP_FEED_ERROR;
        } else if (s == 16384) {
            n2 = 3;
            n3 = 2;
            string = POSPrinterServiceMsg.STARTUP_ERROR;
        } else if (s == 16385) {
            n2 = 3;
            n3 = 2;
            string = POSPrinterServiceMsg.UNRECOVERABLE_ERROR;
        } else if (s == Short.MIN_VALUE) {
            n2 = 2;
            n3 = 2;
            string = POSPrinterServiceMsg.COMMAND_REJECTED;
        }
        if (!this.serviceState.getAsyncMode()) {
            return n4;
        }
        POSSPrinterErrorEvent pOSSPrinterErrorEvent = null;
        try {
            this.serviceState.setState(4);
            pOSSPrinterErrorEvent = new POSSPrinterErrorEvent(this.callbackHandler.getEventSource(), n5, n6, 1, 11, this.serviceState, n2, n3, string);
            this.firingComplete[0] = false;
            boolean[] blArray = this.firingComplete;
            synchronized (blArray) {
                this.serviceEventQueueManager.postEvent(pOSSPrinterErrorEvent);
                this.firingComplete.wait();
            }
            if (!this.firingComplete[0]) {
                n4 = 12;
            }
            try {
                this.serviceState.setErrorLevel(1);
                this.serviceState.setErrorStation(2);
                this.serviceState.setErrorString("");
            }
            catch (JposException jposException) {
                // empty catch block
            }
            if (n4 == 0) {
                n4 = ((ErrorEvent)pOSSPrinterErrorEvent.getJposEvent()).getErrorResponse();
            }
            switch (n4) {
                case 12: {
                    this.printerManager.clearOutput();
                    this.setIdle();
                    this.serviceEventQueueManager.removeAllErrorEvent();
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Tracer.trace(4, className, "posmPrnPrinterError(" + s + "," + n + ")", "Exit");
        return n4;
    }

    protected abstract void recoverPrinting() throws JposException;

    public abstract void endRemoval() throws JposException;

    public abstract void beginRemoval(int var1) throws JposException;

    public abstract void endInsertion() throws JposException;

    public abstract void beginInsertion(int var1) throws JposException;

    public abstract void doScaleVertically(int var1, StringBuffer var2, boolean var3) throws JposException;

    public abstract void doScaleHorizontally(int var1, StringBuffer var2, boolean var3) throws JposException;

    public abstract void doAlternateColor(StringBuffer var1, boolean var2, int var3, int var4) throws JposException;

    public abstract void doFeedReverse(int var1, StringBuffer var2, boolean var3) throws JposException;

    public abstract void setSlipRemoved(boolean var1) throws JposException;

    public abstract void waitForSlipRemoved(int var1) throws JposException;

    public abstract boolean isSlipRemoved() throws JposException;

    public abstract void waitForSlipReady(int var1) throws JposException;

    public abstract boolean isSlipReady() throws JposException;

    public abstract void waitForSlipInserted(int var1) throws JposException;

    public abstract boolean isSlipInserted() throws JposException;

    public abstract int getMaxPrintBitmapSize() throws JposException;

    public abstract int getMaxSetBitmapSize(int var1) throws JposException;

    public abstract void downloadData(int var1, byte[] var2, int var3, int var4) throws JposException;

    public abstract void downloadData(int var1, String var2, int var3, int var4) throws JposException;

    class POSSPrinterErrorEvent
    implements JposEventContainer {
        private POSPrinterServiceState serviceState = null;
        private ErrorEvent errorEvent = null;
        private int errorLevel = 0;
        private int errorStation = 0;
        private String errorString;
        private final String className = "POSSPrinterErrorEvent";

        public POSSPrinterErrorEvent(Object object, int n, int n2, int n3, int n4, POSPrinterServiceState pOSPrinterServiceState, int n5, int n6, String string) {
            Tracer.trace(3, "POSSPrinterErrorEvent", "Constructor", "***** POSSPrinterErrorEvent created *****");
            this.errorEvent = new ErrorEvent(object, n, n2, n3, n4);
            this.serviceState = pOSPrinterServiceState;
            this.errorLevel = n5;
            this.errorStation = n6;
            this.errorString = new String(string);
        }

        public JposEvent getJposEvent() {
            return this.errorEvent;
        }

        public void doneFiring() {
            boolean[] blArray = CommApiPOSPrinterServiceImp.this.firingComplete;
            synchronized (blArray) {
                CommApiPOSPrinterServiceImp.this.firingComplete[0] = true;
                CommApiPOSPrinterServiceImp.this.firingComplete.notifyAll();
            }
        }

        public void prepareToFire() {
            try {
                this.serviceState.setErrorLevel(this.errorLevel);
                this.serviceState.setErrorStation(this.errorStation);
                this.serviceState.setErrorString(this.errorString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

