/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.DeviceServiceImp;
import com.ibm.jpos.services.DeviceServiceImpMsg;
import com.ibm.jpos.services.ImpFactory;
import com.ibm.jpos.services.ServiceInstanceImp;
import com.ibm.jpos.services.ServiceRegistry;
import com.ibm.jpos.services.jcomm.CommApiServiceInfo;
import com.ibm.jpos.services.jcomm.CommApiServiceKey;
import com.ibm.jpos.util.JposEntryInfo;
import java.lang.reflect.Constructor;
import jpos.JposException;

public class CommApiImpFactory
extends ImpFactory {
    public static final String PORT_NUMBER_PROP_NAME = "commComPort";
    public static final String DRAWER_NUMBER_PROP_NAME = "commDrawerNumber";
    public static final String UNIT_ID_PROP_NAME = "commUnitIdentifier";

    public static ServiceInstanceImp createImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        JposEntryInfo jposEntryInfo = deviceServiceAbstraction.getDeviceServiceState().getJposEntryInfo();
        String string = jposEntryInfo.getImpClassName();
        Class<?> clazz = null;
        try {
            if (string != null) {
                clazz = Class.forName(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_FOUND_MSG, classNotFoundException);
        }
        Constructor constructor = CommApiImpFactory.lookForValidImpConstructor(clazz);
        if (constructor == null) {
            throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_COMPLIANT_MSG);
        }
        DeviceServiceImp deviceServiceImp = null;
        Object[] objectArray = new Object[]{deviceServiceAbstraction};
        try {
            deviceServiceImp = (DeviceServiceImp)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_INSTANTIATION_ERROR_MSG, exception);
        }
        try {
            CommApiServiceKey commApiServiceKey = CommApiImpFactory.createServiceKey(jposEntryInfo, deviceServiceAbstraction.getDeviceCategory());
            deviceServiceAbstraction.getDeviceServiceState().setServiceKey(commApiServiceKey);
            ServiceRegistry.getInstance().setServiceInfo(commApiServiceKey, new CommApiServiceInfo(commApiServiceKey));
        }
        catch (Exception exception) {
            throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_INSTANTIATION_ERROR_MSG, exception);
        }
        return deviceServiceImp;
    }

    private static CommApiServiceKey createServiceKey(JposEntryInfo jposEntryInfo, String string) {
        String string2 = "";
        String string3 = "0";
        if (jposEntryInfo.hasPropertyWithName(PORT_NUMBER_PROP_NAME)) {
            string2 = jposEntryInfo.getPropertyValue(PORT_NUMBER_PROP_NAME).toString();
        }
        if (jposEntryInfo.hasPropertyWithName(UNIT_ID_PROP_NAME)) {
            string3 = jposEntryInfo.getPropertyValue(UNIT_ID_PROP_NAME).toString();
        } else if (string.indexOf("CashDrawer") != -1 && jposEntryInfo.hasPropertyWithName(DRAWER_NUMBER_PROP_NAME)) {
            string3 = jposEntryInfo.getPropertyValue(DRAWER_NUMBER_PROP_NAME).toString();
        }
        CommApiServiceKey commApiServiceKey = new CommApiServiceKey(string2, string3, string);
        return commApiServiceKey;
    }

    private static Constructor lookForValidImpConstructor(Class clazz) {
        Constructor<?>[] constructorArray = null;
        try {
            constructorArray = clazz.getDeclaredConstructors();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (constructorArray == null || constructorArray.length == 0) {
            return null;
        }
        Constructor<?> constructor = null;
        int n = 0;
        while (n < constructorArray.length) {
            Class<?>[] classArray = constructorArray[n].getParameterTypes();
            if (classArray.length == 1 && classArray[0].getName().equals("com.ibm.jpos.services.DeviceServiceAbstraction")) {
                constructor = constructorArray[n];
                break;
            }
            ++n;
        }
        return constructor;
    }
}

