/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.DeviceServiceImp;
import com.ibm.jpos.services.DeviceServiceState;
import com.ibm.jpos.services.EventQueueManager;
import com.ibm.jpos.services.ServiceInstanceImp;
import com.ibm.jpos.services.jcomm.CommApiDeviceConnection;
import com.ibm.jpos.services.jcomm.CommApiImpFactory;
import com.ibm.jpos.util.Debug;
import com.ibm.jpos.util.Tracer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.comm.SerialPort;
import jpos.JposConst;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.services.EventCallbacks;

public abstract class CommApiDeviceServiceImp
implements DeviceServiceImp,
JposConst {
    private static Vector instanceVector = new Vector();
    private SerialPort serialPort = null;
    private DeviceServiceAbstraction dsAbstraction = null;
    private OutputStream outputStream = null;
    private InputStream inputStream = null;
    private JposEntry jposEntry = null;
    private Hashtable posResourceHashtable = null;
    private String logicalName = null;
    protected CommApiDeviceConnection deviceConnection = null;
    protected String comPort = null;
    protected String baudRate = "9600";
    protected String flowControl = "NONE";
    protected int dataBits = 8;
    protected int stopBits = 1;
    protected int parityBits = 0;
    private Object writeMutex = new Object();
    protected static Debug debug = new Debug(false);
    protected static Debug debugPrintBitmap = new Debug(false);
    protected static Debug debugInsertion = new Debug(false);
    protected static Debug debugRemoval = new Debug(false);
    protected static Debug debugStationSet = new Debug(false);
    protected static Debug debugPrintMessage = new Debug(false);
    protected static Debug debugPrintLine = new Debug(false);
    private static final String className = "CommApiDeviceServiceImp";

    protected CommApiDeviceServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        if (deviceServiceAbstraction == null) {
            throw new JposException(106);
        }
        this.dsAbstraction = deviceServiceAbstraction;
        this.jposEntry = deviceServiceAbstraction.getDeviceServiceState().getJposEntryInfo().getJposEntry();
        this.logicalName = deviceServiceAbstraction.getDeviceServiceState().getJposEntryInfo().getLogicalName();
    }

    public boolean isOnline() {
        Tracer.trace(4, className, "isOnline()", "Entry");
        boolean bl = this.getDeviceConnection() != null && this.getDeviceConnection().isOnline();
        Tracer.trace(4, className, "isOnline()", "Exit: " + (bl ? "true" : "false"));
        return bl;
    }

    public synchronized void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open('" + string + "', " + eventCallbacks + ")", "Entry");
        Hashtable hashtable = this.getPosResourceHashtable();
        try {
            if (this.jposEntry != null) {
                String string2 = "";
                Enumeration enumeration = null;
                String[] stringArray = new String[]{"comm"};
                int n = 0;
                while (n < stringArray.length) {
                    enumeration = this.jposEntry.getPropertyNames();
                    while (enumeration.hasMoreElements()) {
                        string2 = (String)enumeration.nextElement();
                        if (!string2.startsWith(stringArray[n])) continue;
                        hashtable.put(string2.substring(stringArray[n].length(), string2.length()), this.jposEntry.getPropertyValue(string2));
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            Tracer.trace(1, className, "open()", "Buscard Exceptition is " + exception);
            throw new JposException(111);
        }
        if (!hashtable.get("ComPort").toString().equals("")) {
            this.comPort = hashtable.get("ComPort").toString();
        }
        if (!hashtable.get("BaudRate").toString().equals("")) {
            this.baudRate = hashtable.get("BaudRate").toString();
        }
        if (!hashtable.get("ControlFlow").toString().equals("")) {
            this.flowControl = hashtable.get("ControlFlow").toString();
        } else if (!hashtable.get("FlowControl").toString().equals("")) {
            this.flowControl = hashtable.get("FlowControl").toString();
        }
        Tracer.trace(3, className, "open()", "Finished scanning Buscard" + this.comPort + ", " + this.baudRate + ", " + this.flowControl);
        this.deviceConnection = CommApiDeviceConnection.open(this.comPort, new Integer(this.baudRate), this.flowControl, this.dataBits, this.stopBits, this.parityBits);
    }

    public synchronized void close() throws JposException {
        if (this.getDeviceConnection() != null && this.getDeviceConnection().isOpen()) {
            this.getDeviceConnection().close();
        }
    }

    public void claim(int n) throws JposException {
        Tracer.trace(4, className, "claim(" + n + ")", "Entry");
        if (!this.isOnline()) {
            throw new JposException(108);
        }
        Tracer.trace(4, className, "claim(" + n + ")", "Exit");
    }

    public void release() throws JposException {
        Tracer.trace(4, className, "release", "Entry");
        Tracer.trace(4, className, "release", "Exit");
    }

    public void checkHealth(int n) throws JposException {
        DeviceServiceState deviceServiceState = this.getDeviceServiceState();
        switch (n) {
            case 1: {
                if (this.isOnline()) {
                    deviceServiceState.setCheckHealthText("Internal HCheck: Successful");
                    break;
                }
                deviceServiceState.setCheckHealthText("Internal HCheck: Not Responding");
                throw new JposException(108);
            }
            case 2: {
                if (this.isOnline()) {
                    deviceServiceState.setCheckHealthText("External HCheck: Successful");
                    break;
                }
                deviceServiceState.setCheckHealthText("External HCheck: Not Responding");
                throw new JposException(108);
            }
            default: {
                deviceServiceState.setCheckHealthText("");
                throw new JposException(106);
            }
        }
    }

    public void directIO(int n, int[] nArray, Object object) throws JposException {
    }

    public int write(String string, int n) throws JposException {
        Tracer.trace(4, className, "write(\"" + string + "\")", "Entry");
        if (!this.isOnline()) {
            throw new JposException(108);
        }
        if (n < string.length()) {
            n = string.length();
        }
        if (n > 0) {
            try {
                this.getDeviceConnection().getOutputStream().write(string.getBytes("8859_1"), 0, n);
            }
            catch (Exception exception) {
                throw new JposException(111, "JPOS_E_FAILURE: " + exception.getMessage(), exception);
            }
        }
        Tracer.trace(4, className, "write()", "Exit");
        return n;
    }

    public int write(String string) throws JposException {
        return this.write(string, string.length());
    }

    public int read(byte[] byArray, int n) throws JposException {
        Tracer.trace(4, className, "read(byte[" + byArray.length + "])", "Entry");
        int n2 = 0;
        if (!this.isOnline()) {
            throw new JposException(108);
        }
        if (n > byArray.length) {
            n = byArray.length;
        }
        if (n > 0) {
            try {
                while (n2 < n) {
                    byArray[n2] = (byte)this.getDeviceConnection().getInputStream().read();
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Tracer.trace(4, className, "read()", "Exit: " + n2);
        return n2;
    }

    public int read(byte[] byArray) throws JposException {
        return this.read(byArray, byArray.length);
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        Tracer.trace(4, className, "setDeviceEnabled()", "Entry");
        if (bl && !this.isOnline()) {
            throw new JposException(108);
        }
        Tracer.trace(4, className, "setDeviceEnabled()", "Exit");
    }

    public void setFreezeEvents(boolean bl) throws JposException {
        Tracer.trace(4, className, "freezeEvents()", "Entry");
        Tracer.trace(4, className, "freezeEvents()", "Exit");
    }

    public void setPowerNotify(int n) throws JposException {
    }

    public synchronized void deleteImp() throws JposException {
    }

    public static ServiceInstanceImp createImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        ServiceInstanceImp serviceInstanceImp = CommApiImpFactory.createImp(deviceServiceAbstraction);
        return serviceInstanceImp;
    }

    protected DeviceServiceAbstraction getDeviceServiceAbstraction() {
        return this.dsAbstraction;
    }

    protected DeviceServiceState getDeviceServiceState() {
        return this.dsAbstraction.getDeviceServiceState();
    }

    protected EventQueueManager getEventQueueManager() throws JposException {
        return this.dsAbstraction.getEventQueueManager();
    }

    protected JposEntry getJposEntry() {
        return this.jposEntry;
    }

    protected SerialPort getSerialPort() {
        return this.getDeviceConnection() == null ? null : this.getDeviceConnection().getSerialPort();
    }

    protected String getComPort() {
        return this.getDeviceConnection() == null ? "" : this.getDeviceConnection().getPortName();
    }

    protected InputStream getInputStream() {
        return this.getDeviceConnection() == null ? null : this.getDeviceConnection().getInputStream();
    }

    protected OutputStream getOutputStream() {
        return this.getDeviceConnection() == null ? null : this.getDeviceConnection().getOutputStream();
    }

    protected Hashtable getPosResourceHashtable() {
        if (this.posResourceHashtable == null) {
            this.posResourceHashtable = new Hashtable();
        }
        return this.posResourceHashtable;
    }

    protected CommApiDeviceConnection getDeviceConnection() {
        return this.deviceConnection;
    }
}

