/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.util.Tracer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import jpos.JposConst;
import jpos.JposException;

class CommApiDeviceConnection
implements JposConst {
    protected static Vector commApiDeviceConnectionVector = new Vector();
    private static Integer portSemaphore = new Integer(0);
    private String portName = "COM1";
    private SerialPort serialPort = null;
    private int openCount = 0;
    private static final String className = "CommApiDeviceConnection";

    protected CommApiDeviceConnection(String string, int n, String string2, int n2, int n3, int n4) throws JposException {
        Tracer.trace(4, className, "Constructor", "Entry");
        this.portName = string;
        try {
            this.serialPort = (SerialPort)CommPortIdentifier.getPortIdentifier(string).open(className, 2000);
        }
        catch (NoSuchPortException noSuchPortException) {
            throw new JposException(107, "no such port: \"" + string + "\"");
        }
        catch (PortInUseException portInUseException) {
            throw new JposException(111, "port in use: \"" + string + "\"");
        }
        catch (ClassCastException classCastException) {
            throw new JposException(107, "not a serial port: \"" + string + "\"");
        }
        catch (Exception exception) {
            throw new JposException(111, "can't connect to serial port: \"" + string + "\": " + exception.getMessage(), exception);
        }
        if (!this.isOnline()) {
            this.serialPort.close();
            throw new JposException(108);
        }
        try {
            this.serialPort.setSerialPortParams(n, n2, n3, n4);
            if (string2.equalsIgnoreCase("XON/XOFF")) {
                this.serialPort.setFlowControlMode(12);
            } else if (string2.equalsIgnoreCase("RTS/CTS")) {
                this.serialPort.setFlowControlMode(3);
            } else {
                this.serialPort.setFlowControlMode(0);
            }
        }
        catch (Exception exception) {
            throw new JposException(111, "unexpected failure: " + exception.getMessage(), exception);
        }
        this.openCount = 1;
        Tracer.trace(4, className, "Constructor", "Exit");
    }

    public static synchronized CommApiDeviceConnection open(String string, int n, String string2, int n2, int n3, int n4) throws JposException {
        Object object;
        Object object2;
        Tracer.trace(4, className, "open()", "Entry");
        if (Tracer.getTraceLevel() > 3) {
            Tracer.trace(4, className, "open()", "SerialPort Enumeration: ");
            object2 = CommPortIdentifier.getPortIdentifiers();
            while (object2.hasMoreElements()) {
                object = (CommPortIdentifier)object2.nextElement();
                if (((CommPortIdentifier)object).getPortType() != 1) continue;
                Tracer.trace(4, className, "open()", "\t" + ((CommPortIdentifier)object).getName());
            }
        }
        object2 = null;
        object = commApiDeviceConnectionVector;
        synchronized (object) {
            Enumeration enumeration = commApiDeviceConnectionVector.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (CommApiDeviceConnection)enumeration.nextElement();
                if (((CommApiDeviceConnection)object2).getPortName().equals(string)) {
                    ((CommApiDeviceConnection)object2).incrementOpenCount();
                    break;
                }
                object2 = null;
            }
            if (object2 == null) {
                object2 = new CommApiDeviceConnection(string, n, string2, n2, n3, n4);
                commApiDeviceConnectionVector.addElement(object2);
            }
        }
        return object2;
    }

    public synchronized void close() {
        Tracer.trace(4, className, "close()", "Entry");
        Vector vector = commApiDeviceConnectionVector;
        synchronized (vector) {
            Tracer.trace(3, className, "close()", "open count == " + this.openCount);
            if (this.decrementOpenCount() == 0) {
                Tracer.trace(3, className, "close()", "closing serial port");
                try {
                    this.serialPort.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.serialPort = null;
                commApiDeviceConnectionVector.removeElement(this);
            }
        }
        Tracer.trace(4, className, "close()", "Exit");
    }

    public synchronized int write(byte[] byArray, int n) throws JposException {
        Tracer.trace(4, className, "write([" + byArray.toString() + "], " + n + ")", "Entry");
        if (this.isOnline()) {
            try {
                Integer n2 = portSemaphore;
                synchronized (n2) {
                    this.serialPort.getOutputStream().write(byArray, 0, n);
                }
            }
            catch (Exception exception) {
                throw new JposException(111, "write failure: " + exception.getMessage(), exception);
            }
            Tracer.trace(4, className, "write([" + byArray.toString() + "], " + n + ")", "Exit");
            return n;
        }
        throw new JposException(108);
    }

    public int write(String string, int n) throws JposException {
        Tracer.trace(4, className, "write(\"" + string + "\", " + n + ")", "Entry");
        try {
            byte[] byArray = string.getBytes("8859_1");
            return this.write(byArray, n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "write failure: " + exception.getMessage(), exception);
        }
    }

    public int write(String string) throws JposException {
        return this.write(string, string.length());
    }

    public int write(byte[] byArray) throws JposException {
        return this.write(byArray, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n) throws JposException {
        Tracer.trace(4, className, "read(byte[], " + n + ")", "Entry");
        int n2 = 0;
        if (n > byArray.length) {
            n = byArray.length;
        }
        try {
            while (n2 < n) {
                byArray[n2] = (byte)this.getInputStream().read();
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Tracer.trace(4, className, "read()", "Exit: " + n2);
        return n2;
    }

    public int read(byte[] byArray) throws JposException {
        return this.read(byArray, byArray.length);
    }

    public boolean isOnline() {
        Tracer.trace(4, className, "isOnline()", "Entry");
        boolean bl = this.serialPort != null && this.serialPort.isDSR();
        Tracer.trace(4, className, "isOnline()", "Exit: " + (bl ? "true" : "false"));
        return bl;
    }

    public boolean isOpen() {
        return this.openCount > 0;
    }

    protected int incrementOpenCount() {
        return ++this.openCount;
    }

    protected int decrementOpenCount() {
        return --this.openCount;
    }

    public SerialPort getSerialPort() {
        return this.serialPort;
    }

    public String getPortName() {
        return this.portName;
    }

    public int getBaudRate() {
        try {
            return this.serialPort.getBaudRate();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getDataBits() {
        try {
            return this.serialPort.getDataBits();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getStopBits() {
        try {
            return this.serialPort.getStopBits();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getParity() {
        try {
            return this.serialPort.getParity();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getFlowControlMode() {
        try {
            return this.serialPort.getFlowControlMode();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public InputStream getInputStream() {
        try {
            return this.serialPort.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public OutputStream getOutputStream() {
        try {
            return this.serialPort.getOutputStream();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Integer getPortSemaphore() {
        return portSemaphore;
    }

    public int getTraceLevel() {
        return Tracer.getTracerLevel();
    }

    public void setTraceLevel(int n) {
        Tracer.setTracerLevel(n);
    }
}

