/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.jcomm.CommApiDeviceConnection;
import com.ibm.jpos.services.jcomm.IBM4840MSREvent;
import com.ibm.jpos.services.jcomm.IBM4840MSREventListener;
import com.ibm.jpos.util.Tracer;
import java.io.IOException;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import jpos.JposConst;
import jpos.JposException;

class CommApi4840MSRConnection
extends CommApiDeviceConnection
implements SerialPortEventListener,
JposConst {
    private static String className = "CommApi4840MSRConnection";
    static Vector ibm4840MSREventListenerVector = new Vector();
    private static int MSRState = 0;
    private static int MSRDataLenght = 0;
    private byte[] MSRData = new byte[0];

    protected CommApi4840MSRConnection(String string, int n, String string2, int n2, int n3, int n4) throws JposException {
        super(string, n, string2, n2, n3, n4);
        Tracer.trace(4, className, " ", " constructor -  portName:" + string + ", " + " baudRate:" + n + ", " + " controlFlow:" + string2 + " dataBits:" + n2 + " stopBits:" + n3 + " parityBits:" + n4);
        try {
            this.getSerialPort().addEventListener(this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            throw new JposException(111, tooManyListenersException.getMessage(), tooManyListenersException);
        }
        this.getSerialPort().notifyOnFramingError(true);
        this.getSerialPort().notifyOnOverrunError(true);
        this.getSerialPort().notifyOnParityError(true);
        this.getSerialPort().notifyOnDSR(true);
        this.getSerialPort().notifyOnCTS(true);
        this.getSerialPort().notifyOnDataAvailable(true);
    }

    public static synchronized CommApiDeviceConnection open(String string, int n, String string2, int n2, int n3, int n4) throws JposException {
        Tracer.trace(4, className, "open ", " Entry -  portName:" + string + ", " + " baudRate:" + n + ", " + " flowControl:" + string2 + ", " + " dataBits:" + n2 + ", " + " stopBits:" + n3 + ", " + " parityBits:" + n4);
        CommApiDeviceConnection commApiDeviceConnection = null;
        Vector vector = CommApiDeviceConnection.commApiDeviceConnectionVector;
        synchronized (vector) {
            Enumeration enumeration = CommApiDeviceConnection.commApiDeviceConnectionVector.elements();
            while (enumeration.hasMoreElements()) {
                commApiDeviceConnection = (CommApiDeviceConnection)enumeration.nextElement();
                if (commApiDeviceConnection.getPortName().equals(string)) {
                    if (commApiDeviceConnection instanceof CommApi4840MSRConnection) {
                        commApiDeviceConnection.incrementOpenCount();
                        break;
                    }
                    Tracer.trace(4, className, "open() ", "Exception:JPOS_E_NOHARDWARE");
                    throw new JposException(107);
                }
                commApiDeviceConnection = null;
            }
            if (commApiDeviceConnection == null) {
                Tracer.trace(4, className, "open() ", "Make a CommApi4840MSRConnection");
                commApiDeviceConnection = new CommApi4840MSRConnection(string, n, string2, n2, n3, n4);
                CommApiDeviceConnection.commApiDeviceConnectionVector.addElement(commApiDeviceConnection);
            }
        }
        Tracer.trace(4, className, "Open() ", " Exit ");
        return commApiDeviceConnection;
    }

    static void addEventListener(IBM4840MSREventListener iBM4840MSREventListener) {
        if (!ibm4840MSREventListenerVector.contains(iBM4840MSREventListener)) {
            ibm4840MSREventListenerVector.addElement(iBM4840MSREventListener);
            Tracer.trace(2, className, "addEventListener", "number of listeners = " + ibm4840MSREventListenerVector.size());
        }
        Tracer.trace(4, className, "addEventListener", "Exit");
    }

    static void removeEventListener(IBM4840MSREventListener iBM4840MSREventListener) {
        ibm4840MSREventListenerVector.removeElement(iBM4840MSREventListener);
        Tracer.trace(2, className, "removeEventListener", "number of listeners = " + ibm4840MSREventListenerVector.size());
        Tracer.trace(4, className, "removeEventListener", "Exit");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void serialEvent(SerialPortEvent serialPortEvent) {
        byte[] byArray = new byte[]{};
        Tracer.trace(4, className, "serialEvent", "Entry");
        switch (serialPortEvent.getEventType()) {
            case 1: {
                Tracer.trace(3, className, "serialEvent()", "DATA_AVAIL received");
                try {
                    Thread.sleep(350L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    int n = this.getInputStream().available();
                    if (n <= 0) {
                        Tracer.trace(3, className, "serialEvent()", "input stream is empty!");
                        return;
                    }
                    byArray = new byte[n];
                    int n2 = 0;
                    while (n2 < byArray.length) {
                        byArray[n2] = (byte)this.getInputStream().read();
                        ++n2;
                    }
                }
                catch (IOException iOException) {
                    Tracer.trace(4, className, "serialEvent()", "*** IOException");
                    return;
                }
                this.processIncommingDeviceMessage(byArray, 1);
                return;
            }
            case 2: {
                Tracer.trace(3, className, "serialEvent()", "OUTBUF_EMPTY received");
                return;
            }
            case 3: {
                Tracer.trace(3, className, "serialEvent()", "CTS received");
                return;
            }
            case 4: {
                Tracer.trace(3, className, "serialEvent()", "DSR received");
                return;
            }
            case 5: {
                Tracer.trace(3, className, "serialEvent()", "RI received");
                return;
            }
            case 6: {
                Tracer.trace(3, className, "serialEvent()", "CD received");
                return;
            }
            case 8: {
                Tracer.trace(3, className, "serialEvent()", "PE received");
                return;
            }
            case 7: {
                Tracer.trace(3, className, "serialEvent()", "OE received");
                return;
            }
            case 9: {
                Tracer.trace(3, className, "serialEvent()", "FE received");
                return;
            }
            case 10: {
                Tracer.trace(3, className, "serialEvent()", "BI received");
                return;
            }
        }
    }

    private void processIncommingDeviceMessage(byte[] byArray, int n) {
        int n2 = byArray.length;
        Tracer.trace(4, className, "processIncommingDeviceMessage()", "entry");
        if (MSRState == 0) {
            if (byArray[0] == 37 || byArray[0] == 59 || byArray[0] == 43 || byArray[0] == 69) {
                Tracer.trace(4, className, "processIncommingDeviceMessage()", "Hold in buffer");
                this.MSRData = new byte[n2];
                System.arraycopy(byArray, 0, this.MSRData, 0, n2);
            } else {
                Tracer.trace(4, className, "processIncommingDeviceMessage", "data with-out start sentinel!!!");
                MSRState = 0;
            }
            if (this.MSRData[n2 - 1] == 63 || this.MSRData[n2 - 1] == 69) {
                IBM4840MSREvent iBM4840MSREvent = new IBM4840MSREvent(this, n, this.MSRData);
                this.fireEvent(iBM4840MSREvent);
                MSRState = 0;
            } else {
                Tracer.trace(4, className, "processIncommingDeviceMessage()", "Wait for more data");
                MSRState = 1;
            }
        } else if (MSRState == 1) {
            byte[] byArray2 = new byte[n2 + this.MSRData.length];
            System.arraycopy(this.MSRData, 0, byArray2, 0, this.MSRData.length);
            System.arraycopy(byArray, 0, byArray2, this.MSRData.length, n2);
            this.MSRData = byArray2;
            if (this.MSRData[this.MSRData.length - 1] == 63 || this.MSRData[this.MSRData.length - 1] == 69) {
                IBM4840MSREvent iBM4840MSREvent = new IBM4840MSREvent(this, n, this.MSRData);
                this.fireEvent(iBM4840MSREvent);
                MSRState = 0;
            }
        }
        Tracer.trace(4, className, "processIncommingDeviceMessage()", "exit");
    }

    private void fireEvent(IBM4840MSREvent iBM4840MSREvent) {
        Tracer.trace(4, className, "fireEvent()", "entry");
        Vector vector = ibm4840MSREventListenerVector;
        synchronized (vector) {
            int n = 0;
            while (n < ibm4840MSREventListenerVector.size()) {
                IBM4840MSREventListener iBM4840MSREventListener = (IBM4840MSREventListener)ibm4840MSREventListenerVector.elementAt(n);
                iBM4840MSREventListener.IBM4840MSREventOccurred(iBM4840MSREvent);
                ++n;
            }
        }
        Tracer.trace(4, className, "fireEvent()", "exit");
    }

    public boolean isOnline() {
        boolean bl = true;
        Tracer.trace(4, className, "isOnline()", "Entry");
        Tracer.trace(4, className, "isOnline()", "Exit: " + (bl ? "true" : "false"));
        return bl;
    }
}

