/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.jcomm.CommApiDeviceConnection;
import com.ibm.jpos.services.jcomm.IBM4610Event;
import com.ibm.jpos.services.jcomm.IBM4610EventListener;
import com.ibm.jpos.util.BooleanMonitor;
import com.ibm.jpos.util.Semaphore;
import com.ibm.jpos.util.Tracer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import jpos.JposConst;
import jpos.JposException;
import jpos.POSPrinterConst;

class CommApi4610Connection
extends CommApiDeviceConnection
implements SerialPortEventListener,
JposConst,
POSPrinterConst {
    private static Vector ibm4610EventListenerVector = new Vector();
    private BooleanMonitor slipInserted = new BooleanMonitor(false);
    private BooleanMonitor slipReady = new BooleanMonitor(false);
    private static final byte DLE_BYTE = 16;
    private static final byte XON_CHAR = 17;
    private static final byte XOFF_CHAR = 19;
    private static final byte UN_STUFFING_BYTE = 33;
    private static final String REQUEST_PRINTER_ID = "\u001dI\u0001";
    private static final String BUFFERED_STATUS_REQUEST = "\u001bv";
    private static final String PRINTER_RESET = "\u0010\u0005@";
    private static final String ENABLE_UNSOLICITED_STATUS = "\u0010\u0005A";
    private static final String DISABLE_UNSOLICITED_STATUS = "\u0010\u0005B";
    private static final String DISABLE_TRANSPARENT_XON_XOFF = "\u0010\u0005C";
    private static final String REINITIALIZE_PRINTER = "\u001b@";
    private static final String STATUS_SENT_TO_SYSTEM = "\u001b)P";
    private static final String CANCEL_PRINT_BUFFER = "\u0010\u00052";
    private static final String RELEASE_PRINT_BUFFER = "\u0010\u00051";
    private static final String HOLD_PRINT_BUFFER = "\u001b7";
    private static final String ERASE_LOGO_SECTOR = "\u001b#\u0001";
    private static final String REQUEST_MICR_READ = "\u001bI";
    private static final String DISABLE_LINE_COUNT = "\u001b8\u0001";
    private static final String ENABLE_LINE_COUNT = "\u001b8\u0000";
    private static final int RESET_SLEEP_TIME = 10000;
    private static final int PRINTER_ID_RESPONSE_LENGTH = 15;
    private static final int STATUS_REQUEST_RESPONSE_LENGTH = 10;
    private static final int STATUS_BYTE_1 = 0;
    private static final int STATUS1_COMMAND_COMPLETE = 1;
    private static final int STATUS1_RECEIPT_RIGHT_HOME = 2;
    private static final int STATUS1_LEFT_HOME = 4;
    private static final int STATUS1_RIGHT_HOME = 8;
    private static final int STATUS1_COVER_OPEN = 32;
    private static final int STATUS1_RECEIPT_EMPTY = 64;
    private static final int STATUS_BYTE_2 = 1;
    private static final int STATUS2_DOCUMENT_READY = 1;
    private static final int STATUS2_FRONT_SENSOR = 2;
    private static final int STATUS2_TOP_SENSOR = 4;
    private static final int STATUS2_BUFFER_HELD = 16;
    private static final int STATUS2_OPEN_THROAT_POSITION = 32;
    private static final int STATUS2_BUFFER_EMPTY = 64;
    private static final int STATUS2_BUFFER_FULL = 128;
    private static final int STATUS_BYTE_3 = 2;
    private static final int STATUS3_MEMORY_FULL = 1;
    private static final int STATUS3_HOME_ERROR = 2;
    private static final int STATUS3_DOCUMENT_FEED_ERROR = 4;
    private static final int STATUS3_FLASH_EPROM_LOAD_ERROR = 8;
    private static final int STATUS3_FLASH_STORAGE_FULL = 32;
    private static final int STATUS3_FIRMWARE_ERROR = 64;
    private static final int STATUS3_LINE_PRINTED = 128;
    private static final int STATUS_BYTE_4 = 3;
    private static final int STATUS_BYTE_5 = 4;
    private static final int STATUS5_PRINTER_ID_AVAILABLE = 1;
    private static final int STATUS5_EC_LEVEL_AVAILABLE = 2;
    private static final int STATUS5_MICR_DATA_AVAILABLE = 4;
    private static final int STATUS5_MCT_AVAILABLE = 8;
    private static final int STATUS5_FLASH_DATA_AVAILABLE = 16;
    private static final int STATUS_BYTE_6 = 5;
    private static final int STATUS_BYTE_7 = 6;
    private static final int STATUS7_CASHDRAWER_OPEN = 8;
    private static final int STATUS7_KEY_PRESSED = 16;
    private static final int STATUS7_DOCUMENT_STATION_SELECTED = 64;
    private static final int STATUS7_MICR_OR_FLIPPER_ERROR = 128;
    private static final int STATUS_BYTE_8 = 7;
    private static final int DEVICE_INFO_1 = 0;
    private static final int STATUS7_SUREMARK_DEVICE_TYPE = 48;
    private static final int DEVICE_INFO_2 = 1;
    private static final int DEVINFO2_GASTON_ID = 0;
    private static final int DEVINFO2_JORDON_ID = 0;
    private static final int DEVINFO2_LURE_ID = 1;
    private static final int DEVINFO2_HIGHROCK_ID = 1;
    private static final int DEVINFO2_WHITE_ID = 2;
    private static final int DEVINFO2_JOCASSE_ID = 3;
    private static final int DEVINFO2_TILLERY_ID = 3;
    private static final int DEVICE_INFO_3 = 2;
    private static final int DEVINFO3_MICR_PRESENT = 1;
    private static final int DEVINFO3_FLIPPER_PRESENT = 2;
    private static final int DEVICE_INFO_4 = 3;
    private static final int DEVINFO4_COMMAND_SET = 0;
    private static final int DEVINFO4_58MM = 1;
    private static final int DEVICE_INFO_5 = 4;
    private static final int DEVINFO5_EC_LEVEL = 0;
    private static final int CONTROL_FLOW_HARDWARE = 0;
    private static final int CONTROL_FLOW_XON_XOFF = 1;
    private static final int MAX_STATIONS = 3;
    private static final int MAX_PORTS = 8;
    public static final int SLIP_EMPTY = 0;
    public static final int SLIP_INSERTED = 1;
    public static final int SLIP_READY = 2;
    public static final int SLIP_NEAREMPTY = 4;
    private boolean micrPresent = false;
    private boolean flipperPresent = false;
    private boolean narrowPaper = false;
    private byte[] deviceInfo = new byte[5];
    private byte deviceInfoType;
    private byte deviceInfoId;
    private byte deviceFeatures;
    private byte deviceFeatures2;
    private boolean fFlashEPROMError = false;
    private boolean fFlashFullError = false;
    private boolean fFirmwareError = false;
    private boolean fMicrReadRequested = false;
    private boolean fMicrDataAvailable = false;
    private boolean fThroatOpen = false;
    private boolean fBufferHeld = false;
    private boolean fBufferEmpty = true;
    private boolean fBufferFull = false;
    private boolean fEraseComplete = true;
    private boolean fFlipCheckComplete = true;
    private boolean fSlipStationSelected = false;
    private boolean fReceiptStationSelected = true;
    private boolean fMemoryFullError = false;
    private boolean fDrawerOpened = false;
    private boolean fCdSignalsReversed = false;
    private boolean bufferHeld = false;
    private boolean bufferEmpty = true;
    private boolean bufferFull = false;
    private int slipStatus = -1;
    public StringBuffer micrData = new StringBuffer();
    public long micrSignalLevel;
    private byte[] statusBytes = new byte[8];
    private byte[] prevStatusBytes = new byte[8];
    private boolean coverOpen = false;
    private boolean recEmpty = false;
    private Semaphore drawerIsClosedEvent = new Semaphore(true);
    private Semaphore drawerIsOpenedEvent = new Semaphore(true);
    private Semaphore bufferEmptyEvent = new Semaphore(true);
    private Semaphore mctAvailable = new Semaphore(true);
    private Semaphore bufferFullEvent = new Semaphore();
    private Semaphore bufferHeldEvent = new Semaphore();
    private Semaphore bufferNotFullEvent = new Semaphore(true);
    private Semaphore eraseCompleteEvent = new Semaphore();
    private Semaphore flipCheckCompleteEvent = new Semaphore();
    private Semaphore frontCoverOpenEvent = new Semaphore();
    private Semaphore homeErrorEvent = new Semaphore();
    private Semaphore micrDataEvent = new Semaphore();
    private Semaphore printerIdEvent = new Semaphore();
    private Semaphore receiptEmptyEvent = new Semaphore();
    private Semaphore slipFeedErrorEvent = new Semaphore();
    private Semaphore receiptStationSelectedEvent = new Semaphore(true);
    private Semaphore slipStationSelectedEvent = new Semaphore();
    private Semaphore deviceOnline = new Semaphore();
    private Object sentQueueMutex = new Object();
    private Vector sentQueue = new Vector();
    private static String className = "CommApi4610Connection";

    protected CommApi4610Connection(String string, int n, String string2, int n2, int n3, int n4) throws JposException {
        super(string, n, string2, n2, n3, n4);
        try {
            this.getSerialPort().addEventListener(this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            throw new JposException(111, tooManyListenersException.getMessage(), tooManyListenersException);
        }
        this.getSerialPort().notifyOnFramingError(true);
        this.getSerialPort().notifyOnOverrunError(true);
        this.getSerialPort().notifyOnParityError(true);
        this.getSerialPort().notifyOnDSR(true);
        this.getSerialPort().notifyOnCTS(true);
        this.getSerialPort().notifyOnDataAvailable(true);
        this.write(REINITIALIZE_PRINTER);
        this.initDevice();
        long l = this.printerIdEvent.waitForSet(5000L);
        if (l == 112L) {
            Tracer.trace(1, className, "Constructor()", "waitForSet(5000) timed out");
            throw new JposException(107);
        }
        this.write("\n");
    }

    protected void finalize() {
        try {
            this.getSerialPort().notifyOnFramingError(false);
            this.getSerialPort().notifyOnOverrunError(false);
            this.getSerialPort().notifyOnParityError(false);
            this.getSerialPort().notifyOnDSR(false);
            this.getSerialPort().notifyOnCTS(false);
            this.getSerialPort().notifyOnDataAvailable(false);
            this.getSerialPort().notifyOnOutputEmpty(false);
            this.getSerialPort().removeEventListener();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized CommApiDeviceConnection open(String string, int n, String string2, int n2, int n3, int n4) throws JposException {
        Tracer.trace(4, className, "open(\"" + string + "\", " + n + ", " + string2 + ", " + n2 + ", " + n3 + ", " + n4 + ")", "Entry");
        CommApiDeviceConnection commApiDeviceConnection = null;
        Vector vector = CommApiDeviceConnection.commApiDeviceConnectionVector;
        synchronized (vector) {
            Enumeration enumeration = CommApiDeviceConnection.commApiDeviceConnectionVector.elements();
            while (enumeration.hasMoreElements()) {
                commApiDeviceConnection = (CommApiDeviceConnection)enumeration.nextElement();
                if (commApiDeviceConnection.getPortName().equals(string)) {
                    if (commApiDeviceConnection instanceof CommApi4610Connection) {
                        commApiDeviceConnection.incrementOpenCount();
                        break;
                    }
                    throw new JposException(107);
                }
                commApiDeviceConnection = null;
            }
            if (commApiDeviceConnection == null) {
                commApiDeviceConnection = new CommApi4610Connection(string, n, string2, n2, n3, n4);
                CommApiDeviceConnection.commApiDeviceConnectionVector.addElement(commApiDeviceConnection);
            }
        }
        return commApiDeviceConnection;
    }

    protected void initDevice() throws JposException {
        Tracer.trace(3, className, "initDevice()", "Entry");
        if (!this.isOnline()) {
            throw new JposException(108);
        }
        this.sleep(1500);
        this.write("\u001bM^AA");
        this.write("\u001bM_SS");
        this.write("\u001bc1\u0002\u001b2");
        this.write("\u001bc1\u0004\u001b2");
        this.write("\u001bt\u0001");
        this.write(DISABLE_LINE_COUNT);
        this.write(STATUS_SENT_TO_SYSTEM);
        this.write(ENABLE_UNSOLICITED_STATUS);
        this.write(REQUEST_PRINTER_ID);
        Tracer.trace(3, className, "initDevice()", "Exit");
    }

    public void serialEvent(SerialPortEvent serialPortEvent) {
        Tracer.trace(3, className, "serialEvent()", "Entry");
        block4 : switch (serialPortEvent.getEventType()) {
            case 1: {
                Tracer.trace(3, className, "serialEvent()", "DATA_AVAIL received");
                try {
                    int n;
                    int n2;
                    if (Tracer.getTraceLevel() > 0 && (n2 = this.getInputStream().available()) < 1) {
                        Tracer.trace(1, className, "serialEvent()", "*** ERROR: " + n2 + " bytes available");
                    }
                    n2 = 250;
                    int n3 = 6;
                    while ((n = this.getInputStream().available()) != 0) {
                        int n4;
                        Tracer.trace(4, className, "serialEvent()", "new message: count available from stream: " + n);
                        if (n < 2) {
                            Tracer.trace(4, className, "serialEvent()", "waiting for at least 2 available...");
                            n4 = 0;
                            while (n4 < n3 && (n = this.getInputStream().available()) < 2) {
                                try {
                                    Thread.sleep(n2);
                                }
                                catch (InterruptedException interruptedException) {
                                    break;
                                }
                                ++n4;
                            }
                            if (n < 2) {
                                Tracer.trace(4, className, "serialEvent()", "*** ERROR: only " + n + " bytes available; flushing input stream.");
                                this.getInputStream().skip(this.getInputStream().available());
                                break block4;
                            }
                        }
                        if (this.getInputStream().read() != 0) {
                            Tracer.trace(4, className, "serialEvent()", "*** ERROR: 1st byte failed validation (it's not 0); flushing input stream.");
                            this.getInputStream().skip(this.getInputStream().available());
                            break block4;
                        }
                        n4 = this.getInputStream().read();
                        if (n4 < 10 || n4 > 255) {
                            Tracer.trace(3, className, "serialEvent()", "*** ERROR: 2nd byte failed validation (it's outside range 10-255); flushing input stream.");
                            this.getInputStream().skip(this.getInputStream().available());
                            break block4;
                        }
                        Tracer.trace(4, className, "serialEvent()", "'countInMessage' (message length): " + n4);
                        if (n < n4) {
                            Tracer.trace(4, className, "serialEvent()", "waiting for at least " + (n4 - 2) + " available (already read 2)...");
                            int n5 = 0;
                            while (n5 < n3 && (n = this.getInputStream().available()) < n4 - 2) {
                                try {
                                    Thread.sleep(n2);
                                }
                                catch (InterruptedException interruptedException) {
                                    break;
                                }
                                ++n5;
                            }
                            if (n < n4 - 2) {
                                Tracer.trace(4, className, "serialEvent()", "*** ERROR: only " + n + " bytes available; flushing input stream.");
                                this.getInputStream().skip(this.getInputStream().available());
                                break block4;
                            }
                            Tracer.trace(4, className, "serialEvent()", "count available from stream: " + n);
                        }
                        byte[] byArray = new byte[8];
                        int n6 = 0;
                        while (n6 < byArray.length) {
                            byArray[n6] = (byte)this.getInputStream().read();
                            ++n6;
                        }
                        byte[] byArray2 = new byte[n4 - 10];
                        int n7 = 0;
                        while (n7 < byArray2.length) {
                            byArray2[n7] = (byte)this.getInputStream().read();
                            ++n7;
                        }
                        if (Tracer.getTraceLevel() >= 3) {
                            StringBuffer stringBuffer = new StringBuffer("status (hex): [");
                            int n8 = 0;
                            while (n8 < byArray.length) {
                                if (n8 != 0) {
                                    stringBuffer.append(" ");
                                }
                                if ((byArray[n8] & 0xFFFFFFF0) == 0) {
                                    stringBuffer.append("0");
                                }
                                stringBuffer.append(Integer.toHexString(byArray[n8] & 0xFF));
                                ++n8;
                            }
                            stringBuffer.append("]");
                            Tracer.trace(1, className, "serialEvent()", stringBuffer.toString());
                            stringBuffer = new StringBuffer("data (hex)  : [");
                            int n9 = 0;
                            while (n9 < byArray2.length) {
                                if (n9 != 0) {
                                    stringBuffer.append(" ");
                                }
                                if ((byArray2[n9] & 0xFFFFFFF0) == 0) {
                                    stringBuffer.append("0");
                                }
                                stringBuffer.append(Integer.toHexString(byArray2[n9] & 0xFF));
                                ++n9;
                            }
                            stringBuffer.append("]");
                            Tracer.trace(1, className, "serialEvent()", stringBuffer.toString());
                        }
                        this.processIncomingDeviceMessage(byArray, byArray2);
                    }
                }
                catch (IOException iOException) {
                    Tracer.trace(4, className, "serialEvent()", "*** ERROR: IOException while reading input stream.");
                }
                catch (Exception exception) {
                    Tracer.trace(4, className, "serialEvent()", "*** ERROR: Exception: " + exception.getMessage());
                }
                break;
            }
            case 2: {
                Tracer.trace(3, className, "serialEvent()", "OUTBUF_EMPTY received");
                break;
            }
            case 3: {
                Tracer.trace(3, className, "serialEvent()", "CTS received");
                break;
            }
            case 4: {
                Tracer.trace(3, className, "serialEvent()", "DSR received");
                if (!serialPortEvent.getNewValue()) break;
                try {
                    this.initDevice();
                }
                catch (Exception exception) {}
                break;
            }
            case 5: {
                Tracer.trace(3, className, "serialEvent()", "RI received");
                break;
            }
            case 6: {
                Tracer.trace(3, className, "serialEvent()", "CD received");
                break;
            }
            case 8: {
                Tracer.trace(3, className, "serialEvent()", "PE received");
                break;
            }
            case 7: {
                Tracer.trace(3, className, "serialEvent()", "OE received");
                break;
            }
            case 9: {
                Tracer.trace(3, className, "serialEvent()", "FE received");
                break;
            }
            case 10: {
                Tracer.trace(3, className, "serialEvent()", "BI received");
            }
        }
        Tracer.trace(4, className, "serialEvent()", "Exit");
    }

    private void verifyConnection() throws JposException {
        int n = 0;
        boolean bl = true;
        Tracer.trace(4, className, "verifyConnection()", "Entry");
        while (bl && n < 4) {
            ++n;
            this.write(REQUEST_PRINTER_ID);
            Tracer.trace(1, className, "verifyConnection()", "waiting for printerId event...");
            long l = this.printerIdEvent.waitForSet(500L);
            if (l == 112L) {
                Tracer.trace(1, className, "verifyConnection()", "waitForSet(500) timed out");
                continue;
            }
            if (this.deviceInfoType != 48) {
                this.write(DISABLE_TRANSPARENT_XON_XOFF);
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                bl = true;
                continue;
            }
            bl = false;
            this.deviceOnline.set();
            break;
        }
        if (bl) {
            throw new JposException(107);
        }
        Tracer.trace(4, className, "verifyConnection()", "Exit");
    }

    private void processStatus() {
        long l;
        int n;
        byte[] byArray = new byte[1000];
        long l2 = 10L;
        long l3 = 8L;
        long l4 = 0L;
        long l5 = 0L;
        int n2 = 0;
        Tracer.trace(4, className, "processStatus()", "Entry");
        InputStream inputStream = this.getInputStream();
        try {
            n2 = 0;
            while (n2 < 10) {
                n = this.getInputStream().read();
                if (l5 == -1L) continue;
                byArray[n2] = (byte)n;
                ++n2;
            }
            Tracer.trace(3, className, "processStatus()", "processStatus:read length = " + n2);
            Tracer.trace(4, className, "processStatus()", "processStatus:bytes read : ");
            int n3 = 0;
            while (n3 < n2) {
                Tracer.trace(4, className, "processStatus()", "read" + Integer.toHexString(byArray[n3]));
                ++n3;
            }
        }
        catch (IOException iOException) {
            Tracer.trace(1, className, "processStatus()", "processStatus:read exception");
        }
        if (n2 >= 10) {
            l2 = byArray[1] - 10;
            l = l2 - 10L;
            Tracer.trace(3, className, "processStatus()", "bytesToRead =" + l2);
            Tracer.trace(4, className, "processStatus()", "bytesCount  =" + l);
        } else {
            l2 = 0L;
            l = 0L;
        }
        if (n2 >= 10) {
            System.arraycopy(this.statusBytes, 0, this.prevStatusBytes, 0, 8);
            System.arraycopy(byArray, 2, this.statusBytes, 0, 8);
            Tracer.trace(4, className, "processStatus()", "status bytes : ");
            int n4 = 0;
            while (n4 < this.statusBytes.length) {
                Tracer.trace(4, className, "processStatus()", Integer.toHexString(this.statusBytes[n4]));
                ++n4;
            }
            Tracer.trace(4, className, "processStatus()", "Status Byte 2 = " + Integer.toHexString(this.statusBytes[1]));
            if (this.statusBytes[4] != 0) {
                int n5;
                int n6;
                Tracer.trace(4, className, "processStatus()", "Status Byte 5 = " + Integer.toHexString(this.statusBytes[4]));
                if ((this.statusBytes[4] & 2) == 2) {
                    this.removePrintedLinesFromQueue();
                }
                if ((this.statusBytes[4] & 8) == 8) {
                    byte[] byArray2 = new byte[30];
                    try {
                        n6 = 0;
                        while ((long)n6 < l2) {
                            n5 = this.getInputStream().read();
                            if (n5 == -1) continue;
                            byArray2[n6] = (byte)n5;
                            ++n6;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Tracer.trace(4, className, "processStatus()", "MCT Data Available (" + Integer.toHexString(byArray2[0]) + "." + Integer.toHexString(byArray2[1]) + ")");
                    if (byArray2[0] == 65 && byArray2[1] == 65) {
                        this.removePrintedLinesFromQueue();
                    } else if (byArray2[0] == 83 && byArray2[1] == 83) {
                        this.mctAvailable.set();
                    }
                }
                if ((this.statusBytes[4] & 4) == 4) {
                    Tracer.trace(4, className, "processStatus()", "MICR Data Available flag set");
                    this.readMicrData(l2);
                }
                if ((this.statusBytes[4] & 1) == 1) {
                    Tracer.trace(4, className, "processStatus()", "Printer ID Available... reading");
                    try {
                        n = 0;
                        while ((long)n < l2) {
                            n6 = this.getInputStream().read();
                            if (n6 == -1) continue;
                            this.deviceInfo[n] = (byte)n6;
                            ++n;
                        }
                        if ((long)n >= l2) {
                            Tracer.trace(4, className, "processStatus()", "PrinterID read : ");
                            n5 = 0;
                            while (n5 < n) {
                                Tracer.trace(4, className, "processStatus()", Integer.toHexString(this.deviceInfo[n5]));
                                ++n5;
                            }
                            this.deviceInfoType = this.deviceInfo[0];
                            this.deviceInfoId = this.deviceInfo[1];
                            this.deviceFeatures = this.deviceInfo[2];
                            this.deviceFeatures2 = this.deviceInfo[3];
                            if ((this.deviceFeatures & 1) == 1) {
                                this.micrPresent = true;
                                Tracer.trace(4, className, "processStatus()", "Micr Present");
                            } else {
                                this.micrPresent = false;
                            }
                            if ((this.deviceFeatures & 2) == 2) {
                                this.flipperPresent = true;
                                Tracer.trace(4, className, "processStatus()", "Flipper present");
                            } else {
                                this.flipperPresent = false;
                            }
                            if ((this.deviceFeatures2 & 1) == 1) {
                                this.narrowPaper = true;
                                Tracer.trace(4, className, "processStatus()", "Narrow Paper");
                            } else {
                                this.narrowPaper = false;
                            }
                            Tracer.trace(4, className, "processStatus()", "Info: id=0x" + Integer.toHexString(this.deviceInfoType) + ", type=0x" + Integer.toHexString(this.deviceInfoId) + ", feat=0x" + Integer.toHexString(this.deviceFeatures) + ", micr=" + this.micrPresent + ", flip=" + this.flipperPresent + ", Narrow=" + this.narrowPaper);
                        } else {
                            Tracer.trace(4, className, "processStatus()", "Printer info not read");
                            this.deviceInfoType = 0;
                            this.deviceInfoId = 0;
                            this.deviceFeatures = 0;
                            this.micrPresent = false;
                            this.flipperPresent = false;
                            this.narrowPaper = false;
                        }
                        this.printerIdEvent.set();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            this.checkErrorConditions();
            this.checkStatus();
        } else {
            Tracer.trace(1, className, "processStatus()", "Write failed");
        }
        Tracer.trace(4, className, "processStatus()", "Exit");
    }

    private void processIncomingDeviceMessage(byte[] byArray, byte[] byArray2) {
        Tracer.trace(4, className, "processIncomingDeviceMessage()", "Entry");
        if (Tracer.getTraceLevel() >= 3) {
            Tracer.trace(3, className, "processDeviceMessage()", "Status Byte 1: 0x" + Integer.toHexString(byArray[0]));
            if ((byArray[0] & 1) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  command complete (0x01)");
            }
            if ((byArray[0] & 2) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  receipt right home (0x02)");
            }
            if ((byArray[0] & 4) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  receipt left home (0x04)");
            }
            if ((byArray[0] & 8) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  document right home (0x08)");
            }
            if ((byArray[0] & 0x20) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  ribbon cover open (0x20)");
            }
            if ((byArray[0] & 0x40) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  paper cover open or receipt station out of paper (0x40)");
            }
            if ((byArray[0] & 0xFFFFFF80) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  command reject (0x80)");
            }
            Tracer.trace(3, className, "processDeviceMessage()", "Status Byte 2: 0x" + Integer.toHexString(byArray[1]));
            if ((byArray[1] & 1) == 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  document ready (!0x01)");
            }
            if ((byArray[1] & 2) == 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  document under front sensor (!0x02)");
            }
            if ((byArray[1] & 4) == 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  document under top sensor (!0x04)");
            }
            if ((byArray[1] & 0x10) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  buffer held (0x10)");
            }
            if ((byArray[1] & 0x20) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  open throat position (0x20)");
            }
            if ((byArray[1] & 0x40) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  buffer empty (0x40)");
            }
            if ((byArray[1] & 0xFFFFFF80) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  buffer full (0x80)");
            }
            Tracer.trace(3, className, "processDeviceMessage()", "Status Byte 3: 0x" + Integer.toHexString(byArray[2]));
            if ((byArray[2] & 1) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  memory sector full (0x01)");
            }
            if ((byArray[2] & 2) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  home error (0x02)");
            }
            if ((byArray[2] & 4) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  document error (0x04)");
            }
            if ((byArray[2] & 8) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  flash or mct load error (0x08)");
            }
            if ((byArray[2] & 0x20) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  user flash sector full (0x20)");
            }
            if ((byArray[2] & 0x40) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  microcode crc error (0x40)");
            }
            if ((byArray[2] & 0xFFFFFF80) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  line has printed, or erase flash sector or flip check command complete (0x80)");
            }
            Tracer.trace(3, className, "processDeviceMessage()", "Status Byte 4: 0x" + Integer.toHexString(byArray[3]) + " (EC Level " + byArray[3] + ")");
            Tracer.trace(3, className, "processDeviceMessage()", "Status Byte 5: 0x" + Integer.toHexString(byArray[4]));
            if ((byArray[4] & 1) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  printer id or extended address response (0x01)");
            }
            if ((byArray[4] & 2) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  EC Level response (0x02)");
            }
            if ((byArray[4] & 4) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  MICR read response (0x04)");
            }
            if ((byArray[4] & 8) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  MCT read response (0x08)");
            }
            if ((byArray[4] & 0x10) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  user flash read response (0x10)");
            }
            Tracer.trace(3, className, "processDeviceMessage()", "Status Byte 6: 0x" + Integer.toHexString(byArray[5]) + " (line count " + byArray[5] + ")");
            Tracer.trace(3, className, "processDeviceMessage()", "Status Byte 7: 0x" + Integer.toHexString(byArray[6]));
            if ((byArray[6] & 8) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  cash drawer status (0x08)");
            }
            if ((byArray[6] & 0x10) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  print key pressed (0x10)");
            }
            if ((byArray[6] & 0x40) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  document insert station selected (0x40)");
            }
            if ((byArray[6] & 0xFFFFFF80) != 0) {
                Tracer.trace(3, className, "processDeviceMessage()", "  document feed error (0x80)");
            }
        }
        System.arraycopy(this.statusBytes, 0, this.prevStatusBytes, 0, 8);
        System.arraycopy(byArray, 0, this.statusBytes, 0, 8);
        if ((this.statusBytes[4] & 2) == 2) {
            this.removePrintedLinesFromQueue();
        }
        if ((this.statusBytes[4] & 8) == 8) {
            if (byArray2[0] == 65 && byArray2[1] == 65) {
                this.removePrintedLinesFromQueue();
            } else if (byArray2[0] == 83 && byArray2[1] == 83) {
                this.mctAvailable.set();
            }
        }
        if ((this.statusBytes[4] & 4) == 4) {
            Tracer.trace(4, className, "processStatus()", "MICR Data Available flag set");
            if (this.fMicrReadRequested) {
                this.fMicrReadRequested = false;
                this.micrData = new StringBuffer();
                if (byArray2.length > 1) {
                    this.micrSignalLevel = byArray2[0];
                    int n = 1;
                    while (n < byArray2.length) {
                        this.micrData.append((char)byArray2[n]);
                        ++n;
                    }
                    this.fMicrDataAvailable = true;
                } else {
                    this.fMicrDataAvailable = false;
                }
                this.micrDataEvent.set();
                this.fireEvent(new IBM4610Event(this, 1));
            }
        }
        if ((this.statusBytes[4] & 1) == 1) {
            Tracer.trace(4, className, "processStatus()", "Printer ID Available... reading");
            if (byArray2.length >= 5) {
                System.arraycopy(byArray2, 0, this.deviceInfo, 0, 5);
                this.deviceInfoType = this.deviceInfo[0];
                this.deviceInfoId = this.deviceInfo[1];
                this.deviceFeatures = this.deviceInfo[2];
                this.deviceFeatures2 = this.deviceInfo[3];
                this.micrPresent = (this.deviceFeatures & 1) == 1;
                this.flipperPresent = (this.deviceFeatures & 2) == 2;
                if ((this.deviceFeatures2 & 1) == 1) {
                    this.narrowPaper = true;
                    Tracer.trace(4, className, "processStatus()", "Narrow Paper");
                } else {
                    this.narrowPaper = false;
                }
                Tracer.trace(4, className, "processStatus()", "Info: id=0x" + Integer.toHexString(this.deviceInfoType) + ", type=0x" + Integer.toHexString(this.deviceInfoId) + ", feat=0x" + Integer.toHexString(this.deviceFeatures) + ", micr=" + this.micrPresent + ", flip=" + this.flipperPresent + ", narrow=" + this.narrowPaper);
            }
            Tracer.trace(4, className, "processIncomingDeviceMessage()", "Setting printerIdEvent");
            this.printerIdEvent.set();
        }
        this.checkErrorConditions();
        this.checkStatus();
        Tracer.trace(4, className, "processIncomingDeviceMessage()", "Exit");
    }

    private void checkErrorConditions() {
        Tracer.trace(4, className, "checkErrorConditions()", "Entry");
        if ((this.statusBytes[0] & 0x40) == 64 != ((this.prevStatusBytes[0] & 0x40) == 64)) {
            this.checkReceiptStation();
        }
        if ((this.statusBytes[2] & 1) == 1 != ((this.prevStatusBytes[2] & 1) == 1)) {
            if ((this.statusBytes[2] & 1) == 1) {
                this.fMemoryFullError = true;
                Tracer.trace(2, className, "checkErrorConditions()", "Memory Full");
            } else {
                this.fMemoryFullError = false;
            }
        }
        if ((this.statusBytes[2] & 2) == 2 != ((this.prevStatusBytes[2] & 2) == 2)) {
            if ((this.statusBytes[2] & 2) == 2) {
                this.homeErrorEvent.set();
                Tracer.trace(2, className, "checkErrorConditions()", "Home Error");
            } else {
                this.homeErrorEvent.reset();
            }
        }
        if ((this.statusBytes[2] & 4) == 4 != ((this.prevStatusBytes[2] & 4) == 4)) {
            if ((this.statusBytes[2] & 4) == 4) {
                this.slipFeedErrorEvent.set();
                Tracer.trace(2, className, "checkErrorConditions()", "DocumentFeedError");
            } else {
                this.slipFeedErrorEvent.reset();
            }
        }
        if ((this.statusBytes[2] & 8) == 8 != ((this.prevStatusBytes[2] & 8) == 8)) {
            if ((this.statusBytes[2] & 8) == 8) {
                this.fFlashEPROMError = true;
                Tracer.trace(2, className, "checkErrorConditions()", "FlashEPROMLoadError");
            } else {
                this.fFlashEPROMError = false;
            }
        }
        if ((this.statusBytes[2] & 0x20) == 32 != ((this.prevStatusBytes[2] & 0x20) == 32)) {
            if ((this.statusBytes[2] & 0x20) == 32) {
                this.fFlashFullError = true;
                Tracer.trace(2, className, "checkErrorConditions()", "FlashStorageFull");
            } else {
                this.fFlashFullError = false;
            }
        }
        if ((this.statusBytes[2] & 0x40) == 64 != ((this.prevStatusBytes[2] & 0x40) == 64)) {
            if ((this.statusBytes[2] & 0x40) == 64) {
                this.fFirmwareError = true;
                Tracer.trace(2, className, "checkErrorConditions()", "FirmwareError");
            } else {
                this.fFirmwareError = false;
            }
        }
        if ((this.statusBytes[6] & 0x80) == 128 != ((this.prevStatusBytes[6] & 0x80) == 128) && (this.statusBytes[6] & 0x80) == 128 && this.fMicrReadRequested) {
            this.fMicrReadRequested = false;
            this.micrData = null;
            this.micrData = new StringBuffer();
            this.fMicrDataAvailable = false;
            this.micrDataEvent.set();
        }
        Tracer.trace(4, className, "checkErrorConditions()", "Exit");
    }

    private void checkStatus() {
        Tracer.trace(4, className, "checkStatus()", "Entry");
        if ((this.statusBytes[0] & 0x20) == 32 != ((this.prevStatusBytes[0] & 0x20) == 32)) {
            this.checkFrontCoverStatus();
        }
        Tracer.trace(4, className, "checkStatus()", "1");
        if ((this.statusBytes[1] & 2) == 2 != ((this.prevStatusBytes[1] & 2) == 2) || (this.statusBytes[1] & 4) == 4 != ((this.prevStatusBytes[1] & 4) == 4) || (this.statusBytes[1] & 1) == 1 != ((this.prevStatusBytes[1] & 1) == 1)) {
            this.checkSlipStatus();
        }
        Tracer.trace(4, className, "checkStatus()", "2");
        if ((this.statusBytes[6] & 8) == 8 != ((this.prevStatusBytes[6] & 8) == 8)) {
            this.checkCashDrawerStatus();
        }
        Tracer.trace(4, className, "checkStatus()", "3");
        if ((this.statusBytes[1] & 0x20) == 32 != ((this.prevStatusBytes[1] & 0x20) == 32)) {
            this.fThroatOpen = (this.statusBytes[1] & 0x20) == 32;
        }
        Tracer.trace(4, className, "checkStatus()", "4");
        if ((this.statusBytes[1] & 0x10) == 16 != ((this.prevStatusBytes[1] & 0x10) == 16)) {
            if ((this.statusBytes[1] & 0x10) == 16) {
                if (!this.fBufferHeld) {
                    this.fBufferHeld = true;
                    this.bufferHeldEvent.set();
                }
            } else if (this.fBufferHeld) {
                this.fBufferHeld = false;
                this.bufferHeldEvent.set();
            }
        }
        Tracer.trace(4, className, "checkStatus()", "5");
        if ((this.statusBytes[1] & 0x40) == 64 != ((this.prevStatusBytes[1] & 0x40) == 64)) {
            if ((this.statusBytes[1] & 0x40) == 64) {
                if (!this.fBufferEmpty) {
                    this.fBufferEmpty = true;
                    this.bufferEmptyEvent.set();
                }
            } else if (this.fBufferEmpty) {
                this.fBufferEmpty = false;
                this.bufferEmptyEvent.reset();
            }
        }
        Tracer.trace(4, className, "checkStatus()", "6");
        if ((this.statusBytes[1] & 0x80) == 128 != ((this.prevStatusBytes[1] & 0x80) == 128)) {
            if ((this.statusBytes[1] & 0x80) == 128) {
                if (!this.fBufferFull) {
                    this.fBufferFull = true;
                    this.bufferNotFullEvent.reset();
                    this.bufferFullEvent.set();
                }
            } else if (this.fBufferFull) {
                this.fBufferFull = false;
                this.bufferFullEvent.reset();
                this.bufferNotFullEvent.set();
            }
        }
        Tracer.trace(4, className, "checkStatus()", "7");
        if ((this.statusBytes[2] & 0x80) == 128 != ((this.prevStatusBytes[2] & 0x80) == 128) && (this.statusBytes[2] & 0x80) == 128) {
            if (!this.fEraseComplete) {
                this.fEraseComplete = true;
                this.eraseCompleteEvent.set();
            } else if (!this.fFlipCheckComplete) {
                this.fFlipCheckComplete = true;
                Tracer.trace(2, className, "checkErrorConditions()", "FlipCheckComplete");
                this.flipCheckCompleteEvent.set();
            }
        }
        Tracer.trace(4, className, "checkStatus()", "8");
        if ((this.statusBytes[6] & 0x40) == 64 != ((this.prevStatusBytes[6] & 0x40) == 64)) {
            if ((this.statusBytes[6] & 0x40) == 64) {
                if (!this.fSlipStationSelected) {
                    this.fSlipStationSelected = true;
                    this.slipStationSelectedEvent.set();
                }
            } else if (this.fSlipStationSelected) {
                this.fSlipStationSelected = false;
                this.receiptStationSelectedEvent.set();
            }
        }
        Tracer.trace(4, className, "checkStatus()", "Exit");
    }

    private void checkReceiptStation() {
        Tracer.trace(4, className, "checkReceiptStation()", "Entry");
        if ((this.statusBytes[0] & 0x40) == 64) {
            this.receiptEmptyEvent.set();
            if ((this.prevStatusBytes[0] & 0x40) != 64) {
                Tracer.trace(2, className, "checkReceiptStation()", "CoverOpen");
                this.coverOpen = true;
                IBM4610Event iBM4610Event = new IBM4610Event(this, 2);
                this.fireEvent(iBM4610Event);
            }
        } else {
            this.receiptEmptyEvent.reset();
            if ((this.prevStatusBytes[0] & 0x40) == 64) {
                this.coverOpen = false;
                IBM4610Event iBM4610Event = new IBM4610Event(this, 3);
                this.fireEvent(iBM4610Event);
            }
        }
        Tracer.trace(4, className, "checkReceiptStation()", "Exit");
    }

    private void checkFrontCoverStatus() {
        Tracer.trace(4, className, "checkFrontCoverStatus()", "Entry");
        if ((this.statusBytes[0] & 0x20) == 32) {
            if (!this.coverOpen) {
                this.coverOpen = true;
                IBM4610Event iBM4610Event = new IBM4610Event(this, 2);
                this.fireEvent(iBM4610Event);
                Tracer.trace(2, className, "checkFrontCoverStatus()", "CoverOpen");
            }
        } else if (this.coverOpen) {
            this.coverOpen = false;
            IBM4610Event iBM4610Event = new IBM4610Event(this, 3);
            this.fireEvent(iBM4610Event);
            Tracer.trace(2, className, "checkFrontCoverStatus()", "Cover OK");
        }
        Tracer.trace(4, className, "checkFrontCoverStatus()", "Exit");
    }

    private void checkSlipStatus() {
        this.checkSlipStatus(false);
    }

    public void checkSlipStatus(boolean bl) {
        boolean bl2 = false;
        Tracer.trace(4, className, "checkSlipStatus(" + bl + ")", "Entry");
        if ((1 & this.statusBytes[1]) == 0) {
            if (this.slipStatus != 2) {
                bl2 = true;
            }
            this.slipStatus = 2;
            this.slipReady.set(true);
            this.slipInserted.set(true);
            Tracer.trace(2, className, "checkSlipStatus", "SLIP READY");
        } else if ((2 & this.statusBytes[1]) == 0 || (4 & this.statusBytes[1]) == 0) {
            if (this.slipStatus != 1) {
                bl2 = true;
            }
            this.slipStatus = 1;
            this.slipReady.set(false);
            this.slipInserted.set(true);
            Tracer.trace(2, className, "checkSlipStatus", "SLIP INSERTED");
        } else {
            if (this.slipStatus != 0) {
                bl2 = true;
            }
            this.slipStatus = 0;
            this.slipReady.set(false);
            this.slipInserted.set(false);
            Tracer.trace(2, className, "checkSlipStatus", "SLIP EMPTY");
        }
        if (bl2 || bl) {
            Tracer.trace(2, className, "checkSlipStatus", "Slip Status change");
            switch (this.slipStatus) {
                case 2: {
                    Tracer.trace(2, className, "checkSlipStatus", "firing SM_SLIP_READY");
                    this.fireEvent(new IBM4610Event(this, 8));
                    break;
                }
                case 1: {
                    Tracer.trace(2, className, "checkSlipStatus", "firing SM_SLIP_INSERTED");
                    this.fireEvent(new IBM4610Event(this, 7));
                    break;
                }
                case 0: {
                    Tracer.trace(2, className, "checkSlipStatus", "firing SM_SLIP_REMOVED");
                    this.fireEvent(new IBM4610Event(this, 6));
                }
            }
        }
        Tracer.trace(4, className, "checkSlipStatus(" + bl + ")", "Exit");
    }

    public void setCDSignalsReversed() {
        if (!this.fCdSignalsReversed) {
            this.fCdSignalsReversed = true;
            Tracer.trace(2, className, "setCDSignalsReversed", "Cash drawer signal lines marked as reversed");
            if (this.fDrawerOpened) {
                this.fDrawerOpened = false;
                this.drawerIsClosedEvent.set();
                this.drawerIsOpenedEvent.reset();
            } else {
                this.fDrawerOpened = true;
                this.drawerIsOpenedEvent.set();
                this.drawerIsClosedEvent.reset();
            }
        }
    }

    private void checkCashDrawerStatus() {
        Tracer.trace(4, className, "checkCashDrawerStatus()", "Entry");
        if ((this.statusBytes[6] & 8) == 8) {
            if (!this.fCdSignalsReversed) {
                if (!this.fDrawerOpened) {
                    Tracer.trace(2, className, "checkCashDrawerStatus", "Drawer now opened");
                    this.fDrawerOpened = true;
                    this.drawerIsOpenedEvent.set();
                    this.drawerIsClosedEvent.reset();
                    IBM4610Event iBM4610Event = new IBM4610Event(this, 9);
                    this.fireEvent(iBM4610Event);
                }
            } else if (this.fDrawerOpened) {
                Tracer.trace(2, className, "checkCashDrawerStatus", "Drawer now closed");
                this.fDrawerOpened = false;
                this.drawerIsClosedEvent.set();
                this.drawerIsOpenedEvent.reset();
                IBM4610Event iBM4610Event = new IBM4610Event(this, 10);
                this.fireEvent(iBM4610Event);
            }
        } else if (!this.fCdSignalsReversed) {
            if (this.fDrawerOpened) {
                this.fDrawerOpened = false;
                Tracer.trace(2, className, "checkCashDrawerStatus", "Drawer now closed");
                this.drawerIsClosedEvent.set();
                this.drawerIsOpenedEvent.reset();
                IBM4610Event iBM4610Event = new IBM4610Event(this, 10);
                this.fireEvent(iBM4610Event);
            }
        } else if (!this.fDrawerOpened) {
            Tracer.trace(2, className, "checkCashDrawerStatus", "Drawer now opened");
            this.fDrawerOpened = true;
            this.drawerIsOpenedEvent.set();
            this.drawerIsClosedEvent.reset();
            IBM4610Event iBM4610Event = new IBM4610Event(this, 9);
            this.fireEvent(iBM4610Event);
        }
        Tracer.trace(4, className, "checkCashDrawerStatus()", "Exit");
    }

    public void requestMicrData() throws JposException {
        Tracer.trace(4, className, "requestMicrData", "Entry");
        this.fMicrReadRequested = true;
        this.write(REQUEST_MICR_READ);
        Tracer.trace(4, className, "requestMicrData", "Exit");
    }

    private void readMicrData(long l) {
        Tracer.trace(4, className, "readMicrData(" + l + ")", "Entry");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Tracer.trace(4, className, "readMicrData(" + l + ")", "Entry");
        InputStream inputStream = this.getInputStream();
        try {
            while ((long)n <= l) {
                int n2 = this.getInputStream().read();
                if (n2 == -1) continue;
                stringBuffer.append(new Character((char)n2).charValue());
                ++n;
            }
            Tracer.trace(4, className, "readMicrData(" + l + ")", "buffer = [" + stringBuffer.toString() + "] Count = " + n);
            if ((long)n >= l) {
                if (this.fMicrReadRequested) {
                    this.fMicrReadRequested = false;
                    this.micrSignalLevel = new Long(stringBuffer.charAt(0));
                    char[] cArray = new char[stringBuffer.length()];
                    stringBuffer.getChars(1, stringBuffer.length() - 1, cArray, 0);
                    this.micrData = null;
                    this.micrData = new StringBuffer();
                    this.micrData.append(cArray);
                    this.fMicrDataAvailable = true;
                    this.micrDataEvent.set();
                    Tracer.trace(4, className, "readMicrData(" + l + ")", "Good Read");
                    IBM4610Event iBM4610Event = new IBM4610Event(this, 1);
                    this.fireEvent(iBM4610Event);
                }
            } else if (this.fMicrReadRequested) {
                this.fMicrReadRequested = false;
                this.micrData = null;
                this.micrData = new StringBuffer();
                this.fMicrDataAvailable = false;
                this.micrDataEvent.set();
                Tracer.trace(2, className, "readMicrData(" + l + ")", "Bad Read");
                IBM4610Event iBM4610Event = new IBM4610Event(this, 1);
                this.fireEvent(iBM4610Event);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Tracer.trace(4, className, "readMicrData(" + l + ")", "Exit");
    }

    public byte getStatusByte(int n) {
        return this.statusBytes[n];
    }

    public boolean isFlipperPresent() {
        return this.flipperPresent;
    }

    public boolean useNarrowPaper() {
        return this.narrowPaper;
    }

    public boolean isMICRPresent() {
        return this.micrPresent;
    }

    public boolean isSlipInserted() {
        return this.slipInserted.isTrue();
    }

    public boolean isSlipReady() {
        return this.slipReady.isTrue();
    }

    public boolean isSentQueueEmpty() {
        return this.sentQueue.isEmpty();
    }

    public boolean isSlipRemoved() {
        return this.slipInserted.isFalse();
    }

    public void waitForSlipInserted(int n) throws JposException {
        this.slipInserted.waitForTrue(n);
    }

    public void waitForSlipReady(int n) throws JposException {
        this.slipReady.waitForTrue(n);
    }

    public void waitForSlipRemoved(int n) throws JposException {
        this.slipInserted.waitForFalse(n);
    }

    public boolean isSlipStationSelected() {
        return this.fSlipStationSelected;
    }

    public boolean isReceiptStationSelected() {
        return !this.fSlipStationSelected;
    }

    public synchronized void writeSyncData(String string, int n, int n2) throws JposException {
        Tracer.trace(4, className, "writeSyncData(" + string + "," + n + "," + n2 + ")", "Entry");
        try {
            this.writeSyncData(string.getBytes("8859_1"), n, n2);
        }
        catch (Exception exception) {
            throw new JposException(111, "write failure: " + exception.getMessage(), exception);
        }
        Tracer.trace(4, className, "writeSyncData(String)", "Exit");
    }

    public synchronized void writeSyncData(byte[] byArray, int n, int n2) throws JposException {
        Tracer.trace(4, className, "writeSyncData(byte[], " + n + "," + n2 + ")", "Entry");
        boolean bl = false;
        if (n > 0) {
            Integer n3 = this.getPortSemaphore();
            synchronized (n3) {
                this.mctAvailable.reset();
                try {
                    this.write(byArray);
                }
                catch (Exception exception) {
                    Tracer.trace(1, className, "writeSyncData", "Exception on buffer write");
                    throw new JposException(111);
                }
                try {
                    this.write("\u001bS_");
                }
                catch (Exception exception) {
                    Tracer.trace(1, className, "writeSyncData", "Exception on status Request");
                    throw new JposException(111);
                }
                int n4 = Math.min(2000, n2 / 10);
                int n5 = 0;
                while (n5 < n2 && this.mctAvailable.isOff()) {
                    this.mctAvailable.waitForSet(n4);
                    if (this.mctAvailable.isOff() && this.coverOpen) {
                        this.write(CANCEL_PRINT_BUFFER);
                        throw new JposException(114, 201);
                    }
                    n5 += n4;
                }
                if (this.mctAvailable.isOff()) {
                    Tracer.trace(1, className, "writeSyncData", "Timeout");
                    throw new JposException(111);
                }
            }
        }
        Tracer.trace(4, className, "writeSyncData(byte[])", "Exit");
    }

    void removePrintedLinesFromQueue() {
        PrintLine printLine = null;
        boolean bl = false;
        long l = 0L;
        Object object = this.sentQueueMutex;
        synchronized (object) {
            while (!this.sentQueue.isEmpty() && (printLine = (PrintLine)this.sentQueue.firstElement()) != null) {
                this.sentQueue.removeElementAt(0);
                l = printLine.outputID;
                printLine = null;
                if (l == 0L) continue;
            }
        }
    }

    public void removeAllQueuedLines() {
        PrintLine printLine = null;
        Object object = this.sentQueueMutex;
        synchronized (object) {
            while (!this.sentQueue.isEmpty()) {
                printLine = (PrintLine)this.sentQueue.firstElement();
                this.sentQueue.removeElementAt(0);
                if (printLine == null) continue;
                printLine = null;
            }
        }
    }

    public void resetPrinter() throws JposException {
        Tracer.trace(4, className, "resetPrinter()", "Entry");
        this.write(PRINTER_RESET);
        this.sleep(10000);
        this.write(BUFFERED_STATUS_REQUEST);
        Tracer.trace(4, className, "resetPrinter()", "Exit");
    }

    public void holdPrintBuffer() throws JposException {
        Tracer.trace(4, className, "holdPrintBuffer()", "Entry");
        this.write(HOLD_PRINT_BUFFER);
        Tracer.trace(4, className, "holdPrintBuffer()", "Exit");
    }

    public void cancelPrintBuffer() throws JposException {
        Tracer.trace(4, className, "cancelPrintBuffer()", "Entry");
        this.write(CANCEL_PRINT_BUFFER);
        Tracer.trace(4, className, "cancelPrintBuffer()", "Exit");
    }

    public void releasePrintBuffer() throws JposException {
        Tracer.trace(4, className, "releasePrintBuffer()", "Entry");
        this.write(RELEASE_PRINT_BUFFER);
        Tracer.trace(4, className, "releasePrintBuffer()", "Exit");
    }

    void sleep(int n) {
        Tracer.trace(4, className, "sleep(" + n + ")", "Entry");
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Tracer.trace(4, className, "sleep(" + n + ")", "Exit");
    }

    public synchronized void writeAsyncData(String string, int n, boolean bl, long l) throws JposException {
        Tracer.trace(4, className, "writeSyncData(" + string + "," + n + "," + bl + "," + l + ")", "Entry");
        PrintLine printLine = new PrintLine(string, n, l);
        Object object = this.sentQueueMutex;
        synchronized (object) {
            this.sentQueue.addElement(printLine);
        }
        if (n > 0) {
            try {
                this.write(string);
            }
            catch (Exception exception) {
                throw new JposException(111);
            }
            try {
                this.write("\u001b\u0000\u0080\u0000", 4);
            }
            catch (Exception exception) {
                throw new JposException(111);
            }
        }
        Tracer.trace(4, className, "writeAsyncData(" + string + "," + n + "," + bl + "," + l + ")", "Exit");
    }

    public void clearBitmaps(boolean bl) throws JposException {
        String string = ERASE_LOGO_SECTOR;
        Tracer.trace(2, className, "clearBitmaps(" + bl + ")", "Entry");
        this.waitForBufferEmpty(bl);
        Integer n = this.getPortSemaphore();
        synchronized (n) {
            this.write(string);
            this.sleep(1500);
            boolean bl2 = false;
            long l = System.currentTimeMillis() + 3000L;
            while (!bl2) {
                byte by = this.getStatusByte(2);
                if ((by & 0x80) == 128) {
                    bl2 = true;
                }
                if (System.currentTimeMillis() > l) {
                    bl2 = true;
                }
                this.sleep(100);
            }
        }
        Tracer.trace(2, className, "clearBitmaps()", "Exit");
    }

    public void waitForBufferEmpty(boolean bl) throws JposException {
        Tracer.trace(2, className, "waitForBufferEmpty(" + bl + ")", "Entry");
        this.write(REQUEST_PRINTER_ID);
        if (bl) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.serialEvent(new SerialPortEvent(this.getSerialPort(), 1, false, false));
        }
        boolean bl2 = false;
        long l = System.currentTimeMillis() + 10000L;
        while (!bl2) {
            byte by = this.getStatusByte(1);
            if ((by & 0x40) == 64) {
                bl2 = true;
            }
            if (System.currentTimeMillis() > l) {
                throw new JposException(112);
            }
            this.sleep(100);
        }
        Tracer.trace(2, className, "waitForBufferEmpty()", "Exit");
    }

    static void addEventListener(IBM4610EventListener iBM4610EventListener) {
        Tracer.trace(4, className, "addEventListener", "Entry");
        ibm4610EventListenerVector.addElement(iBM4610EventListener);
        Tracer.trace(2, className, "addEventListener", "number of listeners = " + ibm4610EventListenerVector.size());
        Tracer.trace(4, className, "addEventListener", "Exit");
    }

    static void removeEventListener(IBM4610EventListener iBM4610EventListener) {
        Tracer.trace(4, className, "removeEventListener", "Entry");
        ibm4610EventListenerVector.removeElement(iBM4610EventListener);
        Tracer.trace(2, className, "removeEventListener", "number of listeners = " + ibm4610EventListenerVector.size());
        Tracer.trace(4, className, "removeEventListener", "Exit");
    }

    private void fireEvent(IBM4610Event iBM4610Event) {
        Tracer.trace(4, className, "fireevent", "Entry");
        Tracer.trace(2, className, "fireEvent", "event = " + iBM4610Event.getEventType());
        Vector vector = ibm4610EventListenerVector;
        synchronized (vector) {
            Tracer.trace(2, className, "fireEvent", "number of listeners = " + ibm4610EventListenerVector.size());
            int n = 0;
            while (n < ibm4610EventListenerVector.size()) {
                IBM4610EventListener iBM4610EventListener = (IBM4610EventListener)ibm4610EventListenerVector.elementAt(n);
                Tracer.trace(2, className, "fireEvent", "this listener = " + iBM4610EventListener);
                iBM4610EventListener.IBM4610EventOccurred(iBM4610Event);
                ++n;
            }
        }
        Tracer.trace(4, className, "fireevent", "Exit");
    }

    class PrintLine {
        public String data;
        public int length;
        public long outputID;

        public PrintLine(String string, int n, long l) {
            this.data = string;
            this.length = n;
            this.outputID = l;
        }
    }
}

