/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.ibmprinter;

import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.PrintDataParseException;
import com.ibm.jpos.services.ibmprinter.PrintDataParser;
import com.ibm.jpos.services.ibmprinter.TextSegment;
import com.ibm.jpos.util.ByteEncoder;
import com.ibm.jpos.util.Tracer;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.Vector;
import jpos.JposConst;
import jpos.JposException;
import jpos.POSPrinterConst;

public abstract class PrintDataCompiler
extends PrintDataParser
implements JposConst,
POSPrinterConst {
    private POSPrinterServiceState serviceState;
    private int station;
    private String source;
    private int rotation;
    private boolean validate;
    private boolean reverseLines;
    private boolean reverseText;
    private ByteEncoder byteEncoder;
    private TextSegment attributesSegment;
    private TextSegment printableSegment;
    private TextSegment leftAlignedSegment;
    private TextSegment centerAlignedSegment;
    private TextSegment rightAlignedSegment;
    private Vector lineSegments;
    private String topLogo = "";
    private String bottomLogo = "";
    private TextSegment alignedSegment;
    private int cellsPerLine;
    private int maxLines;
    private int cellsBuffered;
    private int fontTypeface = 0;
    private boolean isHSChanged;
    private int cellsPerByte;
    private static final String className = "PrintDataCompiler";
    private static final int TL_OFF = 0;
    private static final int TL_WARNING = 1;
    private static final int TL_METHOD = 2;
    private static final int TL_DETAIL = 3;
    private static final int TL_DEBUG = 4;
    private static final int TL_MAX = 4;

    public PrintDataCompiler(POSPrinterServiceState pOSPrinterServiceState) throws JposException {
        try {
            this.serviceState = pOSPrinterServiceState;
            this.byteEncoder = new ByteEncoder(pOSPrinterServiceState.getCharacterSet());
            this.attributesSegment = TextSegment.alloc();
            this.printableSegment = TextSegment.alloc();
            this.leftAlignedSegment = TextSegment.alloc();
            this.centerAlignedSegment = TextSegment.alloc();
            this.rightAlignedSegment = TextSegment.alloc();
            this.lineSegments = new Vector();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("PrintDataCompiler: Internal Error: Unsupported Encoding: " + pOSPrinterServiceState.getCharacterSet());
            throw new JposException(111, "JPOS_E_FAILURE: Internal Error: Unsupported Encoding: " + pOSPrinterServiceState.getCharacterSet(), unsupportedEncodingException);
        }
    }

    public byte[] compile(int n, String string, int n2) throws JposException {
        return this.compile(n, string, n2, false);
    }

    public void validate(int n, String string, int n2) throws JposException {
        this.compile(n, string, n2, true);
    }

    public void setLogo(int n, String string) throws JposException {
        if (string == null) {
            throw new JposException(106, "JPOS_E_ILLEGAL: data is null.");
        }
        if (string.indexOf("\u001b|tL") >= 0 || string.indexOf("\u001b|bL") >= 0) {
            throw new JposException(106);
        }
        switch (n) {
            case 1: {
                this.topLogo = string;
                break;
            }
            case 2: {
                this.bottomLogo = string;
                break;
            }
            default: {
                throw new JposException(106, "JPOS_E_ILLEGAL: Illegal location: " + n);
            }
        }
    }

    public POSPrinterServiceState getServiceState() {
        return this.serviceState;
    }

    public int getStation() {
        return this.station;
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean isValidating() {
        return this.validate;
    }

    public String getEncoding() {
        return this.byteEncoder.getEncoding();
    }

    protected void reverseLines() {
        this.reverseLines = true;
    }

    public boolean hasReversedLines() {
        return this.reverseLines;
    }

    public void resetCellsBuffered() {
        if (this.lineSegments.size() > 0) {
            ((TextSegment)this.lineSegments.lastElement()).setCellsBuffered(0);
        }
    }

    protected void reverseText() {
        this.reverseText = true;
    }

    private synchronized byte[] compile(int n, String string, int n2, boolean bl) throws JposException {
        TextSegment textSegment;
        PrintDataCompiler.trace(2, "compile", "Entry");
        byte[] byArray = new byte[]{};
        this.station = n;
        this.source = string;
        this.rotation = n2;
        this.validate = bl;
        if (string == null || string.length() == 0) {
            return new byte[0];
        }
        block1 : switch (n) {
            case 1: {
                if (!this.serviceState.getCapJrnPresent()) {
                    throw new JposException(106, "JPOS_E_ILLEGAL: Journal station not present.");
                }
                if (n2 != 1) {
                    throw new JposException(106, "JPOS_E_ILLEGAL: Illegal rotation for journal station.");
                }
                this.cellsPerLine = this.serviceState.getJrnLineChars();
                this.maxLines = Integer.MAX_VALUE;
                break;
            }
            case 2: {
                if (!this.serviceState.getCapRecPresent()) {
                    throw new JposException(106, "JPOS_E_ILLEGAL: Receipt station not present.");
                }
                switch (n2) {
                    case 1: {
                        this.cellsPerLine = this.serviceState.getRecLineChars();
                        this.maxLines = Integer.MAX_VALUE;
                        break block1;
                    }
                    case 257: {
                        if (!this.serviceState.getCapRecRight90()) {
                            throw new JposException(106, "JPOS_E_ILLEGAL: Illegal rotation for receipt station.");
                        }
                        this.cellsPerLine = this.serviceState.getRecSidewaysMaxChars();
                        this.maxLines = this.serviceState.getRecSidewaysMaxLines();
                        break block1;
                    }
                    case 258: {
                        if (!this.serviceState.getCapRecLeft90()) {
                            throw new JposException(106, "JPOS_E_ILLEGAL: Illegal rotation for receipt station.");
                        }
                        this.cellsPerLine = this.serviceState.getRecSidewaysMaxChars();
                        this.maxLines = this.serviceState.getRecSidewaysMaxLines();
                        break block1;
                    }
                    case 259: {
                        if (!this.serviceState.getCapRecRotate180()) {
                            throw new JposException(106, "JPOS_E_ILLEGAL: Illegal rotation for receipt station.");
                        }
                        this.cellsPerLine = this.serviceState.getRecLineChars();
                        this.maxLines = Integer.MAX_VALUE;
                        break block1;
                    }
                }
                throw new JposException(106, "JPOS_E_ILLEGAL: Illegal rotation.");
            }
            case 4: {
                if (!this.serviceState.getCapSlpPresent()) {
                    throw new JposException(106, "JPOS_E_ILLEGAL: Slip station not present.");
                }
                switch (n2) {
                    case 1: {
                        this.cellsPerLine = this.serviceState.getSlpLineChars();
                        this.maxLines = Integer.MAX_VALUE;
                        break block1;
                    }
                    case 257: {
                        if (!this.serviceState.getCapSlpRight90()) {
                            throw new JposException(106, "JPOS_E_ILLEGAL: Illegal rotation for slip station.");
                        }
                        this.cellsPerLine = this.serviceState.getSlpSidewaysMaxChars();
                        this.maxLines = this.serviceState.getSlpSidewaysMaxLines();
                        break block1;
                    }
                    case 258: {
                        if (!this.serviceState.getCapSlpLeft90()) {
                            throw new JposException(106, "JPOS_E_ILLEGAL: Illegal rotation for slip station.");
                        }
                        this.cellsPerLine = this.serviceState.getSlpSidewaysMaxChars();
                        this.maxLines = this.serviceState.getSlpSidewaysMaxLines();
                        break block1;
                    }
                    case 259: {
                        if (!this.serviceState.getCapSlpRotate180()) {
                            throw new JposException(106, "JPOS_E_ILLEGAL: Illegal rotation for slip station.");
                        }
                        this.cellsPerLine = this.serviceState.getSlpLineChars();
                        this.maxLines = Integer.MAX_VALUE;
                        break block1;
                    }
                }
                throw new JposException(106, "JPOS_E_ILLEGAL: Illegal rotation.");
            }
            default: {
                throw new JposException(106, "JPOS_E_ILLEGAL: Illegal station.");
            }
        }
        this.reverseLines = false;
        this.reverseText = false;
        try {
            if (this.byteEncoder.getCharacterSet() != this.serviceState.getCharacterSet()) {
                this.byteEncoder = new ByteEncoder(this.serviceState.getCharacterSet());
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("PrintDataCompiler: Internal Error: Unsupported Encoding: " + this.serviceState.getCharacterSet());
            throw new JposException(111, "JPOS_E_FAILURE: Internal Error: Unsupported Encoding: " + this.serviceState.getCharacterSet(), unsupportedEncodingException);
        }
        this.attributesSegment.reinit();
        this.printableSegment.reinit();
        this.leftAlignedSegment.reinit(-1);
        this.centerAlignedSegment.reinit(-2);
        this.rightAlignedSegment.reinit(-3);
        this.alignedSegment = this.leftAlignedSegment;
        this.cellsPerByte = 1;
        this.isHSChanged = true;
        this.cellsBuffered = 0;
        if (this.lineSegments.size() > 0) {
            textSegment = (TextSegment)this.lineSegments.lastElement();
            if (n == textSegment.getStation()) {
                this.cellsBuffered = textSegment.getCellsBuffered();
            }
            int n3 = 0;
            while (n3 < this.lineSegments.size()) {
                ((TextSegment)this.lineSegments.elementAt(n3)).free();
                ++n3;
            }
            this.lineSegments.removeAllElements();
        }
        this.parse(string, bl);
        if (bl) {
            if (this.lineSegments.size() > this.maxLines) {
                throw new JposException(106, "JPOS_E_ILLEGAL: Too many lines.");
            }
        } else {
            if (this.lineSegments.size() > 0) {
                textSegment = (TextSegment)this.lineSegments.elementAt(0);
                TextSegment textSegment2 = null;
                PrintDataCompiler.trace(4, "compile", "lineSegments[0]: " + PrintDataCompiler.getByteDump(((TextSegment)this.lineSegments.elementAt(0)).getBytes()));
                int n4 = 1;
                while (n4 < this.lineSegments.size()) {
                    textSegment2 = (TextSegment)this.lineSegments.elementAt(n4);
                    PrintDataCompiler.trace(4, "compile", "lineSegments[" + n4 + "]: " + PrintDataCompiler.getByteDump(((TextSegment)this.lineSegments.elementAt(n4)).getBytes()));
                    if (textSegment.getEndAttributes().attributesEqual(textSegment2.getBeginAttributes())) {
                        PrintDataCompiler.trace(4, "compile", "mergedLineSegment end attrs == nextLineSeg's begin attr's");
                        PrintDataCompiler.trace(4, "compile", "nextLineSeg's begin attrs len == " + textSegment2.getBeginAttributesLength());
                        textSegment.append(textSegment2.getBytes(), textSegment2.getBeginAttributesLength(), textSegment2.getByteCount() - textSegment2.getBeginAttributesLength(), textSegment2.getCellCount());
                    } else {
                        textSegment.append(textSegment2.getBytes(), 0, textSegment2.getByteCount(), textSegment2.getCellCount());
                    }
                    textSegment.getEndAttributes().reinit(textSegment2.getEndAttributes());
                    ++n4;
                }
                this.printableSegment.append(textSegment.getBytes(), 0, textSegment.getByteCount(), textSegment.getCellCount());
                byArray = new byte[this.printableSegment.getByteCount()];
                System.arraycopy(this.printableSegment.getBytes(), 0, byArray, 0, this.printableSegment.getByteCount());
            }
            this.fontTypeface = this.attributesSegment.getFontTypefaceSelection();
        }
        PrintDataCompiler.trace(2, "compile", "Exit \n" + PrintDataCompiler.getByteDump(byArray));
        return byArray;
    }

    public static void printBytes(byte[] byArray) {
        if (byArray == null) {
            System.out.println("<null>");
        } else if (byArray.length == 0) {
            System.out.println("<empty>");
        } else {
            int n = 0;
            while (n < byArray.length) {
                if (n % 16 == 0) {
                    System.out.print("\n  ");
                }
                System.out.print(" x" + (byArray[n] < 16 ? "0" : "") + Integer.toHexString(byArray[n] & 0xFF));
                ++n;
            }
            System.out.print('\n');
        }
    }

    public static String getByteDump(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray == null) {
            stringBuffer.append("<null>");
        } else if (byArray.length == 0) {
            stringBuffer.append("<empty>");
        } else {
            int n = 0;
            while (n < byArray.length) {
                if (n % 16 == 0) {
                    stringBuffer.append("\n  ");
                }
                stringBuffer.append(" x" + ((byArray[n] & 0xFFFFFFF0) == 0 ? "0" : "") + Integer.toHexString(byArray[n] & 0xFF));
                ++n;
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    protected void processParsePrologue() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processParsePrologue", "Entry");
        this.printableSegment.append(this.getPrologueBytes());
        this.attributesSegment.setNormal(this.getNormalBytes());
        this.attributesSegment.setFontTypefaceSelection(this.fontTypeface, this.getFontTypefaceSelectionBytes(this.fontTypeface));
        this.alignedSegment.append(this.attributesSegment);
        PrintDataCompiler.trace(2, "processParsePrologue", "Exit");
    }

    protected void processParseComplete() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processParseComplete", "Entry");
        this.flushLine();
        PrintDataCompiler.trace(2, "processParseComplete", "Exit");
    }

    protected void processParseEpilogue() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processParseEpilogue", "Entry");
        byte[] byArray = this.getEpilogueBytes();
        if (byArray.length > 0 && this.lineSegments.size() > 0) {
            ((TextSegment)this.lineSegments.lastElement()).append(byArray);
        }
        PrintDataCompiler.trace(2, "processParseEpilogue", "Exit");
    }

    protected void processNewline() {
        PrintDataCompiler.trace(2, "processNewLine", "Entry");
        this.wrapLine();
        PrintDataCompiler.trace(2, "processNewLine", "Exit");
    }

    protected void processPrintableText(int n, int n2) {
        PrintDataCompiler.trace(2, "processPrintableText", "Entry");
        String string = this.source.substring(n, n2);
        PrintDataCompiler.trace(3, "processPrintableText", "text: \"" + string + "\"");
        if (this.reverseText) {
            string = new StringBuffer(string).reverse().toString();
        }
        byte[] byArray = this.byteEncoder.getBytes(string);
        if (this.isHSChanged) {
            this.cellsPerByte = this.attributesSegment.getHorizontalScale();
            this.isHSChanged = false;
        }
        PrintDataCompiler.trace(4, "processPrintableText", "bytes.length     : " + byArray.length);
        PrintDataCompiler.trace(4, "processPrintableText", "cellsPerByte     : " + this.cellsPerByte);
        PrintDataCompiler.trace(4, "processPrintableText", "cellsPerLine     : " + this.cellsPerLine);
        PrintDataCompiler.trace(4, "processPrintableText", "left cell count  : " + this.leftAlignedSegment.getCellCount());
        PrintDataCompiler.trace(4, "processPrintableText", "center cell count: " + this.centerAlignedSegment.getCellCount());
        PrintDataCompiler.trace(4, "processPrintableText", "right cell count : " + this.rightAlignedSegment.getCellCount());
        PrintDataCompiler.trace(4, "processPrintableText", "l+c+r cell count : " + (this.leftAlignedSegment.getCellCount() + this.centerAlignedSegment.getCellCount() + this.rightAlignedSegment.getCellCount()));
        if (byArray.length * this.cellsPerByte <= this.cellsPerLine - (this.leftAlignedSegment.getCellCount() + this.centerAlignedSegment.getCellCount() + this.rightAlignedSegment.getCellCount() + this.cellsBuffered)) {
            PrintDataCompiler.trace(4, "processPrintableText", "all text will fit on the line");
            this.alignedSegment.append(byArray, 0, byArray.length, byArray.length * this.cellsPerByte);
        } else {
            PrintDataCompiler.trace(4, "processPrintableText", "won't fit, need to insert newline(s)");
            int n3 = byArray.length;
            int n4 = 0;
            int n5 = 0;
            if (!this.byteEncoder.isDBCSCodePage()) {
                int n6 = byArray.length - n3;
                while (n6 < byArray.length) {
                    if ((this.cellsPerLine - n5 - (this.leftAlignedSegment.getCellCount() + this.centerAlignedSegment.getCellCount() + this.rightAlignedSegment.getCellCount() + this.cellsBuffered)) / this.cellsPerByte >= 1) {
                        ++n4;
                        n5 += this.cellsPerByte;
                        --n3;
                    } else {
                        this.alignedSegment.append(byArray, byArray.length - n3 - n4, n4, n5);
                        this.wrapLine();
                        this.cellsBuffered = 0;
                        n4 = 1;
                        n5 = this.cellsPerByte;
                        --n3;
                    }
                    ++n6;
                }
                if (n4 > 0) {
                    this.alignedSegment.append(byArray, byArray.length - n3 - n4, n4, n5);
                }
            } else {
                int n7 = byArray.length - n3;
                while (n7 < byArray.length) {
                    if (this.byteEncoder.isDBCSLeadByte(byArray[n7])) {
                        if ((this.cellsPerLine - n5 - (this.leftAlignedSegment.getCellCount() + this.centerAlignedSegment.getCellCount() + this.rightAlignedSegment.getCellCount() + this.cellsBuffered)) / this.cellsPerByte >= 2) {
                            n4 += 2;
                            n5 += 2 * this.cellsPerByte;
                            n3 -= 2;
                        } else {
                            this.alignedSegment.append(byArray, byArray.length - n3 - n4, n4, n5);
                            this.wrapLine();
                            this.cellsBuffered = 0;
                            n4 = 2;
                            n5 = 2 * this.cellsPerByte;
                            n3 -= 2;
                        }
                        ++n7;
                    } else if ((this.cellsPerLine - n5 - (this.leftAlignedSegment.getCellCount() + this.centerAlignedSegment.getCellCount() + this.rightAlignedSegment.getCellCount() + this.cellsBuffered)) / this.cellsPerByte >= 1) {
                        ++n4;
                        n5 += this.cellsPerByte;
                        --n3;
                    } else {
                        this.alignedSegment.append(byArray, byArray.length - n3 - n4, n4, n5);
                        this.wrapLine();
                        this.cellsBuffered = 0;
                        n4 = 1;
                        n5 = this.cellsPerByte;
                        --n3;
                    }
                    ++n7;
                }
                if (n4 > 0) {
                    this.alignedSegment.append(byArray, byArray.length - n3 - n4, n4, n5);
                }
            }
        }
        PrintDataCompiler.trace(2, "processPrintableText", "Exit");
    }

    protected void processISOControl(int n) {
        PrintDataCompiler.trace(2, "processISOControl", "Entry: index == " + n);
        this.alignedSegment.append((byte)(this.source.charAt(n) & 0xFF));
        PrintDataCompiler.trace(2, "processISOControl", "Exit");
    }

    protected int processDeviceEscape(int n) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processDeviceEscape", "Entry: beginIndex == " + n);
        byte[] byArray = this.getDeviceEscapeSequenceBytes(this.source, n);
        this.alignedSegment.append(byArray);
        PrintDataCompiler.trace(2, "processDeviceEscape", "Exit (" + byArray.length + ")");
        return byArray.length;
    }

    protected void processDeviceEscape(int n, int n2) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processDeviceEscape", "Entry: beginIndex == " + n + ", endIndex == " + n2);
        byte[] byArray = new byte[n2 - n];
        int n3 = n;
        while (n3 < n2) {
            byArray[n3 - n] = (byte)(this.source.charAt(n3 + n) & 0xFF);
            ++n3;
        }
        this.alignedSegment.append(byArray);
        PrintDataCompiler.trace(2, "processDeviceEscape", "Exit");
    }

    protected void processPaperCutEscape(int n) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processPaperCutEscape", "Entry");
        PrintDataCompiler.trace(3, "processPaperCutEscape", "cut percentage: " + n);
        if (this.station != 2 && this.isValidating()) {
            throw new JposException(111);
        }
        if (!this.serviceState.getCapRecPapercut() && this.isValidating()) {
            throw new JposException(111);
        }
        if (n < 0) {
            if (this.isValidating()) {
                throw new JposException(106);
            }
            n = 0;
        }
        byte[] byArray = this.getPaperCutBytes(n);
        if (n > 0) {
            this.alignedSegment.append(byArray);
            this.wrapLine();
        }
        PrintDataCompiler.trace(2, "processPaperCutEscape", "Exit");
    }

    protected void processRGBEscape(int n) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processRGBEscape(" + n + ")", "Entry");
        if (n != 0 && this.isValidating()) {
            throw new JposException(111);
        }
        PrintDataCompiler.trace(2, "processRGBEscape", "Exit");
    }

    protected void processSubAndSuperScriptEscape(boolean bl) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processSubAndSuperScriptEscape(" + bl + ")", "Entry");
        if (this.isValidating()) {
            throw new JposException(111);
        }
        PrintDataCompiler.trace(2, "processSubAndSuperScriptEscape", "Exit");
    }

    protected void processFeedAndPaperCutEscape(int n) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processFeedAndPaperCutEscape", "Entry");
        PrintDataCompiler.trace(3, "processFeedAndPaperCutEscape", "cut percentage: " + n);
        if (this.station != 2 && this.isValidating()) {
            throw new JposException(111);
        }
        if (!this.serviceState.getCapRecPapercut() && this.isValidating()) {
            throw new JposException(111);
        }
        if (n < 0) {
            if (this.isValidating()) {
                throw new JposException(106);
            }
            n = 0;
        }
        byte[] byArray = this.getFeedAndPaperCutBytes(n);
        this.alignedSegment.append(byArray);
        this.wrapLine();
        PrintDataCompiler.trace(2, "processFeedAndPaperCutEscape", "Exit");
    }

    protected void processFeedPaperCutAndStampEscape(int n) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processFeedPaperCutAndStampEscape", "Entry");
        PrintDataCompiler.trace(3, "processFeedPaperCutAndStampEscape", "cut percentage: " + n);
        if (this.station != 2 && this.isValidating()) {
            throw new JposException(111);
        }
        if (!this.serviceState.getCapRecPapercut() && this.isValidating()) {
            throw new JposException(111);
        }
        if (n < 0) {
            if (this.isValidating()) {
                throw new JposException(106);
            }
            n = 0;
        }
        byte[] byArray = this.getFeedPaperCutAndStampBytes(n);
        if (!this.serviceState.getCapRecStamp() && this.isValidating()) {
            throw new JposException(111);
        }
        this.alignedSegment.append(byArray);
        this.wrapLine();
        PrintDataCompiler.trace(2, "processFeedPaperCutAndStampEscape", "Exit");
    }

    protected void processFireStampEscape() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processFireStampEscape", "Entry");
        if (this.station != 2 && this.isValidating()) {
            throw new JposException(111);
        }
        if (!this.serviceState.getCapRecStamp() && this.isValidating()) {
            throw new JposException(111);
        }
        this.alignedSegment.append(this.getFireStampBytes());
        this.wrapLine();
        PrintDataCompiler.trace(2, "processFireStampEscape", "Exit");
    }

    protected void processPrintBitmapEscape(int n) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processPrintBitmapEscape", "Entry: bitmap number == " + n);
        switch (this.station) {
            case 1: {
                if (this.isValidating()) {
                    throw new JposException(111);
                }
            }
            case 2: {
                if (this.serviceState.getCapRecBitmap() || !this.isValidating()) break;
                throw new JposException(111);
            }
            case 4: {
                if (this.serviceState.getCapSlpBitmap() || !this.isValidating()) break;
                throw new JposException(111);
            }
        }
        this.wrapIncompleteLine();
        this.alignedSegment.append(this.getPrintBitmapBytes(n, this.alignedSegment.getAlignment()));
        this.flushLine();
        PrintDataCompiler.trace(2, "processPrintBitmapEscape", "Exit");
    }

    protected String includeTopLogoAt(int n) {
        this.source = this.source.substring(0, n) + this.topLogo + this.source.substring(n);
        return this.source;
    }

    protected String includeBottomLogoAt(int n) {
        this.source = this.source.substring(0, n) + this.bottomLogo + this.source.substring(n);
        return this.source;
    }

    protected void processFeedLinesEscape(int n) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processFeedLinesEscape", "Entry: line count == " + n);
        if (n < 0 && this.isValidating()) {
            throw new JposException(106);
        }
        int n2 = 0;
        while (n2 < n) {
            this.wrapLine();
            ++n2;
        }
        PrintDataCompiler.trace(2, "processFeedLinesEscape", "Exit");
    }

    protected void processFeedUnitsEscape(int n) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processFeedUnitsEscape", "Entry: unit count == " + n);
        if (n < 0 && this.isValidating()) {
            throw new JposException(106);
        }
        this.alignedSegment.append(this.getFeedUnitsBytes(n));
        PrintDataCompiler.trace(2, "processFeedUnitsEscape", "Exit");
    }

    protected void processFeedReverseEscape(int n) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processFeedReverseEscape", "Entry: line count == " + n);
        if (this.station != 4 && this.isValidating()) {
            throw new JposException(111);
        }
        if (n < 0 && this.isValidating()) {
            throw new JposException(111);
        }
        this.alignedSegment.append(this.getFeedReverseBytes(n));
        PrintDataCompiler.trace(2, "processFeedReverseEscape", "Exit");
    }

    protected void processFontTypefaceSelectionEscape(int n) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processFontTypefaceSelectionEscape", "Entry: typeface number == " + n);
        StringTokenizer stringTokenizer = new StringTokenizer(this.serviceState.getFontTypefaceList(), ",", false);
        int n2 = stringTokenizer.countTokens();
        if ((n < 0 || n > n2) && this.isValidating()) {
            throw new JposException(111);
        }
        byte[] byArray = this.getFontTypefaceSelectionBytes(n);
        this.alignedSegment.setFontTypefaceSelection(n, byArray);
        this.attributesSegment.setFontTypefaceSelection(n, byArray);
        PrintDataCompiler.trace(2, "processFontTypefaceSelectionEscape", "Exit");
    }

    protected void processBoldEscape() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processBoldEscape", "Entry");
        switch (this.station) {
            case 1: {
                if (this.serviceState.getCapJrnBold() || !this.isValidating()) break;
                throw new JposException(111);
            }
            case 2: {
                if (this.serviceState.getCapRecBold() || !this.isValidating()) break;
                throw new JposException(111);
            }
            case 4: {
                if (this.serviceState.getCapSlpBold() || !this.isValidating()) break;
                throw new JposException(111);
            }
        }
        byte[] byArray = this.getBoldBytes();
        PrintDataCompiler.trace(2, "processBoldEscape", "bold bytes: " + PrintDataCompiler.getByteDump(byArray));
        this.alignedSegment.setBold(byArray);
        this.attributesSegment.setBold(byArray);
        PrintDataCompiler.trace(2, "processBoldEscape", "alignedSegment: " + PrintDataCompiler.getByteDump(this.alignedSegment.getBytes()));
        PrintDataCompiler.trace(2, "processBoldEscape", "attributesSegment: " + PrintDataCompiler.getByteDump(this.attributesSegment.getBytes()));
        PrintDataCompiler.trace(2, "processBoldEscape", "Exit");
    }

    protected void processUnderlineEscape() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processUnderlineEscape", "Entry: thickness == default");
        switch (this.station) {
            case 1: {
                if (this.serviceState.getCapJrnUnderline() || !this.isValidating()) break;
                throw new JposException(111);
            }
            case 2: {
                if (this.serviceState.getCapRecUnderline() || !this.isValidating()) break;
                throw new JposException(111);
            }
            case 4: {
                if (this.serviceState.getCapSlpUnderline() || !this.isValidating()) break;
                throw new JposException(111);
            }
        }
        byte[] byArray = this.getUnderlineBytes();
        this.alignedSegment.setUnderline(byArray);
        this.attributesSegment.setUnderline(byArray);
        PrintDataCompiler.trace(2, "processUnderlineEscape", "Exit");
    }

    protected void processUnderlineEscape(int n) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processUnderlineEscape", "Entry: thickness == " + n);
        switch (this.station) {
            case 1: {
                if (this.serviceState.getCapJrnUnderline() || !this.isValidating()) break;
                throw new JposException(111);
            }
            case 2: {
                if (this.serviceState.getCapRecUnderline() || !this.isValidating()) break;
                throw new JposException(111);
            }
            case 4: {
                if (this.serviceState.getCapSlpUnderline() || !this.isValidating()) break;
                throw new JposException(111);
            }
        }
        byte[] byArray = this.getUnderlineBytes(n);
        this.alignedSegment.setUnderline(n, byArray);
        this.attributesSegment.setUnderline(n, byArray);
        PrintDataCompiler.trace(2, "processUnderlineEscape", "Exit");
    }

    protected void processItalicEscape() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processItalicEscape", "Entry");
        switch (this.station) {
            case 1: {
                if (this.serviceState.getCapJrnItalic() || !this.isValidating()) break;
                throw new JposException(111);
            }
            case 2: {
                if (this.serviceState.getCapRecItalic() || !this.isValidating()) break;
                throw new JposException(111);
            }
            case 4: {
                if (this.serviceState.getCapSlpItalic() || !this.isValidating()) break;
                throw new JposException(111);
            }
        }
        byte[] byArray = this.getItalicBytes();
        this.alignedSegment.setItalic(byArray);
        this.attributesSegment.setItalic(byArray);
        PrintDataCompiler.trace(2, "processItalicEscape", "Exit");
    }

    protected void processAlternateColorEscape(int n) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processAlternateColorEscape(" + n + ")", "Entry");
        switch (this.station) {
            case 1: {
                if ((this.serviceState.getCapJrnColor() & n) != 0) break;
                if (this.isValidating()) {
                    throw new JposException(106);
                }
                n = 1;
                break;
            }
            case 2: {
                if ((this.serviceState.getCapRecColor() & n) != 0) break;
                if (this.isValidating()) {
                    throw new JposException(106);
                }
                n = 1;
                break;
            }
            case 4: {
                if ((this.serviceState.getCapSlpColor() & n) != 0) break;
                if (this.isValidating()) {
                    throw new JposException(106);
                }
                n = 1;
            }
        }
        if (n <= 0) {
            if (this.isValidating()) {
                throw new JposException(106);
            }
            n = 1;
        }
        byte[] byArray = this.getAlternateColorBytes(n);
        this.alignedSegment.setAlternateColor(byArray);
        this.attributesSegment.setAlternateColor(byArray);
        PrintDataCompiler.trace(2, "processAlternateColorEscape", "Exit");
    }

    protected void processAlternateColorEscape() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processAlternateColorEscape()", "Entry");
        int n = 2;
        switch (this.station) {
            case 1: {
                if (this.serviceState.getCapJrn2Color()) break;
                if (this.isValidating()) {
                    throw new JposException(111);
                }
                n = 1;
                break;
            }
            case 2: {
                if (this.serviceState.getCapRec2Color()) break;
                if (this.isValidating()) {
                    throw new JposException(111);
                }
                n = 1;
                break;
            }
            case 4: {
                if (this.serviceState.getCapSlp2Color()) break;
                if (this.isValidating()) {
                    throw new JposException(111);
                }
                n = 1;
            }
        }
        byte[] byArray = this.getAlternateColorBytes(n);
        this.alignedSegment.setAlternateColor(byArray);
        this.attributesSegment.setAlternateColor(byArray);
        PrintDataCompiler.trace(2, "processAlternateColorEscape", "Exit");
    }

    protected void processReverseVideoEscape() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processReverseVideoEscape", "Entry");
        if (this.station != 2 && this.isValidating()) {
            throw new JposException(111);
        }
        byte[] byArray = this.getReverseVideoBytes();
        this.alignedSegment.setReverseVideo(byArray);
        this.attributesSegment.setReverseVideo(byArray);
        PrintDataCompiler.trace(2, "processReverseVideoEscape", "Exit");
    }

    protected void processShadingEscape() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processShadingEscape", "Entry: percentage == default");
        byte[] byArray = this.getShadingBytes();
        this.alignedSegment.setShading(byArray);
        this.attributesSegment.setShading(byArray);
        PrintDataCompiler.trace(2, "processShadingEscape", "Exit");
    }

    protected void processShadingEscape(int n) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processShadingEscape", "Entry: percentage == " + n);
        byte[] byArray = this.getShadingBytes(n);
        if ((n < 0 || n > 100) && this.isValidating()) {
            throw new JposException(106);
        }
        this.alignedSegment.setShading(n, byArray);
        this.attributesSegment.setShading(n, byArray);
        PrintDataCompiler.trace(2, "processShadingEscape", "Exit");
    }

    protected void processSingleWideSingleHighEscape() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processSingleWideSingleHighEscape", "Entry");
        this.isHSChanged = true;
        byte[] byArray = this.getSingleWideSingleHighBytes();
        this.alignedSegment.setSingleWideSingleHigh(byArray);
        this.attributesSegment.setHorizontalScale(1, byArray);
        PrintDataCompiler.trace(2, "processSingleWideSingleHighEscape", "Exit");
    }

    protected void processDoubleWideEscape() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processDoubleWideEscape", "Entry");
        int n = 2;
        switch (this.station) {
            case 1: {
                this.isHSChanged = this.serviceState.getCapJrnDwide();
                if (this.isHSChanged) break;
                if (this.isValidating()) {
                    throw new JposException(111);
                }
                n = 1;
                break;
            }
            case 2: {
                this.isHSChanged = this.serviceState.getCapRecDwide();
                if (this.isHSChanged) break;
                if (this.isValidating()) {
                    throw new JposException(111);
                }
                n = 1;
                break;
            }
            case 4: {
                this.isHSChanged = this.serviceState.getCapSlpDwide();
                if (this.isHSChanged) break;
                if (this.isValidating()) {
                    throw new JposException(111);
                }
                n = 1;
            }
        }
        byte[] byArray = this.getDoubleWideBytes();
        this.alignedSegment.setDoubleWide(byArray);
        this.attributesSegment.setHorizontalScale(n, byArray);
        PrintDataCompiler.trace(2, "processDoubleWideEscape", "Exit");
    }

    protected void processDoubleHighEscape() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processDoubleHighEscape", "Entry");
        switch (this.station) {
            case 1: {
                if (this.serviceState.getCapJrnDhigh() || !this.isValidating()) break;
                throw new JposException(111);
            }
            case 2: {
                if (this.serviceState.getCapRecDhigh() || !this.isValidating()) break;
                throw new JposException(111);
            }
            case 4: {
                if (this.serviceState.getCapSlpDhigh() || !this.isValidating()) break;
                throw new JposException(111);
            }
        }
        byte[] byArray = this.getDoubleHighBytes();
        this.alignedSegment.setDoubleHigh(byArray);
        this.attributesSegment.setDoubleHigh(byArray);
        PrintDataCompiler.trace(2, "processDoubleHighEscape", "Exit");
    }

    protected void processDoubleWideDoubleHighEscape() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processDoubleWideDoubleHighEscape", "Entry");
        int n = 2;
        switch (this.station) {
            case 1: {
                this.isHSChanged = this.serviceState.getCapJrnDwideDhigh();
                if (this.isHSChanged) break;
                if (this.isValidating()) {
                    throw new JposException(111);
                }
                n = 1;
                break;
            }
            case 2: {
                this.isHSChanged = this.serviceState.getCapRecDwideDhigh();
                if (this.isHSChanged) break;
                if (this.isValidating()) {
                    throw new JposException(111);
                }
                n = 1;
                break;
            }
            case 4: {
                this.isHSChanged = this.serviceState.getCapSlpDwideDhigh();
                if (this.isHSChanged) break;
                if (this.isValidating()) {
                    throw new JposException(111);
                }
                n = 1;
            }
        }
        byte[] byArray = this.getDoubleWideDoubleHighBytes();
        this.alignedSegment.setDoubleWideDoubleHigh(byArray);
        this.attributesSegment.setHorizontalScale(n, byArray);
        PrintDataCompiler.trace(2, "processDoubleWideDoubleHighEscape", "Exit");
    }

    protected void processScaleHorizontallyEscape(int n) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processScaleHorizontallyEscape", "Entry: factor == " + n);
        switch (this.station) {
            case 1: {
                if (n != 1 && n != 2 && this.isValidating()) {
                    throw new JposException(106);
                }
                if (n <= 1) {
                    this.processSingleWideSingleHighEscape();
                    break;
                }
                this.isHSChanged = this.serviceState.getCapJrnDwide();
                if (!this.isHSChanged) {
                    if (this.isValidating()) {
                        throw new JposException(106);
                    }
                    this.processSingleWideSingleHighEscape();
                    break;
                }
                byte[] byArray = this.getDoubleWideBytes();
                this.alignedSegment.setDoubleWide(byArray);
                this.attributesSegment.setHorizontalScale(2, byArray);
                break;
            }
            case 2: {
                if (n < 1 && this.isValidating()) {
                    throw new JposException(106);
                }
                if (n <= 1) {
                    this.processSingleWideSingleHighEscape();
                    break;
                }
                if (this.getActualHorizontalScaleFactor(n) == 1) {
                    this.isHSChanged = this.serviceState.getCapRecDwide();
                    if (!this.isHSChanged) {
                        if (this.isValidating()) {
                            throw new JposException(106);
                        }
                        this.processSingleWideSingleHighEscape();
                        break;
                    }
                    if (n > 2 && this.isValidating()) {
                        throw new JposException(106);
                    }
                    byte[] byArray = this.getDoubleWideBytes();
                    this.alignedSegment.setDoubleWide(byArray);
                    this.attributesSegment.setHorizontalScale(2, byArray);
                    break;
                }
                this.isHSChanged = true;
                byte[] byArray = this.getScaleHorizontallyBytes(n);
                this.alignedSegment.setHorizontalScale(this.getActualHorizontalScaleFactor(n), byArray);
                this.attributesSegment.setHorizontalScale(this.getActualHorizontalScaleFactor(n), byArray);
                break;
            }
            case 4: {
                if (n != 1 && n != 2 && this.isValidating()) {
                    throw new JposException(106);
                }
                if (n <= 1) {
                    this.processSingleWideSingleHighEscape();
                    break;
                }
                if (!this.serviceState.getCapSlpDwide()) {
                    if (this.isValidating()) {
                        throw new JposException(106);
                    }
                    this.processSingleWideSingleHighEscape();
                    break;
                }
                this.isHSChanged = true;
                byte[] byArray = this.getDoubleWideBytes();
                this.alignedSegment.setDoubleWide(byArray);
                this.attributesSegment.setHorizontalScale(2, byArray);
            }
        }
        PrintDataCompiler.trace(2, "processScaleHorizontallyEscape", "Exit");
    }

    protected void processScaleVerticallyEscape(int n) throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processScaleVerticallyEscape", "Entry: factor == " + n);
        switch (this.station) {
            case 1: {
                if (n != 1 && n != 2 && this.isValidating()) {
                    throw new JposException(106);
                }
                if (n <= 1) {
                    this.processSingleWideSingleHighEscape();
                    break;
                }
                if (!this.serviceState.getCapJrnDhigh()) {
                    if (this.isValidating()) {
                        throw new JposException(106);
                    }
                    this.processSingleWideSingleHighEscape();
                    break;
                }
                byte[] byArray = this.getDoubleHighBytes();
                this.alignedSegment.setDoubleHigh(byArray);
                this.attributesSegment.setDoubleHigh(byArray);
                break;
            }
            case 2: {
                if (n < 1 && this.isValidating()) {
                    throw new JposException(106);
                }
                if (n <= 1) {
                    this.processSingleWideSingleHighEscape();
                    break;
                }
                if (this.getActualVerticalScaleFactor(n) == 1) {
                    if (!this.serviceState.getCapRecDhigh()) {
                        if (this.isValidating()) {
                            throw new JposException(106);
                        }
                        this.processSingleWideSingleHighEscape();
                        break;
                    }
                    if (n > 2 && this.isValidating()) {
                        throw new JposException(106);
                    }
                    byte[] byArray = this.getDoubleHighBytes();
                    this.alignedSegment.setDoubleHigh(byArray);
                    this.attributesSegment.setDoubleHigh(byArray);
                    break;
                }
                byte[] byArray = this.getScaleVerticallyBytes(n);
                this.alignedSegment.setVerticalScale(this.getActualVerticalScaleFactor(n), byArray);
                this.attributesSegment.setVerticalScale(this.getActualVerticalScaleFactor(n), byArray);
                break;
            }
            case 4: {
                if (n != 1 && n != 2 && this.isValidating()) {
                    throw new JposException(106);
                }
                if (n <= 1) {
                    this.processSingleWideSingleHighEscape();
                    break;
                }
                if (!this.serviceState.getCapSlpDhigh()) {
                    if (this.isValidating()) {
                        throw new JposException(106);
                    }
                    this.processSingleWideSingleHighEscape();
                    break;
                }
                byte[] byArray = this.getDoubleHighBytes();
                this.alignedSegment.setDoubleHigh(byArray);
                this.attributesSegment.setDoubleHigh(byArray);
            }
        }
        PrintDataCompiler.trace(2, "processScaleVerticallyEscape", "Exit");
    }

    protected int getActualHorizontalScaleFactor(int n) {
        return 1;
    }

    protected int getActualVerticalScaleFactor(int n) {
        return 1;
    }

    protected void processAlignCenterEscape() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processAlignCenterEscape", "Entry");
        this.alignedSegment = this.centerAlignedSegment;
        this.alignedSegment.append(this.attributesSegment);
        PrintDataCompiler.trace(2, "processAlignCenterEscape", "Exit");
    }

    protected void processAlignRightEscape() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processAlignRightEscape", "Entry");
        this.alignedSegment = this.rightAlignedSegment;
        this.alignedSegment.append(this.attributesSegment);
        PrintDataCompiler.trace(2, "processAlignRightEscape", "Exit");
    }

    protected void processNormalEscape() throws PrintDataParseException, JposException {
        PrintDataCompiler.trace(2, "processNormalEscape", "Entry");
        this.isHSChanged = true;
        this.alignedSegment = this.leftAlignedSegment;
        int n = this.attributesSegment.getFontTypefaceSelection();
        byte[] byArray = this.getNormalBytes();
        byte[] byArray2 = this.getFontTypefaceSelectionBytes(n);
        this.attributesSegment.reinit();
        this.attributesSegment.setNormal(byArray);
        this.attributesSegment.setFontTypefaceSelection(n, byArray2);
        if (this.alignedSegment.getByteCount() == 0) {
            this.alignedSegment.append(this.attributesSegment);
        } else {
            this.alignedSegment.setNormal(byArray);
            if (n != this.alignedSegment.getFontTypefaceSelection()) {
                this.alignedSegment.setFontTypefaceSelection(n, byArray2);
            }
        }
    }

    protected byte[] getPrologueBytes() throws PrintDataParseException, JposException {
        return new byte[0];
    }

    protected byte[] getEpilogueBytes() throws PrintDataParseException, JposException {
        return new byte[0];
    }

    protected byte[] getNewlineBytes() {
        return new byte[]{13, 10};
    }

    protected byte[] getDeviceEscapeSequenceBytes(String string, int n) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getPaperCutBytes(int n) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getFeedAndPaperCutBytes(int n) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getFeedPaperCutAndStampBytes(int n) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getFireStampBytes() throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getPrintBitmapBytes(int n, int n2) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getFeedUnitsBytes(int n) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getFeedReverseBytes(int n) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getNormalBytes() {
        return new byte[0];
    }

    protected byte[] getFontTypefaceSelectionBytes(int n) throws PrintDataParseException, JposException {
        if (n == 0) {
            return new byte[0];
        }
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getBoldBytes() throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getUnderlineBytes() throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getUnderlineBytes(int n) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getItalicBytes() throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getAlternateColorBytes(int n) throws PrintDataParseException, JposException {
        if (this.isValidating() && n != 1) {
            throw new JposException(106);
        }
        return new byte[0];
    }

    protected byte[] getReverseVideoBytes() throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getShadingBytes() throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getShadingBytes(int n) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getSingleWideSingleHighBytes() throws PrintDataParseException, JposException {
        return new byte[0];
    }

    protected byte[] getDoubleWideBytes() throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getDoubleHighBytes() throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getDoubleWideDoubleHighBytes() throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getScaleHorizontallyBytes(int n) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getScaleVerticallyBytes(int n) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    private void flushLine() {
        byte[] byArray;
        PrintDataCompiler.trace(2, "flushLine", "Entry");
        TextSegment textSegment = TextSegment.alloc(this.leftAlignedSegment.getAlignment(), this.station);
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        TextSegment textSegment2 = this.reverseText ? this.rightAlignedSegment : this.leftAlignedSegment;
        TextSegment textSegment3 = this.reverseText ? this.leftAlignedSegment : this.rightAlignedSegment;
        int n4 = 0;
        int n5 = 0;
        TextSegment textSegment4 = TextSegment.alloc();
        boolean bl = true;
        if (textSegment2.getByteCount() > textSegment2.getBeginAttributesLength()) {
            textSegment.append(textSegment2);
            bl = textSegment2.getEndAttributes().isNormal();
        }
        if (this.centerAlignedSegment.getByteCount() > this.centerAlignedSegment.getBeginAttributesLength()) {
            if (this.centerAlignedSegment.getCellCount() > 0 && (n2 = (this.cellsPerLine - 2 * (textSegment.getCellCount() + this.cellsBuffered) - this.centerAlignedSegment.getCellCount()) / (2 * n)) > 0) {
                if (!bl || textSegment.getByteCount() == 0) {
                    textSegment.append(this.getNormalBytes());
                    textSegment.getEndAttributes().setNormal();
                }
                n3 = 0;
                while (n3 < n2) {
                    textSegment.append((byte)32, n);
                    ++n3;
                }
                n5 = textSegment.getByteCount();
                if (!bl) {
                    textSegment.append(textSegment.getBytes(), textSegment.getBeginIndex(), textSegment.getBeginAttributesLength(), 0);
                    n4 += textSegment.getBeginAttributesLength();
                }
                textSegment.setBeginIndex(n5);
                if (this.lineSegments.size() > 0) {
                    n3 = 0;
                    while (n3 < this.lineSegments.size()) {
                        textSegment4 = (TextSegment)this.lineSegments.elementAt(n3);
                        if (textSegment4.getFlag()) {
                            textSegment.append(textSegment4.getBytes(), textSegment4.getBeginIndex(), textSegment4.getBeginAttributesLength(), 0);
                            bl = bl && textSegment4.getBeginAttributesLength() == 0;
                            n4 += textSegment4.getBeginAttributesLength();
                            textSegment4.setFlag(false);
                        }
                        ++n3;
                    }
                }
            }
            if (!this.centerAlignedSegment.getBeginAttributes().attributesEqual(textSegment.getEndAttributes())) {
                n4 += this.centerAlignedSegment.getBeginAttributesLength();
                bl = false;
            }
            textSegment.append(this.centerAlignedSegment);
            textSegment.setBeginAttributesLength(n4);
        }
        if (textSegment3.getByteCount() > textSegment3.getBeginAttributesLength()) {
            if (textSegment3.getCellCount() > 0 && (n2 = (this.cellsPerLine - textSegment.getCellCount() - this.cellsBuffered - textSegment3.getCellCount()) / n) > 0) {
                if (!bl || textSegment.getByteCount() == 0) {
                    textSegment.append(this.getNormalBytes());
                    textSegment.getEndAttributes().setNormal();
                }
                n3 = 0;
                while (n3 < n2) {
                    textSegment.append((byte)32, n);
                    ++n3;
                }
                n4 = 0;
                n5 = textSegment.getByteCount();
                if (!bl) {
                    textSegment.append(textSegment.getBytes(), textSegment.getBeginIndex(), textSegment.getBeginAttributesLength(), 0);
                    n4 += textSegment.getBeginAttributesLength();
                }
                textSegment.setBeginIndex(n5);
                if (this.lineSegments.size() > 0) {
                    n3 = 0;
                    while (n3 < this.lineSegments.size()) {
                        textSegment4 = (TextSegment)this.lineSegments.elementAt(n3);
                        if (textSegment4.getFlag()) {
                            textSegment.append(textSegment4.getBytes(), textSegment4.getBeginIndex(), textSegment4.getBeginAttributesLength(), 0);
                            n4 += textSegment4.getBeginAttributesLength();
                            textSegment4.setFlag(false);
                        }
                        ++n3;
                    }
                }
            }
            if (!textSegment3.getBeginAttributes().attributesEqual(textSegment.getEndAttributes())) {
                n4 += textSegment3.getBeginAttributesLength();
            }
            textSegment.append(textSegment3);
            textSegment.setBeginAttributesLength(n4);
            PrintDataCompiler.trace(3, "flushLine", "final lineSeg:\n " + PrintDataCompiler.getByteDump(textSegment.getBytes()));
        }
        if ((byArray = textSegment.getBytes()).length > 0) {
            this.cellsBuffered = byArray[byArray.length - 1] != 10 ? (this.cellsBuffered + textSegment.getCellCount()) % this.cellsPerLine : 0;
        }
        textSegment.setCellsBuffered(this.cellsBuffered);
        if (textSegment.getByteCount() > textSegment.getBeginAttributesLength()) {
            if (this.reverseLines) {
                this.lineSegments.insertElementAt(textSegment, 0);
            } else {
                this.lineSegments.addElement(textSegment);
            }
        }
        this.attributesSegment.reinit();
        this.leftAlignedSegment.reinit(-1);
        this.centerAlignedSegment.reinit(-2);
        this.rightAlignedSegment.reinit(-3);
        this.alignedSegment.append(this.attributesSegment);
    }

    private void wrapLine() {
        if (this.rightAlignedSegment.getByteCount() > this.rightAlignedSegment.getBeginAttributesLength()) {
            this.rightAlignedSegment.append(this.getNewlineBytes());
        } else if (this.centerAlignedSegment.getByteCount() > this.centerAlignedSegment.getBeginAttributesLength()) {
            this.centerAlignedSegment.append(this.getNewlineBytes());
        } else {
            this.alignedSegment.append(this.getNewlineBytes());
        }
        this.flushLine();
    }

    private void wrapIncompleteLine() throws PrintDataParseException, JposException {
        if (this.leftAlignedSegment.getByteCount() > this.leftAlignedSegment.getBeginAttributesLength() || this.centerAlignedSegment.getByteCount() > this.centerAlignedSegment.getBeginAttributesLength() || this.rightAlignedSegment.getByteCount() > this.rightAlignedSegment.getBeginAttributesLength()) {
            this.wrapLine();
        }
    }

    private static final void trace(int n, String string, String string2) {
        if (n <= 4) {
            Tracer.trace(n, className, string, string2);
        }
    }
}

