/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.ibmprinter;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.BmpImageProducer;
import com.ibm.jpos.services.ibmprinter.CacheVector;
import com.ibm.jpos.services.ibmprinter.CacheVectorEntry;
import com.ibm.jpos.services.ibmprinter.DebugGraphicsFrame;
import com.ibm.jpos.services.ibmprinter.PrintBitmapBWImageFilter;
import com.ibm.jpos.services.ibmprinter.PrintBitmapData;
import com.ibm.jpos.services.ibmprinter.PrintBitmapImageInfo;
import com.ibm.jpos.services.ibmprinter.PrintBitmapUtilImplementor;
import com.ibm.jpos.services.ibmprinter.PrintQueueData;
import com.ibm.jpos.services.ibmprinter.SetBitmapData;
import com.ibm.jpos.util.HexDumper;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.Printer;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.ReplicateScaleFilter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import jpos.JposConst;
import jpos.JposException;
import jpos.POSPrinterConst;

public class PrintBitmapUtil
implements JposConst,
Printer,
POSPrinterConst {
    private final int CLEAR_BITMAPS_FLAG = -100;
    POSPrinterServiceState serviceState = null;
    DeviceServiceAbstraction serviceAbstraction = null;
    PrintBitmapUtilImplementor utilImp = null;
    public int bitmapIndex = 1;
    public int messageIndex = 1;
    public CacheVector cacheVector = new CacheVector();
    private static final String className = "PrintBitmapUtil";

    public PrintBitmapUtil(DeviceServiceAbstraction deviceServiceAbstraction, PrintBitmapUtilImplementor printBitmapUtilImplementor) {
        Tracer.trace(4, className, "Constructor", "Entry");
        this.serviceAbstraction = deviceServiceAbstraction;
        this.serviceState = (POSPrinterServiceState)deviceServiceAbstraction.getDeviceServiceState();
        this.utilImp = printBitmapUtilImplementor;
        Tracer.trace(4, className, "Constructor", "Exit");
    }

    Image loadFromDisk(String string) throws JposException {
        File file = new File(string);
        if (!file.exists()) {
            throw new JposException(109);
        }
        return Toolkit.getDefaultToolkit().getImage(string);
    }

    public void validateBitmap(PrintQueueData printQueueData, int n, int n2) throws JposException {
        Tracer.trace(4, className, "validateBitmap()", "Entry");
        Image image = null;
        Image image2 = null;
        int n3 = ((PrintBitmapData)printQueueData).getStation();
        int n4 = ((PrintBitmapData)printQueueData).getWidth();
        String string = ((PrintBitmapData)printQueueData).getFileName();
        int n5 = ((PrintBitmapData)printQueueData).getAlignment();
        int n6 = -1;
        int n7 = 0;
        if (printQueueData instanceof SetBitmapData) {
            n6 = ((SetBitmapData)printQueueData).getBitmapNumber();
        }
        Tracer.trace(4, className, "validateBitmap: " + n3 + ", " + string + ", " + n4 + ", " + n5 + ", " + n + ", " + n6, "");
        switch (n3) {
            case 2: {
                if (this.serviceState.getCapRecBitmap()) break;
                throw new JposException(111);
            }
            case 4: {
                if (!this.serviceState.getCapSlpBitmap()) {
                    throw new JposException(111);
                }
                if (n != 2 || this.utilImp.isSlipReady() || this.serviceState.getAsyncMode()) break;
                throw new JposException(114, 204);
            }
        }
        if (string == "" && n == 16) {
            this.doSetBitmap(new SetBitmapData(n6, n3, "", 0, -100, new byte[1]));
            Tracer.trace(4, className, "validateBitmap()", "Bitmaps cleared");
            return;
        }
        if (n4 != -11) {
            n4 = n4 / 8 * 8;
        }
        switch (n5) {
            case -1: 
            case 0: {
                int n8 = 0;
                break;
            }
            case -2: {
                int n8 = 1;
                break;
            }
            case -3: {
                int n8 = 2;
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
        this.utilImp.checkMode(n3, n);
        DebugGraphicsFrame debugGraphicsFrame = new DebugGraphicsFrame();
        URL uRL = null;
        Image image3 = null;
        try {
            image3 = Toolkit.getDefaultToolkit().createImage(new BmpImageProducer(string));
            this.waitForImage(image3, debugGraphicsFrame);
        }
        catch (Exception exception) {
            try {
                uRL = new URL(string);
                String string2 = uRL.getProtocol();
                if (string2.equalsIgnoreCase("file")) {
                    string = uRL.getHost() + ":" + uRL.getFile();
                    image3 = this.loadFromDisk(string);
                } else {
                    image3 = Toolkit.getDefaultToolkit().getImage(uRL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                image3 = this.loadFromDisk(string);
            }
            catch (Exception exception2) {
                throw new JposException(114, 207);
            }
            this.waitForImage(image3, debugGraphicsFrame);
        }
        if (n4 == -11 && image3.getWidth(debugGraphicsFrame) > n2) {
            throw new JposException(114, 206);
        }
        int n9 = n2 / 8;
        int n10 = 0;
        if (n == 16) {
            n10 = this.utilImp.getStationMaxBitmapHeight(n3);
            n7 = this.utilImp.getMaxSetBitmapSize(n3);
        } else {
            n10 = Integer.MAX_VALUE;
            n7 = this.utilImp.getMaxPrintBitmapSize();
        }
        if (this.utilImp.getForcedBitmapWidth() != -1) {
            n4 = this.utilImp.getForcedBitmapWidth();
        }
        image2 = this.scaleImage(image3, debugGraphicsFrame, n4, this.utilImp.getForcedBitmapWidth(), this.utilImp.getForcedBitmapHeight(), n7);
        PrintBitmapBWImageFilter printBitmapBWImageFilter = new PrintBitmapBWImageFilter();
        image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image2.getSource(), printBitmapBWImageFilter));
        this.waitForImage(image, debugGraphicsFrame);
        int n11 = image.getWidth(debugGraphicsFrame);
        int n12 = image.getHeight(debugGraphicsFrame);
        int[] nArray = new int[n11 * n12];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, nArray, 0, n11);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new JposException(114, 207);
        }
        if (image.getWidth(debugGraphicsFrame) > n2) {
            throw new JposException(114, 206);
        }
        int n13 = (image.getWidth(debugGraphicsFrame) - 1) / 8 + 1;
        int n14 = (image.getHeight(debugGraphicsFrame) - 1) / 8 + 1;
        if (n13 > n9) {
            Tracer.trace(4, className, "validateBitmap()", "Bitmap width to big: " + n13 + " - " + n9);
            throw new JposException(114, 206);
        }
        if (n14 > n10) {
            Tracer.trace(4, className, "validateBitmap()", "Bitmap height to big: " + n14 + " - " + n10);
            throw new JposException(114, 206);
        }
        PrintBitmapImageInfo printBitmapImageInfo = new PrintBitmapImageInfo(0L, 0L, image.getWidth(debugGraphicsFrame), image.getHeight(debugGraphicsFrame), false, nArray);
        int n15 = n13 * n14 * 8 + 100;
        Tracer.trace(4, className, "validateBitmap()", "Bitmap size = " + n15);
        if (n15 > n7 && n == 16) {
            Tracer.trace(4, className, "validateBitmap()", "Bitmap too big!");
            throw new JposException(114, 206);
        }
        byte[] byArray = new byte[n15];
        int n16 = 0;
        byArray[n16++] = 0;
        byArray[n16++] = (byte)n13;
        byArray[n16++] = (byte)n14;
        short s = 0;
        while (!printBitmapImageInfo.done) {
            s = this.utilImp.getNextByteForStation(n3, printBitmapImageInfo);
            byArray[n16++] = (byte)s;
        }
        if (n == 16) {
            ((SetBitmapData)printQueueData).setBitmapStream(byArray);
        } else {
            ((PrintBitmapData)printQueueData).setBitmapStream(byArray);
        }
        Tracer.trace(4, className, "validateBitmap()", "Exit");
    }

    public void doSetBitmap(SetBitmapData setBitmapData) throws JposException {
        int n = setBitmapData.getStation();
        byte[] byArray = setBitmapData.getBitmapStream();
        int n2 = setBitmapData.getAlignment();
        int n3 = setBitmapData.getBitmapNumber();
        Tracer.trace(4, className, "doSetBitmap(" + n + "," + n2 + "," + n3 + ")", "Entry");
        byArray[0] = (byte)this.bitmapIndex;
        Tracer.trace(4, className, "doSetBitmap()", "bitmapIndex = " + this.bitmapIndex);
        CacheVectorEntry cacheVectorEntry = new CacheVectorEntry(n, n2, byArray, false, n3, this.bitmapIndex, CacheVector.BITMAP);
        ++this.bitmapIndex;
        Tracer.trace(4, className, "doSetBitmap()", "Clearing and downloading bitmap.");
        this.utilImp.clearBitmaps();
        this.cacheVector.remove(CacheVector.BITMAP, n, n3);
        if (n2 != -100) {
            this.cacheVector.add(cacheVectorEntry);
        }
        this.cacheVector.clearAllDownloaded(CacheVector.BITMAP);
        int n4 = 0;
        while (n4 < this.cacheVector.size()) {
            CacheVectorEntry cacheVectorEntry2 = (CacheVectorEntry)this.cacheVector.elementAt(n4);
            if (cacheVectorEntry2.type == CacheVector.BITMAP) {
                cacheVectorEntry2.bitmap[0] = (byte)this.bitmapIndex;
                cacheVectorEntry2.downloaded = true;
                try {
                    this.utilImp.downloadData(cacheVectorEntry2.station, cacheVectorEntry2.bitmap, cacheVectorEntry2.alignment, cacheVectorEntry2.number);
                }
                catch (JposException jposException) {
                    cacheVectorEntry2.downloaded = false;
                    Tracer.trace(4, className, "doSetBitmap()", "Bitmap download error = " + jposException.getErrorCode() + " (" + jposException.getErrorCodeExtended() + ")");
                    throw jposException;
                }
                cacheVectorEntry2.index = this.bitmapIndex;
                if (cacheVectorEntry2.downloaded) {
                    Tracer.trace(4, className, "doSetBitmap()", "Downloaded " + cacheVectorEntry2.number + " to " + this.bitmapIndex);
                }
                ++this.bitmapIndex;
                setBitmapData.setDownloaded(cacheVectorEntry2.downloaded);
            }
            ++n4;
        }
        Tracer.trace(4, className, "doSetBitmap()", "Exit");
    }

    public void doSetLogo(int n, String string) throws JposException {
        Object object;
        Tracer.trace(4, className, "doSetLogo(" + n + "," + string + ")", "Entry");
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.insert(0, (char)this.messageIndex);
        if (Tracer.getTraceLevel() > 3) {
            object = new StringBuffer();
            HexDumper hexDumper = new HexDumper("doSetLogo: ", stringBuffer, -1, (StringBuffer)object);
            Tracer.trace(4, className, "doSetLogo()", "Data = " + object);
        }
        Tracer.trace(4, className, "doSetLogo()", "messageIndex = " + this.messageIndex);
        object = new CacheVectorEntry(-1, -1, stringBuffer.toString(), false, n, this.messageIndex, CacheVector.MESSAGE);
        ++this.messageIndex;
        if (this.cacheVector.exists(CacheVector.MESSAGE, -1, n)) {
            Tracer.trace(4, className, "doSetLogo()", "Message existed, clearing and redownloading.");
            this.utilImp.clearMessages();
            this.cacheVector.remove(CacheVector.MESSAGE, -1, n);
            this.cacheVector.add((CacheVectorEntry)object);
            this.cacheVector.clearAllDownloaded(CacheVector.MESSAGE);
            int n2 = 0;
            while (n2 < this.cacheVector.size()) {
                CacheVectorEntry cacheVectorEntry = (CacheVectorEntry)this.cacheVector.elementAt(n2);
                if (cacheVectorEntry.type == CacheVector.MESSAGE) {
                    stringBuffer = new StringBuffer(cacheVectorEntry.message);
                    stringBuffer.setCharAt(0, (char)this.messageIndex);
                    this.utilImp.downloadData(2, stringBuffer.toString(), 0, cacheVectorEntry.number);
                    cacheVectorEntry.index = this.messageIndex;
                    Tracer.trace(4, className, "doSetLogo()", "reDownloaded " + cacheVectorEntry.number + " to " + this.messageIndex);
                    ++this.messageIndex;
                }
                ++n2;
            }
        } else {
            this.cacheVector.add((CacheVectorEntry)object);
            this.utilImp.downloadData(2, ((CacheVectorEntry)object).message, 0, ((CacheVectorEntry)object).number);
            Tracer.trace(4, className, "doSetLogo()", "Downloaded " + ((CacheVectorEntry)object).number + " to " + (this.messageIndex - 1));
        }
        Tracer.trace(4, className, "doSetLogo()", "Exit");
    }

    public Image scaleImage(Image image, Frame frame, int n, int n2, int n3, int n4) throws JposException {
        int n5;
        int n6;
        Tracer.trace(4, className, "scaleImage(" + n + ", " + n2 + "," + n3 + "," + n4 + ")", "Entry");
        n4 *= 8;
        if (n2 > 0) {
            n6 = n2;
            n5 = n3;
        } else {
            float f = n == -11 ? 1.0f : (float)n / (float)image.getWidth(frame);
            n6 = (int)((float)image.getWidth(frame) * f);
            n5 = (int)((float)image.getHeight(frame) * f);
            if ((n6 = n6 / 8 * 8) * (n5 = n5 / 8 * 8) / 8 > n4) {
                f = (float)n4 / ((float)(n6 * n5) / 8.0f);
                if ((f = (float)Math.sqrt(f)) > 0.0f) {
                    n6 = (int)((float)n6 * f);
                    n5 = (int)((float)n5 * f);
                    n6 = n6 / 8 * 8;
                    n5 = n5 / 8 * 8;
                }
            }
        }
        ReplicateScaleFilter replicateScaleFilter = new ReplicateScaleFilter(n6, n5);
        Image image2 = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), replicateScaleFilter));
        this.waitForImage(image2, frame);
        Tracer.trace(4, className, "scaleImage()", "Exit");
        return image2;
    }

    public void waitForImage(Image image, Frame frame) throws JposException {
        Tracer.trace(4, className, "waitForImage()", "Entry");
        MediaTracker mediaTracker = null;
        try {
            mediaTracker = new MediaTracker(frame);
            mediaTracker.addImage(image, 1);
            mediaTracker.checkID(1, true);
            mediaTracker.waitForAll(10000L);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new JposException(111, "can't load bitmap: out of memory");
        }
        catch (Throwable throwable) {
            throw new JposException(111);
        }
        if (mediaTracker.isErrorAny()) {
            throw new JposException(114, 207);
        }
        Tracer.trace(4, className, "waitForImage()", "Exit");
    }
}

