/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceService;
import com.ibm.jpos.services.HardTotalsServiceImp;
import com.ibm.jpos.services.HardTotalsServiceState;
import jpos.JposException;
import jpos.services.HardTotalsService15;

public abstract class HardTotalsService
extends DeviceService
implements HardTotalsService15 {
    public static final String HARDTOTALS_DEVCAT = "com.ibm.jpos.services.HardTotalsService";

    public HardTotalsService(HardTotalsServiceImp hardTotalsServiceImp) {
        super(hardTotalsServiceImp);
        this.setDeviceServiceState(new HardTotalsServiceState());
    }

    public synchronized void setDeviceEnabled(boolean bl) throws JposException {
        this.getDeviceServiceState().isOpen();
        this.getDeviceServiceImp().setDeviceEnabled(bl);
        this.getDeviceServiceState().setDeviceEnabled(bl);
        HardTotalsServiceState hardTotalsServiceState = this.getHardTotalsServiceState();
        if (bl && hardTotalsServiceState.getTotalsSize() <= 0) {
            HardTotalsServiceImp hardTotalsServiceImp = (HardTotalsServiceImp)this.getDeviceServiceImp();
            hardTotalsServiceImp.setTotalsSize();
            hardTotalsServiceImp.getPersistentFile();
        }
    }

    public boolean getCapErrorDetection() throws JposException {
        HardTotalsServiceState hardTotalsServiceState;
        HardTotalsServiceState hardTotalsServiceState2 = hardTotalsServiceState = this.getHardTotalsServiceState();
        synchronized (hardTotalsServiceState2) {
            hardTotalsServiceState.isOpen();
            boolean bl = hardTotalsServiceState.getCapErrorDetection();
            return bl;
        }
    }

    public boolean getCapSingleFile() throws JposException {
        HardTotalsServiceState hardTotalsServiceState;
        HardTotalsServiceState hardTotalsServiceState2 = hardTotalsServiceState = this.getHardTotalsServiceState();
        synchronized (hardTotalsServiceState2) {
            hardTotalsServiceState.isOpen();
            boolean bl = hardTotalsServiceState.getCapSingleFile();
            return bl;
        }
    }

    public boolean getCapTransactions() throws JposException {
        HardTotalsServiceState hardTotalsServiceState;
        HardTotalsServiceState hardTotalsServiceState2 = hardTotalsServiceState = this.getHardTotalsServiceState();
        synchronized (hardTotalsServiceState2) {
            hardTotalsServiceState.isOpen();
            boolean bl = hardTotalsServiceState.getCapTransactions();
            return bl;
        }
    }

    public int getFreeData() throws JposException {
        HardTotalsServiceState hardTotalsServiceState;
        HardTotalsServiceState hardTotalsServiceState2 = hardTotalsServiceState = this.getHardTotalsServiceState();
        synchronized (hardTotalsServiceState2) {
            hardTotalsServiceState.isOpenEnable();
            int n = hardTotalsServiceState.getFreeData();
            return n;
        }
    }

    public int getNumberOfFiles() throws JposException {
        HardTotalsServiceState hardTotalsServiceState;
        HardTotalsServiceState hardTotalsServiceState2 = hardTotalsServiceState = this.getHardTotalsServiceState();
        synchronized (hardTotalsServiceState2) {
            hardTotalsServiceState.isOpenEnable();
            int n = hardTotalsServiceState.getNumberOfFiles();
            return n;
        }
    }

    public int getTotalsSize() throws JposException {
        HardTotalsServiceState hardTotalsServiceState;
        HardTotalsServiceImp hardTotalsServiceImp = this.getHardTotalsServiceImp();
        HardTotalsServiceState hardTotalsServiceState2 = hardTotalsServiceState = this.getHardTotalsServiceState();
        synchronized (hardTotalsServiceState2) {
            hardTotalsServiceState.isOpenEnable();
            int n = hardTotalsServiceState.getTotalsSize();
            if (n == -1) {
                hardTotalsServiceImp.setTotalsSize();
                n = hardTotalsServiceState.getTotalsSize();
                hardTotalsServiceState.setFreeData(n);
            }
            int n2 = n;
            return n2;
        }
    }

    public boolean getTransactionInProgress() throws JposException {
        HardTotalsServiceState hardTotalsServiceState;
        HardTotalsServiceState hardTotalsServiceState2 = hardTotalsServiceState = this.getHardTotalsServiceState();
        synchronized (hardTotalsServiceState2) {
            hardTotalsServiceState.isOpen();
            boolean bl = hardTotalsServiceState.getTransactionInProgress();
            return bl;
        }
    }

    public synchronized void release() throws JposException {
        super.releaseSharable();
    }

    public synchronized void beginTrans() throws JposException {
        HardTotalsServiceState hardTotalsServiceState = this.getHardTotalsServiceState();
        hardTotalsServiceState.isOpenEnable();
        this.getHardTotalsServiceImp().beginTrans();
    }

    public synchronized void checkHealth(int n) throws JposException {
        this.getDeviceServiceState().isOpenEnable();
        this.checkClaimedService();
        this.checkCheckHealthArg(n);
        this.getDeviceServiceImp().checkHealth(n);
    }

    public synchronized void claimFile(int n, int n2) throws JposException {
        HardTotalsServiceState hardTotalsServiceState = this.getHardTotalsServiceState();
        this.checkNegativeArg(n);
        this.checkTimeoutArg(n2);
        hardTotalsServiceState.isOpenEnable();
        this.getHardTotalsServiceImp().claimFile(n, n2);
    }

    public synchronized void commitTrans() throws JposException {
        HardTotalsServiceState hardTotalsServiceState = this.getHardTotalsServiceState();
        hardTotalsServiceState.isOpenEnable();
        this.getHardTotalsServiceImp().commitTrans();
    }

    public synchronized void create(String string, int[] nArray, int n, boolean bl) throws JposException {
        HardTotalsServiceState hardTotalsServiceState;
        block2: {
            hardTotalsServiceState = this.getHardTotalsServiceState();
            this.checkNullArg(string);
            this.checkNullArg(nArray);
            this.checkNegativeArg(n);
            hardTotalsServiceState.isOpen();
            try {
                hardTotalsServiceState.isClaim();
            }
            catch (JposException jposException) {
                if (jposException.getErrorCode() != 102) break block2;
                throw jposException;
            }
        }
        hardTotalsServiceState.isEnable();
        this.checkClaimedService();
        this.checkName(string);
        this.checkOnline();
        this.getHardTotalsServiceImp().create(string, nArray, n, bl);
    }

    public synchronized void delete(String string) throws JposException {
        HardTotalsServiceState hardTotalsServiceState;
        block3: {
            hardTotalsServiceState = this.getHardTotalsServiceState();
            this.checkNullArg(string);
            hardTotalsServiceState.isOpen();
            try {
                hardTotalsServiceState.isClaim();
            }
            catch (JposException jposException) {
                if (jposException.getErrorCode() != 102) break block3;
                throw jposException;
            }
        }
        hardTotalsServiceState.isEnable();
        this.checkClaimedService();
        this.checkName(string);
        this.checkOnline();
        if (this.getHardTotalsServiceImp().fileClaimedByOther(-1, string)) {
            throw new JposException(102);
        }
        this.getHardTotalsServiceImp().delete(string);
    }

    public synchronized void find(String string, int[] nArray, int[] nArray2) throws JposException {
        HardTotalsServiceState hardTotalsServiceState;
        block2: {
            hardTotalsServiceState = this.getHardTotalsServiceState();
            this.checkNullArg(string);
            this.checkNullArg(nArray);
            this.checkNullArg(nArray2);
            hardTotalsServiceState.isOpen();
            try {
                hardTotalsServiceState.isClaim();
            }
            catch (JposException jposException) {
                if (jposException.getErrorCode() != 102) break block2;
                throw jposException;
            }
        }
        hardTotalsServiceState.isEnable();
        this.checkClaimedService();
        this.checkName(string);
        this.getHardTotalsServiceImp().find(string, nArray, nArray2);
    }

    public synchronized void findByIndex(int n, String[] stringArray) throws JposException {
        HardTotalsServiceState hardTotalsServiceState;
        block2: {
            hardTotalsServiceState = this.getHardTotalsServiceState();
            this.checkNegativeArg(n);
            this.checkNullArg(stringArray);
            hardTotalsServiceState.isOpen();
            try {
                hardTotalsServiceState.isClaim();
            }
            catch (JposException jposException) {
                if (jposException.getErrorCode() != 102) break block2;
                throw jposException;
            }
        }
        hardTotalsServiceState.isEnable();
        this.checkClaimedService();
        this.getHardTotalsServiceImp().findByIndex(n, stringArray);
    }

    public synchronized void read(int n, byte[] byArray, int n2, int n3) throws JposException {
        HardTotalsServiceState hardTotalsServiceState = this.getHardTotalsServiceState();
        this.checkNegativeArg(n);
        this.checkNullArg(byArray);
        this.checkNegativeArg(n2);
        this.checkNegativeArg(n3);
        hardTotalsServiceState.isOpenEnable();
        this.checkClaimedService();
        this.checkOnline();
        if (this.getHardTotalsServiceImp().fileClaimedByOther(n, "")) {
            throw new JposException(102);
        }
        this.getHardTotalsServiceImp().read(n, byArray, n2, n3);
    }

    public synchronized void recalculateValidationData(int n) throws JposException {
        HardTotalsServiceState hardTotalsServiceState;
        block3: {
            hardTotalsServiceState = this.getHardTotalsServiceState();
            this.checkNegativeArg(n);
            hardTotalsServiceState.isOpen();
            try {
                hardTotalsServiceState.isClaim();
            }
            catch (JposException jposException) {
                if (jposException.getErrorCode() != 102) break block3;
                throw jposException;
            }
        }
        hardTotalsServiceState.isEnable();
        this.checkClaimedService();
        if (this.getHardTotalsServiceImp().fileClaimedByOther(n, "")) {
            throw new JposException(102);
        }
        this.getHardTotalsServiceImp().recalculateValidationData(n);
    }

    public synchronized void releaseFile(int n) throws JposException {
        HardTotalsServiceState hardTotalsServiceState = this.getHardTotalsServiceState();
        this.checkNegativeArg(n);
        hardTotalsServiceState.isOpenEnable();
        if (this.getHardTotalsServiceImp().fileClaimedByOther(n, "")) {
            throw new JposException(106);
        }
        this.getHardTotalsServiceImp().releaseFile(n);
    }

    public synchronized void rename(int n, String string) throws JposException {
        HardTotalsServiceState hardTotalsServiceState = this.getHardTotalsServiceState();
        this.checkNegativeArg(n);
        this.checkNullArg(string);
        hardTotalsServiceState.isOpenEnable();
        this.checkClaimedService();
        this.checkName(string);
        this.checkOnline();
        if (this.getHardTotalsServiceImp().fileClaimedByOther(n, "")) {
            throw new JposException(102);
        }
        this.getHardTotalsServiceImp().rename(n, string);
    }

    public synchronized void rollback() throws JposException {
        HardTotalsServiceState hardTotalsServiceState = this.getHardTotalsServiceState();
        hardTotalsServiceState.isOpenEnable();
        this.getHardTotalsServiceImp().rollback();
    }

    public synchronized void setAll(int n, byte by) throws JposException {
        HardTotalsServiceState hardTotalsServiceState = this.getHardTotalsServiceState();
        this.checkNegativeArg(n);
        hardTotalsServiceState.isOpenEnable();
        this.checkClaimedService();
        this.checkOnline();
        if (this.getHardTotalsServiceImp().fileClaimedByOther(n, "")) {
            throw new JposException(102);
        }
        this.getHardTotalsServiceImp().setAll(n, by);
    }

    public synchronized void validateData(int n) throws JposException {
        HardTotalsServiceState hardTotalsServiceState;
        block3: {
            hardTotalsServiceState = this.getHardTotalsServiceState();
            this.checkNegativeArg(n);
            hardTotalsServiceState.isOpen();
            try {
                hardTotalsServiceState.isClaim();
            }
            catch (JposException jposException) {
                if (jposException.getErrorCode() != 102) break block3;
                throw jposException;
            }
        }
        hardTotalsServiceState.isEnable();
        this.checkClaimedService();
        if (this.getHardTotalsServiceImp().fileClaimedByOther(n, "")) {
            throw new JposException(102);
        }
        this.getHardTotalsServiceImp().validateData(n);
    }

    public synchronized void write(int n, byte[] byArray, int n2, int n3) throws JposException {
        HardTotalsServiceState hardTotalsServiceState = this.getHardTotalsServiceState();
        this.checkNegativeArg(n);
        this.checkNullArg(byArray);
        this.checkNegativeArg(n2);
        this.checkNegativeArg(n3);
        hardTotalsServiceState.isOpenEnable();
        this.checkClaimedService();
        this.checkOnline();
        if (this.getHardTotalsServiceImp().fileClaimedByOther(n, "")) {
            throw new JposException(102);
        }
        this.getHardTotalsServiceImp().write(n, byArray, n2, n3);
    }

    private void checkName(String string) throws JposException {
        if (!string.equals("") && string.length() > 10) {
            throw new JposException(106);
        }
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) < ' ' || string.charAt(n) > '\u007f') {
                throw new JposException(106);
            }
            ++n;
        }
    }

    protected HardTotalsServiceState getHardTotalsServiceState() {
        return (HardTotalsServiceState)this.getDeviceServiceState();
    }

    protected HardTotalsServiceImp getHardTotalsServiceImp() {
        return (HardTotalsServiceImp)this.getDeviceServiceImp();
    }

    public final String getDeviceCategory() {
        return HARDTOTALS_DEVCAT;
    }
}

