/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.EventProcessing;
import com.ibm.jpos.util.JposEventContainer;
import com.ibm.jpos.util.JposEventQueue;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.services.EventCallbacks;

public class EventQueueManager
implements Runnable {
    private EventCallbacks eventCallbacks = null;
    private EventProcessing eventProcessing = null;
    private JposEventQueue jposEventQueue = new JposEventQueue();
    private boolean freezeEvents = false;
    private boolean dataEventEnabled = false;
    private boolean terminated = false;
    private Thread eventThread = new Thread((Runnable)this, "EventQueueManager.eventThread");
    private Object eventPosted = new Object();
    private Object eventUnfrozen = new Object();
    private Object dataEventEnabledLock = new Object();
    public static final String EVENTQUEUEMANAGER_THREAD_NAME = "EventQueueManager.eventThread";

    public EventQueueManager(EventCallbacks eventCallbacks, EventProcessing eventProcessing) {
        this.eventCallbacks = eventCallbacks;
        this.eventProcessing = eventProcessing;
        this.eventThread.start();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        while (true) {
            if (!this.jposEventQueue.isEmpty()) ** GOTO lbl30
            var1_1 = this.eventPosted;
            synchronized (var1_1) {
                try {
                    this.eventPosted.wait();
                }
                catch (InterruptedException var2_3) {
                    // empty catch block
                }
            }
            {
                var2_2 = this.eventUnfrozen;
                synchronized (var2_2) {
                    try {
                        this.eventUnfrozen.wait();
                    }
                    catch (InterruptedException var3_4) {
                        // empty catch block
                    }
                }
                do {
                    if (this.freezeEvents) continue block11;
                    if (this.terminated) {
                        return;
                    }
                    this.fireJposEvent(this.jposEventQueue.dequeue());
lbl30:
                    // 2 sources

                } while (!this.jposEventQueue.isEmpty());
            }
        }
    }

    public synchronized void setFreezeEvents(boolean bl) {
        this.freezeEvents = bl;
        if (!this.freezeEvents) {
            Object object = this.eventUnfrozen;
            synchronized (object) {
                this.eventUnfrozen.notifyAll();
            }
        }
    }

    public boolean isFreezeEvents() {
        return this.freezeEvents;
    }

    public synchronized void setDataEventEnabled(boolean bl) {
        this.dataEventEnabled = bl;
        if (this.dataEventEnabled) {
            Object object = this.dataEventEnabledLock;
            synchronized (object) {
                this.dataEventEnabledLock.notifyAll();
            }
        }
    }

    public boolean isDataEventEnabled() {
        return this.dataEventEnabled;
    }

    public synchronized void postEvent(JposEvent jposEvent) {
        this.jposEventQueue.enqueue(jposEvent);
        if (jposEvent instanceof DataEvent) {
            this.eventProcessing.newDataEventPosted();
        }
        if (jposEvent instanceof ErrorEvent) {
            this.eventProcessing.newErrorEventPosted((ErrorEvent)jposEvent);
        }
        Object object = this.eventPosted;
        synchronized (object) {
            this.eventPosted.notifyAll();
        }
    }

    public synchronized void postEvent(JposEventContainer jposEventContainer) {
        this.jposEventQueue.enqueue(jposEventContainer);
        if (jposEventContainer.getJposEvent() instanceof DataEvent) {
            this.eventProcessing.newDataEventPosted();
        }
        if (jposEventContainer.getJposEvent() instanceof ErrorEvent) {
            this.eventProcessing.newErrorEventPosted((ErrorEvent)jposEventContainer.getJposEvent());
        }
        Object object = this.eventPosted;
        synchronized (object) {
            this.eventPosted.notifyAll();
        }
    }

    synchronized void terminate() {
        this.terminated = true;
        if (this.freezeEvents) {
            this.freezeEvents = false;
            Object object = this.eventUnfrozen;
            synchronized (object) {
                this.eventUnfrozen.notifyAll();
            }
            return;
        }
        if (!this.dataEventEnabled) {
            this.dataEventEnabled = true;
            Object object = this.dataEventEnabledLock;
            synchronized (object) {
                this.dataEventEnabledLock.notifyAll();
            }
        }
        if (this.jposEventQueue.isEmpty()) {
            this.postEvent(new TerminateEvent(this));
        }
    }

    public synchronized void removeAllErrorEvent() {
        this.jposEventQueue.removeAllErrorEvent();
    }

    synchronized void removeAllDataEvent() {
        this.jposEventQueue.removeAllDataEvent();
    }

    public synchronized void removeAllEvents() {
        this.jposEventQueue.removeAllEvents();
    }

    synchronized boolean isEnqueuedDataEvent() {
        return this.jposEventQueue.isEnqueuedDataEvent();
    }

    synchronized void enqueueInFront(JposEvent jposEvent) {
        this.jposEventQueue.enqueueInFront(jposEvent);
    }

    synchronized void enqueueInFront(JposEventContainer jposEventContainer) {
        this.jposEventQueue.enqueueInFront(jposEventContainer);
    }

    private void fireJposEvent(Object object) {
        if (object instanceof TerminateEvent) {
            return;
        }
        JposEvent jposEvent = null;
        JposEventContainer jposEventContainer = null;
        if (object instanceof JposEventContainer) {
            jposEventContainer = (JposEventContainer)object;
            jposEvent = jposEventContainer.getJposEvent();
        } else {
            jposEvent = (JposEvent)object;
        }
        if (jposEvent instanceof DataEvent) {
            Object object2;
            while (!this.dataEventEnabled || this.freezeEvents) {
                if (object instanceof JposEventContainer) {
                    this.enqueueInFront((JposEventContainer)object);
                } else {
                    this.enqueueInFront((JposEvent)object);
                }
                if (!this.dataEventEnabled) {
                    object2 = this.dataEventEnabledLock;
                    synchronized (object2) {
                        try {
                            this.dataEventEnabledLock.wait();
                            if (!this.jposEventQueue.isEmpty()) {
                                this.fireJposEvent(this.jposEventQueue.dequeue());
                            }
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                    }
                }
                Object object3 = this.eventUnfrozen;
                synchronized (object3) {
                    try {
                        this.eventUnfrozen.wait();
                        if (!this.jposEventQueue.isEmpty()) {
                            this.fireJposEvent(this.jposEventQueue.dequeue());
                        }
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
            if (this.terminated) {
                return;
            }
            object2 = (DataEvent)jposEvent;
            if (jposEventContainer != null) {
                jposEventContainer.prepareToFire();
            }
            this.eventProcessing.preEventProcessing((DataEvent)object2);
            this.eventCallbacks.fireDataEvent((DataEvent)object2);
            this.eventProcessing.postEventProcessing((DataEvent)object2);
            if (jposEventContainer != null) {
                jposEventContainer.doneFiring();
            }
            return;
        }
        if (this.terminated) {
            return;
        }
        if (jposEvent instanceof DirectIOEvent) {
            if (jposEventContainer != null) {
                jposEventContainer.prepareToFire();
            }
            this.eventCallbacks.fireDirectIOEvent((DirectIOEvent)jposEvent);
        }
        if (jposEvent instanceof ErrorEvent) {
            Object object4;
            while (!this.dataEventEnabled || this.freezeEvents) {
                if (object instanceof JposEventContainer) {
                    this.enqueueInFront((JposEventContainer)object);
                } else {
                    this.enqueueInFront((JposEvent)object);
                }
                if (!this.dataEventEnabled) {
                    object4 = this.dataEventEnabledLock;
                    synchronized (object4) {
                        try {
                            this.dataEventEnabledLock.wait();
                            if (!this.jposEventQueue.isEmpty()) {
                                this.fireJposEvent(this.jposEventQueue.dequeue());
                            }
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                    }
                }
                Object object5 = this.eventUnfrozen;
                synchronized (object5) {
                    try {
                        this.eventUnfrozen.wait();
                        if (!this.jposEventQueue.isEmpty()) {
                            this.fireJposEvent(this.jposEventQueue.dequeue());
                        }
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
            if (this.terminated) {
                return;
            }
            object4 = (ErrorEvent)jposEvent;
            if (jposEventContainer != null) {
                jposEventContainer.prepareToFire();
            }
            this.eventProcessing.preEventProcessing((ErrorEvent)object4);
            this.eventCallbacks.fireErrorEvent((ErrorEvent)object4);
            this.eventProcessing.postEventProcessing((ErrorEvent)object4);
        }
        if (this.terminated) {
            return;
        }
        if (jposEvent instanceof OutputCompleteEvent) {
            this.eventCallbacks.fireOutputCompleteEvent((OutputCompleteEvent)jposEvent);
        }
        if (jposEvent instanceof StatusUpdateEvent) {
            this.eventCallbacks.fireStatusUpdateEvent((StatusUpdateEvent)jposEvent);
        }
        if (jposEventContainer != null) {
            jposEventContainer.doneFiring();
        }
    }

    private class TerminateEvent
    extends JposEvent {
        public TerminateEvent(Object object) {
            super(object);
        }
    }
}

