/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.DeviceServiceImp;
import com.ibm.jpos.services.DeviceServiceState;
import com.ibm.jpos.services.EventProcessing;
import com.ibm.jpos.services.EventQueueManager;
import com.ibm.jpos.services.InputDeviceService;
import com.ibm.jpos.services.InputDeviceServiceState;
import com.ibm.jpos.services.OutputDeviceService;
import com.ibm.jpos.services.ServiceRegistry;
import com.ibm.jpos.util.Timer;
import com.ibm.jpos.util.Timerable;
import jpos.JposException;
import jpos.events.DataEvent;
import jpos.events.ErrorEvent;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;

public abstract class DeviceService
implements BaseService,
DeviceServiceAbstraction {
    private DeviceServiceState deviceServiceState = null;
    private EventQueueManager eventQueueManager = null;
    private EventCallbacks eventCallbacks = null;
    private DeviceServiceImp deviceServiceImp = null;
    private boolean timerExpired = false;
    public static final int CLAIM_POLLING_TIMEOUT = 200;
    public static final String DEFAULT_DEVICESERVICE_DEVCAT = "com.ibm.jpos.services.DeviceService";

    public DeviceService(DeviceServiceImp deviceServiceImp) {
        this.deviceServiceImp = deviceServiceImp;
    }

    public int getCapPowerReporting() throws JposException {
        DeviceServiceState deviceServiceState;
        DeviceServiceState deviceServiceState2 = deviceServiceState = this.getDeviceServiceState();
        synchronized (deviceServiceState2) {
            deviceServiceState.isOpen();
            int n = deviceServiceState.getCapPowerReporting();
            return n;
        }
    }

    public int getPowerNotify() throws JposException {
        DeviceServiceState deviceServiceState;
        DeviceServiceState deviceServiceState2 = deviceServiceState = this.getDeviceServiceState();
        synchronized (deviceServiceState2) {
            deviceServiceState.isOpen();
            int n = deviceServiceState.getPowerNotify();
            return n;
        }
    }

    public void setPowerNotify(int n) throws JposException {
        DeviceServiceState deviceServiceState = this.getDeviceServiceState();
        deviceServiceState.isOpen();
        if (deviceServiceState.getDeviceEnabled()) {
            throw new JposException(106);
        }
        if (deviceServiceState.getCapPowerReporting() == 0) {
            throw new JposException(106);
        }
        this.getDeviceServiceImp().setPowerNotify(n);
        deviceServiceState.setPowerNotify(n);
    }

    public int getPowerState() throws JposException {
        DeviceServiceState deviceServiceState;
        DeviceServiceState deviceServiceState2 = deviceServiceState = this.getDeviceServiceState();
        synchronized (deviceServiceState2) {
            deviceServiceState.isOpen();
            int n = deviceServiceState.getPowerState();
            return n;
        }
    }

    public String getCheckHealthText() throws JposException {
        DeviceServiceState deviceServiceState;
        DeviceServiceState deviceServiceState2 = deviceServiceState = this.getDeviceServiceState();
        synchronized (deviceServiceState2) {
            deviceServiceState.isOpen();
            String string = deviceServiceState.getCheckHealthText();
            return string;
        }
    }

    public boolean getClaimed() throws JposException {
        DeviceServiceState deviceServiceState;
        DeviceServiceState deviceServiceState2 = deviceServiceState = this.getDeviceServiceState();
        synchronized (deviceServiceState2) {
            deviceServiceState.isOpen();
            boolean bl = deviceServiceState.getClaimed();
            return bl;
        }
    }

    public boolean getDeviceEnabled() throws JposException {
        DeviceServiceState deviceServiceState;
        DeviceServiceState deviceServiceState2 = deviceServiceState = this.getDeviceServiceState();
        synchronized (deviceServiceState2) {
            deviceServiceState.isOpen();
            boolean bl = deviceServiceState.getDeviceEnabled();
            return bl;
        }
    }

    public synchronized void setDeviceEnabled(boolean bl) throws JposException {
        this.getDeviceServiceState().isOpenClaim();
        DeviceServiceState deviceServiceState = this.getDeviceServiceState();
        if (!deviceServiceState.getDeviceEnabled()) {
            this.checkOnline();
        }
        this.getDeviceServiceImp().setDeviceEnabled(bl);
        this.getDeviceServiceState().setDeviceEnabled(bl);
    }

    public String getDeviceServiceDescription() throws JposException {
        DeviceServiceState deviceServiceState;
        DeviceServiceState deviceServiceState2 = deviceServiceState = this.getDeviceServiceState();
        synchronized (deviceServiceState2) {
            deviceServiceState.isOpen();
            String string = deviceServiceState.getDeviceServiceDescription();
            return string;
        }
    }

    public int getDeviceServiceVersion() throws JposException {
        DeviceServiceState deviceServiceState;
        DeviceServiceState deviceServiceState2 = deviceServiceState = this.getDeviceServiceState();
        synchronized (deviceServiceState2) {
            int n = deviceServiceState.getDeviceServiceVersion();
            return n;
        }
    }

    public boolean getFreezeEvents() throws JposException {
        DeviceServiceState deviceServiceState;
        DeviceServiceState deviceServiceState2 = deviceServiceState = this.getDeviceServiceState();
        synchronized (deviceServiceState2) {
            deviceServiceState.isOpen();
            boolean bl = deviceServiceState.getFreezeEvents();
            return bl;
        }
    }

    public synchronized void setFreezeEvents(boolean bl) throws JposException {
        DeviceServiceState deviceServiceState = this.getDeviceServiceState();
        deviceServiceState.isOpen();
        if (deviceServiceState.getFreezeEvents() == bl) {
            return;
        }
        this.getDeviceServiceImp().setFreezeEvents(bl);
        this.getEventQueueManager().setFreezeEvents(bl);
        deviceServiceState.setFreezeEvents(bl);
    }

    public String getPhysicalDeviceDescription() throws JposException {
        DeviceServiceState deviceServiceState;
        DeviceServiceState deviceServiceState2 = deviceServiceState = this.getDeviceServiceState();
        synchronized (deviceServiceState2) {
            deviceServiceState.isOpen();
            String string = deviceServiceState.getPhysicalDeviceDescription();
            return string;
        }
    }

    public String getPhysicalDeviceName() throws JposException {
        DeviceServiceState deviceServiceState;
        DeviceServiceState deviceServiceState2 = deviceServiceState = this.getDeviceServiceState();
        synchronized (deviceServiceState2) {
            deviceServiceState.isOpen();
            String string = deviceServiceState.getPhysicalDeviceName();
            return string;
        }
    }

    public int getState() throws JposException {
        return this.getDeviceServiceState().getState();
    }

    public synchronized void claim(int n) throws JposException {
        DeviceServiceState deviceServiceState = this.getDeviceServiceState();
        deviceServiceState.isOpen();
        this.checkTimeoutArg(n);
        this.checkOnline();
        if (deviceServiceState.getClaimed()) {
            return;
        }
        Exception exception = null;
        if (this.getClaimedService() == null) {
            try {
                this.getDeviceServiceImp().claim(n);
                deviceServiceState.setClaimed(true);
                return;
            }
            catch (JposException jposException) {
                if (jposException.getErrorCode() == 108) {
                    throw jposException;
                }
                exception = jposException;
            }
        }
        if (n == 0) {
            throw new JposException(112, String.valueOf(112), exception);
        }
        if (n == -1) {
            while (true) {
                try {
                    this.getDeviceServiceImp().claim(n);
                    deviceServiceState.setClaimed(true);
                }
                catch (JposException jposException) {
                    if (jposException.getErrorCode() == 108) {
                        throw jposException;
                    }
                    exception = jposException;
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
                if (deviceServiceState.getClaimed()) {
                    return;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(this.getClaimPollingWait());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.timerExpired = false;
        Timer timer = new Timer(new Timerable(){

            public void timerExpired() {
                DeviceService.this.timerExpired = true;
            }
        });
        timer.setTime(n);
        timer.start();
        while (!this.timerExpired) {
            try {
                this.getDeviceServiceImp().claim(n);
                deviceServiceState.setClaimed(true);
            }
            catch (JposException jposException) {
                if (jposException.getErrorCode() == 108) {
                    throw jposException;
                }
                exception = jposException;
            }
            catch (Exception exception3) {
                exception = exception3;
            }
            if (deviceServiceState.getClaimed()) {
                return;
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.getClaimPollingWait());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.timerExpired && !deviceServiceState.getClaimed()) {
            throw new JposException(112, String.valueOf(112), exception);
        }
    }

    public synchronized void open(String string, EventCallbacks eventCallbacks) throws JposException {
        this.getDeviceServiceState().setDeviceService(this);
        this.getDeviceServiceState().initProperties();
        this.eventCallbacks = eventCallbacks;
        this.eventQueueManager = new EventQueueManager(eventCallbacks, this.newEventProcessing());
        if (this instanceof InputDeviceService) {
            this.eventQueueManager.setDataEventEnabled(((InputDeviceServiceState)((Object)this.getDeviceServiceState())).getDataEventEnabled());
        } else if (this instanceof OutputDeviceService) {
            this.eventQueueManager.setDataEventEnabled(true);
        }
        this.getDeviceServiceImp().open(string, eventCallbacks);
        this.getDeviceServiceState().setState(2);
        ServiceRegistry.getInstance().addDeviceService(this.getDeviceServiceState().getServiceKey(), this);
    }

    public synchronized void close() throws JposException {
        DeviceServiceState deviceServiceState = this.getDeviceServiceState();
        deviceServiceState.isOpen();
        if (this.getClaimed()) {
            if (this.getDeviceEnabled()) {
                this.setDeviceEnabled(false);
            }
            this.release();
        }
        this.getDeviceServiceImp().close();
        this.eventCallbacks = null;
        this.eventQueueManager.terminate();
        this.eventQueueManager = null;
        deviceServiceState.setState(1);
        ServiceRegistry.getInstance().removeDeviceService(deviceServiceState.getServiceKey(), this);
    }

    public synchronized void checkHealth(int n) throws JposException {
        this.getDeviceServiceState().isOpenClaimEnable();
        this.checkCheckHealthArg(n);
        this.getDeviceServiceImp().checkHealth(n);
    }

    public synchronized void directIO(int n, int[] nArray, Object object) throws JposException {
        this.getDeviceServiceState().isOpen();
        this.getDeviceServiceImp().directIO(n, nArray, object);
    }

    public abstract void release() throws JposException;

    protected boolean isOnline() {
        return this.getDeviceServiceImp() == null ? false : this.getDeviceServiceImp().isOnline();
    }

    protected void checkOnline() throws JposException {
        if (!this.isOnline()) {
            throw new JposException(108);
        }
    }

    protected synchronized void releaseSharable() throws JposException {
        DeviceServiceState deviceServiceState = this.getDeviceServiceState();
        deviceServiceState.isOpen();
        if (!deviceServiceState.getClaimed()) {
            throw new JposException(106);
        }
        this.getDeviceServiceImp().release();
        deviceServiceState.setClaimed(false);
    }

    protected synchronized void releaseExclusive() throws JposException {
        DeviceServiceState deviceServiceState = this.getDeviceServiceState();
        deviceServiceState.isOpen();
        if (!deviceServiceState.getClaimed()) {
            throw new JposException(106);
        }
        if (this.getDeviceEnabled()) {
            this.setDeviceEnabled(false);
        }
        this.getDeviceServiceImp().release();
        deviceServiceState.setClaimed(false);
        this.getEventQueueManager().removeAllEvents();
        if (deviceServiceState.getState() == 4) {
            deviceServiceState.setState(2);
        }
        if (this instanceof InputDeviceService) {
            ((InputDeviceServiceState)((Object)deviceServiceState)).setDataCount(0);
        }
    }

    public String getDeviceCategory() {
        return DEFAULT_DEVICESERVICE_DEVCAT;
    }

    synchronized DeviceServiceImp getDeviceServiceImp() {
        return this.deviceServiceImp;
    }

    protected synchronized void setDeviceServiceImp(DeviceServiceImp deviceServiceImp) {
        this.deviceServiceImp = deviceServiceImp;
    }

    public DeviceServiceState getDeviceServiceState() {
        return this.deviceServiceState;
    }

    protected synchronized void setDeviceServiceState(DeviceServiceState deviceServiceState) {
        this.deviceServiceState = deviceServiceState;
    }

    protected EventProcessing newEventProcessing() {
        return new DefaultEventProcessing();
    }

    public EventQueueManager getEventQueueManager() throws JposException {
        if (this.eventQueueManager == null) {
            throw new JposException(101);
        }
        return this.eventQueueManager;
    }

    public Object getEventSource() throws JposException {
        if (this.eventCallbacks == null) {
            throw new JposException(101);
        }
        return this.eventCallbacks.getEventSource();
    }

    protected void checkZeroArg(int n) throws JposException {
        if (n == 0) {
            throw new JposException(106);
        }
    }

    protected void checkNullArg(Object object) throws JposException {
        if (object == null) {
            throw new JposException(106);
        }
    }

    protected void checkNegativeArg(int n) throws JposException {
        if (n < 0) {
            throw new JposException(106);
        }
    }

    protected void checkTimeoutArg(int n) throws JposException {
        if (n < -1) {
            throw new JposException(106);
        }
    }

    protected void checkIntArrayArg(int[] nArray) throws JposException {
        if (nArray == null || nArray.length < 1) {
            throw new JposException(106);
        }
    }

    protected void checkCheckHealthArg(int n) throws JposException {
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    protected void checkClaimedService() throws JposException {
        DeviceServiceState deviceServiceState = this.getDeviceServiceState();
        DeviceService deviceService = ServiceRegistry.getInstance().getClaimedService(deviceServiceState.getServiceKey());
        if (deviceService != null && deviceService != this) {
            throw new JposException(102);
        }
    }

    protected DeviceService getClaimedService() {
        DeviceServiceState deviceServiceState = this.getDeviceServiceState();
        return ServiceRegistry.getInstance().getClaimedService(deviceServiceState.getServiceKey());
    }

    protected int getClaimPollingWait() {
        return 200;
    }

    public synchronized void deleteInstance() throws JposException {
        this.getDeviceServiceImp().deleteImp();
        this.getDeviceServiceState().setZombified(true);
    }

    protected void preEventProcessing(ErrorEvent errorEvent) {
    }

    protected void postEventProcessing(ErrorEvent errorEvent) {
        block14: {
            try {
                DeviceServiceState deviceServiceState = this.getDeviceServiceState();
                if (errorEvent.getErrorLocus() == 2) {
                    DeviceServiceState deviceServiceState2 = deviceServiceState;
                    synchronized (deviceServiceState2) {
                        deviceServiceState.setState(2);
                    }
                }
                if (errorEvent.getErrorResponse() == 12) {
                    this.getEventQueueManager().removeAllErrorEvent();
                    if (this instanceof InputDeviceService) {
                        this.getEventQueueManager().removeAllDataEvent();
                        ((InputDeviceServiceState)((Object)deviceServiceState)).setDataCount(0);
                    }
                    DeviceServiceState deviceServiceState3 = deviceServiceState;
                    synchronized (deviceServiceState3) {
                        deviceServiceState.setState(2);
                        break block14;
                    }
                }
                if (errorEvent.getErrorResponse() != 13) break block14;
                DeviceServiceState deviceServiceState4 = deviceServiceState;
                synchronized (deviceServiceState4) {
                    deviceServiceState.setState(4);
                }
            }
            catch (JposException jposException) {
                jposException.printStackTrace();
            }
        }
    }

    protected synchronized void preEventProcessing(DataEvent dataEvent) {
        if (this instanceof InputDeviceService) {
            try {
                InputDeviceServiceState inputDeviceServiceState = (InputDeviceServiceState)((Object)this.getDeviceServiceState());
                ((InputDeviceService)((Object)this)).setDataEventEnabled(false);
                if (inputDeviceServiceState.getDataCount() > 0) {
                    inputDeviceServiceState.setDataCount(inputDeviceServiceState.getDataCount() - 1);
                }
            }
            catch (JposException jposException) {
                jposException.printStackTrace();
            }
        }
    }

    protected synchronized void postEventProcessing(DataEvent dataEvent) {
    }

    protected void newDataEventPosted() {
        if (this instanceof InputDeviceService) {
            InputDeviceServiceState inputDeviceServiceState;
            InputDeviceServiceState inputDeviceServiceState2 = inputDeviceServiceState = (InputDeviceServiceState)((Object)this.getDeviceServiceState());
            synchronized (inputDeviceServiceState2) {
                try {
                    inputDeviceServiceState.setDataCount(inputDeviceServiceState.getDataCount() + 1);
                }
                catch (JposException jposException) {
                    jposException.printStackTrace();
                }
            }
        }
    }

    protected void newErrorEventPosted(ErrorEvent errorEvent) {
        DeviceServiceState deviceServiceState = null;
        try {
            DeviceServiceState deviceServiceState2 = deviceServiceState = this.getDeviceServiceState();
            synchronized (deviceServiceState2) {
                deviceServiceState.setState(4);
            }
            if (errorEvent.getErrorLocus() == 2 && this.getEventQueueManager().isEnqueuedDataEvent()) {
                ErrorEvent errorEvent2 = new ErrorEvent(errorEvent.getSource(), errorEvent.getErrorCode(), errorEvent.getErrorCodeExtended(), 3, 13);
                this.getEventQueueManager().enqueueInFront(errorEvent2);
            }
        }
        catch (JposException jposException) {
            jposException.printStackTrace();
        }
    }

    protected class DefaultEventProcessing
    implements EventProcessing {
        protected DefaultEventProcessing() {
        }

        public void preEventProcessing(ErrorEvent errorEvent) {
            DeviceService.this.preEventProcessing(errorEvent);
        }

        public void postEventProcessing(ErrorEvent errorEvent) {
            DeviceService.this.postEventProcessing(errorEvent);
        }

        public void preEventProcessing(DataEvent dataEvent) {
            DeviceService.this.preEventProcessing(dataEvent);
        }

        public void postEventProcessing(DataEvent dataEvent) {
            DeviceService.this.postEventProcessing(dataEvent);
        }

        public void newDataEventPosted() {
            DeviceService.this.newDataEventPosted();
        }

        public void newErrorEventPosted(ErrorEvent errorEvent) {
            DeviceService.this.newErrorEventPosted(errorEvent);
        }
    }
}

