/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.config.auto;

import com.ibm.jpos.config.auto.CashDrawerDevInfo;
import com.ibm.jpos.config.auto.EntryFactory;
import com.ibm.jpos.config.auto.HardTotalsDevInfo;
import com.ibm.jpos.config.auto.JposEntryRegUtility;
import com.ibm.jpos.config.auto.KeylockDevInfo;
import com.ibm.jpos.config.auto.LineDisplayDevInfo;
import com.ibm.jpos.config.auto.MICRDevInfo;
import com.ibm.jpos.config.auto.MSRDevInfo;
import com.ibm.jpos.config.auto.POSKeyboardDevInfo;
import com.ibm.jpos.config.auto.POSPrinterDevInfo;
import com.ibm.jpos.config.auto.PosDevId;
import com.ibm.jpos.config.auto.PosDevInfo;
import com.ibm.jpos.config.auto.ScaleDevInfo;
import com.ibm.jpos.config.auto.ScannerDevInfo;
import com.ibm.jpos.config.auto.ToneIndicatorDevInfo;
import jpos.JposException;
import jpos.POSPrinter;

final class PosDevInfoFactory {
    public static final int CLAIM_TIMEOUT = 1000;

    private PosDevInfoFactory() {
    }

    static PosDevInfo[] createPosDevInfos(PosDevId posDevId) {
        byte by = posDevId.getType();
        PosDevInfo[] posDevInfoArray = null;
        switch (by) {
            case 6: {
                posDevInfoArray = new PosDevInfo[]{new CashDrawerDevInfo(posDevId)};
                break;
            }
            case 2: {
                posDevInfoArray = new PosDevInfo[]{new LineDisplayDevInfo(posDevId)};
                break;
            }
            case 9: {
                posDevInfoArray = PosDevInfoFactory.createPOSKeyboardPosDevInfos(posDevId);
                break;
            }
            case 3: {
                posDevInfoArray = PosDevInfoFactory.createPOSPrinterPosDevInfos(posDevId);
                break;
            }
            case 5: {
                posDevInfoArray = new PosDevInfo[]{new MSRDevInfo(posDevId)};
                break;
            }
            case 4: {
                posDevInfoArray = new PosDevInfo[]{new ScannerDevInfo(posDevId)};
                break;
            }
            case 11: {
                posDevInfoArray = new PosDevInfo[]{new ScaleDevInfo(posDevId)};
                break;
            }
            case 8: {
                posDevInfoArray = new PosDevInfo[]{new HardTotalsDevInfo(posDevId)};
                break;
            }
            default: {
                posDevInfoArray = new PosDevInfo[]{};
            }
        }
        return posDevInfoArray;
    }

    private static PosDevInfo[] createPOSKeyboardPosDevInfos(PosDevId posDevId) {
        PosDevInfo[] posDevInfoArray = null;
        posDevInfoArray = posDevId.getSubtype() == 6 ? new PosDevInfo[]{new ToneIndicatorDevInfo(posDevId), new POSKeyboardDevInfo(posDevId)} : (posDevId.getSubtype() == 12 ? new PosDevInfo[]{new KeylockDevInfo(posDevId), new ToneIndicatorDevInfo(posDevId)} : new PosDevInfo[]{new KeylockDevInfo(posDevId), new ToneIndicatorDevInfo(posDevId), new POSKeyboardDevInfo(posDevId)});
        return posDevInfoArray;
    }

    private static PosDevInfo[] createPOSPrinterPosDevInfos(PosDevId posDevId) {
        PosDevInfo[] posDevInfoArray = null;
        posDevInfoArray = posDevId.getDeviceNumber() == 53 ? (PosDevInfoFactory.isPOSPrinter4610WithMICR(new POSPrinterDevInfo(posDevId)) ? new PosDevInfo[]{new POSPrinterDevInfo(posDevId), new MICRDevInfo(posDevId)} : new PosDevInfo[]{new POSPrinterDevInfo(posDevId)}) : new PosDevInfo[]{new POSPrinterDevInfo(posDevId)};
        return posDevInfoArray;
    }

    /*
     * Loose catch block
     */
    private static boolean isPOSPrinter4610WithMICR(POSPrinterDevInfo pOSPrinterDevInfo) {
        String string = "";
        boolean bl = false;
        if (!JposEntryRegUtility.hasJposEntryFor(pOSPrinterDevInfo)) {
            string = "POSPrinter4610" + pOSPrinterDevInfo.getDeviceNumber() + "_Temp";
            pOSPrinterDevInfo.setLogicalName(string);
            JposEntryRegUtility.addJposEntryToRegistry(EntryFactory.createEntry(pOSPrinterDevInfo, pOSPrinterDevInfo.getLogicalName()));
        } else {
            string = pOSPrinterDevInfo.getLogicalName();
        }
        POSPrinter pOSPrinter = new POSPrinter();
        pOSPrinter.open(string);
        pOSPrinter.claim(1000);
        pOSPrinter.setDeviceEnabled(true);
        boolean[] blArray = new boolean[1];
        pOSPrinter.directIO(17, null, blArray);
        bl = blArray[0];
        Object var6_6 = null;
        try {
            pOSPrinter.release();
            pOSPrinter.close();
        }
        catch (JposException jposException) {
            // empty catch block
        }
        JposEntryRegUtility.removeJposEntryInRegistry(string);
        return bl;
        {
            catch (Exception exception) {
                bl = false;
                Object var6_7 = null;
                try {
                    pOSPrinter.release();
                    pOSPrinter.close();
                }
                catch (JposException jposException) {
                    // empty catch block
                }
                JposEntryRegUtility.removeJposEntryInRegistry(string);
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                pOSPrinter.release();
                pOSPrinter.close();
            }
            catch (JposException jposException) {
                // empty catch block
            }
            JposEntryRegUtility.removeJposEntryInRegistry(string);
            return bl;
        }
    }
}

