/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Mode;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.encoder.ByteMatrix;

public final class QRCode {
    public static final int NUM_MASK_PATTERNS = 8;
    private Mode mode;
    private ErrorCorrectionLevel ecLevel;
    private Version version;
    private int maskPattern = -1;
    private ByteMatrix matrix;

    public static boolean isValidMaskPattern(int maskPattern) {
        return maskPattern >= 0 && maskPattern < 8;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode value) {
        this.mode = value;
    }

    public ErrorCorrectionLevel getECLevel() {
        return this.ecLevel;
    }

    public void setECLevel(ErrorCorrectionLevel value) {
        this.ecLevel = value;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public int getMaskPattern() {
        return this.maskPattern;
    }

    public void setMaskPattern(int value) {
        this.maskPattern = value;
    }

    public ByteMatrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(ByteMatrix value) {
        this.matrix = value;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(200);
        result.append("<<\n");
        result.append(" mode: ");
        result.append((Object)this.mode);
        result.append("\n ecLevel: ");
        result.append((Object)this.ecLevel);
        result.append("\n version: ");
        result.append(this.version);
        result.append("\n maskPattern: ");
        result.append(this.maskPattern);
        if (this.matrix == null) {
            result.append("\n matrix: null\n");
        } else {
            result.append("\n matrix:\n");
            result.append(this.matrix);
        }
        result.append(">>\n");
        return result.toString();
    }
}

