/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.common.GridSampler;
import com.google.zxing.common.detector.WhiteRectangleDetector;

public final class Detector {
    private final BitMatrix image;
    private final WhiteRectangleDetector rectangleDetector;

    public Detector(BitMatrix image) throws NotFoundException {
        this.image = image;
        this.rectangleDetector = new WhiteRectangleDetector(image);
    }

    private static ResultPoint shiftPoint(ResultPoint point, ResultPoint to, int div) {
        float x = (to.getX() - point.getX()) / (float)(div + 1);
        float y = (to.getY() - point.getY()) / (float)(div + 1);
        return new ResultPoint(point.getX() + x, point.getY() + y);
    }

    private static ResultPoint moveAway(ResultPoint point, float fromX, float fromY) {
        float x = point.getX();
        float y = point.getY();
        x = x < fromX ? (x -= 1.0f) : (x += 1.0f);
        y = y < fromY ? (y -= 1.0f) : (y += 1.0f);
        return new ResultPoint(x, y);
    }

    private static BitMatrix sampleGrid(BitMatrix image, ResultPoint topLeft, ResultPoint bottomLeft, ResultPoint bottomRight, ResultPoint topRight, int dimensionX, int dimensionY) throws NotFoundException {
        GridSampler sampler = GridSampler.getInstance();
        return sampler.sampleGrid(image, dimensionX, dimensionY, 0.5f, 0.5f, (float)dimensionX - 0.5f, 0.5f, (float)dimensionX - 0.5f, (float)dimensionY - 0.5f, 0.5f, (float)dimensionY - 0.5f, topLeft.getX(), topLeft.getY(), topRight.getX(), topRight.getY(), bottomRight.getX(), bottomRight.getY(), bottomLeft.getX(), bottomLeft.getY());
    }

    public DetectorResult detect() throws NotFoundException {
        ResultPoint[] cornerPoints = this.rectangleDetector.detect();
        ResultPoint[] points = this.detectSolid1(cornerPoints);
        points = this.detectSolid2(points);
        points[3] = this.correctTopRight(points);
        if (points[3] == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        points = this.shiftToModuleCenter(points);
        ResultPoint topLeft = points[0];
        ResultPoint bottomLeft = points[1];
        ResultPoint bottomRight = points[2];
        ResultPoint topRight = points[3];
        int dimensionTop = this.transitionsBetween(topLeft, topRight) + 1;
        int dimensionRight = this.transitionsBetween(bottomRight, topRight) + 1;
        if ((dimensionTop & 1) == 1) {
            ++dimensionTop;
        }
        if ((dimensionRight & 1) == 1) {
            ++dimensionRight;
        }
        if (4 * dimensionTop < 7 * dimensionRight && 4 * dimensionRight < 7 * dimensionTop) {
            dimensionTop = dimensionRight = Math.max(dimensionTop, dimensionRight);
        }
        BitMatrix bits = Detector.sampleGrid(this.image, topLeft, bottomLeft, bottomRight, topRight, dimensionTop, dimensionRight);
        return new DetectorResult(bits, new ResultPoint[]{topLeft, bottomLeft, bottomRight, topRight});
    }

    private ResultPoint[] detectSolid1(ResultPoint[] cornerPoints) {
        ResultPoint pointA = cornerPoints[0];
        ResultPoint pointB = cornerPoints[1];
        ResultPoint pointC = cornerPoints[3];
        ResultPoint pointD = cornerPoints[2];
        int trAB = this.transitionsBetween(pointA, pointB);
        int trBC = this.transitionsBetween(pointB, pointC);
        int trCD = this.transitionsBetween(pointC, pointD);
        int trDA = this.transitionsBetween(pointD, pointA);
        int min = trAB;
        ResultPoint[] points = new ResultPoint[]{pointD, pointA, pointB, pointC};
        if (min > trBC) {
            min = trBC;
            points[0] = pointA;
            points[1] = pointB;
            points[2] = pointC;
            points[3] = pointD;
        }
        if (min > trCD) {
            min = trCD;
            points[0] = pointB;
            points[1] = pointC;
            points[2] = pointD;
            points[3] = pointA;
        }
        if (min > trDA) {
            points[0] = pointC;
            points[1] = pointD;
            points[2] = pointA;
            points[3] = pointB;
        }
        return points;
    }

    private ResultPoint[] detectSolid2(ResultPoint[] points) {
        int trCD;
        ResultPoint pointA = points[0];
        ResultPoint pointB = points[1];
        ResultPoint pointC = points[2];
        ResultPoint pointD = points[3];
        int tr = this.transitionsBetween(pointA, pointD);
        ResultPoint pointBs = Detector.shiftPoint(pointB, pointC, (tr + 1) * 4);
        ResultPoint pointCs = Detector.shiftPoint(pointC, pointB, (tr + 1) * 4);
        int trBA = this.transitionsBetween(pointBs, pointA);
        if (trBA < (trCD = this.transitionsBetween(pointCs, pointD))) {
            points[0] = pointA;
            points[1] = pointB;
            points[2] = pointC;
            points[3] = pointD;
        } else {
            points[0] = pointB;
            points[1] = pointC;
            points[2] = pointD;
            points[3] = pointA;
        }
        return points;
    }

    private ResultPoint correctTopRight(ResultPoint[] points) {
        int sumc2;
        ResultPoint pointA = points[0];
        ResultPoint pointB = points[1];
        ResultPoint pointC = points[2];
        ResultPoint pointD = points[3];
        int trTop = this.transitionsBetween(pointA, pointD);
        int trRight = this.transitionsBetween(pointB, pointD);
        ResultPoint pointAs = Detector.shiftPoint(pointA, pointB, (trRight + 1) * 4);
        ResultPoint pointCs = Detector.shiftPoint(pointC, pointB, (trTop + 1) * 4);
        trTop = this.transitionsBetween(pointAs, pointD);
        trRight = this.transitionsBetween(pointCs, pointD);
        ResultPoint candidate1 = new ResultPoint(pointD.getX() + (pointC.getX() - pointB.getX()) / (float)(trTop + 1), pointD.getY() + (pointC.getY() - pointB.getY()) / (float)(trTop + 1));
        ResultPoint candidate2 = new ResultPoint(pointD.getX() + (pointA.getX() - pointB.getX()) / (float)(trRight + 1), pointD.getY() + (pointA.getY() - pointB.getY()) / (float)(trRight + 1));
        if (!this.isValid(candidate1)) {
            if (this.isValid(candidate2)) {
                return candidate2;
            }
            return null;
        }
        if (!this.isValid(candidate2)) {
            return candidate1;
        }
        int sumc1 = this.transitionsBetween(pointAs, candidate1) + this.transitionsBetween(pointCs, candidate1);
        if (sumc1 > (sumc2 = this.transitionsBetween(pointAs, candidate2) + this.transitionsBetween(pointCs, candidate2))) {
            return candidate1;
        }
        return candidate2;
    }

    private ResultPoint[] shiftToModuleCenter(ResultPoint[] points) {
        ResultPoint pointA = points[0];
        ResultPoint pointB = points[1];
        ResultPoint pointC = points[2];
        ResultPoint pointD = points[3];
        int dimH = this.transitionsBetween(pointA, pointD) + 1;
        int dimV = this.transitionsBetween(pointC, pointD) + 1;
        ResultPoint pointAs = Detector.shiftPoint(pointA, pointB, dimV * 4);
        ResultPoint pointCs = Detector.shiftPoint(pointC, pointB, dimH * 4);
        dimH = this.transitionsBetween(pointAs, pointD) + 1;
        dimV = this.transitionsBetween(pointCs, pointD) + 1;
        if ((dimH & 1) == 1) {
            ++dimH;
        }
        if ((dimV & 1) == 1) {
            ++dimV;
        }
        float centerX = (pointA.getX() + pointB.getX() + pointC.getX() + pointD.getX()) / 4.0f;
        float centerY = (pointA.getY() + pointB.getY() + pointC.getY() + pointD.getY()) / 4.0f;
        pointA = Detector.moveAway(pointA, centerX, centerY);
        pointB = Detector.moveAway(pointB, centerX, centerY);
        pointC = Detector.moveAway(pointC, centerX, centerY);
        pointD = Detector.moveAway(pointD, centerX, centerY);
        pointAs = Detector.shiftPoint(pointA, pointB, dimV * 4);
        pointAs = Detector.shiftPoint(pointAs, pointD, dimH * 4);
        ResultPoint pointBs = Detector.shiftPoint(pointB, pointA, dimV * 4);
        pointBs = Detector.shiftPoint(pointBs, pointC, dimH * 4);
        pointCs = Detector.shiftPoint(pointC, pointD, dimV * 4);
        pointCs = Detector.shiftPoint(pointCs, pointB, dimH * 4);
        ResultPoint pointDs = Detector.shiftPoint(pointD, pointC, dimV * 4);
        pointDs = Detector.shiftPoint(pointDs, pointA, dimH * 4);
        return new ResultPoint[]{pointAs, pointBs, pointCs, pointDs};
    }

    private boolean isValid(ResultPoint p) {
        return p.getX() >= 0.0f && p.getX() < (float)this.image.getWidth() && p.getY() > 0.0f && p.getY() < (float)this.image.getHeight();
    }

    private int transitionsBetween(ResultPoint from, ResultPoint to) {
        boolean steep;
        int fromX = (int)from.getX();
        int fromY = (int)from.getY();
        int toX = (int)to.getX();
        int toY = (int)to.getY();
        boolean bl = steep = Math.abs(toY - fromY) > Math.abs(toX - fromX);
        if (steep) {
            int temp = fromX;
            fromX = fromY;
            fromY = temp;
            temp = toX;
            toX = toY;
            toY = temp;
        }
        int dx = Math.abs(toX - fromX);
        int dy = Math.abs(toY - fromY);
        int error = -dx / 2;
        int ystep = fromY < toY ? 1 : -1;
        int xstep = fromX < toX ? 1 : -1;
        int transitions = 0;
        boolean inBlack = this.image.get(steep ? fromY : fromX, steep ? fromX : fromY);
        int y = fromY;
        for (int x = fromX; x != toX; x += xstep) {
            boolean isBlack = this.image.get(steep ? y : x, steep ? x : y);
            if (isBlack != inBlack) {
                ++transitions;
                inBlack = isBlack;
            }
            if ((error += dy) <= 0) continue;
            if (y == toY) break;
            y += ystep;
            error -= dx;
        }
        return transitions;
    }
}

