/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util.codigobarras;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.excecoes.ExcecaoCodigoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoDigitoInvalido;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.codigobarras.CalculadorDigito;

public class CodigoBarrasUtil {
    public static final int CONVENIO_MODULO_11_VALOR_REAL = 8;
    public static final int CONVENIO_MODULO_11_VALOR_REFERENCIA = 9;
    public static final int VALIDAR_TITULO = 1;
    public static final int VALIDAR_CONVENIO = 2;
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CodigoBarrasUtil.class);

    public static void validaBlocoParcialConvenio(String codigo, int numeroBloco) throws ExcecaoDigitoInvalido {
        String digitoCalculado;
        logger.debug("validaBlocoParcialConvenio: codigo: {}, numeroBloco: {}", codigo, numeroBloco);
        if (codigo == null || codigo.trim().length() == 0) {
            throw new ExcecaoDigitoInvalido();
        }
        if (numeroBloco < 1) {
            throw new IllegalArgumentException();
        }
        int posInicio = (numeroBloco - 1) * 12;
        String bloco = codigo.substring(posInicio, posInicio + 12);
        String digito = bloco.substring(bloco.length() - 1);
        logger.debug("validaBlocoParcialConvenio: posInicio: {}, bloco: {}, digito: {}", posInicio, bloco, digito);
        try {
            int indicadorModulo = CodigoBarrasUtil.capturaIndicativoValidacao(codigo);
            logger.debug("validaBlocoParcialConvenio: indicadorModulo: {}", indicadorModulo);
            digitoCalculado = indicadorModulo == 8 || indicadorModulo == 9 ? CalculadorDigito.calculaDigitoModulo11Bloco(bloco.substring(0, bloco.length() - 1), 2) : CalculadorDigito.calculaDigitoModulo10(bloco.substring(0, bloco.length() - 1));
            logger.debug("validaBlocoParcialConvenio: digitoCalculado: {}", digitoCalculado);
        }
        catch (ExcecaoCodigoInvalido e) {
            throw new ExcecaoDigitoInvalido(e.getMessage());
        }
        logger.debug("validaBlocoParcialConvenio: digito: {}, digitoCalculado: {}", digito, digitoCalculado);
        if (!digito.equals(digitoCalculado)) {
            throw new ExcecaoDigitoInvalido();
        }
    }

    public static void validaBlocoParcialTituloDigitavel(String linhaDigitavel, int numeroBloco) throws ExcecaoCodigoInvalido {
        logger.trace("validaBlocoParcialTituloDigitavel: INICIO");
        if (numeroBloco < 1) {
            throw new IllegalArgumentException();
        }
        String campo1 = linhaDigitavel.substring(0, 9);
        String campo2 = null;
        String campo3 = null;
        String campo4 = null;
        String digitoVerificadorGeral = null;
        if (numeroBloco >= 2) {
            campo2 = linhaDigitavel.substring(10, 20);
            if (numeroBloco >= 3) {
                campo3 = linhaDigitavel.substring(21, 31);
                if (numeroBloco >= 4) {
                    campo4 = linhaDigitavel.substring(33);
                    if (numeroBloco == 5) {
                        digitoVerificadorGeral = linhaDigitavel.substring(32, 33);
                    }
                }
            }
        }
        boolean codigoInvalido = false;
        switch (numeroBloco) {
            case 1: {
                if (!linhaDigitavel.substring(9, 10).equals(CalculadorDigito.calculaDigitoModulo10(campo1))) {
                    codigoInvalido = true;
                }
                logger.debug("validaBlocoParcialTituloDigitavel: numeroBloco: {}, campo: {}, codigoInvalido: {}", numeroBloco, campo1, codigoInvalido);
                break;
            }
            case 2: {
                if (!linhaDigitavel.substring(20, 21).equals(CalculadorDigito.calculaDigitoModulo10(campo2))) {
                    codigoInvalido = true;
                }
                logger.debug("validaBlocoParcialTituloDigitavel: numeroBloco: {}, campo: {}, codigoInvalido: {}", numeroBloco, campo2, codigoInvalido);
                break;
            }
            case 3: {
                if (!linhaDigitavel.substring(31, 32).equals(CalculadorDigito.calculaDigitoModulo10(campo3))) {
                    codigoInvalido = true;
                }
                logger.debug("validaBlocoParcialTituloDigitavel: numeroBloco: {}, campo: {}, codigoInvalido: {}", numeroBloco, campo3, codigoInvalido);
                break;
            }
            case 4: {
                logger.debug("validaBlocoParcialTituloDigitavel: numeroBloco: {}, campo: {}, codigoInvalido: {}", numeroBloco, campo4, false);
                break;
            }
            case 5: {
                String codigoBarras = "";
                codigoBarras = codigoBarras + campo1.substring(0, 4);
                codigoBarras = codigoBarras + campo4;
                codigoBarras = codigoBarras + linhaDigitavel.substring(4, campo1.length());
                codigoBarras = codigoBarras + campo2;
                codigoBarras = codigoBarras + campo3;
                String digitoBarras = CalculadorDigito.calculaDigitoModulo11Bloco(codigoBarras, 1);
                if (!digitoBarras.equals(digitoVerificadorGeral)) {
                    codigoInvalido = true;
                }
                logger.debug("validaBlocoParcialTituloDigitavel: numeroBloco: {}, digitoBarras: {}, digitoVerificadorGeral: {}, codigoInvalido: {}", numeroBloco, digitoBarras, digitoVerificadorGeral, codigoInvalido);
                break;
            }
            default: {
                throw new IllegalArgumentException("N\u00famero de bloco n\u00e3o esperado");
            }
        }
        if (codigoInvalido) {
            throw new ExcecaoCodigoInvalido();
        }
        logger.trace("validaBlocoParcialTituloDigitavel: FIM");
    }

    public static String formataLinhaDigitavelTitulo(String linhaDigitavel) {
        logger.trace("formataLinhaDigitavelTitulo: INICIO");
        if (linhaDigitavel == null || linhaDigitavel.length() < 33) {
            throw new IllegalArgumentException("Linha digit\u00e1vel inv\u00e1lida: " + linhaDigitavel);
        }
        String campo1 = linhaDigitavel.substring(0, 10);
        String campo2 = linhaDigitavel.substring(10, 21);
        String campo3 = linhaDigitavel.substring(21, 32);
        String digitoVerificadorGeral = linhaDigitavel.substring(32, 33);
        String campo4 = linhaDigitavel.substring(33);
        campo4 = StringUtil.completaString(campo4, 14, '0', 3);
        String numDoc = campo1 + campo2 + campo3 + digitoVerificadorGeral + campo4;
        logger.debug("formataLinhaDigitavelTitulo: codigo convertido: {}", numDoc);
        logger.trace("formataLinhaDigitavelTitulo: FIM");
        return numDoc;
    }

    public static String converteLinhaDigitavelTitulo(String codigo) {
        logger.trace("converteLinhaDigitavelTitulo: INICIO");
        if (codigo == null || codigo.length() < 47) {
            throw new IllegalArgumentException("Linha digit\u00e1vel do t\u00edtulo inv\u00e1lida");
        }
        String numDoc = codigo.substring(0, 4) + codigo.charAt(32) + codigo.substring(33, 47) + codigo.substring(4, 9) + codigo.substring(10, 20) + codigo.substring(21, 31);
        logger.debug("converteLinhaDigitavelTitulo: codigo convertido: {}", numDoc);
        logger.trace("converteLinhaDigitavelTitulo: FIM");
        return numDoc;
    }

    public static String converteLinhaDigitavelConvenio(String codigo) {
        logger.trace("converteLinhaDigitavelConvenio: INICIO");
        if (codigo == null || codigo.length() < 48) {
            throw new IllegalArgumentException("Linha digit\u00e1vel do conv\u00eanio inv\u00e1lida");
        }
        StringBuilder numDoc = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            numDoc.append(codigo, i * 12, i * 12 + 11);
        }
        logger.debug("converteLinhaDigitavelConvenio: codigo convertido: {}", numDoc);
        logger.trace("converteLinhaDigitavelConvenio: FIM");
        return numDoc.toString();
    }

    public static int identificaTipoConta(String codigo) {
        if (codigo.length() < 3) {
            throw new IllegalArgumentException("Tamanho do c\u00f3digo de barras inv\u00e1lido");
        }
        int primeirosDigitos = Integer.parseInt(codigo.substring(0, 3));
        if (primeirosDigitos < 810) {
            return 1;
        }
        return 2;
    }

    public static String converteCodigoBarrasConvenio(String codigo) {
        logger.trace("converteCodigoBarrasConvenio: INICIO");
        if (codigo == null || codigo.length() != 44) {
            throw new IllegalArgumentException("C\u00f3digo de barras do conv\u00eanio inv\u00e1lido");
        }
        StringBuilder linhaDigitavel = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            String digitoCalculado;
            int pos = i * 11;
            String bloco = codigo.substring(pos, pos + 11);
            try {
                digitoCalculado = CalculadorDigito.calculaDigitoModulo10(bloco);
            }
            catch (ExcecaoCodigoInvalido e) {
                throw new IllegalArgumentException("C\u00f3digo de barras inv\u00e1lido");
            }
            linhaDigitavel.append(bloco).append(digitoCalculado);
        }
        logger.debug("converteCodigoBarrasConvenio: codigo convertido: {}", linhaDigitavel);
        logger.trace("converteCodigoBarrasConvenio: FIM");
        return linhaDigitavel.toString();
    }

    public static String converteCodigoBarrasTitulo(String codigo) {
        String numDoc;
        logger.trace("converteCodigoBarrasTitulo: INICIO");
        if (codigo == null || codigo.length() != 44) {
            throw new IllegalArgumentException("C\u00f3digo de barras do t\u00edtulo inv\u00e1lido");
        }
        try {
            String bloco1 = codigo.substring(0, 4) + codigo.substring(19, 24);
            String dv1 = CalculadorDigito.calculaDigitoModulo10(bloco1);
            String bloco2 = codigo.substring(24, 34);
            String dv2 = CalculadorDigito.calculaDigitoModulo10(bloco2);
            String bloco3 = codigo.substring(34, 44);
            String dv3 = CalculadorDigito.calculaDigitoModulo10(bloco3);
            String dvGeral = codigo.substring(4, 5);
            String campoVariavel = codigo.substring(5, 9) + codigo.substring(9, 19);
            numDoc = bloco1 + dv1 + bloco2 + dv2 + bloco3 + dv3 + dvGeral + campoVariavel;
        }
        catch (ExcecaoCodigoInvalido e) {
            throw new IllegalArgumentException();
        }
        logger.debug("converteCodigoBarrasTitulo: codigo convertido: {}", numDoc);
        logger.trace("converteCodigoBarrasTitulo: FIM");
        return numDoc;
    }

    public static int capturaIndicativoValidacao(String codigo) {
        return Integer.parseInt(codigo.substring(2, 3));
    }
}

