/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util.codigobarras;

import com.csi.ctfclient.excecoes.ExcecaoCodigoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoDigitoInvalido;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.codigobarras.Codigo;

public class CodGeral
extends Codigo {
    private static final long serialVersionUID = 5942982975780897863L;

    public CodGeral(String codigo) throws ExcecaoDigitoInvalido, ExcecaoCodigoInvalido {
        super(codigo);
        this.setCodigo(codigo);
        this.setDigitoVerificador();
    }

    public String calculaDigito(String codigo) {
        if ((codigo = StringUtil.completaString(codigo.trim(), 10, '0', true)).length() != 10) {
            return null;
        }
        int[] digs = new int[10];
        for (int i = 0; i < 10; ++i) {
            digs[i] = codigo.charAt(i) - 48;
        }
        int total = 0;
        total += 2 * digs[9] + 3 * digs[8] + 4 * digs[7] + 5 * digs[6] + 6 * digs[5];
        total += 7 * digs[4] + 8 * digs[3] + 9 * digs[2] + 2 * digs[1] + 3 * digs[0];
        int dig = (total *= 10) % 11;
        if (dig == 0) {
            dig = 1;
        }
        if (dig == 10) {
            dig = 0;
        }
        return new Integer(dig).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CodGeral) {
            return super.equals(obj);
        }
        return false;
    }

    @Override
    protected void setCodigo(String codigo) throws ExcecaoCodigoInvalido {
        int i = 0;
        codigo = codigo.trim();
        while (codigo.charAt(i) == '0') {
            ++i;
        }
        super.setCodigo(codigo.substring(i));
    }

    protected void setDigitoVerificador() throws ExcecaoDigitoInvalido {
        String digito = this.calculaDigito(this.codigo);
        if (digito == null || digito.equals("")) {
            throw new ExcecaoDigitoInvalido();
        }
        super.setDigitoVerificador(digito);
    }

    @Override
    protected void setDigitoVerificador(String digito) throws ExcecaoDigitoInvalido {
        super.setDigitoVerificador(digito);
    }

    @Override
    public void touch() {
    }

    @Override
    protected boolean validaDigito() {
        String cod = StringUtil.completaString(this.codigo, 10, '0', true);
        if (cod.length() != 10 || this.digitoVerificador.length() != 1) {
            return false;
        }
        return this.digitoVerificador.equals("" + this.calculaDigito(cod));
    }
}

