/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import com.csi.ctfclient.tools.util.CSIBigDecimal;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public final class StringUtil {
    public static final int TRUNCAMENTO = 1;
    public static final int ARREDONDA = 2;
    public static final int ESQUERDA = 3;
    public static final int DIREITA = 4;
    private static final String DEFAULT_SEPARATOR = ",";
    public static final String REGEX_NUMERICO = "[0-9]";

    private StringUtil() {
    }

    public static String allTrim(String str) {
        return str.trim();
    }

    public static byte[] asciiToByteArray(String str) {
        char[] aux = str.toCharArray();
        byte[] result = new byte[aux.length];
        for (int i = 0; i < aux.length; ++i) {
            result[i] = (byte)aux[i];
        }
        return result;
    }

    public static String byteArrayToSpacedHexStr(byte[] in) {
        StringBuilder sb = new StringBuilder();
        for (byte b : in) {
            sb.append(String.format("%02X ", b));
        }
        return sb.toString().trim();
    }

    public static String byteArrayToHexString(byte[] in) {
        if (in == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : in) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    public static String charArrayToHexString(char[] in) {
        StringBuilder sb = new StringBuilder();
        if (in != null && in.length != 0) {
            for (char b : in) {
                sb.append(String.format("%02X", (byte)b));
            }
        }
        return sb.toString();
    }

    public static String StringArrayToHexString(String in) {
        StringBuilder sb = new StringBuilder();
        if (in != null && in.length() != 0) {
            for (char b : in.toCharArray()) {
                sb.append(String.format("%02X", (byte)b));
            }
        }
        return sb.toString();
    }

    public static char[] byteArrayToCharArray(byte[] in) {
        try {
            return new String(in, "ISO-8859-1").toCharArray();
        }
        catch (Exception e) {
            return new char[0];
        }
    }

    public static byte[] stringToByteArray(String in) {
        try {
            return in.getBytes("ISO-8859-1");
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static String nibbleToHexString(byte[] in) {
        StringBuilder sb = new StringBuilder();
        for (int ct = 0; ct < in.length; ++ct) {
            sb.append(String.format("%02X", in[ct]));
        }
        String ret = sb.toString();
        ret = ret.replace('A', ':');
        ret = ret.replace('B', ';');
        ret = ret.replace('C', '<');
        ret = ret.replace('D', '=');
        ret = ret.replace('E', '>');
        ret = ret.replace('F', '?');
        return ret;
    }

    public static byte[] hexStringToNibble(String in) {
        int len = in.length();
        if (len % 2 != 0) {
            in = in + '?';
            ++len;
        }
        byte[] data = new byte[len / 2];
        in = in.replace(':', 'A');
        in = in.replace(';', 'B');
        in = in.replace('<', 'C');
        in = in.replace('=', 'D');
        in = in.replace('>', 'E');
        in = in.replace('?', 'F');
        for (int ct = 0; ct < len; ct += 2) {
            data[ct / 2] = (byte)((Character.digit(in.charAt(ct), 16) << 4) + Character.digit(in.charAt(ct + 1), 16));
        }
        return data;
    }

    public static String centraliza(String str, int tamanho) {
        int falta = tamanho - str.length();
        if (falta >= 0) {
            if (falta % 2 == 1) {
                str = str + " ";
                --falta;
            }
            while (falta > 0) {
                str = " " + str + " ";
                falta -= 2;
            }
        }
        return str;
    }

    public static String completaString(String texto, int tamanho, char complemento, int lado) {
        return StringUtil.completaString(texto, tamanho, complemento, lado == 3);
    }

    public static String completaString(String texto, int tamanho, char complemento, boolean esquerda) {
        while (texto.length() < tamanho) {
            if (esquerda) {
                texto = complemento + texto;
                continue;
            }
            texto = texto + complemento;
        }
        return texto;
    }

    public static String padMiddle(String left, String right, int totalLength, char filler, int minFillerLength) {
        if (minFillerLength < 0) {
            throw new IllegalArgumentException("Tamanho m\u00ednimo de preenchimento deve ser maior ou igual a zero");
        }
        int padding = totalLength - left.length() - right.length();
        if (padding < 0) {
            throw new IllegalArgumentException("Tamanho inv\u00e1lido de strings para preenchimento central");
        }
        if (padding < minFillerLength) {
            throw new IllegalArgumentException(String.format("Tamanho de preenchimento menor que o m\u00ednimo (padding=%d, min=%d)", padding, minFillerLength));
        }
        return left + StringUtils.repeat(filler, padding) + right;
    }

    public static String copia(char caractere, int quantidade) {
        char[] c = new char[quantidade];
        for (int i = 0; i < quantidade; ++i) {
            c[i] = caractere;
        }
        return new String(c);
    }

    public static String copia(String str, int quantidade) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < quantidade; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static int count(char c, String s) {
        int retorno = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++retorno;
        }
        return retorno;
    }

    public static String duplicaChar(char caracter, String texto) {
        int i = 0;
        while (i < texto.length()) {
            if (texto.charAt(i++) != caracter) continue;
            texto = i != texto.length() ? texto.substring(0, i) + texto.substring(i - 1) : texto + caracter;
            ++i;
        }
        return texto;
    }

    public static String lTrim(String str) {
        int i;
        String result = "";
        for (i = 0; i < str.length() && Character.isWhitespace(str.charAt(i)); ++i) {
        }
        while (i < str.length()) {
            result = result + str.charAt(i);
            ++i;
        }
        return result;
    }

    public static String numeroToString(int numero, int decimais, int tamanho, String separadorDecimal, String separadorMilhares, int modoTruncamento) {
        return StringUtil.numeroToString(numero, decimais, tamanho, separadorDecimal, separadorMilhares, modoTruncamento == 1);
    }

    public static String numeroToString(int numero, int decimais, int tamanho, String separadorDecimal, String separadorMilhares, boolean truncar) {
        boolean negativo;
        long multiplicador = 1L;
        boolean bl = negativo = (double)numero < 0.0;
        if (negativo) {
            numero = -numero;
        }
        for (int i = 0; i < decimais; ++i) {
            multiplicador *= 10L;
        }
        numero = (int)((long)numero * multiplicador);
        long num = truncar ? Math.round(Math.floor(numero)) : (long)Math.round(numero);
        long frac = num % multiplicador;
        String strFrac = StringUtil.completaString("" + frac, decimais, '0', 3);
        if (strFrac.length() > decimais) {
            strFrac = strFrac.substring(0, decimais);
        }
        num /= multiplicador;
        String result = "";
        int tamMilhar = 3 + separadorMilhares.length();
        do {
            String auxMilhar = num % 1000L + separadorMilhares;
            if (num >= 1000L) {
                while (auxMilhar.length() < tamMilhar) {
                    auxMilhar = "0" + auxMilhar;
                }
            }
            result = auxMilhar + result;
        } while ((num /= 1000L) > 0L);
        result = result.substring(0, result.length() - separadorMilhares.length());
        result = result + separadorDecimal + strFrac;
        result = StringUtil.completaString(result, negativo ? tamanho - 1 : tamanho, '0', 3);
        if (negativo) {
            result = "-" + result;
        }
        return result;
    }

    public static String numeroToString(CSIBigDecimal numero, int decimais, int tamanho, String separadorDecimal, String separadorMilhares, int modoTruncamento) {
        return StringUtil.numeroToString(numero, decimais, tamanho, separadorDecimal, separadorMilhares, modoTruncamento == 1);
    }

    public static String numeroToString(CSIBigDecimal numero, int decimais, int tamanho, String separadorDecimal, String separadorMilhares, boolean truncar) {
        long multiplicador = 1L;
        boolean negativo = numero.lesser(CSIBigDecimal.getZero());
        if (negativo) {
            numero = numero.negative();
        }
        for (int i = 0; i < decimais; ++i) {
            multiplicador *= 10L;
        }
        long num = truncar ? numero.movePointRight(decimais).longValue() : numero.setScale(decimais, 4).movePointRight(decimais).longValue();
        long frac = num % multiplicador;
        String strFrac = StringUtil.completaString("" + frac, decimais, '0', 3);
        if (strFrac.length() > decimais) {
            strFrac = strFrac.substring(0, decimais);
        }
        num /= multiplicador;
        String result = "";
        int tamMilhar = 3 + separadorMilhares.length();
        do {
            String auxMilhar = num % 1000L + separadorMilhares;
            if (num >= 1000L) {
                while (auxMilhar.length() < tamMilhar) {
                    auxMilhar = "0" + auxMilhar;
                }
            }
            result = auxMilhar + result;
        } while ((num /= 1000L) > 0L);
        result = result.substring(0, result.length() - separadorMilhares.length());
        result = result + separadorDecimal + strFrac;
        result = StringUtil.completaString(result, negativo ? tamanho - 1 : tamanho, '0', 3);
        if (negativo) {
            result = "-" + result;
        }
        return result;
    }

    public static String removeChar(String str, char ch) {
        String aux = str;
        int iaux = aux.indexOf("" + ch);
        while (iaux != -1) {
            aux = aux.substring(0, iaux) + aux.substring(iaux + 1);
            iaux = aux.indexOf("" + ch);
        }
        return aux;
    }

    public static String reverse(String str) {
        return new StringBuffer(str).reverse().toString();
    }

    public static String rTrim(String str) {
        String result = str;
        int tam = result.length();
        if (tam > 0) {
            while (Character.isWhitespace(result.charAt(tam - 1))) {
                result = result.substring(0, tam - 1);
                --tam;
            }
        }
        return result;
    }

    public static String sprintf(String texto, Object[] args) {
        StringBuffer sb = new StringBuffer();
        int arg = 0;
        int i = 0;
        while (i < texto.length()) {
            char c = texto.charAt(i);
            if (c != '%') {
                sb.append(c);
                ++i;
            } else if (texto.charAt(i + 1) == '%') {
                sb.append('%');
                ++i;
            } else {
                int num;
                char aux;
                boolean flagPlus = false;
                boolean flagMinus = false;
                int width = -1;
                boolean flagZeroEsquerda = false;
                int precision = -1;
                int type = 32;
                if ((aux = texto.charAt(++i)) == '+') {
                    flagPlus = true;
                    aux = texto.charAt(++i);
                } else if (aux == '-') {
                    flagMinus = true;
                    aux = texto.charAt(++i);
                }
                if (Character.isDigit(aux)) {
                    num = 0;
                    if (aux == '0') {
                        flagZeroEsquerda = true;
                    }
                    while (Character.isDigit(aux)) {
                        num = 10 * num + aux - 48;
                        aux = texto.charAt(++i);
                    }
                    width = num;
                }
                if (aux == '*') {
                    width = (Integer)args[arg++];
                    aux = texto.charAt(++i);
                }
                if (aux == '.') {
                    if ((aux = texto.charAt(++i)) == '*') {
                        precision = (Integer)args[arg++];
                        aux = texto.charAt(++i);
                    } else if (Character.isDigit(aux)) {
                        num = 0;
                        while (Character.isDigit(aux)) {
                            num = 10 * num + aux - 48;
                            aux = texto.charAt(++i);
                        }
                        precision = num;
                    } else {
                        precision = 0;
                    }
                }
                if (aux == 'l' || aux == 'L') {
                    aux = texto.charAt(++i);
                }
                type = aux;
                ++i;
                switch (type) {
                    case 100: {
                        boolean negativo;
                        long num2;
                        try {
                            num2 = ((Number)args[arg]).longValue();
                        }
                        catch (ClassCastException e) {
                            num2 = ((CSIBigDecimal)args[arg]).longValue();
                        }
                        ++arg;
                        if (precision == -1) {
                            precision = 1;
                        }
                        if (num2 == 0L && precision == 0) break;
                        boolean bl = negativo = num2 < 0L;
                        if (negativo) {
                            num2 = -num2;
                        }
                        String sinal = negativo ? "-" : (flagPlus ? "+" : "");
                        String str = "" + num2;
                        while (str.length() < precision) {
                            str = "0" + str;
                        }
                        width -= sinal.length();
                        while (str.length() < width) {
                            if (flagMinus) {
                                str = str + " ";
                                continue;
                            }
                            if (flagZeroEsquerda) {
                                str = "0" + str;
                                continue;
                            }
                            str = " " + str;
                        }
                        str = sinal + str;
                        sb.append(str);
                        break;
                    }
                    case 102: {
                        int j;
                        boolean negativo;
                        double num3;
                        try {
                            num3 = ((Number)args[arg]).doubleValue();
                        }
                        catch (ClassCastException e) {
                            num3 = ((CSIBigDecimal)args[arg]).doubleValue();
                        }
                        ++arg;
                        if (precision == -1) {
                            precision = 6;
                        }
                        boolean bl = negativo = num3 < 0.0;
                        if (negativo) {
                            num3 = -num3;
                        }
                        String sinal = negativo ? "-" : (flagPlus ? "+" : "");
                        for (j = 0; j < precision; ++j) {
                            num3 *= 10.0;
                        }
                        num3 += 0.5;
                        for (j = 0; j < precision; ++j) {
                            num3 /= 10.0;
                        }
                        String str = "" + Math.round(Math.floor(num3));
                        if (precision != 0) {
                            str = str + ".";
                            double dAux = num3 - Math.floor(num3);
                            for (int j2 = 0; j2 < precision; ++j2) {
                                long n = Math.round(Math.floor(dAux *= 10.0));
                                str = str + n;
                                dAux -= (double)n;
                            }
                        }
                        width -= sinal.length();
                        while (str.length() < width) {
                            if (flagMinus) {
                                str = str + " ";
                                continue;
                            }
                            if (flagZeroEsquerda) {
                                str = "0" + str;
                                continue;
                            }
                            str = " " + str;
                        }
                        str = sinal + str;
                        sb.append(str);
                        break;
                    }
                    case 115: {
                        String str = (String)args[arg++];
                        if (precision != -1 && str.length() > precision) {
                            str = str.substring(0, precision);
                        }
                        while (str.length() < width) {
                            if (flagMinus) {
                                str = str + " ";
                                continue;
                            }
                            str = " " + str;
                        }
                        sb.append(str);
                        break;
                    }
                    case 88: 
                    case 120: {
                        String str;
                        boolean flagMaiusc = type == 88;
                        int letraBase = flagMaiusc ? 65 : 97;
                        int num4 = (Integer)args[arg++];
                        if (precision == -1) {
                            precision = 1;
                        }
                        if (num4 == 0 && precision == 0 || num4 < 0) break;
                        String string = str = num4 == 0 ? "0" : "";
                        while (num4 > 0) {
                            int n16 = num4 % 16;
                            str = n16 < 10 ? n16 + str : (char)(letraBase + n16 - 10) + str;
                            num4 /= 16;
                        }
                        while (str.length() < precision) {
                            str = "0" + str;
                        }
                        while (str.length() < width) {
                            if (flagMinus) {
                                str = str + " ";
                                continue;
                            }
                            str = (flagZeroEsquerda ? "0" : " ") + str;
                        }
                        sb.append(str);
                        break;
                    }
                    case 99: {
                        char caractere;
                        Object obj = args[arg++];
                        if (obj instanceof Character) {
                            caractere = ((Character)obj).charValue();
                        } else {
                            try {
                                caractere = (char)((Number)obj).intValue();
                            }
                            catch (ClassCastException e) {
                                caractere = (char)((CSIBigDecimal)obj).intValue();
                            }
                        }
                        sb.append(caractere);
                        break;
                    }
                }
            }
        }
        return sb.toString();
    }

    public static String trocaChar(String str, char antigo, char novo) {
        StringBuffer sb = new StringBuffer(str);
        for (int i = 0; i < str.length(); ++i) {
            if (sb.charAt(i) != antigo) continue;
            sb.setCharAt(i, novo);
        }
        return sb.toString();
    }

    public static String zerosEsquerda(String str) {
        BigInteger i = new BigInteger(str);
        return i.toString();
    }

    public static String completeNumberZERO(long numOri, int tam) {
        String strOri = String.valueOf(numOri);
        return StringUtil.wrappedCompleteChar(strOri, tam, '0', true);
    }

    public static String completeStringCHAR(String strOri, int tam) {
        if (strOri != null) {
            return StringUtil.wrappedCompleteChar(strOri, tam, ' ', false);
        }
        return StringUtil.wrappedCompleteChar("null", tam, ' ', false);
    }

    public static String completeStringZERO(String strOri, int tam) {
        if (strOri != null) {
            return StringUtil.wrappedCompleteChar(strOri, tam, '0', true);
        }
        return StringUtil.wrappedCompleteChar("null", tam, '0', true);
    }

    public static String csiBigDecToString(CSIBigDecimal number, int total, int dec) {
        if (number != null) {
            if (total > dec) {
                StringTokenizer st = new StringTokenizer(number.toString(), ".");
                String parteInteira = st.nextToken();
                String parteDecimal = "";
                while (st.hasMoreTokens()) {
                    int pdLength = (parteDecimal = st.nextToken()).length();
                    parteDecimal = parteDecimal.substring(0, pdLength >= dec ? dec : pdLength);
                }
                parteDecimal = StringUtil.completaString(parteDecimal, dec, '0', false);
                int tamInteira = total - dec;
                parteInteira = parteInteira.length() <= tamInteira ? StringUtil.completaString(parteInteira, tamInteira, '0', true) : parteInteira.substring(0, tamInteira);
                return parteInteira + "." + parteDecimal;
            }
            return "";
        }
        return "null";
    }

    private static String wrappedCompleteChar(String strOri, int tam, char cs, boolean left) {
        return strOri.length() < tam ? StringUtil.completaString(strOri, tam, cs, left) : strOri.substring(0, tam);
    }

    public static String toString(String[] args) {
        return StringUtil.toString(args, DEFAULT_SEPARATOR);
    }

    public static String toString(String[] args, String separator) {
        if (args != null && args.length > 0) {
            String value = "";
            for (int i = 0; i < args.length; ++i) {
                value = value + args[i];
                if (i >= args.length - 1) continue;
                value = value + separator;
            }
            return value;
        }
        return "";
    }

    public static String[] splitPorTamanho(String buffer, int tamanho) {
        if (buffer != null && buffer.length() >= tamanho && buffer.length() % tamanho == 0) {
            int total = buffer.length() / tamanho;
            String[] valores = new String[total];
            int offSet = 0;
            for (int i = 0; i < total; ++i) {
                String valor = buffer.substring(offSet, offSet + tamanho);
                offSet += tamanho;
                valores[i] = valor;
            }
            return valores;
        }
        return null;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static String getMessage(String clas, String exception) {
        return StringUtil.toString(new String[]{clas, exception});
    }

    public static String bareClassName(String fullName) {
        int i = fullName.lastIndexOf(46);
        if (i >= 0 && i < fullName.length() - 1) {
            fullName = fullName.substring(i + 1);
        }
        return fullName;
    }

    public static String bareClassName(Class<?> clazz) {
        return StringUtil.bareClassName(clazz.getName());
    }

    public static String objectToString(Object obj) {
        if (obj == null) {
            return "{\n\t<null>\n}\n";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("{\n");
        try {
            Field[] fields;
            for (Field f : fields = obj.getClass().getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                f.setAccessible(true);
                Object value = f.get(obj);
                String str = String.format("\t(%s) %s = |%s|\n", StringUtil.bareClassName(f.getType().getName()), f.getName(), value == null ? "null" : value.toString());
                buffer.append(str);
            }
        }
        catch (Throwable t) {
            buffer.append(String.format("\t<error '%s'>\n", t.getMessage()));
        }
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String retornaStringDigitada(String valor, int numeroCaractaresDigitados) {
        if (StringUtils.isNotBlank(valor)) {
            return valor.substring(valor.length() - numeroCaractaresDigitados);
        }
        return "";
    }
}

