/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.IdentTerminal;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;

public class PersistService {
    private static PersistService persistService;
    private static String PATH_APP;
    private static int VERSAO_PATH_TERMINAL;
    private final String PERSISTENCE_FOLDER = "dat";
    private static final AuttarLogger logger;

    private PersistService() {
    }

    public static PersistService getInstance() {
        if (persistService == null) {
            persistService = new PersistService();
        }
        return persistService;
    }

    public static void setPathApp(String path, int versaoPathTerminal) {
        logger.debug("setPathApp: PathApp: {} VersaoPathTerminal: {}", path, versaoPathTerminal);
        PATH_APP = path;
        VERSAO_PATH_TERMINAL = versaoPathTerminal;
    }

    private String formatPath(IdentTerminal identTerminal) {
        logger.trace("formatPath: Inicio");
        logger.trace("formatPath: identTerminal: " + identTerminal);
        int idxEmpresa = VERSAO_PATH_TERMINAL == 1 ? 0 : 1;
        logger.debug("formatPath: idxEmpresa: " + idxEmpresa);
        logger.debug("formatPath: PathApp: " + PATH_APP);
        String path = PATH_APP == null ? "./" + identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal() + "/" : PATH_APP + identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal() + "/";
        logger.debug("formatPath: PathFormado: " + path.concat("dat").concat("/"));
        logger.trace("formatPath: Fim");
        return path + "dat" + "/";
    }

    private String formatName(String name, IdentTerminal identTerminal) {
        logger.debug("formatName: name: {} IdentTerminal: {} ", name, identTerminal);
        return this.formatPath(identTerminal) + name + ".dat";
    }

    public boolean exists(String key, IdentTerminal identTerminal) {
        logger.trace("exists");
        String name = this.formatName(key, identTerminal);
        File file = new File(name);
        return file.exists();
    }

    public void save(String key, Object obj, IdentTerminal identTerminal) throws ExcecaoApiAc {
        logger.trace("save: Inicio");
        logger.debug("save: key: {} Obj: {} IdentTerminal: {} ", key, obj, identTerminal);
        String path = this.formatName(key, identTerminal);
        this.createPath(path);
        try {
            RandomAccessFile raf = new RandomAccessFile(path, "rwd");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(bos);
            output.writeObject(obj);
            byte[] buffer = bos.toByteArray();
            raf.write(buffer);
            output.close();
            bos.close();
            raf.close();
            logger.trace("save: Fim");
        }
        catch (Exception e) {
            logger.error("n\u00e3o foi poss\u00edvel gravar o arquivo de controle " + key + ".dat para o terminal " + identTerminal);
            throw new ExcecaoApiAc("PS01", "Erro ao gravar arquivo de persistencia", e.getMessage());
        }
    }

    public Object load(String key, IdentTerminal identTerminal) throws ExcecaoApiAc {
        Object obj;
        logger.trace("load: Inicio");
        logger.debug("load: key {} IdentTerminal {}", key, identTerminal);
        String name = this.formatName(key, identTerminal);
        try {
            ObjectInputStream input;
            FileInputStream fileInput = null;
            try {
                fileInput = new FileInputStream(name);
                input = new ObjectInputStream(fileInput);
            }
            catch (StreamCorruptedException e) {
                logger.error("o arquivo " + key + ".dat para o terminal " + identTerminal + " est\u00e1 corrompido e ser\u00e1 deletado.");
                fileInput.close();
                File file = new File(name);
                if (file.exists()) {
                    logger.info(key + ".dat deletado para o terminal " + identTerminal + " " + file.delete());
                }
                throw new ExcecaoApiAc("PS02", "Erro ao carregar arquivo de persistencia (arquivo corrompido)", e.getMessage());
            }
            try {
                obj = input.readObject();
                logger.debug("arquivo de controle " + key + ".dat carregado para terminal " + identTerminal);
            }
            catch (ClassNotFoundException e) {
                input.close();
                fileInput.close();
                throw new ExcecaoApiAc("PS03", "Erro de classe nao encontrada na carga da CMOS do terminal " + identTerminal, e.getMessage());
            }
            input.close();
            fileInput.close();
        }
        catch (IOException e) {
            throw new ExcecaoApiAc("PS04", "Erro de leitura na classe do CMOS: ", "ERRO_FILE", e);
        }
        logger.debug("load: obj: " + obj);
        logger.trace("load: Inicio");
        return obj;
    }

    public Collection<Object> loadAll(IdentTerminal identTerminal) throws ExcecaoApiAc {
        logger.trace("loadAll: Inicio");
        ArrayList<Object> list = null;
        File file = new File(this.formatPath(identTerminal));
        if (file.exists()) {
            list = new ArrayList<Object>();
            File[] files = file.listFiles();
            int qtd = files != null ? files.length : 0;
            for (int i = 0; i < qtd; ++i) {
                File f = files[i];
                int tam = f.getName().length();
                Object dat = this.load(f.getName().substring(0, tam - 4), identTerminal);
                if (dat == null) break;
                list.add(dat);
            }
        }
        logger.debug("loadAll: list: " + list);
        logger.trace("loadAll: Fim");
        return list;
    }

    public void remove(String key, IdentTerminal identTerminal) {
        logger.trace("remove: Inicio");
        String name = this.formatName(key, identTerminal);
        File file = new File(name);
        if (file.delete()) {
            logger.debug("remove: Arquivo: {} deletado", file);
        } else {
            logger.warn("remove: Arquivo: {} n\u00e3o deletado", file);
        }
        logger.trace("remove: Fim");
    }

    @Deprecated
    public void removeAll(IdentTerminal identTerminal) {
        logger.trace("removeAll: Inicio");
        String path = this.formatPath(identTerminal);
        File dir = new File(path);
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.delete()) {
                    logger.debug("createPath: Arquivo {} removido", file);
                    continue;
                }
                logger.warn("createPath: Arquivo {} nao removido", file);
            }
        }
        logger.trace("removeAll: Fim");
    }

    private void createPath(String path) {
        logger.trace("createPath: Inicio");
        if (path.lastIndexOf("/") != -1) {
            File arquivo = new File(path.substring(0, path.lastIndexOf("/")));
            if (arquivo.mkdirs()) {
                logger.debug("createPath: Diretorio {} criado", arquivo);
            } else {
                logger.debug("createPath: Diretorio {} existe", arquivo);
            }
        }
        logger.trace("createPath: Fim");
    }

    static {
        PATH_APP = null;
        VERSAO_PATH_TERMINAL = 0;
        logger = CTFClientCore.getAuttarLoggerFactory().getLogger(PersistService.class);
    }
}

