/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.integracao.GeneralConfigException;
import com.csi.ctfclient.integracao.GeneralConfigHandler;
import com.csi.ctfclient.integracao.GeneralConfigKeys;
import com.csi.ctfclient.servicos.CTFClientCore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class KeyStoreUtil {
    private static final String KEYSTORE = "keystore.jks";
    private static String storePassword;
    private static final AuttarLogger logger;

    private static String getStorePassword() throws GeneralConfigException {
        if (storePassword == null) {
            storePassword = GeneralConfigHandler.getInstance().getValue(GeneralConfigKeys.STOREPASSWORD.name());
        }
        return storePassword;
    }

    public static KeyStore getDefaultKeyStory() {
        try {
            return KeyStoreUtil.createKeyStore(KEYSTORE, KeyStoreUtil.getStorePassword());
        }
        catch (Exception e) {
            logger.error("Nao foi possivel carregar keystore: " + e.getMessage());
            return null;
        }
    }

    public static KeyStore createKeyStore(String fileName, String pw) throws Exception {
        File file = new File(fileName);
        KeyStore keyStore = KeyStore.getInstance("JCEKS");
        if (file.exists()) {
            FileInputStream fis = new FileInputStream(file);
            keyStore.load(fis, pw.toCharArray());
            fis.close();
        } else {
            keyStore.load(null, null);
            FileOutputStream fos = new FileOutputStream(file);
            keyStore.store(fos, pw.toCharArray());
            fos.close();
        }
        return keyStore;
    }

    public static void store(KeyStore keyStore) throws Exception {
        File kf = new File(KEYSTORE);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(kf);
            keyStore.store(fos, KeyStoreUtil.getStorePassword().toCharArray());
        }
        catch (KeyStoreException e) {
            logger.error("Erro de keystore no armazenamento: " + e.getMessage());
            throw new Exception(e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Erro de algoritmo no armazenamento: " + e.getMessage());
            throw new Exception(e);
        }
        catch (CertificateException e) {
            logger.error("Erro de certificado no armazenamento: " + e.getMessage());
            throw new Exception(e);
        }
        catch (FileNotFoundException e) {
            logger.error("Erro de arquivo nao encontrado no armazenamento: " + e.getMessage());
            throw new Exception(e);
        }
        catch (IOException e) {
            logger.error("Erro de IO no armazenamento: " + e.getMessage());
            throw new Exception(e);
        }
        catch (GeneralConfigException e) {
            logger.error("Erro na recupera\u00e7\u00e3o das configura\u00e7\u00f5es gerais: " + e.getMessage());
            throw new Exception(e);
        }
        finally {
            if (fos != null && fos.getChannel().isOpen()) {
                fos.close();
            }
        }
    }

    static {
        logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    }
}

