/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class JavaVersion
implements Comparable<JavaVersion> {
    public static final String re = "^([0-9]+)([\\._][0-9]+)*$";
    public static final String re2 = "[\\._]([0-9]+)";
    public static final Pattern p = Pattern.compile("^([0-9]+)([\\._][0-9]+)*$");
    public static final Pattern p2 = Pattern.compile("[\\._]([0-9]+)");
    private Integer major;
    private Integer minor;
    private Integer maintenance;
    private Integer build;
    private List<Integer> otherParts;

    private JavaVersion() {
    }

    private JavaVersion(Integer major, Integer minor, Integer maintenance, Integer build, List<Integer> otherParts) {
        this.major = major;
        this.minor = minor;
        this.maintenance = maintenance;
        this.build = build;
        this.otherParts = otherParts;
    }

    Integer getMajor() {
        return this.major;
    }

    Integer getMinor() {
        return this.minor;
    }

    Integer getMaintenance() {
        return this.maintenance;
    }

    Integer getBuild() {
        return this.build;
    }

    List<Integer> getOtherParts() {
        return this.otherParts;
    }

    static JavaVersion parse(String version) throws ParseException {
        Matcher m = p.matcher(version);
        Matcher m2 = p2.matcher(version);
        if (m.find()) {
            Integer major = new Integer(m.group(1));
            Integer minor = 0;
            Integer maintenance = 0;
            Integer build = 0;
            ArrayList<Integer> otherParts = null;
            if (m2.find()) {
                minor = new Integer(m2.group(1));
                if (m2.find()) {
                    maintenance = new Integer(m2.group(1));
                    if (m2.find()) {
                        build = new Integer(m2.group(1));
                        if (m2.find()) {
                            otherParts = new ArrayList<Integer>();
                            otherParts.add(new Integer(m2.group(1)));
                            while (m2.find()) {
                                otherParts.add(new Integer(m2.group(1)));
                            }
                        }
                    }
                }
            }
            return new JavaVersion(major, minor, maintenance, build, otherParts);
        }
        throw new ParseException("Formato da vers\u00e3o Java " + version + " n\u00e3o pode ser parseado corretamente", 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaVersion that = (JavaVersion)o;
        return Objects.equals(this.major, that.major) && Objects.equals(this.minor, that.minor) && Objects.equals(this.maintenance, that.maintenance) && Objects.equals(this.build, that.build) && Objects.equals(this.otherParts, that.otherParts);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.maintenance, this.build, this.otherParts);
    }

    @Override
    public int compareTo(JavaVersion javaVersion) {
        if (javaVersion == null) {
            return 1;
        }
        if (!Objects.equals(this.major, javaVersion.getMajor())) {
            return this.major.compareTo(javaVersion.getMajor());
        }
        if (!Objects.equals(this.minor, javaVersion.getMinor())) {
            return this.minor.compareTo(javaVersion.getMinor());
        }
        if (!Objects.equals(this.maintenance, javaVersion.getMaintenance())) {
            return this.maintenance.compareTo(javaVersion.getMaintenance());
        }
        if (!Objects.equals(this.build, javaVersion.getBuild())) {
            return this.build.compareTo(javaVersion.getBuild());
        }
        if (this.otherParts == null && javaVersion.getOtherParts() == null) {
            return 0;
        }
        if (this.otherParts == null) {
            return -1;
        }
        if (javaVersion.getOtherParts() == null) {
            return 1;
        }
        int i = 0;
        while (this.otherParts.size() > i | javaVersion.getOtherParts().size() > i) {
            Integer jvOtherPartsI;
            Integer otherPartsI = this.otherParts.size() > i ? this.otherParts.get(i) : null;
            Integer n = jvOtherPartsI = javaVersion.getOtherParts().size() > i ? javaVersion.getOtherParts().get(i) : null;
            if (otherPartsI == null && jvOtherPartsI == null) {
                return 0;
            }
            if (otherPartsI == null) {
                return -1;
            }
            if (jvOtherPartsI == null) {
                return 1;
            }
            if (otherPartsI.compareTo(jvOtherPartsI) != 0) {
                return otherPartsI.compareTo(jvOtherPartsI);
            }
            ++i;
        }
        return 0;
    }
}

