/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CriptografiaUtil {
    public static final String SHA_256 = "SHA-256";

    private CriptografiaUtil() {
    }

    public static void utilizaCriptografiaContingenciaDUKPT(TabelaCriptografia tabelaCriptografia, AuttarLogger logger) {
        if (tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo() == 3) {
            if (logger != null) {
                logger.info("A criptografia de conting\u00eancia ser\u00e1 utilizada para a Senha.");
            }
            if (tabelaCriptografia.getCriptografiaSenhaContingencia() != null) {
                tabelaCriptografia.setCriptografiaSenhaPrincipal(tabelaCriptografia.getCriptografiaSenhaContingencia());
            } else if (logger != null) {
                logger.warn("A criptografia de conting\u00eancia deveria ser utilizada para Senha, mas n\u00e3o h\u00e1 chave dispon\u00edvel.");
            }
        }
        if (tabelaCriptografia.getCriptografiaDadosPrincipal() != null && tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo() == 3) {
            if (logger != null) {
                logger.info("A criptografia de conting\u00eancia ser\u00e1 utilizada para os Dados");
            }
            if (tabelaCriptografia.getCriptografiaDadosContingencia() != null) {
                tabelaCriptografia.setCriptografiaDadosPrincipal(tabelaCriptografia.getCriptografiaDadosContingencia());
            } else if (logger != null) {
                logger.warn("A criptografia de conting\u00eancia deveria ser utilizada para Dados, mas n\u00e3o h\u00e1 chave dispon\u00edvel.");
            }
        }
        CriptografiaUtil.atualizarUsoRestritoCriptografia(tabelaCriptografia, logger);
    }

    public static void atualizarUsoRestritoCriptografia(TabelaCriptografia tabelaCriptografia, AuttarLogger logger) {
        if (tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo() == 0 && tabelaCriptografia.getCriptografiaDadosPrincipal() != null && tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo() == 1) {
            if (logger != null) {
                logger.info("A criptografia de senha \u00e9 DES portando n\u00e3o poder\u00e1 ser utilizado 3DES para os dados");
            }
            tabelaCriptografia.setCriptografiaDadosPrincipal(tabelaCriptografia.getCriptografiaDadosContingencia());
        }
    }

    public static void utilizaCriptografiaContingenciaSenha(TabelaCriptografia tabelaCriptografia, AuttarLogger logger) {
        if (logger != null) {
            logger.info("A criptografia de conting\u00eancia ser\u00e1 utilizada para a Senha.");
        }
        tabelaCriptografia.setCriptografiaSenhaPrincipal(tabelaCriptografia.getCriptografiaSenhaContingencia());
    }

    public static void utilizaCriptografiaContingenciaDados(TabelaCriptografia tabelaCriptografia, AuttarLogger logger) {
        if (logger != null) {
            logger.info("A criptografia de conting\u00eancia ser\u00e1 utilizada para os Dados");
        }
        tabelaCriptografia.setCriptografiaDadosPrincipal(tabelaCriptografia.getCriptografiaDadosContingencia());
    }

    public static boolean verificaVersaoInjecaoChaves(String versao) {
        if (versao == null) {
            return false;
        }
        if (versao.length() >= 1) {
            Integer major = new Integer(versao.substring(0, 1));
            if (major.compareTo(new Integer("1")) > 0) {
                return true;
            }
            if (major.compareTo(new Integer("1")) < 0) {
                return false;
            }
        } else {
            return false;
        }
        if (versao.length() >= 4) {
            Integer minor = new Integer(versao.substring(2, 4));
            if (minor.compareTo(new Integer("7")) > 0) {
                return true;
            }
            return minor.compareTo(new Integer("7")) >= 0;
        }
        return false;
    }

    public static boolean possuiChaveContingencia(RegistroCriptografia registroCriptografiaPrincipal, RegistroCriptografia registroCriptografiaContingencia) {
        return registroCriptografiaContingencia != null && (registroCriptografiaPrincipal.getAlgoritmo() != registroCriptografiaContingencia.getAlgoritmo() || registroCriptografiaPrincipal.getIndiceMasterKey() != registroCriptografiaContingencia.getIndiceMasterKey());
    }

    public static String gerarHash(String texto, String algoritmo) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algoritmo);
            messageDigest.update(texto.getBytes());
            byte[] bytes = messageDigest.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < bytes.length; ++i) {
                sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }
}

