/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import com.csi.ctfclient.tools.util.StringUtil;
import org.apache.commons.lang3.math.NumberUtils;

public class CnpjUtil {
    public static boolean validaCnpj(String cnpj) {
        if (cnpj == null || cnpj.trim().length() != 14 || !NumberUtils.isDigits(cnpj)) {
            return false;
        }
        String codigo = cnpj.trim().substring(0, 12);
        String digitoVerificador = cnpj.trim().substring(12, 14);
        if (codigo.length() < 12) {
            codigo = StringUtil.completeStringZERO(codigo.trim(), 12);
        }
        int[] dig = new int[codigo.length() + 1];
        for (int i = 0; i < dig.length - 1; ++i) {
            dig[i + 1] = codigo.charAt(i) - 48;
        }
        int aux = 5 * dig[1] + 4 * dig[2] + 3 * dig[3] + 2 * dig[4] + 9 * dig[5] + 8 * dig[6] + 7 * dig[7] + 6 * dig[8] + 5 * dig[9] + 4 * dig[10] + 3 * dig[11] + 2 * dig[12];
        int soma = aux / 11;
        int dig1 = aux - (soma *= 11);
        dig1 = dig1 == 0 || dig1 == 1 ? 0 : 11 - dig1;
        int aux2 = 0;
        aux2 = 6 * dig[1] + 5 * dig[2] + 4 * dig[3] + 3 * dig[4] + 2 * dig[5] + 9 * dig[6] + 8 * dig[7] + 7 * dig[8] + 6 * dig[9] + 5 * dig[10] + 4 * dig[11] + 3 * dig[12] + 2 * dig1;
        int soma2 = 0;
        soma2 = aux2 / 11;
        int dig2 = aux2 - (soma2 *= 11);
        dig2 = dig2 == 0 || dig2 == 1 ? 0 : 11 - dig2;
        String strDig = "" + dig1 + "" + dig2;
        return strDig.equals(digitoVerificador);
    }
}

