/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import br.com.auttar.AuttarLogger;
import br.com.auttar.util.emv.CryptoKeyType;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class ChavesCriptografiaUtil {
    public static void validatePinpadKey(AuttarLogger logger, ControladorPerifericos perifericos, TabelaCriptografia tabelaCriptografia, CryptoKeyType cryptoKeyType) throws ExcecaoPerifericos, ExcecaoNaoLocal {
        String descricaoChaveLog;
        RegistroCriptografia registroCriptografia;
        boolean possuiContingencia = cryptoKeyType == CryptoKeyType.PIN ? CriptografiaUtil.possuiChaveContingencia(tabelaCriptografia.getCriptografiaSenhaPrincipal(), tabelaCriptografia.getCriptografiaSenhaContingencia()) : CriptografiaUtil.possuiChaveContingencia(tabelaCriptografia.getCriptografiaDadosPrincipal(), tabelaCriptografia.getCriptografiaDadosContingencia());
        if (!possuiContingencia) {
            logger.info("N\u00e3o existem chaves de conting\u00eancia");
            return;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.VERCHAPIN_TITLE));
        perifericos.imprimeDisplay(displayModel);
        if (cryptoKeyType == CryptoKeyType.PIN) {
            registroCriptografia = tabelaCriptografia.getCriptografiaSenhaPrincipal();
            descricaoChaveLog = "senha";
        } else {
            registroCriptografia = tabelaCriptografia.getCriptografiaDadosPrincipal();
            descricaoChaveLog = "dados";
        }
        logger.debug("Pesquisando chave de " + descricaoChaveLog + " algoritmo: " + registroCriptografia.getAlgoritmo() + ", \u00edndice: " + registroCriptografia.getIndiceMasterKey());
        PinEMV pinEMV = perifericos.getPinpad();
        if (!pinEMV.containsKey(registroCriptografia.getAlgoritmo(), cryptoKeyType, registroCriptografia.getIndiceMasterKey())) {
            if (cryptoKeyType == CryptoKeyType.PIN) {
                CriptografiaUtil.utilizaCriptografiaContingenciaSenha(tabelaCriptografia, logger);
            } else {
                CriptografiaUtil.utilizaCriptografiaContingenciaDados(tabelaCriptografia, logger);
            }
            CriptografiaUtil.atualizarUsoRestritoCriptografia(tabelaCriptografia, logger);
        }
    }
}

