/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import java.util.Arrays;
import java.util.stream.Collectors;

public enum CSILibErrorCode {
    ERR_PARAM(-1, "Erro nos parametros enviados"),
    ERR_MEMORY(-2, "Erro ao alocar mem\u00f3ria"),
    ERR_WORD(-3, "Erro no formato da palavra chave enviada"),
    ERR_FILE(-4, "Erro ao acessar, criar ou ler o arquivo"),
    ERR_OBFUSC(-5, "Erro ao obfuscar/deobfuscar um dado"),
    ERR_NOT_CATEGORISED(-999, "Erro n\u00e3o classificado");

    private final int errorCode;
    private final String description;

    private CSILibErrorCode(int errorCode, String description) {
        this.errorCode = errorCode;
        this.description = description;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getDescription() {
        return this.description;
    }

    public static CSILibErrorCode getByErrorCode(int errorCode) {
        if (errorCode >= 0) {
            return null;
        }
        return Arrays.stream(CSILibErrorCode.values()).collect(Collectors.toList()).stream().filter(e -> e.getErrorCode() == errorCode).findFirst().orElse(ERR_NOT_CATEGORISED);
    }
}

