/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import com.csi.ctfclient.excecoes.ExcecaoHexaInvalido;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Hex;

public final class ByteUtil {
    public static final byte[] VAZIO = new byte[0];

    private ByteUtil() {
    }

    public static short byteArrayToShort(byte[] bytes) {
        int result = 0;
        result |= 0xFF00 & bytes[0] << 8;
        return (short)(result |= 0xFF & bytes[1]);
    }

    public static byte[] intTo3BytesArray(int valor) {
        byte[] result = new byte[3];
        for (int i = 0; i < result.length; ++i) {
            result[2 - i] = (byte)(valor & 0xFF);
            valor >>= 8;
        }
        return result;
    }

    public static byte[] shortToByteArray(int valor) {
        byte[] result = new byte[2];
        for (int i = 0; i < result.length; ++i) {
            result[1 - i] = (byte)(valor & 0xFF);
            valor >>= 8;
        }
        return result;
    }

    public static boolean getBit(byte[] bitMap, int index) throws ArrayIndexOutOfBoundsException {
        return (bitMap[index / 8] & 1 << 7 - index % 8) != 0;
    }

    public static void setBit(byte[] bitMap, int index, boolean value) throws ArrayIndexOutOfBoundsException {
        int i = index / 8;
        int mask = 1 << 7 - index % 8;
        if (value) {
            int n = i;
            bitMap[n] = (byte)(bitMap[n] | mask);
        } else {
            int n = i;
            bitMap[n] = (byte)(bitMap[n] & ~mask);
        }
    }

    private static int hexDigitValue(char c) throws ExcecaoHexaInvalido {
        int retorno;
        if (c >= '0' && c <= '9') {
            retorno = (byte)c - 48;
        } else if (c >= 'A' && c <= 'F') {
            retorno = (byte)c - 55;
        } else if (c >= 'a' && c <= 'f') {
            retorno = (byte)c - 87;
        } else {
            throw new ExcecaoHexaInvalido();
        }
        return retorno;
    }

    public static byte hexToByte(String hexa) throws ExcecaoHexaInvalido {
        if (hexa == null) {
            throw new ExcecaoHexaInvalido();
        }
        if (hexa.length() != 2) {
            throw new ExcecaoHexaInvalido();
        }
        byte[] b = hexa.getBytes();
        return (byte)(ByteUtil.hexDigitValue((char)b[0]) * 16 + ByteUtil.hexDigitValue((char)b[1]));
    }

    public static byte[] hexToByteArray(String hexa) throws ExcecaoHexaInvalido {
        if (hexa == null) {
            throw new ExcecaoHexaInvalido();
        }
        if (hexa.length() % 2 != 0) {
            throw new ExcecaoHexaInvalido();
        }
        int tamArray = hexa.length() / 2;
        byte[] retorno = new byte[tamArray];
        for (int i = 0; i < tamArray; ++i) {
            retorno[i] = ByteUtil.hexToByte(hexa.substring(i * 2, i * 2 + 2));
        }
        return retorno;
    }

    public static String byteArrayToHex(byte[] bytes) {
        StringBuilder retorno = new StringBuilder();
        if (bytes == null || bytes.length == 0) {
            return retorno.toString();
        }
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int d1;
            byte valor;
            int d2 = (valor & 0xF0) >> 4;
            retorno.append((char)(d2 += d2 < 10 ? 48 : 55)).append((char)(d1 += (d1 = (valor = byArray[i]) & 0xF) < 10 ? 48 : 55));
        }
        return retorno.toString();
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static byte[] copyRange(byte[] source, int offset, int length) {
        int lastIndex = offset + length;
        if (lastIndex > source.length) {
            throw new IllegalArgumentException(lastIndex + " > " + source.length);
        }
        byte[] destination = new byte[length];
        int sourceIndex = offset;
        int destinationIndex = 0;
        while (destinationIndex < length) {
            destination[destinationIndex++] = source[sourceIndex++];
        }
        return destination;
    }

    public static String toZonedString(String s) {
        return new String(Hex.encodeHex(s.getBytes(StandardCharsets.UTF_8)));
    }
}

