/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.postef.servico;

import br.com.auttar.AuttarLogger;
import br.com.auttar.clientservices.AuttarServicesClient;
import br.com.auttar.clientservices.model.Checkout;
import br.com.auttar.clientservices.model.PaymentResult;
import br.com.auttar.clientservices.services.PaymentRequestListener;
import br.com.auttar.clientservices.services.PaymentResultListener;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ConfClienteServico;
import com.csi.ctfclient.config.ConfPOSTef;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.postef.POSTef;
import com.csi.ctfclient.tools.devices.postef.model.TipoMensagem;
import com.csi.ctfclient.tools.devices.postef.servico.ConfiguracaoServico;
import com.csi.ctfclient.tools.devices.postef.servico.ConsultaPagamentoPOSTefServico;
import com.csi.ctfclient.tools.devices.postef.servico.ProvedorMensagemServico;
import com.csi.ctfclient.tools.devices.postef.servico.RespostaPagamentoPOSTefServico;
import java.util.Objects;

public class POSTefServico
extends POSTef<ProvedorMensagemServico<?>> {
    private AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(POSTefServico.class);
    private AuttarServicesClient auttarServicesClient;
    private PaymentRequestListener paymentRequestListener = (sessionMessage, checkout) -> {
        ProvedorMensagemServico<Checkout> gerenciadorMensagemServico = new ProvedorMensagemServico<Checkout>(TipoMensagem.pagamento_postef, sessionMessage, checkout);
        this.handler(gerenciadorMensagemServico);
    };
    private PaymentResultListener paymentResultListener = (sessionMessage, paymentResult) -> {
        ProvedorMensagemServico<PaymentResult> gerenciadorMensagemServico = new ProvedorMensagemServico<PaymentResult>(TipoMensagem.resposta_pagamento_postef, sessionMessage, paymentResult);
        this.handler(gerenciadorMensagemServico);
    };

    @Override
    public void conecta() {
        if (!this.isInicializado()) {
            Thread t = new Thread(() -> {
                try {
                    this.logger.info("Inicializando AuttarServicesClient...");
                    ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
                    ConfClienteServico configClienteServico = confCTFClient.getConfClienteServico();
                    ConfPOSTef confPOSTef = confCTFClient.getConfPOSTef();
                    if (configClienteServico != null && configClienteServico.isHabilitado()) {
                        ConfiguracaoServico configuracaoServico = new ConfiguracaoServico();
                        configuracaoServico.setCompanyCode(confCTFClient.getEstabelecimento());
                        configuracaoServico.setStoreCode(confCTFClient.getLoja());
                        configuracaoServico.setMessageBrokerUrl(configClienteServico.getHost());
                        if (confPOSTef != null && confPOSTef.isHabilitado()) {
                            configuracaoServico.setMobilePosCode(confPOSTef.getTerminalPosMovel());
                        }
                        configuracaoServico.setExternalCode(configClienteServico.getCodigoPdv());
                        this.auttarServicesClient = new AuttarServicesClient(configuracaoServico);
                        if (this.auttarServicesClient.connect()) {
                            this.logger.info("AuttarServicesClient inicializado.");
                            if (confPOSTef != null && confPOSTef.isHabilitado()) {
                                if (confPOSTef.getTerminalPosMovel() != null) {
                                    this.auttarServicesClient.addPaymentRequestListener(this.paymentRequestListener);
                                    this.auttarServicesClient.addPaymentResultListener(this.paymentResultListener);
                                    this.logger.info("listeners posmovel configurado para POS '" + confPOSTef.getTerminalPosMovel() + "'");
                                } else {
                                    this.logger.warn("configuaracao posmovel invalida. necessario informar o codigo do POS associado.");
                                }
                            }
                            this.setInicializado(true);
                            while (this.isInicializado()) {
                                Thread.sleep(500L);
                            }
                        } else {
                            this.logger.error("AuttarServicesClient nao inicializado.");
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error("nao foi possivel inicializar AuttarServicesClient -> " + e.getMessage());
                }
            });
            t.start();
        }
    }

    @Override
    public void desconecta() {
        super.desconecta();
        this.logger.info("finalizando AuttarServicesClient...");
        if (this.auttarServicesClient != null) {
            if (this.auttarServicesClient.disconnect()) {
                this.logger.info("AuttarServicesClient finalizado.");
            } else {
                this.logger.error("AuttarServicesClient nao finalizado.");
            }
        } else {
            this.logger.info("solicitacao invalida. AuttarServicesClient nao inicializado.");
        }
    }

    @Override
    protected synchronized void handlerPagamentoPOSTef(ProvedorMensagemServico<?> messageManager) {
        super.handlerPagamentoPOSTef(messageManager);
        ConsultaPagamentoPOSTefServico pagamentoPOSTefServico = new ConsultaPagamentoPOSTefServico(messageManager, this.getPagamentoPendente(), this.getTimestampPagamento());
        this.execute(pagamentoPOSTefServico);
    }

    @Override
    protected synchronized void handlerResultadoPagamento(ProvedorMensagemServico<?> messageManager) {
        super.handlerResultadoPagamento(messageManager);
        RespostaPagamentoPOSTefServico respostaPagamentoPOSTefServico = new RespostaPagamentoPOSTefServico(messageManager, this, this.getPosTefListener());
        this.execute(respostaPagamentoPOSTefServico);
    }
}

