/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.generic;

import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.generic.ExcecaoPortaSerial;
import com.csi.ctfclient.tools.devices.generic.PortaSerial;
import java.io.IOException;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;

public class ScannerSerial
extends Scanner
implements SerialPortEventListener {
    private PortaSerial serial = new PortaSerial();
    private String codigoLido = "";
    private boolean lendoCodigo = false;

    public ScannerSerial(String porta, String speed, String databits, String parity, String stopbits) throws ExcecaoPerifericos {
        try {
            this.serial.abrirPortaSerial(this, porta, speed, databits, parity, stopbits);
        }
        catch (ExcecaoPortaSerial e) {
            throw new ExcecaoPerifericos("SS01", String.format("Erro na instanciacao do scanner serial (%s, %s, %s, %s, %s)", porta, speed, databits, parity, stopbits), e.getMessage());
        }
    }

    @Override
    public void desabilita() throws ExcecaoPerifericos {
        this.setHabilitado(false);
        super.desabilita();
    }

    @Override
    public void habilita() throws ExcecaoPerifericos {
        this.setHabilitado(true);
    }

    @Override
    public void liberaRecursos() throws ExcecaoPerifericos {
        this.desabilita();
        this.serial.fecharPortaSerial();
        super.liberaRecursos();
    }

    @Override
    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                try {
                    while (this.serial.in.available() > 0) {
                        char aux = (char)this.serial.in.read();
                        if (!this.getHabilitado()) continue;
                        if (!this.lendoCodigo) {
                            this.codigoLido = "";
                            this.lendoCodigo = true;
                        }
                        if (aux == '\r') {
                            this.codigoRecebido(this.codigoLido);
                            this.codigoLido = "";
                            this.lendoCodigo = false;
                            continue;
                        }
                        if (aux < '0' || aux > '9') continue;
                        this.codigoLido = this.codigoLido + aux;
                    }
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

