/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.generic;

import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.generic.EventoSequenciaTeclado;
import com.csi.ctfclient.tools.devices.generic.ProtocoloTecladoPCListener;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class ProtocoloTecladoPC
implements KeyListener,
WindowListener {
    private static final int ESTADO_ANTES_DADOS = 0;
    private static final int ESTADO_EM_DADOS = 1;
    private static final int COMP_CONTEM_PARCIAL = 0;
    private static final int COMP_CONTEM_INTEGRAL = 1;
    private static final int COMP_NAO_CONTEM = 2;
    private static ProtocoloTecladoPC proto = null;
    private final Frame janela;
    private OuvinteProtocoloTeclado ouvintePadrao = null;
    private final Vector<OuvinteProtocoloTeclado> ouvintes = new Vector();
    private int estadoAtual = 0;
    private final int[] buffer = new int[512];
    private int qtdTeclas = 0;
    private OuvinteProtocoloTeclado ouvinteAtual = null;
    private long tempoUltimaTecla = 0L;
    private ThreadDisparaEventoAutomatico threadDispAuto;

    private ProtocoloTecladoPC(Frame janela) throws ExcecaoPerifericos {
        try {
            this.janela = janela;
            janela.addKeyListener(this);
            janela.addWindowListener(this);
            this.threadDispAuto = new ThreadDisparaEventoAutomatico(this);
            this.threadDispAuto.start();
        }
        catch (Exception e) {
            throw new ExcecaoPerifericos("PTPC01", "Erro ao instanciar protocolo de teclado PC", e);
        }
    }

    public static ProtocoloTecladoPC getInstancia(Frame frame) throws ExcecaoPerifericos {
        if (proto == null) {
            proto = new ProtocoloTecladoPC(frame);
        }
        return proto;
    }

    private synchronized void verificaTimeoutRecebimento() {
        if (this.qtdTeclas == 0) {
            return;
        }
        if (System.currentTimeMillis() - this.tempoUltimaTecla > 200L) {
            this.geraEventoOuvintePadrao(this.qtdTeclas);
        }
    }

    @Override
    public synchronized void keyPressed(KeyEvent evt) {
        int codTecla = evt.getKeyCode() == 0 && evt.getKeyChar() != '\u0000' ? 512 + evt.getKeyChar() : (evt.getKeyChar() == '\uffff' ? 512 + evt.getKeyCode() : evt.getKeyChar());
        this.trataTeclaRecebida(codTecla);
    }

    private synchronized void trataTeclaRecebida(int codTecla) {
        this.buffer[this.qtdTeclas++] = codTecla;
        this.tempoUltimaTecla = System.currentTimeMillis();
        switch (this.estadoAtual) {
            case 0: {
                this.ouvinteAtual = null;
                boolean naoIdent = true;
                while (naoIdent) {
                    for (OuvinteProtocoloTeclado ouvinte : this.ouvintes) {
                        OuvinteProtocoloTeclado o = ouvinte;
                        int ret = o.comparaPrefixo(this.buffer, this.qtdTeclas);
                        if (ret == 1) {
                            this.ouvinteAtual = o;
                            this.estadoAtual = 1;
                            return;
                        }
                        naoIdent &= ret == 2;
                    }
                    if (!naoIdent) continue;
                    this.geraEventoOuvintePadrao(1);
                    if (this.qtdTeclas != 0) continue;
                    naoIdent = false;
                }
                break;
            }
            case 1: {
                boolean tamValido;
                boolean noEscopo = this.ouvinteAtual.noEscopo(this.buffer[this.qtdTeclas - 1]);
                boolean bl = tamValido = this.qtdTeclas - this.ouvinteAtual.prefixo.length <= this.ouvinteAtual.tamMaxSeq;
                if (!tamValido || !noEscopo) {
                    this.geraEventoOuvintePadrao(this.qtdTeclas);
                    break;
                }
                if (!this.ouvinteAtual.contemSufixo(this.buffer, this.qtdTeclas)) break;
                this.geraEventoOuvinteAtual();
            }
        }
    }

    private void geraEventoOuvintePadrao(int qtd) {
        if (this.ouvintePadrao != null) {
            int[] tmp = new int[qtd];
            System.arraycopy(this.buffer, 0, tmp, 0, qtd);
            EventoSequenciaTeclado ev = new EventoSequenciaTeclado(this, tmp, qtd);
            this.ouvintePadrao.listener.codigoDigitado(ev);
        }
        this.qtdTeclas -= qtd;
        if (this.qtdTeclas == 0) {
            this.estadoAtual = 0;
        } else {
            for (int i = 0; i < this.qtdTeclas; ++i) {
                this.buffer[i] = this.buffer[i + qtd];
            }
        }
    }

    private void geraEventoOuvinteAtual() {
        if (this.ouvinteAtual != null) {
            int tamDados = this.qtdTeclas - this.ouvinteAtual.prefixo.length - this.ouvinteAtual.sufixo.length;
            int[] tmp = new int[tamDados];
            System.arraycopy(this.buffer, this.ouvinteAtual.prefixo.length, tmp, 0, tamDados);
            EventoSequenciaTeclado ev = new EventoSequenciaTeclado(this, tmp, tamDados);
            this.ouvinteAtual.listener.codigoDigitado(ev);
        }
        this.qtdTeclas = 0;
        this.estadoAtual = 0;
    }

    public void liberaRecursos() throws ExcecaoPerifericos {
        this.janela.removeKeyListener(this);
        this.janela.removeWindowListener(this);
        this.threadDispAuto.finalizar();
        this.threadDispAuto = null;
        proto = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProtocoloTecladoPCListener(int[] prefixo, int[] sufixo, int tam, int[] escopo, ProtocoloTecladoPCListener ouvinte) {
        OuvinteProtocoloTeclado o = new OuvinteProtocoloTeclado(prefixo, sufixo, tam, escopo, ouvinte);
        Vector<OuvinteProtocoloTeclado> vector = this.ouvintes;
        synchronized (vector) {
            if (prefixo == null && sufixo == null) {
                this.ouvintePadrao = o;
            } else {
                this.ouvintes.add(o);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProtocoloTecladoPCListener(ProtocoloTecladoPCListener ouvinte) {
        Vector<OuvinteProtocoloTeclado> vector = this.ouvintes;
        synchronized (vector) {
            for (int i = 0; i < this.ouvintes.size(); ++i) {
                OuvinteProtocoloTeclado o = this.ouvintes.get(i);
                if (o.listener != ouvinte) continue;
                this.ouvintes.remove(i);
                break;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void windowActivated(WindowEvent evt) {
        ((Frame)evt.getSource()).requestFocus();
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowClosing(WindowEvent evt) {
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    class OuvinteProtocoloTeclado {
        public int[] prefixo;
        public int[] sufixo;
        public ProtocoloTecladoPCListener listener;
        private final int[] escopo;
        private final int tamMaxSeq;

        public OuvinteProtocoloTeclado(int[] prefixo, int[] sufixo, int tamMax, int[] escopo, ProtocoloTecladoPCListener ouvinte) {
            this.prefixo = prefixo;
            this.sufixo = sufixo;
            this.listener = ouvinte;
            if (tamMax > ProtocoloTecladoPC.this.buffer.length) {
                tamMax = ProtocoloTecladoPC.this.buffer.length;
            }
            this.tamMaxSeq = tamMax;
            this.escopo = escopo;
        }

        public boolean noEscopo(int valor) {
            int i;
            boolean noEscopo = false;
            for (i = 0; !noEscopo && this.escopo != null && i < this.escopo.length; ++i) {
                noEscopo = this.escopo[i] == valor;
            }
            for (i = 0; !noEscopo && this.prefixo != null && i < this.prefixo.length; ++i) {
                noEscopo = this.prefixo[i] == valor;
            }
            for (i = 0; !noEscopo && this.sufixo != null && i < this.sufixo.length; ++i) {
                noEscopo = this.sufixo[i] == valor;
            }
            return noEscopo;
        }

        public int comparaPrefixo(int[] seq, int tam) {
            if (this.prefixo == null) {
                return 2;
            }
            int tamanho = Math.min(tam, this.prefixo.length);
            boolean ok = true;
            for (int i = 0; ok && i < tamanho; ++i) {
                ok = this.prefixo[i] == seq[i];
            }
            if (tam >= this.prefixo.length) {
                return ok ? 1 : 2;
            }
            return ok ? 0 : 2;
        }

        public boolean contemSufixo(int[] seq, int tam) {
            if (this.sufixo == null || this.sufixo.length > tam) {
                return false;
            }
            boolean contemSufixo = true;
            for (int i = 0; contemSufixo && i < this.sufixo.length; ++i) {
                contemSufixo = this.sufixo[i] == seq[tam - this.sufixo.length + i];
            }
            return contemSufixo;
        }
    }

    static class ThreadDisparaEventoAutomatico
    extends Thread {
        ProtocoloTecladoPC proto;
        boolean finalizada = false;

        public ThreadDisparaEventoAutomatico(ProtocoloTecladoPC proto) {
            this.proto = proto;
        }

        public void finalizar() {
            this.finalizada = true;
        }

        @Override
        public void run() {
            while (!this.finalizada) {
                this.proto.verificaTimeoutRecebimento();
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

