/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.generic;

import com.csi.ctfclient.tools.devices.generic.ExcecaoPortaSerial;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class PortaSerial {
    public static final byte STX = 2;
    public static final byte ETX = 3;
    public static final byte EOT = 4;
    public static final byte ENQ = 5;
    public static final byte ACK = 6;
    public static final byte NAK = 21;
    public static final byte SI = 15;
    public static final byte SO = 14;
    public static final byte FS = 28;
    public static final int ERR_TIMEOUT = -1;
    public static final int TIMEOUT_INDEFINIDO = -1;
    public SerialPort port = null;
    public InputStream in;
    public OutputStream out;
    private String nomePorta = null;
    private int timeoutLeitura = -1;

    public synchronized void abrirPortaSerial(SerialPortEventListener listener, String portName, String baudRate, String dataBits, String parity, String stopBits) throws ExcecaoPortaSerial {
        CommPortIdentifier portId = null;
        boolean portaExiste = false;
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements() && !portaExiste) {
            portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1 || !portId.getName().equals(portName)) continue;
            portaExiste = true;
        }
        if (!portaExiste) {
            throw new ExcecaoPortaSerial("PER104");
        }
        this.nomePorta = portName;
        try {
            this.port = (SerialPort)portId.open(listener.getClass().getName(), 2000);
        }
        catch (Exception e) {
            throw new ExcecaoPortaSerial("PER105", e);
        }
        try {
            this.in = this.port.getInputStream();
            this.out = this.port.getOutputStream();
        }
        catch (Throwable t) {
            this.fecharPortaSerial();
            throw new ExcecaoPortaSerial("PER106", t);
        }
        try {
            this.port.addEventListener(listener);
        }
        catch (Throwable t) {
            this.fecharPortaSerial();
            throw new ExcecaoPortaSerial("PER106", t);
        }
        this.configurarPortaSerial(baudRate, dataBits, parity, stopBits);
        this.port.setInputBufferSize(4096);
        this.port.setOutputBufferSize(4096);
        this.port.notifyOnDataAvailable(true);
    }

    public synchronized void configurarPortaSerial(String baudRate, String dataBits, String parity, String stopBits) throws ExcecaoPortaSerial {
        int par;
        int stopb;
        int datab;
        int baud;
        try {
            baud = Integer.parseInt(baudRate);
        }
        catch (NumberFormatException e) {
            throw new ExcecaoPortaSerial("PER100");
        }
        if (dataBits.equals("5")) {
            datab = 5;
        } else if (dataBits.equals("6")) {
            datab = 6;
        } else if (dataBits.equals("7")) {
            datab = 7;
        } else if (dataBits.equals("8")) {
            datab = 8;
        } else {
            throw new ExcecaoPortaSerial("PER101");
        }
        if (stopBits.equals("1")) {
            stopb = 1;
        } else if (stopBits.equals("1.5")) {
            stopb = 3;
        } else if (stopBits.equals("2")) {
            stopb = 2;
        } else {
            throw new ExcecaoPortaSerial("PER102");
        }
        if (parity.equals("N")) {
            par = 0;
        } else if (parity.equals("E")) {
            par = 2;
        } else if (parity.equals("O")) {
            par = 1;
        } else if (parity.equals("M")) {
            par = 3;
        } else if (parity.equals("S")) {
            par = 4;
        } else {
            throw new ExcecaoPortaSerial("PER103");
        }
        try {
            if (this.port != null) {
                this.port.setSerialPortParams(baud, datab, stopb, par);
            }
        }
        catch (UnsupportedCommOperationException e) {
            this.fecharPortaSerial();
            throw new ExcecaoPortaSerial("PER107", e);
        }
    }

    public synchronized void fecharPortaSerial() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.port != null) {
            this.port.close();
        }
        this.port = null;
    }

    public synchronized int receberByteTimeout(int timeOut) {
        int ret = -1;
        if (timeOut < 0 && timeOut != -1) {
            return ret;
        }
        if (this.timeoutLeitura != timeOut) {
            try {
                if (timeOut == -1) {
                    this.port.disableReceiveTimeout();
                } else {
                    this.port.enableReceiveTimeout(timeOut);
                }
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                // empty catch block
            }
            this.timeoutLeitura = timeOut;
        }
        try {
            ret = this.in.read();
            if (ret < 0) {
                ret = -1;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public String getNomePorta() {
        return this.nomePorta;
    }
}

