/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.generic;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import java.io.Serializable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class Ansi98Crypto
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Ansi98Crypto.class);
    private static Cipher desCipher;
    public byte[] masterKey;
    public byte[] workingKey;
    public byte[] workingKey0;

    public Ansi98Crypto(String workingKey0, String masterKey) {
        this.workingKey0 = Ansi98Crypto.chaveStrHex2Bin(workingKey0);
        this.masterKey = Ansi98Crypto.chaveStrHex2Bin(masterKey);
        try {
            desCipher = Ansi98Crypto.getMyCipher();
        }
        catch (Exception e) {
            logger.warn("N\u00e3o foi poss\u00edvel obter a cifra criptogr\u00e1fica para Ansi98: " + e.getMessage());
        }
        this.workingKey = this.decriptografaDES(this.workingKey0, this.masterKey);
    }

    private static SecretKey getCriptoKey(byte[] key) {
        try {
            SecretKeyFactory secKeyFactory = SecretKeyFactory.getInstance("DES");
            DESKeySpec dk = new DESKeySpec(key);
            return secKeyFactory.generateSecret(dk);
        }
        catch (Exception e) {
            logger.warn("CRIPTOKEY erro:" + e);
            return null;
        }
    }

    public static Cipher getMyCipher() {
        if (desCipher == null) {
            try {
                desCipher = Cipher.getInstance("DES/ECB/NoPadding");
            }
            catch (Throwable e) {
                logger.warn("N\u00e3o foi poss\u00edvel criar a cifra DES/ECB/NoPadding: " + e.getMessage());
            }
        }
        return desCipher;
    }

    public static void main(String[] args) {
    }

    private static String byte2Str(byte valor) {
        int d1;
        int d2 = (valor & 0xF0) >> 4;
        return "" + (char)(d2 += d2 < 10 ? 48 : 55) + (char)(d1 += (d1 = valor & 0xF) < 10 ? 48 : 55);
    }

    public static String chaveBin2StrHex(byte[] res, int size) {
        StringBuilder cmd = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            cmd.append(Ansi98Crypto.byte2Str(res[i]));
        }
        return cmd.toString();
    }

    public static byte[] chaveStrHex2Bin(String strHex) {
        byte[] res = new byte[8];
        for (int i = 0; i < 8; ++i) {
            String cHex = strHex.substring(i * 2, (i + 1) * 2);
            res[i] = (byte)(Ansi98Crypto.chr2Byte(cHex.charAt(0)) * 16 + Ansi98Crypto.chr2Byte(cHex.charAt(1)));
        }
        return res;
    }

    private static int chr2Byte(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return 0;
    }

    public byte[] decriptografaDES(byte[] texto, byte[] chave) {
        byte[] criptografada = null;
        try {
            desCipher = Ansi98Crypto.getMyCipher();
            desCipher.init(2, Ansi98Crypto.getCriptoKey(chave));
            criptografada = desCipher.doFinal(texto);
        }
        catch (Exception e) {
            logger.warn("N\u00e3o foi poss\u00edvel descriptografar DES: " + e.getMessage());
        }
        return criptografada;
    }

    public void touch() {
    }
}

