/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.fusion;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.model.BombaFusion;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.fusion.DadosListaPreset;
import com.csi.ctfclient.tools.devices.fusion.DadosPistaFusion;
import com.csi.ctfclient.tools.devices.fusion.Preset;
import com.csi.ctfclient.tools.devices.fusion.ProdutoBombaCombustivel;
import com.csi.ctfclient.tools.devices.fusion.StatusFusion;
import com.csi.ctfclient.tools.devices.fusion.StatusPresetFusion;
import com.csi.ctfclient.tools.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class ControladorFusion {
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    private static ControladorFusion controladorFusion = null;
    private static Socket socket = null;
    private static boolean modoContingencia;
    private static String ip;
    private static int porta;
    protected final String CMD_GENERICO_ERRO = "00";
    protected final String CMD_ECO = "01";
    protected final String CMD_RESP_ECO = "02";
    protected final String CMD_INFO_PISTA = "03";
    protected final String CMD_RESP_INFO_PISTA = "04";
    protected final String CMD_PRESET = "05";
    protected final String CMD_RESP_PRESET = "06";
    protected final String CMD_STATUS_PRESET = "07";
    protected final String CMD_RESP_STATUS_PRESET = "08";
    protected final String CMD_CANCELAMENTO_PRESET = "09";
    protected final String CMD_RESP_CANCELAMENTO_PRESET = "10";
    protected final String CMD_FINALIZA_PRESET = "11";
    protected final String CMD_RESP_FINALIZA_PRESET = "12";
    protected final String CMD_LISTAR_PRESET = "13";
    protected final String CMD_RESP_LISTAR_PRESET = "14";
    protected final String ERRO_TIMEOUT = "05";
    private final int MAX_RETRY = 3;

    private ControladorFusion() {
        modoContingencia = false;
    }

    public static ControladorFusion getInstancia() {
        if (controladorFusion == null) {
            controladorFusion = new ControladorFusion();
        }
        return controladorFusion;
    }

    public static void setParametrosInicializacao(String ip, int porta) {
        ControladorFusion.ip = ip;
        ControladorFusion.porta = porta;
    }

    private static void init() {
        try {
            socket = new Socket(ip, porta);
            logger.info("Controlador Fusion inicializado...");
        }
        catch (UnknownHostException e) {
            logger.error("Erro ao conectar com o Fusion, host desconhecido: " + e.getMessage());
        }
        catch (IOException e) {
            logger.error("Erro ao conectar com o Fusion, erro de comunicacao: " + e.getMessage());
        }
    }

    public static String converteCodigoProdutoFusion(String codigoProdutoSelecionado) {
        if (codigoProdutoSelecionado.length() > 2) {
            return codigoProdutoSelecionado.substring(codigoProdutoSelecionado.length() - 2, codigoProdutoSelecionado.length());
        }
        return codigoProdutoSelecionado;
    }

    public static boolean isModoContingencia() {
        return modoContingencia;
    }

    public static void setModoContingencia(boolean modoContingencia) {
        ControladorFusion.modoContingencia = modoContingencia;
    }

    protected final synchronized String executaComando(String comando) {
        OutputStream os = null;
        InputStream is = null;
        String resposta = "";
        try {
            int retry = 0;
            boolean comandoOK = false;
            if (!comandoOK && retry < 3) {
                if (socket == null || socket.isClosed()) {
                    ControladorFusion.init();
                }
                if (socket == null) {
                    return null;
                }
                os = socket.getOutputStream();
                is = socket.getInputStream();
                os.write(comando.getBytes());
                os.flush();
                byte[] buffer = new byte[9999];
                is.read(buffer, 0, 4);
                int tamBuffer = Integer.parseInt(new String(buffer, 0, 4));
                is.read(buffer, 4, tamBuffer - 4);
                resposta = new String(buffer, 0, tamBuffer);
                int offSet = 0;
                Integer.parseInt(resposta.substring(offSet, offSet + 4));
                String codResp = resposta.substring(offSet += 4, offSet + 2);
                offSet += 2;
                if (codResp.equals("00")) {
                    String erro = resposta.substring(offSet, offSet + 2);
                    if (erro.equals("05")) {
                        ++retry;
                        socket.close();
                    } else {
                        return resposta;
                    }
                }
                socket.close();
                return resposta;
            }
        }
        catch (IOException e) {
            logger.warn("Erro ao executar comando do fusion: " + e.getMessage());
            try {
                socket.close();
                socket = null;
            }
            catch (IOException e1) {
                logger.warn("Erro ao fechar socket depois do comando do fusion: " + e.getMessage());
            }
        }
        return resposta;
    }

    public boolean eco() {
        String comando = "000601";
        String resposta = this.executaComando(comando);
        if (resposta == null || resposta.length() == 0) {
            return false;
        }
        int offSet = 0;
        Integer.parseInt(resposta.substring(offSet, offSet + 4));
        String codResp = resposta.substring(offSet += 4, offSet + 2);
        offSet += 2;
        return codResp.equals("02");
    }

    public DadosPistaFusion infoPista() {
        return this.infoPista("00");
    }

    public DadosPistaFusion infoPista(String codigo) {
        String comando = "000803" + codigo;
        String resposta = this.executaComando(comando);
        if (resposta == null || resposta.length() == 0) {
            return null;
        }
        DadosPistaFusion dadosPista = new DadosPistaFusion();
        int offSet = 0;
        Integer.parseInt(resposta.substring(offSet, offSet + 4));
        String codResp = resposta.substring(offSet += 4, offSet + 2);
        offSet += 2;
        if (!codResp.equals("04")) {
            logger.error("msg fussion invalida: req-> " + comando + ", resp-> " + resposta);
            return null;
        }
        dadosPista.setResultado(Integer.parseInt(resposta.substring(offSet, offSet + 2)));
        dadosPista.setStatusFusion(Integer.parseInt(resposta.substring(offSet += 2, offSet + 2)));
        offSet += 2;
        if (dadosPista.getResultado() == 0) {
            dadosPista.setVersaoFirmware(resposta.substring(offSet, offSet + 7));
            dadosPista.setNumeroSerie(resposta.substring(offSet += 7, offSet + 6));
            int qtdBombas = Integer.parseInt(resposta.substring(offSet += 6, offSet + 2));
            offSet += 2;
            if (qtdBombas > 0) {
                for (int i = 0; i < qtdBombas; ++i) {
                    BombaFusion bomba = new BombaFusion();
                    dadosPista.addBomba(bomba);
                    int idBomba = Integer.parseInt(resposta.substring(offSet, offSet + 2));
                    bomba.setId(idBomba);
                    int casasDecimais = Integer.parseInt(resposta.substring(offSet += 2, offSet + 1));
                    bomba.setCasasDecimais(casasDecimais);
                    int qtdProdutos = Integer.parseInt(resposta.substring(++offSet, offSet + 2));
                    offSet += 2;
                    if (qtdProdutos <= 0) continue;
                    for (int x = 0; x < qtdProdutos; ++x) {
                        ProdutoBombaCombustivel produtoBombaCombustivel = new ProdutoBombaCombustivel(bomba);
                        bomba.addProduto(produtoBombaCombustivel);
                        String codProduto = resposta.substring(offSet, offSet + 2);
                        produtoBombaCombustivel.setId(codProduto);
                        BigDecimal valor = new BigDecimal(resposta.substring(offSet += 2, offSet + 8));
                        offSet += 8;
                        valor = valor.movePointLeft(bomba.getCasasDecimais());
                    }
                }
            }
        }
        return dadosPista;
    }

    public StatusFusion preset(ProdutoBombaCombustivel produto, BombaFusion bomba, int tipo, int quantidade, String contexto) {
        String comando = "05";
        comando = comando + (bomba.getId() < 10 ? "0" + bomba.getId() : bomba.getId() + "");
        comando = comando + produto.getId();
        comando = comando + tipo;
        comando = comando + StringUtil.completaString(quantidade + "", 8, '0', true);
        comando = comando + contexto;
        String tam = StringUtil.completaString(comando.length() + 4 + "", 4, '0', true);
        comando = tam + comando;
        String resposta = this.executaComando(comando);
        StatusFusion statusFusion = new StatusFusion();
        int offSet = 0;
        Integer.parseInt(resposta.substring(offSet, offSet + 4));
        String codResp = resposta.substring(offSet += 4, offSet + 2);
        offSet += 2;
        if (!codResp.equals("06")) {
            logger.error("msg fussion invalida: req-> " + comando + ", resp-> " + resposta);
            return null;
        }
        statusFusion.setResultado(Integer.parseInt(resposta.substring(offSet, offSet + 2)));
        statusFusion.setStatusFusion(Integer.parseInt(resposta.substring(offSet += 2, offSet + 2)));
        offSet += 2;
        return statusFusion;
    }

    public StatusFusion preset(ProdutoBombaCombustivel produto, BombaFusion bomba, int quantidade, String contexto) {
        return this.preset(produto, bomba, 1, quantidade, contexto);
    }

    public StatusFusion preset(ProdutoBombaCombustivel produto, BombaFusion bomba, BigDecimal valor, String contexto) {
        valor = valor.movePointRight(bomba.getCasasDecimais());
        return this.preset(produto, bomba, 2, valor.intValue(), contexto);
    }

    public StatusPresetFusion statusPreset(String contexto) {
        String comando = "07";
        comando = comando + contexto;
        String tam = StringUtil.completaString(comando.length() + 4 + "", 4, '0', true);
        comando = tam + comando;
        String resposta = this.executaComando(comando);
        StatusPresetFusion statusPreset = new StatusPresetFusion();
        int offSet = 0;
        Integer.parseInt(resposta.substring(offSet, offSet + 4));
        String codResp = resposta.substring(offSet += 4, offSet + 2);
        offSet += 2;
        if (!codResp.equals("08")) {
            logger.error("msg fussion invalida: req-> " + comando + ", resp-> " + resposta);
            return null;
        }
        statusPreset.setResultado(Integer.parseInt(resposta.substring(offSet, offSet + 2)));
        statusPreset.setStatusFusion(Integer.parseInt(resposta.substring(offSet += 2, offSet + 2)));
        offSet += 2;
        if (statusPreset.getResultado() == 0) {
            statusPreset.setStatusPreset(Integer.parseInt(resposta.substring(offSet, offSet + 1)));
            statusPreset.setCodigoProduto(resposta.substring(++offSet, offSet + 2));
            BigDecimal volumeFinal = new BigDecimal(resposta.substring(offSet += 2, offSet + 8));
            volumeFinal = volumeFinal.movePointLeft(3);
            statusPreset.setVolumeFinal(volumeFinal);
            BigDecimal precoFinal = new BigDecimal(resposta.substring(offSet += 8, offSet + 8));
            precoFinal = precoFinal.movePointLeft(2);
            statusPreset.setPrecoFinal(precoFinal);
            BigDecimal precoUnitario = new BigDecimal(resposta.substring(offSet += 8, offSet + 8));
            precoUnitario = precoUnitario.movePointLeft(3);
            statusPreset.setPrecoUnitario(precoUnitario);
            statusPreset.setCodigoAutorizacaoFusion(resposta.substring(offSet += 8, offSet + 10));
            BombaFusion bomba = new BombaFusion();
            bomba.setId(Integer.parseInt(resposta.substring(offSet += 10, offSet + 2)));
            statusPreset.setBomba(bomba);
            offSet += 2;
        }
        return statusPreset;
    }

    public StatusFusion cancelarPreset(String contexto) {
        String comando = "09";
        comando = comando + contexto;
        String tam = StringUtil.completaString(comando.length() + 4 + "", 4, '0', true);
        comando = tam + comando;
        String resposta = this.executaComando(comando);
        StatusFusion statusFusion = new StatusFusion();
        int offSet = 0;
        Integer.parseInt(resposta.substring(offSet, offSet + 4));
        String codResp = resposta.substring(offSet += 4, offSet + 2);
        offSet += 2;
        if (!codResp.equals("10")) {
            logger.error("msg fussion invalida: req-> " + comando + ", resp-> " + resposta);
            return null;
        }
        statusFusion.setResultado(Integer.parseInt(resposta.substring(offSet, offSet + 2)));
        statusFusion.setStatusFusion(Integer.parseInt(resposta.substring(offSet += 2, offSet + 2)));
        offSet += 2;
        return statusFusion;
    }

    public StatusFusion finalizarPreset(String contexto) {
        String comando = "11";
        comando = comando + contexto;
        String tam = StringUtil.completaString(comando.length() + 4 + "", 4, '0', true);
        comando = tam + comando;
        String resposta = this.executaComando(comando);
        StatusFusion statusFusion = new StatusFusion();
        int offSet = 0;
        Integer.parseInt(resposta.substring(offSet, offSet + 4));
        String codResp = resposta.substring(offSet += 4, offSet + 2);
        offSet += 2;
        if (!codResp.equals("12")) {
            logger.error("msg fussion invalida: req-> " + comando + ", resp-> " + resposta);
            return null;
        }
        statusFusion.setResultado(Integer.parseInt(resposta.substring(offSet, offSet + 2)));
        statusFusion.setStatusFusion(Integer.parseInt(resposta.substring(offSet += 2, offSet + 2)));
        offSet += 2;
        return statusFusion;
    }

    public DadosListaPreset listarPresets() {
        String comando = "000613";
        String resposta = this.executaComando(comando);
        if (resposta == null || resposta.length() == 0) {
            return null;
        }
        DadosListaPreset dadosListaPreset = new DadosListaPreset();
        int offSet = 0;
        Integer.parseInt(resposta.substring(offSet, offSet + 4));
        String codResp = resposta.substring(offSet += 4, offSet + 2);
        offSet += 2;
        if (!codResp.equals("14")) {
            logger.error("msg fussion invalida: req-> " + comando + ", resp-> " + resposta);
            return null;
        }
        int contPresets = Integer.parseInt(resposta.substring(offSet, offSet + 2));
        offSet += 2;
        ArrayList<Preset> listPreset = new ArrayList<Preset>();
        for (int i = 0; i < contPresets; ++i) {
            Preset preset = new Preset();
            BombaFusion bombaFusion = new BombaFusion();
            ProdutoBombaCombustivel produto = new ProdutoBombaCombustivel(bombaFusion);
            bombaFusion.setId(Integer.parseInt(resposta.substring(offSet, offSet + 2)));
            String dataString = resposta.substring(offSet += 2, offSet + 12);
            try {
                preset.setDataCriacao(new SimpleDateFormat("yyyyMMddHHmm").parse(dataString));
            }
            catch (ParseException e) {
                logger.error("Erro ao formatar a data do Preset: " + e.getMessage());
            }
            produto.setId(resposta.substring(offSet += 12, offSet + 2));
            produto.setBomba(bombaFusion);
            preset.setProduto(produto);
            preset.setTipoPreset(Integer.parseInt(resposta.substring(offSet += 2, offSet + 1)));
            BigDecimal quantidadeAutorizada = new BigDecimal(resposta.substring(++offSet, offSet + 8));
            preset.setQuantidadeAutorizada(quantidadeAutorizada.movePointLeft(3));
            BigDecimal precoUnitario = new BigDecimal(resposta.substring(offSet += 8, offSet + 8));
            preset.setPrecoUnitario(precoUnitario.movePointLeft(3));
            preset.setStatusPreset(Integer.parseInt(resposta.substring(offSet += 8, offSet + 1)));
            BigDecimal valorFinal = new BigDecimal(resposta.substring(++offSet, offSet + 8));
            preset.setValorFinal(valorFinal.movePointLeft(2));
            BigDecimal volumeAbastecido = new BigDecimal(resposta.substring(offSet += 8, offSet + 8));
            preset.setVolumeAbastecido(volumeAbastecido.movePointLeft(3));
            int tamanhoContexto = Integer.parseInt(resposta.substring(offSet += 8, offSet + 4));
            preset.setContexto(resposta.substring(offSet += 4, offSet + tamanhoContexto));
            offSet += tamanhoContexto;
            listPreset.add(preset);
        }
        dadosListaPreset.setListPreset(listPreset);
        return dadosListaPreset;
    }

    public boolean isClosed() {
        return socket == null || socket.isClosed();
    }

    public void fecharSocket() {
        if (socket != null) {
            try {
                socket.close();
                socket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

