/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emvfull;

import java.nio.ByteBuffer;
import java.util.HashMap;

public class TLVProtocol {
    private static HashMap<ByteBuffer, byte[]> hashMap;

    public TLVProtocol(byte[] input) {
        hashMap = new HashMap();
        this.parseTLVData(input);
    }

    public TLVProtocol(char[] input) {
        hashMap = new HashMap();
        byte[] inputBuffer = TLVProtocol.charArrayToByteArray(input);
        this.parseTLVData(inputBuffer);
    }

    private static byte[] charArrayToByteArray(char[] input) {
        byte[] output = new byte[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = (byte)input[i];
        }
        return output;
    }

    private static int getTagBytesCount(byte[] input, int offset) {
        if ((input[offset] & 0x1F) == 31) {
            int len = 2;
            for (int i = offset + 1; i < offset + 10 && (input[i] & 0x80) == 128; ++i) {
                ++len;
            }
            return len;
        }
        return 1;
    }

    private static int getDataLength(byte[] input, int offset) {
        int length = input[offset] & 0xFF;
        if ((length & 0x80) == 128) {
            int numberOfBytes = length & 0x7F;
            if (numberOfBytes > 3) {
                throw new NumberFormatException(String.format("At position %d the length is more then 3 [%d]", offset, numberOfBytes));
            }
            length = 0;
            for (int i = offset + 1; i < offset + 1 + numberOfBytes; ++i) {
                length = length * 256 + (input[i] & 0xFF);
            }
        }
        return length;
    }

    private static int getLengthBytesCount(byte[] input, int offset) {
        int len = input[offset] & 0xFF;
        if ((len & 0x80) == 128) {
            return 1 + (len & 0x7F);
        }
        return 1;
    }

    private void parseTLVData(byte[] input) {
        if (input == null || input.length < 1) {
            throw new IllegalArgumentException("Invalid input arguments");
        }
        int tagBytesCount = 0;
        int lengthBytesCount = 0;
        int valueLength = 0;
        for (int offset = 0; offset < input.length; offset += tagBytesCount + lengthBytesCount + valueLength) {
            tagBytesCount = TLVProtocol.getTagBytesCount(input, offset);
            byte[] currentTag = new byte[tagBytesCount];
            System.arraycopy(input, offset, currentTag, 0, tagBytesCount);
            lengthBytesCount = TLVProtocol.getLengthBytesCount(input, offset + tagBytesCount);
            valueLength = TLVProtocol.getDataLength(input, offset + tagBytesCount);
            int remaining = input.length - (offset + tagBytesCount + lengthBytesCount + valueLength);
            if (remaining < 0) {
                throw new IndexOutOfBoundsException(String.format("Missing %d bytes from input buffer", remaining * -1));
            }
            byte[] value = new byte[valueLength];
            System.arraycopy(input, offset + tagBytesCount + lengthBytesCount, value, 0, valueLength);
            hashMap.put(ByteBuffer.wrap(currentTag), value);
        }
    }

    public byte[] getTLVData(char[] tag) {
        byte[] searchTag = TLVProtocol.charArrayToByteArray(tag);
        return hashMap.get(ByteBuffer.wrap(searchTag));
    }

    public byte[] getTLVData(byte[] tag) {
        return hashMap.get(ByteBuffer.wrap(tag));
    }
}

