/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emvfull;

import br.com.auttar.model.constants.EMVResponseCode;
import br.com.auttar.util.emv.CryptoKeyType;
import com.csi.ctfclient.apitef.model.IdRedeIndiceTabela;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.devices.emv.SaidaDefineWKPANEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGenericCmdEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetCardEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetTimeStampEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.emvfull.GenericPinpadController;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.util.StringUtil;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ProtocoloBibliotecaCompartilhada
extends GenericPinpadController {
    public ProtocoloBibliotecaCompartilhada(String port, String handler) throws ExcecaoPerifericos {
        super(port, handler);
        logger = CTFClientCore.getAuttarLoggerFactory().getLogger(ProtocoloBibliotecaCompartilhada.class);
    }

    @Deprecated
    public ProtocoloBibliotecaCompartilhada(GenericPinpadController other) {
        super(other);
    }

    private static String buildK3Command(int keyType, CryptoKeyType cryptoKeyType, int keyIndex) {
        return "02008K3" + keyType + cryptoKeyType.getProtocol() + StringUtil.completaString(String.valueOf(keyIndex), 2, '0', 3) + StringUtil.completaString(String.valueOf(keyIndex), 2, '0', 3);
    }

    @Override
    public String getTableVersion() {
        SaidaGetTimeStampEMV saidaGetTimeStampEMV = this.pinpad.getTimeStamp(this.getVersion(), "00".toCharArray());
        if (saidaGetTimeStampEMV != null && saidaGetTimeStampEMV.getRetorno() == EMVResponseCode.PP_OK.getId().intValue()) {
            return saidaGetTimeStampEMV.getTimeStamp();
        }
        return null;
    }

    @Override
    public boolean isPinpadAbecs() {
        return false;
    }

    @Override
    protected void setupSecureCommunication() throws ExcecaoPerifericos {
        try {
            if (StringUtils.isBlank(GenericPinpadController.getWkpan())) {
                logger.info("Habilitando comunica\u00e7\u00e3o segura...");
                String rsaPublicKey = KeyFactory.getRsaPublicKey();
                logger.info("Definindo WKPAN...");
                SaidaDefineWKPANEMV saidaDefineWKPANEMV = this.defineWKPAN(rsaPublicKey.toCharArray());
                if (saidaDefineWKPANEMV.getRetorno() == EMVResponseCode.PP_INVCALL.getId().intValue()) {
                    logger.warn("Dispositivo nao suporta conexao segura, desligando");
                    ProtocoloBibliotecaCompartilhada.setSecureCommunication(false);
                    return;
                }
                ProtocoloBibliotecaCompartilhada.validateReturn(saidaDefineWKPANEMV.getRetorno(), "defineWKPAN");
                logger.info("WKPAN definida");
                if (!KeyFactory.isChaveLocal()) {
                    logger.info("comunicacao segura em modo remoto habilitado...");
                    GenericPinpadController.setWkpan(saidaDefineWKPANEMV.getCertificado());
                    return;
                }
                String certificado = saidaDefineWKPANEMV.getCertificado();
                if (!("T".equals(saidaDefineWKPANEMV.getCabecalho()) && "1".equals(saidaDefineWKPANEMV.getVersao()) && "X".equals(saidaDefineWKPANEMV.getFinalizador()))) {
                    logger.error("Certificado gerado pelo pinpad inv\u00e1lido: ".concat(certificado));
                    throw new ExcecaoPerifericos("PBC01", "ERRO COMUNICACAO SEGURA", "Certificado gerado pelo pinpad inv\u00e1lido = " + certificado, CodigoErroIntegracaoEnum.MSG_ERRO_COMUNICACAO_SEGURA);
                }
                logger.info("O certificado gerado pelo pinpad \u00e9 v\u00e1lido!");
                ProtocoloBibliotecaCompartilhada.setWkpan(certificado.substring(11, 43));
            } else {
                logger.info("Comunica\u00e7\u00e3o segura ja habilitada");
            }
        }
        catch (Exception e) {
            logger.error("Erro ao habilitar a comunica\u00e7\u00e3o segura com o pinpad, fechando a comunica\u00e7\u00e3o...");
            throw e;
        }
    }

    @Override
    public char[] getVersion() {
        return BC_VERSION;
    }

    @Override
    public char[] prepareClosePrompt(char[] promptMessage) {
        return promptMessage;
    }

    private SaidaDefineWKPANEMV defineWKPAN(char[] input) {
        return this.pinpad.defineWKPAN(BC_VERSION, input);
    }

    private char[] formataTags(String t) {
        if (t != null) {
            String tam = StringUtil.completaString("" + t.length() / 2, 3, '0', true);
            return (tam + t).toCharArray();
        }
        return "000".toCharArray();
    }

    @Override
    public char[] buildStartGetCardParameters(LeitorCartao cardReader) {
        Date dt = cardReader.getDataTransacao();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmss");
        StringBuilder stringBuffer = new StringBuilder();
        DecimalFormat numberFormat1 = new DecimalFormat("00");
        DecimalFormat numberFormat2 = new DecimalFormat("000000000000");
        GenericPinpadController.ParamsReleituraGetCard paramsReleitura = this.buildParamsReleituraGetCard(cardReader);
        stringBuffer.append(numberFormat1.format(paramsReleitura.getRedeAdq()));
        stringBuffer.append(numberFormat1.format(paramsReleitura.getTipoAplicacao()));
        stringBuffer.append(numberFormat2.format(cardReader.getValorInicialTransacao()));
        stringBuffer.append(dateFormat.format(dt));
        stringBuffer.append(cardReader.getTimeStamp());
        stringBuffer.append(paramsReleitura.getIdsAceitos());
        Integer flag_contacless = null;
        if (this.saidaGetInfoEMV.getVersaoEspecificacao().compareTo("1.08") >= 0) {
            flag_contacless = Boolean.compare(cardReader.isActiveContactless(), false);
            stringBuffer.append(flag_contacless);
        }
        logger.debug("buildStartGetCardParameters - idsAceitos=" + paramsReleitura.getIdsAceitos() + " tipoAplicacao=" + paramsReleitura.getTipoAplicacao() + " idRedeAquirente=" + paramsReleitura.getRedeAdq() + " valorInicialTransacao=" + cardReader.getValorInicialTransacao() + " timestamp=" + cardReader.getTimeStamp() + " contacless=" + flag_contacless);
        String cmd = stringBuffer.toString();
        logger.debug(String.format("startGetCard(%s)", cmd));
        return cmd.toCharArray();
    }

    @Override
    public char[] buildStartCheckEventParameters(Integer checkKEY, Integer checkMAG, Integer checkICC, Integer checkCTLS) {
        String checkEventParam = checkKEY.toString();
        checkEventParam = checkEventParam + checkMAG.toString();
        checkEventParam = checkEventParam + checkICC.toString();
        checkEventParam = checkEventParam + checkCTLS.toString();
        logger.debug(String.format("startCheckEvent(%s)", checkEventParam));
        return checkEventParam.toCharArray();
    }

    @Override
    public char[] buildStartGenericCommandTag84Parameters(SaidaGetCardEMV getCardOut) {
        int idRede = getCardOut.getIdRedeAdquirente();
        String parameters = null;
        if (idRede == 4) {
            parameters = "040070400184";
        } else if (idRede == 3) {
            parameters = "030040284";
        }
        logger.debug("Par\u00e2metros startGenericCommandTag84 = " + parameters);
        if (parameters != null) {
            return parameters.toCharArray();
        }
        return null;
    }

    @Override
    public boolean containsKey(int keyType, CryptoKeyType cryptoKeyType, int keyIndex) throws ExcecaoPerifericos {
        logger.debug(String.format("containsKeyBc(%d, %s, %d)", keyType, cryptoKeyType.getProtocol(), keyIndex));
        String genericCommandParams = ProtocoloBibliotecaCompartilhada.buildK3Command(keyType, cryptoKeyType, keyIndex);
        int startGenericCmdResponse = this.startGenericCmd(genericCommandParams.toCharArray());
        ProtocoloBibliotecaCompartilhada.validateReturn(startGenericCmdResponse, "startGenericCmd");
        SaidaGenericCmdEMV saidaGenericCmdEMV = this.genericCmd();
        if (null == saidaGenericCmdEMV) {
            throw new ExcecaoPerifericos("PBC02", "Erro ao ler resposta da GenericCommand");
        }
        ProtocoloBibliotecaCompartilhada.validateReturn(saidaGenericCmdEMV.getRetorno(), "genericCmd");
        String replyK3 = saidaGenericCmdEMV.getBufferResposta();
        if (null == replyK3) {
            throw new ExcecaoPerifericos("PBC03", "A solicitacao K3 nao teve resposta");
        }
        int bufferLength = 0;
        if (replyK3.length() >= 3) {
            try {
                bufferLength = Integer.parseInt(replyK3.substring(0, 3));
            }
            catch (NumberFormatException e) {
                throw new ExcecaoPerifericos("PBC04", "Erro ao converter em num\u00e9rico o tamanho do buffer de resposta do GenericCommand", e);
            }
        }
        if (replyK3.length() < 4 || bufferLength <= 0) {
            throw new ExcecaoPerifericos("PBC05", String.format("Tamanho inv\u00e1lido da resposta do K3, buffer: '%s'", replyK3));
        }
        int keyState = Integer.parseInt(replyK3.substring(3, 4));
        switch (keyState) {
            case 0: {
                logger.debug("Retorno K3: Chave ausente");
                return false;
            }
            case 1: {
                logger.debug("Retorno K3: Chave presente");
                return true;
            }
            case 2: {
                logger.debug("Retorno K3: Chave n\u00e3o suportada");
                return false;
            }
        }
        throw new ExcecaoPerifericos("PBC05", "Retorno K3 n\u00e3o tratado: " + keyState);
    }

    @Override
    public char[] buildGetInfoParameters() {
        String getInfoParameters = "00";
        logger.debug(String.format("getInfo(%s)", getInfoParameters));
        return getInfoParameters.toCharArray();
    }

    @Override
    public char[] buildEncryptBufferParameters(int tipoCriptografia, int indiceMasterKey, String workingKey, byte[] dados, byte[] initializationVector) {
        return new char[0];
    }

    @Override
    public char[] buildGoOnChipParameters(BibliotecaPinpad reader) {
        String tmpDadosRestantes;
        if (reader.getDadosRestantes() == null) {
            tmpDadosRestantes = "000";
        } else {
            DecimalFormat decimalFormat = new DecimalFormat("000");
            tmpDadosRestantes = decimalFormat.format(reader.getDadosRestantes().length()) + reader.getDadosRestantes();
        }
        String workingKey = StringUtil.completaString(reader.getWorkingKey(), 32, '0', false);
        String cmdGoOnChip = StringUtil.sprintf("%012ld%012ld%d%d%d%d%02d%s%d%s%02d%s%02d%s", new Object[]{reader.getNovoValorTransacao(), reader.getParcelaValorTransacao(), reader.getConstaListaNegra() ? 1 : 0, reader.getObrigaTransacaoOnline() ? 1 : 0, reader.getReqPINTabelasServTEF() ? 1 : 0, reader.getTipoCriptografia(), reader.getIndiceMasterKey(), workingKey, reader.getGerencRisco() ? 1 : 0, reader.getTermFloorLimit(), reader.getTargetPercBiasedRandomSelection(), reader.getThresholdValueBiasedRandomSelection(), reader.getMaxTargetPerc(), tmpDadosRestantes});
        return cmdGoOnChip.toCharArray();
    }

    @Override
    public char[] buildMandatoryTags(BibliotecaPinpad pinpadLibrary) {
        return this.formataTags(pinpadLibrary.getTags());
    }

    @Override
    public char[] buildOptionalTags(BibliotecaPinpad pinpadLibrary) {
        return this.formataTags(pinpadLibrary.getTagsOpt());
    }

    @Override
    public char[] buildFinishChipParameters(BibliotecaPinpad pinpadLibrary) {
        String responseCode;
        String dadosRestantes = pinpadLibrary.getDadosRestantes();
        if (dadosRestantes == null) {
            dadosRestantes = "";
        }
        if ((responseCode = pinpadLibrary.getAuthRespCode()).length() == 3) {
            responseCode = responseCode.substring(1);
        }
        return StringUtil.sprintf("%d%d%s%03d%s%03d%s", new Object[]{pinpadLibrary.getComunicacaoHost(), pinpadLibrary.getTipoEmissor(), responseCode, pinpadLibrary.getCampo55().length() / 2, pinpadLibrary.getCampo55(), dadosRestantes.length() / 2, dadosRestantes}).toCharArray();
    }

    @Override
    public GenericPinpadController.ParamsReleituraGetCard buildParamsReleituraGetCard(LeitorCartao leitor) {
        if (ProtocoloBibliotecaCompartilhada.isNecessarioReleituraComRedeEIndice(leitor)) {
            return new GenericPinpadController.ParamsReleituraGetCard(leitor.getIdRedeAdquirente(), 0, "01" + IdRedeIndiceTabela.getInstance(leitor.getIdRedeAdquirente(), leitor.getIndiceAID()));
        }
        if (ProtocoloBibliotecaCompartilhada.isNecessarioReleituraComRedeSemIndice(leitor)) {
            return new GenericPinpadController.ParamsReleituraGetCard(leitor.getIdRedeAdquirente(), leitor.getTipoAplicacao(), "00");
        }
        return new GenericPinpadController.ParamsReleituraGetCard(0, 0, leitor.getAidList());
    }
}

