/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emvfull;

import br.com.auttar.model.constants.EMVDadosPin;
import br.com.auttar.util.emv.CryptoKeyType;
import br.com.auttar.util.emv.abecs.CryptoParamsService;
import br.com.auttar.util.emv.abecs.CtfDataCryptoType;
import br.com.auttar.util.emv.abecs.TagBuilder;
import com.csi.ctfclient.apitef.model.IdRedeIndiceTabela;
import com.csi.ctfclient.excecoes.ExcecaoDadoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoHexaInvalido;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.excecoes.InvalidDataException;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.ConstantesAbecs;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.devices.emv.ParamAbecs;
import com.csi.ctfclient.tools.devices.emv.SaidaGetCardEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetClearData;
import com.csi.ctfclient.tools.devices.emv.SaidaGetTracks;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.emvfull.GenericPinpadController;
import com.csi.ctfclient.tools.util.ByteUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.DisplayFisicoCSILanguage;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;

public class ProtocoloAbecs
extends GenericPinpadController {
    public ProtocoloAbecs(String port, String handler) throws ExcecaoPerifericos {
        super(port, handler);
        logger = CTFClientCore.getAuttarLoggerFactory().getLogger(ProtocoloAbecs.class);
    }

    @Deprecated
    public ProtocoloAbecs(GenericPinpadController other) {
        super(other);
    }

    public static char[] montaCmdBlk(ParamAbecs<?, ?> ... params) {
        StringBuilder sb = new StringBuilder();
        for (ParamAbecs<?, ?> par : params) {
            Object[] dado;
            if (par == null) continue;
            Object k = par.getId();
            if (!(k instanceof char[])) {
                return null;
            }
            sb.append((char[])k);
            Object dados = par.getDados();
            if (dados instanceof String) {
                sb.appendCodePoint(((String)dados).length() / 256);
                sb.appendCodePoint(((String)dados).length() % 256);
                sb.append(dados);
                continue;
            }
            if (dados instanceof byte[]) {
                dado = (byte[])dados;
                sb.appendCodePoint(dado.length / 256);
                sb.appendCodePoint(dado.length % 256);
                sb.append(StringUtil.byteArrayToCharArray(dado));
                continue;
            }
            if (dados instanceof char[]) {
                dado = (char[])dados;
                sb.appendCodePoint(dado.length / 256);
                sb.appendCodePoint(dado.length % 256);
                sb.append((char[])dado);
                continue;
            }
            if (dados instanceof char[][]) {
                char[][] arrDados = (char[][])dados;
                sb.appendCodePoint(arrDados.length * 2 / 256);
                sb.appendCodePoint(arrDados.length * 2 % 256);
                for (char[] dado2 : arrDados) {
                    sb.append(dado2);
                }
                continue;
            }
            return null;
        }
        return sb.toString().toCharArray();
    }

    public static String getValorParam(char[] id, byte[] bloco) {
        try {
            byte[] byteTag = ProtocoloAbecs.getByteTag(id, bloco);
            if (byteTag != null) {
                return new String(byteTag, StandardCharsets.ISO_8859_1);
            }
        }
        catch (Exception e) {
            logger.warn("N\u00e3o foi poss\u00edvel ler o tag {}: {}", StringUtil.charArrayToHexString(id), e.getMessage());
        }
        return null;
    }

    public static byte[] getByteTag(char[] id, byte[] block) {
        String blockString = new String(block, StandardCharsets.ISO_8859_1);
        String idString = StringUtil.charArrayToHexString(id);
        int pos = blockString.indexOf(new String(id));
        if (pos == -1) {
            logger.info("Tag {} n\u00e3o foi enviado pelo pinpad", idString);
            return null;
        }
        int tam = block[pos + 2] << 8 & 0xFF;
        int initialPosition = pos + 4;
        int finalPosition = pos + 4 + (tam += block[pos + 3] % 256 & 0xFF);
        logger.debug("Lendo tag ABECS {} no bloco entre [{}, {})", idString, initialPosition, finalPosition);
        try {
            return ByteUtil.copyRange(block, initialPosition, tam);
        }
        catch (Exception e) {
            logger.warn((Object)("N\u00e3o foi poss\u00edvel ler o tag " + idString), e);
            return null;
        }
    }

    public static char[] buildGetClearDataParameters(DadoSolicitaPin data) throws InvalidDataException {
        char[] index;
        int tamMin = data.getTamMin();
        int tamMax = data.getTamMax();
        int indMsg = data.getIndiceMensagem();
        switch (EMVDadosPin.getEnumByKey(indMsg)) {
            case IND_DIGITE_DDD: {
                index = ConstantesAbecs.SPE_MSGIDX_TYPE_DDD;
                break;
            }
            case IND_REDIGITE_DDD: {
                index = ConstantesAbecs.SPE_MSGIDX_RETYPE_DDD;
                break;
            }
            case IND_DIGITE_TELEFONE: {
                index = ConstantesAbecs.SPE_MSGIDX_TYPE_TELEPHONE;
                break;
            }
            case IND_REDIGITE_TELEFONE: {
                index = ConstantesAbecs.SPE_MSGIDX_RETYPE_TELEPHONE;
                break;
            }
            case IND_DIGITE_DDD_TELEFONE: {
                index = ConstantesAbecs.SPE_MSGIDX_TYPE_DDD_TELEPHONE;
                break;
            }
            case IND_REDIGITE_DDD_TELEFONE: {
                index = ConstantesAbecs.SPE_MSGIDX_RETYPE_DDD_TELEPHONE;
                break;
            }
            case IND_DIGITE_CPF: {
                index = ConstantesAbecs.SPE_MSGIDX_TYPE_CPF;
                break;
            }
            case IND_REDIGITE_CPF: {
                index = ConstantesAbecs.SPE_MSGIDX_RETYPE_CPF;
                break;
            }
            case IND_DIGITE_RG: {
                index = ConstantesAbecs.SPE_MSGIDX_TYPE_RG;
                break;
            }
            case IND_REDIGITE_RG: {
                index = ConstantesAbecs.SPE_MSGIDX_RETYPE_RG;
                break;
            }
            case IND_DIGITE_ULT_4_DIG: {
                index = ConstantesAbecs.SPE_MSGIDX_TYPE_LAST_4_DIG;
                break;
            }
            case IND_DIGITE_COD_SEG: {
                index = ConstantesAbecs.SPE_MSGIDX_TYPE_SEC_CODE;
                break;
            }
            default: {
                throw new InvalidDataException("PA02", "Valor inv\u00e1lido para o parametro SPE_MSGIDX", Integer.toString(indMsg));
            }
        }
        ParamAbecs<char[], char[]> par1 = new ParamAbecs<char[], char[]>(ConstantesAbecs.SPE_MSGIDX, index);
        ParamAbecs<char[], char[]> par2 = new ParamAbecs<char[], char[]>(ConstantesAbecs.SPE_MINDIG, new char[]{(char)tamMin});
        ParamAbecs<char[], char[]> par3 = new ParamAbecs<char[], char[]>(ConstantesAbecs.SPE_MAXDIG, new char[]{(char)tamMax});
        logger.debug("buildGetClearDataParameters {SPE_MSGIDX=" + par1 + ", SPE_MINDIG=" + par2 + ", SPE_MAXDIG=" + par3 + '\'' + '}');
        return ProtocoloAbecs.montaCmdBlk(par1, par2, par3);
    }

    @Override
    public String getTableVersion() {
        return this.getInfoEMV().getTableVersion();
    }

    @Override
    public boolean isPinpadAbecs() {
        return true;
    }

    @Override
    public char[] getVersion() {
        return ABECS_VERSION;
    }

    @Override
    public char[] prepareClosePrompt(char[] promptMessage) {
        StringBuilder sb = new StringBuilder();
        sb.append('\r');
        sb.append('\r');
        if (promptMessage.length > 16) {
            sb.append(String.valueOf(promptMessage), 0, 16);
            sb.append('\r');
            sb.append(String.valueOf(promptMessage).substring(16));
        } else {
            sb.append(promptMessage);
        }
        ParamAbecs<char[], String> par = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_DSPMSG, sb.toString());
        logger.debug("prepareClosePrompt {SPE_DSPMSG=" + par + '\'' + '}');
        return ProtocoloAbecs.montaCmdBlk(par);
    }

    public void displayImage(char[] imageName, char[] imageExtension, byte[] imageBuffer) {
        int result = this.pinpad.displayImage(ABECS_VERSION, imageName, imageExtension, imageBuffer, imageBuffer.length);
        logger.info("Retorno 'displayImage' = " + result);
    }

    public void removeImage(char[] imageName) {
        int result = this.pinpad.removeImage(ABECS_VERSION, imageName);
        logger.info("Retorno 'removeImage' = " + result);
    }

    public int startGetClearData(char[] input) {
        return this.pinpad.startGetClearData(ABECS_VERSION, input, input.length);
    }

    public SaidaGetClearData getClearData() {
        return this.pinpad.getClearData(ABECS_VERSION);
    }

    @Override
    public char[] buildGoOnChipParameters(BibliotecaPinpad pinpadLibrary) {
        DecimalFormat numFmt = new DecimalFormat("00");
        char[] goxOpt = new char[]{'0', '0', '0', '0', '0'};
        String workingKey = pinpadLibrary.getWorkingKey();
        ParamAbecs<char[], String> acquirerIdTag = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_ACQREF, numFmt.format(pinpadLibrary.getIdRedeAdquirente()));
        numFmt.applyPattern("000000000000");
        ParamAbecs<char[], String> amountTag = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_AMOUNT, numFmt.format(pinpadLibrary.getNovoValorTransacao()));
        ParamAbecs<char[], String> cashbackTag = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_CASHBACK, numFmt.format(pinpadLibrary.getParcelaValorTransacao()));
        if (pinpadLibrary.getConstaListaNegra()) {
            goxOpt[0] = 49;
        }
        if (pinpadLibrary.getObrigaTransacaoOnline()) {
            goxOpt[1] = 49;
        }
        if (pinpadLibrary.getReqPINTabelasServTEF()) {
            goxOpt[2] = 49;
        }
        ParamAbecs<char[], String> optionalTag = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_GOXOPT, String.valueOf(goxOpt));
        ParamAbecs<char[], String> pinEncryptionMethodTag = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_MTHDPIN, String.valueOf(pinpadLibrary.getTipoCriptografia()));
        numFmt.applyPattern("00");
        ParamAbecs<char[], String> keyIndexTag = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_KEYIDX, numFmt.format(pinpadLibrary.getIndiceMasterKey()));
        if (workingKey.length() < 16) {
            workingKey = StringUtil.completaString(pinpadLibrary.getWorkingKey(), 16, '0', false);
        } else if (workingKey.length() > 16) {
            workingKey = StringUtil.completaString(pinpadLibrary.getWorkingKey(), 32, '0', false);
        }
        byte[] bytesWK = null;
        try {
            bytesWK = ByteUtil.hexToByteArray(workingKey);
        }
        catch (Exception e) {
            logger.error("Erro ao converter working key em array de bytes!");
        }
        ParamAbecs<char[], char[]> workingKeyTag = new ParamAbecs<char[], char[]>(ConstantesAbecs.SPE_WKENC, StringUtil.byteArrayToCharArray(bytesWK));
        byte[] termFloorLimit = new byte[4];
        try {
            termFloorLimit = ByteUtil.hexToByteArray(pinpadLibrary.getTermFloorLimit());
        }
        catch (Exception e) {
            logger.error("Erro ao converter 'term floor limit' em array de bytes!");
        }
        byte[] thrsValBiasedRndSel = new byte[4];
        try {
            thrsValBiasedRndSel = ByteUtil.hexToByteArray(pinpadLibrary.getThresholdValueBiasedRandomSelection());
        }
        catch (Exception e) {
            logger.error("Erro ao converter 'threshold value for biased random selection' em array de bytes!");
        }
        byte[] arrData = new byte[10];
        System.arraycopy(termFloorLimit, 0, arrData, 0, 4);
        arrData[4] = (byte)pinpadLibrary.getTargetPercBiasedRandomSelection();
        System.arraycopy(thrsValBiasedRndSel, 0, arrData, 5, 4);
        arrData[9] = (byte)pinpadLibrary.getMaxTargetPerc();
        ParamAbecs<char[], char[]> terminalParametersTag = new ParamAbecs<char[], char[]>(ConstantesAbecs.SPE_TRMPAR, StringUtil.byteArrayToCharArray(arrData));
        String tags = pinpadLibrary.getTags();
        ParamAbecs<char[], byte[]> tagList = null;
        if (tags != null && tags.trim().length() > 0) {
            String tagsOpt = pinpadLibrary.getTagsOpt();
            if (tagsOpt != null) {
                tags = tags + tagsOpt;
            }
            try {
                byte[] byteTags = ByteUtil.hexToByteArray(tags);
                tagList = new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_TAGLIST, byteTags);
            }
            catch (Exception e) {
                logger.error("Erro ao converter string hexa em um array de bytes!");
            }
        }
        logger.debug(String.format("buildGoOnChipParameters: idRedeAdquirente=%s, novoValorTransacao=%s, parcelaValorTransacao=%s, tagsOpcionais=%s, tipoCriptografia=%s, indiceMasterKey=%s, =%s parametrosTerminal=%s, tags=%s", pinpadLibrary.getIdRedeAdquirente(), pinpadLibrary.getNovoValorTransacao(), pinpadLibrary.getParcelaValorTransacao(), String.valueOf(goxOpt), pinpadLibrary.getTipoCriptografia(), pinpadLibrary.getIndiceMasterKey(), StringUtil.StringArrayToHexString(workingKey), Arrays.toString(StringUtil.byteArrayToCharArray(arrData)), pinpadLibrary.getTags()));
        return ProtocoloAbecs.montaCmdBlk(acquirerIdTag, amountTag, cashbackTag, optionalTag, pinEncryptionMethodTag, keyIndexTag, workingKeyTag, terminalParametersTag, tagList);
    }

    @Override
    public char[] buildMandatoryTags(BibliotecaPinpad pinpadLibrary) {
        return null;
    }

    @Override
    public char[] buildOptionalTags(BibliotecaPinpad pinpadLibrary) {
        return null;
    }

    @Override
    public char[] buildFinishChipParameters(BibliotecaPinpad pinpadLibrary) {
        char[] fcxOpt = new char[]{'0', '0', '0', '0'};
        String responseCode = pinpadLibrary.getAuthRespCode();
        if (pinpadLibrary.getComunicacaoHost() != 0) {
            fcxOpt[0] = 50;
        } else if (!responseCode.equals("00") && !responseCode.equals("000")) {
            fcxOpt[0] = 49;
        }
        ParamAbecs<char[], String> tagFcxOpt = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_FCXOPT, String.valueOf(fcxOpt));
        if (responseCode.length() == 3) {
            responseCode = responseCode.substring(1);
        }
        ParamAbecs<char[], String> tagArc = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_ARC, responseCode);
        String finishChipEmvData = pinpadLibrary.getCampo55();
        ParamAbecs<char[], byte[]> tagEmvData = null;
        if (finishChipEmvData != null) {
            try {
                tagEmvData = new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_EMVDATA, ByteUtil.hexToByteArray(finishChipEmvData));
            }
            catch (ExcecaoHexaInvalido e) {
                logger.warn("N\u00e3o foi poss\u00edvel montar tag SPE_EMVDATA: " + e.getMessage());
                logger.warn("Dados que seriam enviados para FinishChip = " + finishChipEmvData);
            }
        }
        String finishChipTags = pinpadLibrary.getTags();
        ParamAbecs<char[], byte[]> tagList = null;
        if (finishChipTags != null) {
            try {
                tagList = new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_TAGLIST, ByteUtil.hexToByteArray(finishChipTags));
            }
            catch (ExcecaoHexaInvalido e) {
                logger.warn("N\u00e3o foi poss\u00edvel montar tag SPE_TAGLIST: " + e.getMessage());
                logger.warn("Dados que seriam enviados para FinishChip = " + finishChipTags);
            }
        }
        logger.debug("buildFinishChipParameters {tagFcxOpt=" + tagFcxOpt + ", tagArc=" + tagArc + ", tagEmvData=" + tagEmvData + ", tagList=" + tagList + '\'' + '}');
        return ProtocoloAbecs.montaCmdBlk(tagFcxOpt, tagArc, tagEmvData, tagList);
    }

    @Override
    public char[] buildGetInfoParameters() {
        String sb = String.valueOf(ConstantesAbecs.PP_MNNAME) + String.valueOf(ConstantesAbecs.PP_MODEL) + String.valueOf(ConstantesAbecs.PP_SOVER) + String.valueOf(ConstantesAbecs.PP_SPECVER) + String.valueOf(ConstantesAbecs.PP_MANVERS) + String.valueOf(ConstantesAbecs.PP_SERNUM) + String.valueOf(ConstantesAbecs.PP_DSPGRSZ) + String.valueOf(ConstantesAbecs.PP_MFSUP) + String.valueOf(ConstantesAbecs.PP_CAPAB) + String.valueOf(ConstantesAbecs.PP_DSPTXTSZ) + String.valueOf(ConstantesAbecs.PP_MKTDESP) + String.valueOf(ConstantesAbecs.PP_MKTDESD) + String.valueOf(ConstantesAbecs.PP_MKDESP) + String.valueOf(ConstantesAbecs.PP_MKDESD) + String.valueOf(ConstantesAbecs.PP_DKPTTDESP) + String.valueOf(ConstantesAbecs.PP_DKPTTDESD) + String.valueOf(ConstantesAbecs.PP_TABVER00) + String.valueOf(ConstantesAbecs.PP_KRNLVER) + String.valueOf(ConstantesAbecs.PP_CTLSVER) + String.valueOf(ConstantesAbecs.PP_MCTLSVER) + String.valueOf(ConstantesAbecs.PP_VCTLSVER) + String.valueOf(ConstantesAbecs.PP_AECTLSVER) + String.valueOf(ConstantesAbecs.PP_DPCTLSVER) + String.valueOf(ConstantesAbecs.PP_PUREVER);
        ParamAbecs<char[], String> param = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_IDLIST, sb);
        logger.debug("buildGetInfoParameters {SPE_IDLIST=" + param + '}');
        return ProtocoloAbecs.montaCmdBlk(param);
    }

    public SaidaGetTracks getTracks(String tracks, Integer ctfCryptoType, Integer keyIndex, String workingKey, byte[] initializationVector, byte[] rsaModule, byte[] rsaExponent, Integer openDigits) {
        char[] input = this.buildGetTracksParameters(tracks, ctfCryptoType, keyIndex, workingKey, initializationVector, rsaModule, rsaExponent, openDigits);
        return this.pinpad.getTracks(ABECS_VERSION, input, input.length);
    }

    @Override
    public char[] buildEncryptBufferParameters(int tipoCriptografia, int indiceMasterKey, String workingKey, byte[] dados, byte[] initializationVector) {
        ParamAbecs<char[], byte[]> tagGenericData = null;
        try {
            char[] val = StringUtil.byteArrayToCharArray(dados);
            byte[] dado = ByteUtil.hexToByteArray(String.valueOf(val));
            tagGenericData = new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_DATAIN, dado);
        }
        catch (ExcecaoHexaInvalido e) {
            logger.warn("buildEncryptBufferParameters: Nao foi possivel construir o parametro SPE_DATAIN: " + e.getMessage());
        }
        CryptoParamsService cryptoParamsService = new CryptoParamsService();
        ParamAbecs<char[], String> tagCryptoMethod = null;
        try {
            tagCryptoMethod = cryptoParamsService.getDataEncryptMethod(tipoCriptografia);
        }
        catch (ExcecaoDadoInvalido excecaoDadoInvalido) {
            logger.warn("buildEncryptBufferParameters: Nao foi possivel construir o parametro SPE_MTHDDAT: " + excecaoDadoInvalido.getMessage());
        }
        ParamAbecs<char[], byte[]> tagInitializationVector = null;
        try {
            tagInitializationVector = cryptoParamsService.setInitializationVector(initializationVector);
        }
        catch (ExcecaoDadoInvalido excecaoDadoInvalido) {
            logger.warn("buildEncryptBufferParameters: Nao foi possivel construir o parametro SPE_IVCBC: " + excecaoDadoInvalido.getMessage());
        }
        DecimalFormat keyIndexFormat = new DecimalFormat("00");
        ParamAbecs<char[], String> tagKeyIndex = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_KEYIDX, keyIndexFormat.format(indiceMasterKey));
        ParamAbecs<char[], byte[]> tagWorkingKey = null;
        try {
            CtfDataCryptoType ctfCryptoType = CtfDataCryptoType.toEnum(tipoCriptografia);
            if (CtfDataCryptoType.DES.equals((Object)ctfCryptoType) || CtfDataCryptoType.TDES.equals((Object)ctfCryptoType) || CtfDataCryptoType.TDES_CBC.equals((Object)ctfCryptoType)) {
                byte[] bytesWK = ByteUtil.hexToByteArray(workingKey);
                tagWorkingKey = new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_WKENC, bytesWK);
            } else {
                logger.info("buildEncryptBufferParameters: Ignorando parametro working key para criptografias DUKPT");
            }
        }
        catch (Exception e) {
            logger.warn("buildEncryptBufferParameters: Erro ao converter working key em array de bytes:" + e.getMessage());
        }
        logger.debug("buildEncryptBufferParameters {SPE_DATAIN=(tamanho)" + (tagGenericData != null ? Integer.valueOf(ObjectUtils.defaultIfNull(tagGenericData.getDados(), ByteUtil.VAZIO).length) : null) + ", SPE_MTHDDAT=" + (tagCryptoMethod != null ? (String)ObjectUtils.defaultIfNull(tagCryptoMethod.getDados(), null) : null) + ", SPE_KEYIDX=" + (String)ObjectUtils.defaultIfNull(tagKeyIndex.getDados(), null) + ", SPE_WKENC=" + (tagWorkingKey != null ? ByteUtil.byteArrayToHex(ObjectUtils.defaultIfNull(tagWorkingKey.getDados(), null)) : null) + ", SPE_IVCBC=" + (tagInitializationVector != null ? Integer.valueOf(ObjectUtils.defaultIfNull(tagInitializationVector.getDados(), ByteUtil.VAZIO).length) : null) + '}');
        return ProtocoloAbecs.montaCmdBlk(tagGenericData, tagCryptoMethod, tagKeyIndex, tagWorkingKey, tagInitializationVector);
    }

    @Override
    public char[] buildStartGetCardParameters(LeitorCartao cardReader) {
        String displayMessage;
        String getCardOptions;
        SimpleDateFormat dtFmt = new SimpleDateFormat("yyMMdd");
        DecimalFormat numFmt = new DecimalFormat("00");
        Date dtTrans = cardReader.getDataTransacao();
        GenericPinpadController.ParamsReleituraGetCard paramsReleitura = this.buildParamsReleituraGetCard(cardReader);
        ParamAbecs<char[], String> speACQREF = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_ACQREF, numFmt.format(paramsReleitura.getRedeAdq()));
        ParamAbecs<char[], String> speAIDLIST = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_AIDLIST, paramsReleitura.getIdsAceitos());
        ParamAbecs<char[], String> speAPPTYPE = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_APPTYPE, numFmt.format(paramsReleitura.getTipoAplicacao()));
        numFmt.applyPattern("000000000000");
        ParamAbecs<char[], String> speAMOUNT = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_AMOUNT, numFmt.format(cardReader.getValorInicialTransacao()));
        ParamAbecs<char[], String> speTRNDATE = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_TRNDATE, dtFmt.format(dtTrans));
        dtFmt.applyPattern("HHmmss");
        ParamAbecs<char[], String> speTRNTIME = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_TRNTIME, dtFmt.format(dtTrans));
        if (cardReader.isActiveContactless()) {
            getCardOptions = "11000";
            displayMessage = new DisplayFisicoCSILanguage().getMessage(MessageEnum.LEICAR_TITLE_CONTACTLESS3);
        } else {
            getCardOptions = "01000";
            displayMessage = new DisplayFisicoCSILanguage().getMessage(MessageEnum.LEICAR_TITLE1);
        }
        ParamAbecs<char[], String> speGCXOPT = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_GCXOPT, getCardOptions);
        ParamAbecs<char[], String> speDSPMSG = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_DSPMSG, displayMessage);
        char[] emvTagList = new char[]{'\u0084', '\u009f', '\u0007'};
        ParamAbecs<char[], char[]> speTAGLIST = new ParamAbecs<char[], char[]>(ConstantesAbecs.SPE_TAGLIST, emvTagList);
        ParamAbecs<char[], char[]> speTRNTYPE = cardReader.getTipoTransacaoEfetuada() != null ? new ParamAbecs<char[], char[]>(ConstantesAbecs.SPE_TRNTYPE, cardReader.getTipoTransacaoEfetuada().getValor()) : null;
        logger.debug("buildStartGetCardParameters {speAMOUNT=" + speAMOUNT.getDados() + ", speTRNDATE=" + speTRNDATE.getDados() + ", speTRNTIME=" + speTRNTIME.getDados() + ", speAIDLIST=" + speAIDLIST.getDados() + ", speGCXOPT=" + speGCXOPT.getDados() + ", speTAGLIST=" + StringUtil.charArrayToHexString(speTAGLIST.getDados()) + ", speDSPMSG=" + speDSPMSG.getDados() + ", speAPPTYPE=" + speAPPTYPE.getDados() + ", speACQREF=" + speACQREF.getDados() + ", speTRNTYPE=" + (speTRNTYPE != null ? StringUtil.charArrayToHexString(speTRNTYPE.getDados()) : null) + '\'' + '}');
        return ProtocoloAbecs.montaCmdBlk(speAMOUNT, speTRNDATE, speTRNTIME, speAIDLIST, speGCXOPT, speTAGLIST, speDSPMSG, speAPPTYPE, speACQREF, speTRNTYPE);
    }

    @Override
    public GenericPinpadController.ParamsReleituraGetCard buildParamsReleituraGetCard(LeitorCartao leitor) {
        if (ProtocoloAbecs.isNecessarioReleituraComRedeEIndice(leitor)) {
            return new GenericPinpadController.ParamsReleituraGetCard(0, 0, String.valueOf(IdRedeIndiceTabela.getInstance(leitor.getIdRedeAdquirente(), leitor.getIndiceAID())));
        }
        if (ProtocoloAbecs.isNecessarioReleituraComRedeSemIndice(leitor)) {
            return new GenericPinpadController.ParamsReleituraGetCard(leitor.getIdRedeAdquirente(), leitor.getTipoAplicacao(), "");
        }
        return new GenericPinpadController.ParamsReleituraGetCard(0, 0, leitor.getAidList().substring(2));
    }

    @Override
    public char[] buildStartCheckEventParameters(Integer checkKEY, Integer checkMAG, Integer checkICC, Integer checkCTLS) {
        String checkEventParam = checkKEY.toString();
        checkEventParam = checkEventParam + checkMAG.toString();
        checkEventParam = checkEventParam + checkICC.toString();
        checkEventParam = checkEventParam + checkCTLS.toString();
        checkEventParam = checkEventParam + "00";
        ParamAbecs<char[], char[]> par1 = new ParamAbecs<char[], char[]>(ConstantesAbecs.SPE_CEXOPT, checkEventParam.toCharArray());
        logger.debug("buildStartCheckEventParameters {SPE_CEXOPT=(tamanho)" + par1.getDados().length + '\'' + '}');
        return ProtocoloAbecs.montaCmdBlk(par1);
    }

    @Override
    public char[] buildStartGenericCommandTag84Parameters(SaidaGetCardEMV getCardOut) {
        return new char[0];
    }

    @Override
    public boolean containsKey(int keyType, CryptoKeyType cryptoKeyType, int keyIndex) throws ExcecaoPerifericos, ExcecaoNaoLocal {
        logger.debug("containsKeyAbecs({}, {}, {})", keyType, cryptoKeyType.getProtocol(), keyIndex);
        switch (keyType) {
            case 0: {
                if (cryptoKeyType == CryptoKeyType.DATA) {
                    return this.saidaGetInfoEMV.getKeyMapMkDesData().charAt(keyIndex) == '1';
                }
                return this.saidaGetInfoEMV.getKeyMapMkDesPin().charAt(keyIndex) == '1';
            }
            case 1: 
            case 4: {
                if (cryptoKeyType == CryptoKeyType.DATA) {
                    return this.saidaGetInfoEMV.getKeyMapMKTripleDESData().charAt(keyIndex) == '1';
                }
                return this.saidaGetInfoEMV.getKeyMapMKTripleDESPin().charAt(keyIndex) == '1';
            }
            case 2: {
                throw new ExcecaoNaoLocal("PA01", "Chaves do tipo DUKPT DES nao sao suportadas", "tipoChave = 2");
            }
            case 3: 
            case 5: {
                if (cryptoKeyType == CryptoKeyType.DATA) {
                    return this.saidaGetInfoEMV.getKeyMapDUKPTTripleDESData().charAt(keyIndex) == '1';
                }
                return this.saidaGetInfoEMV.getKeyMapDUKPTripleDESPin().charAt(keyIndex) == '1';
            }
        }
        logger.warn("Pulando consulta ao mapa de chaves para o tipo {}", keyType);
        return false;
    }

    public char[] buildGetTracksParameters(String tracks, Integer ctfCryptoType, Integer keyIndex, String workingKey, byte[] initializationVector, byte[] rsaModule, byte[] rsaExponent, Integer openDigits) {
        CryptoParamsService service = new CryptoParamsService();
        ParamAbecs<char[], String> speTRACKS = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_TRACKS, tracks);
        if (null == ctfCryptoType) {
            return ProtocoloAbecs.montaCmdBlk(speTRACKS);
        }
        ParamAbecs<char[], String> speMTHDDAT = null;
        try {
            speMTHDDAT = service.getDataEncryptMethod(ctfCryptoType);
        }
        catch (ExcecaoDadoInvalido excecaoDadoInvalido) {
            logger.warn(excecaoDadoInvalido.getMessage());
        }
        ParamAbecs<char[], String> speKEYIDX = null;
        try {
            speKEYIDX = TagBuilder.buildKeyIndex(keyIndex);
        }
        catch (ExcecaoDadoInvalido excecaoDadoInvalido) {
            logger.warn(excecaoDadoInvalido.getMessage());
        }
        ParamAbecs<char[], byte[]> speWKENC = null;
        try {
            speWKENC = service.setEncryptedWorkingKey(workingKey.getBytes());
        }
        catch (ExcecaoDadoInvalido excecaoDadoInvalido) {
            logger.warn(excecaoDadoInvalido.getMessage());
        }
        ParamAbecs<char[], byte[]> speIVCBC = null;
        try {
            speIVCBC = service.setInitializationVector(initializationVector);
        }
        catch (ExcecaoDadoInvalido excecaoDadoInvalido) {
            logger.warn(excecaoDadoInvalido.getMessage());
        }
        ParamAbecs<char[], byte[]> spePBKMOD = null;
        try {
            spePBKMOD = service.setPublicKeyModule(rsaModule);
        }
        catch (ExcecaoDadoInvalido excecaoDadoInvalido) {
            logger.warn(excecaoDadoInvalido.getMessage());
        }
        ParamAbecs<char[], byte[]> spePBKEXP = null;
        try {
            spePBKEXP = service.setPublicKeyExponent(rsaExponent);
        }
        catch (ExcecaoDadoInvalido excecaoDadoInvalido) {
            logger.warn(excecaoDadoInvalido.getMessage());
        }
        ParamAbecs<char[], String> speOPNDIG = null;
        try {
            speOPNDIG = TagBuilder.buildOpenDigits(openDigits);
        }
        catch (ExcecaoDadoInvalido excecaoDadoInvalido) {
            logger.warn(excecaoDadoInvalido.getMessage());
        }
        logger.debug("buildGetTracksParameters {speTRACKS=" + speTRACKS + ", speMTHDDAT=" + speMTHDDAT + ", speKEYIDX=" + speKEYIDX + ", speWKENC=" + speWKENC + ", speIVCBC=" + speIVCBC + ", spePBKMOD=" + spePBKMOD + ", spePBKEXP=" + spePBKEXP + '\'' + '}');
        return ProtocoloAbecs.montaCmdBlk(speTRACKS, speMTHDDAT, speKEYIDX, speWKENC, speIVCBC, spePBKMOD, spePBKEXP, speOPNDIG);
    }
}

