/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emvfull;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.util.ByteUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;

public class KeyFactory {
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    private static String rsaPubKey;
    private static String indiceChave;
    private static boolean chavesGeradas;
    private static String moduloChave;
    private static String expoenteChave;
    private static RSAPrivateKey priv;

    private KeyFactory() {
    }

    public static void configureKey(String indice, String modulo, String expoente) {
        indiceChave = indice;
        rsaPubKey = "2" + modulo + expoente;
        chavesGeradas = true;
        moduloChave = modulo;
        expoenteChave = expoente;
    }

    public static void reset() {
        indiceChave = null;
        rsaPubKey = null;
        moduloChave = null;
        chavesGeradas = false;
        priv = null;
    }

    public static boolean isChaveLocal() {
        boolean isChaveLocal = indiceChave == null;
        logger.debug("isChaveLocal: " + isChaveLocal);
        return isChaveLocal;
    }

    public static String getIndiceChave() {
        return indiceChave;
    }

    public static void generateKeys() {
        logger.info("Gerando a chave de criptografia...");
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(1024, new SecureRandom());
            KeyPair keyPair = kpg.genKeyPair();
            priv = (RSAPrivateKey)keyPair.getPrivate();
            RSAPublicKey pub = (RSAPublicKey)keyPair.getPublic();
            String modulus = ByteUtil.byteArrayToHex(pub.getModulus().toByteArray());
            if (modulus.length() == 258) {
                modulus = modulus.substring(2);
            }
            String publicKey = "2" + modulus;
            rsaPubKey = publicKey = publicKey + ByteUtil.byteArrayToHex(pub.getPublicExponent().toByteArray());
            chavesGeradas = true;
            indiceChave = null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Retorno da getRSAPubKey null");
        }
        logger.info("Chave de criptografia gerada.");
    }

    public static final String getRsaPublicKey() {
        if (!chavesGeradas) {
            KeyFactory.generateKeys();
        }
        return rsaPubKey;
    }

    public static String getModuloChave() {
        return moduloChave;
    }

    public static String getExpoenteChave() {
        return expoenteChave;
    }

    public static final String decryptRSA(String buffer) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
            cipher.init(2, priv);
            if (buffer.length() < 256) {
                buffer = StringUtil.completaString(buffer, 256, '0', 3);
            }
            byte[] bBuffer = ByteUtil.hexToByteArray(buffer);
            byte[] cipherData = cipher.doFinal(bBuffer);
            return new String(cipherData);
        }
        catch (Exception e) {
            logger.warn("Erro ao decifrar string: " + e.getMessage());
            return null;
        }
    }
}

