/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emvfull;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.EMVResponseCode;
import br.com.auttar.util.emv.CryptoKeyType;
import br.com.auttar.util.exceptions.PinpadOpenException;
import br.com.auttar.util.factories.PinpadDriverFactory;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.DadosGetInfoRedeEMV;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.devices.emv.SaidaCheckEventEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaEncryptBufferEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaFinishChipEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGenericCmdEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetCardEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetCardQualidade;
import com.csi.ctfclient.tools.devices.emv.SaidaGetDUKPTEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoRedecardEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoVisanetEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetPinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetTimeStampEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGoOnChipEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaRemoveCardEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaCompartilhadaHandler;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.util.StringUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class GenericPinpadController {
    protected static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(GenericPinpadController.class);
    protected static final char[] BC_VERSION = "0100".toCharArray();
    protected static final char[] ABECS_VERSION = "0200".toCharArray();
    private static boolean secureCommunication = false;
    private static int timeoutPinDefault = 0;
    private static int timeoutPinBlocking = 0;
    private static int timeoutPinNoblocking = 0;
    private static int timeoutPinStandard = 0;
    private static String handler = null;
    private static String wkpan;
    protected final BibliotecaCompartilhadaHandler pinpad;
    private final String serialPort;
    private final Map<Integer, DadosGetInfoRedeEMV> mapGetInfoRedeEMV = new HashMap<Integer, DadosGetInfoRedeEMV>();
    protected SaidaGetInfoEMV saidaGetInfoEMV = null;
    private boolean serialOpened = false;
    private boolean bcOpened;
    private String tableVersionPinpad;
    private boolean communicationOpened = false;
    private SaidaGetInfoVisanetEMV saidaGetInfoCielo = null;
    private SaidaGetInfoRedecardEMV saidaGetInfoRedecard = null;

    public abstract ParamsReleituraGetCard buildParamsReleituraGetCard(LeitorCartao var1);

    protected GenericPinpadController(String serialPort, String handler) throws ExcecaoPerifericos {
        this.serialPort = serialPort;
        try {
            this.pinpad = (BibliotecaCompartilhadaHandler)Class.forName(handler).newInstance();
        }
        catch (Exception e) {
            throw new ExcecaoPerifericos("GPC05", "Erro na construcao do driver do pinpad", e);
        }
    }

    @Deprecated
    protected GenericPinpadController(GenericPinpadController other) {
        this.pinpad = other.pinpad;
        this.serialPort = other.serialPort;
        this.saidaGetInfoEMV = other.saidaGetInfoEMV;
        this.serialOpened = other.serialOpened;
        this.bcOpened = other.bcOpened;
        this.tableVersionPinpad = other.tableVersionPinpad;
        this.communicationOpened = other.communicationOpened;
        this.saidaGetInfoCielo = other.saidaGetInfoCielo;
        this.saidaGetInfoRedecard = other.saidaGetInfoRedecard;
    }

    @Deprecated
    public static GenericPinpadController getInstance(String port, boolean openCommunication) throws ExcecaoPerifericos {
        return PinpadDriverFactory.getInstance(port, openCommunication);
    }

    @Deprecated
    public static GenericPinpadController getInstance(String port) throws ExcecaoPerifericos {
        return PinpadDriverFactory.getInstance(port, true);
    }

    public static void setHandler(String handler) {
        GenericPinpadController.handler = handler;
    }

    public static String getHandler() {
        return handler;
    }

    public static boolean isSecureCommunication() {
        logger.debug("isSecureCommunication: " + secureCommunication);
        return secureCommunication;
    }

    public static void setSecureCommunication(boolean secureCommunication) {
        if (secureCommunication) {
            logger.info("Criptografia do PAN habilitada na comunica\u00e7\u00e3o com o PINPAD (BC)");
        } else {
            logger.info("Criptografia do PAN n\u00e3o habilitada na comunica\u00e7\u00e3o com o PINPAD (BC)");
        }
        GenericPinpadController.secureCommunication = secureCommunication;
    }

    @Deprecated
    public static void setTimeoutPin(int timeoutPinDefault, int timeoutPinBlocking, int timeoutPinNoblocking) {
        GenericPinpadController.setTimeoutPin(timeoutPinDefault, timeoutPinBlocking, timeoutPinNoblocking, timeoutPinStandard);
    }

    public static void setTimeoutPin(int timeoutPinDefault, int timeoutPinBlocking, int timeoutPinNoblocking, int timeoutPinStandard) {
        logger.info("Timeout default do pin configurado para " + timeoutPinDefault);
        GenericPinpadController.timeoutPinDefault = timeoutPinDefault;
        logger.info("Timeout blocking do pin configurado para " + timeoutPinBlocking);
        GenericPinpadController.timeoutPinBlocking = timeoutPinBlocking;
        logger.info("Timeout noblocking do pin configurado para " + timeoutPinNoblocking);
        GenericPinpadController.timeoutPinNoblocking = timeoutPinNoblocking;
        logger.info("Timeout noblocking do pin configurado para " + timeoutPinStandard);
        GenericPinpadController.timeoutPinStandard = timeoutPinStandard;
    }

    public static String getWkpan() {
        return wkpan;
    }

    protected static void setWkpan(String wkpan) {
        GenericPinpadController.wkpan = wkpan;
    }

    public static String getErrorString(int emvResponseCode) {
        EMVResponseCode enumByKey = EMVResponseCode.getEnumByKey(emvResponseCode);
        if (enumByKey == null) {
            return "Erro indefinido";
        }
        return enumByKey.getCode();
    }

    @Deprecated
    public static void terminateInstance() {
        PinpadDriverFactory.terminateInstance();
    }

    public static void validateReturn(int emvResponseCode, String function) throws ExcecaoPerifericos {
        if (emvResponseCode != EMVResponseCode.PP_OK.getId() && emvResponseCode != EMVResponseCode.PP_PROCESSING.getId() && emvResponseCode != EMVResponseCode.PP_NOTIFY.getId() && emvResponseCode != EMVResponseCode.PP_CANCEL.getId() && emvResponseCode != EMVResponseCode.PP_TABEXP.getId() && emvResponseCode != EMVResponseCode.PP_NOCARD.getId()) {
            logger.error(String.format("Retorno de %s = %d", function, emvResponseCode));
            throw new ExcecaoPerifericos("GPC00", String.format("Retorno inesperado para %s: %d", function, emvResponseCode), GenericPinpadController.getErrorString(emvResponseCode), emvResponseCode);
        }
        logger.trace(String.format("Retorno de %s = %d", function, emvResponseCode));
    }

    public boolean isBcOpened() {
        return this.bcOpened;
    }

    public String getTableVersionPinpad() {
        return this.tableVersionPinpad;
    }

    public void setTableVersionPinpad(String tableVersionPinpad) {
        this.tableVersionPinpad = tableVersionPinpad;
    }

    public abstract String getTableVersion();

    public abstract char[] getVersion();

    public abstract boolean isPinpadAbecs();

    protected abstract char[] buildGetInfoParameters();

    protected abstract char[] buildStartCheckEventParameters(Integer var1, Integer var2, Integer var3, Integer var4);

    public abstract char[] buildStartGetCardParameters(LeitorCartao var1);

    public abstract char[] buildGoOnChipParameters(BibliotecaPinpad var1);

    public abstract char[] buildMandatoryTags(BibliotecaPinpad var1);

    public abstract char[] buildOptionalTags(BibliotecaPinpad var1);

    public abstract char[] buildFinishChipParameters(BibliotecaPinpad var1);

    @Deprecated
    public abstract char[] buildStartGenericCommandTag84Parameters(SaidaGetCardEMV var1);

    public abstract boolean containsKey(int var1, CryptoKeyType var2, int var3) throws ExcecaoPerifericos, ExcecaoNaoLocal;

    public abstract char[] buildEncryptBufferParameters(int var1, int var2, String var3, byte[] var4, byte[] var5);

    public abstract char[] prepareClosePrompt(char[] var1);

    public boolean isCommunicationOpened() {
        return this.communicationOpened;
    }

    public void setTimeout() {
        this.setPPTimeout(timeoutPinDefault, timeoutPinBlocking, timeoutPinNoblocking, timeoutPinStandard);
    }

    public void resetSerial() {
        logger.trace("resetSerial");
        this.closeSerial();
        this.serialOpened = false;
        this.communicationOpened = false;
        this.bcOpened = false;
    }

    public synchronized void openCommunication() throws ExcecaoPerifericos {
        block11: {
            if (this.communicationOpened) {
                logger.warn("Comunica\u00e7\u00e3o com pinpad j\u00e1 estabelecida");
                return;
            }
            this.setTimeout();
            this.openPinpadSerialConnection();
            try {
                this.openPinpadConnection(false);
                if (!this.bcOpened) break block11;
                this.loadGetInfoCache();
                this.tableVersionPinpad = this.getTableVersion();
                logger.info("Retorno 'getInfo()': " + this.saidaGetInfoEMV.getRetorno());
                logger.info("Versao da especificacao no pinpad: '" + this.saidaGetInfoEMV.getVersaoEspecificacao() + "'");
                logger.info("Versao das tabelas de AID no pinpad: '" + this.tableVersionPinpad + "'");
                logger.info("Comunicacao segura: " + secureCommunication);
                GenericPinpadController.validateReturn(this.saidaGetInfoEMV.getRetorno(), "saidaGetInfoEMV()");
                if (secureCommunication) {
                    try {
                        BigDecimal versao = new BigDecimal(this.saidaGetInfoEMV.getVersaoEspecificacao());
                        if (versao.compareTo(new BigDecimal("1.07")) >= 0) {
                            secureCommunication = true;
                        }
                        if (versao.compareTo(new BigDecimal("2.00")) > 0) {
                            logger.info("Usando comunicacao segura padrao do protocolo ABECS.");
                            secureCommunication = false;
                        }
                    }
                    catch (Exception e) {
                        logger.info("N\u00e3o foi poss\u00edvel identificar a vers\u00e3o. Erro: " + e.getMessage());
                    }
                }
                logger.info("Comunicacao segura: " + secureCommunication);
                if (!GenericPinpadController.isSecureCommunication()) {
                    if (!KeyFactory.isChaveLocal()) {
                        KeyFactory.reset();
                    }
                } else {
                    this.setupSecureCommunication();
                }
            }
            catch (ExcecaoPerifericos e) {
                this.closeConnection();
                throw e;
            }
        }
        this.communicationOpened = true;
    }

    public synchronized void closeConnection() {
        this.closeConnection(true, "Auttar".toCharArray());
    }

    @Deprecated
    public synchronized void closeConnection(char[] msgPrompt) {
        this.closeConnection(true, msgPrompt);
    }

    public synchronized void closeConnection(boolean liberaBBComp, char[] msgPrompt) {
        logger.debug("closeConnection: liberaBBComp: {}, msgPrompt: {}", liberaBBComp, msgPrompt);
        msgPrompt = this.prepareClosePrompt(msgPrompt);
        if (liberaBBComp) {
            if (this.isBcOpened() && !this.isCommunicationOpened()) {
                logger.warn("openSerial necessario");
                this.openSerial(this.serialPort.toCharArray());
            }
            this.close(msgPrompt);
            this.bcOpened = false;
        }
        this.closeSerial();
        this.communicationOpened = false;
        logger.debug("Comunica\u00e7\u00e3o com pinpad finalizada!");
    }

    public void testCommunication() throws ExcecaoPerifericos {
        if (this.communicationOpened) {
            logger.warn("comunica\u00e7\u00e3o com pin j\u00e1 estabelecida");
            return;
        }
        this.setTimeout();
        this.openPinpadSerialConnection();
        int response = this.pinpad.checkPinpad(this.getVersion(), this.serialPort.toCharArray());
        if (response != EMVResponseCode.PP_OK.getId()) {
            this.closeSerial();
            throw new PinpadOpenException("GPC02", "Erro ao abrir comunica\u00e7\u00e3o com o PINPAD", response);
        }
        this.openPinpadConnection(true);
        this.communicationOpened = true;
    }

    public SaidaGetInfoEMV getInfoEMV() {
        if (this.saidaGetInfoEMV == null) {
            this.saidaGetInfoEMV = this.getInfo(this.buildGetInfoParameters());
        }
        return this.saidaGetInfoEMV;
    }

    public SaidaGetInfoVisanetEMV getInfoCieloEMV() {
        if (this.saidaGetInfoCielo == null) {
            this.saidaGetInfoCielo = this.getInfoVisanet();
        }
        return this.saidaGetInfoCielo;
    }

    public SaidaGetInfoRedecardEMV getInfoRedecardEMV() {
        if (this.saidaGetInfoRedecard == null) {
            this.saidaGetInfoRedecard = this.getInfoRedecard();
        }
        return this.saidaGetInfoRedecard;
    }

    public DadosGetInfoRedeEMV getInfoAcquire(int acquire) {
        Integer acquireInteger = acquire;
        DadosGetInfoRedeEMV saidaGetInfoRedeEMV = this.mapGetInfoRedeEMV.get(acquireInteger);
        if (saidaGetInfoRedeEMV == null) {
            saidaGetInfoRedeEMV = this.getInfoRedeEMV(acquire);
            this.mapGetInfoRedeEMV.put(acquireInteger, saidaGetInfoRedeEMV);
        }
        return saidaGetInfoRedeEMV;
    }

    protected void loadGetInfoCache() {
        this.saidaGetInfoEMV = this.getInfoEMV();
        this.saidaGetInfoCielo = this.getInfoCieloEMV();
        this.saidaGetInfoRedecard = this.getInfoRedecardEMV();
        this.mapGetInfoRedeEMV.put(4, this.getInfoRedeEMV(4));
    }

    protected void clearOutputCache() {
        this.saidaGetInfoEMV = null;
        this.saidaGetInfoCielo = null;
        this.saidaGetInfoRedecard = null;
        this.mapGetInfoRedeEMV.clear();
    }

    @Deprecated
    public String getSerialPort() {
        return this.serialPort;
    }

    protected void setupSecureCommunication() throws ExcecaoPerifericos {
        logger.info("Nao Utiliza comunicao segura...");
    }

    private void openPinpadSerialConnection() throws ExcecaoPerifericos {
        if (this.serialOpened) {
            logger.warn("Comunica\u00e7\u00e3o serial com pinpad j\u00e1 estabelecida");
            return;
        }
        int response = this.openSerial(this.serialPort.toCharArray());
        if (response != 0) {
            throw new ExcecaoPerifericos("GPC01", "Erro ao abrir comunicacao serial com o PINPAD", "response = " + response);
        }
        logger.info("Comunicacao serial com o pinpad aberta com sucesso");
        this.serialOpened = true;
    }

    private void openPinpadConnection(boolean isTestConnection) throws ExcecaoPerifericos {
        logger.trace("openPinpadConnection");
        if (!this.serialOpened) {
            logger.error("N\u00e3o foi poss\u00edvel abrir comunica\u00e7\u00e3o com pinpad. Comunica\u00e7\u00e3o serial com pinpad n\u00e3o estabelecida");
            throw new ExcecaoPerifericos("GPC03", "Erro comunica\u00e7\u00e3o serial com pinpad n\u00e3o estabelecida");
        }
        if (this.bcOpened) {
            return;
        }
        if (!isTestConnection) {
            this.clearOutputCache();
        }
        int response = this.open();
        if (EMVResponseCode.PP_OK.getId() != response && EMVResponseCode.PP_NOSEC.getId() != response && EMVResponseCode.PP_ALREADYOPEN.getId() != response) {
            throw new PinpadOpenException("GPC02", "Erro ao abrir comunica\u00e7\u00e3o com o PINPAD", response);
        }
        this.bcOpened = true;
        if (EMVResponseCode.PP_NOSEC.getId() == response && !isTestConnection) {
            throw new PinpadOpenException("GPC04", "Pinpad nao suporta comunicacao segura", response);
        }
        if (EMVResponseCode.PP_ALREADYOPEN.getId() == response) {
            logger.warn("Comunicacao com o pinpad ja foi estabelecida");
        }
        logger.info("Comunicacao com o protocolo do pinpad aberta com sucesso");
    }

    public SaidaEncryptBufferEMV encryptBuffer(int encryptationType, int masterKeyIndex, String workingKey, byte[] data, byte[] initializationVector) {
        if (this.isPinpadAbecs()) {
            return this.encryptBuffer(this.buildEncryptBufferParameters(encryptationType, masterKeyIndex, workingKey, data, initializationVector));
        }
        return this.encryptBuffer2(encryptationType, masterKeyIndex, workingKey.toCharArray(), data);
    }

    public int abort() {
        int result = this.pinpad.abort(BC_VERSION);
        logger.debug(String.format("abort(version=%s) = %d", StringUtil.charArrayToHexString(BC_VERSION), result));
        return result;
    }

    public int display(char[] message) {
        char[] version = this.getVersion();
        int result = this.pinpad.display(version, message);
        logger.debug(String.format("display(version=%s, message=%s) = %d", StringUtil.charArrayToHexString(version), StringUtil.charArrayToHexString(message), result));
        return result;
    }

    public int startGetCard(char[] input) {
        char[] version = this.getVersion();
        int result = this.pinpad.startGetCard(version, input);
        logger.debug(String.format("startGetCard(version=%s, input=%s) = %d", StringUtil.charArrayToHexString(version), StringUtil.charArrayToHexString(input), result));
        return result;
    }

    public SaidaGetCardEMV getCard() {
        char[] version = this.getVersion();
        SaidaGetCardEMV result = this.pinpad.getCard(version);
        logger.debug(String.format("getCard(version=%s) = %s", StringUtil.charArrayToHexString(version), result));
        return result;
    }

    public int tableLoadInit(char[] input) {
        char[] version = this.getVersion();
        int result = this.pinpad.tableLoadInit(version, input);
        logger.debug(String.format("tableLoadInit(version=%s, input=%s) = %d", StringUtil.charArrayToHexString(version), StringUtil.charArrayToHexString(input), result));
        return result;
    }

    public int tableLoadEnd() {
        char[] version = this.getVersion();
        int result = this.pinpad.tableLoadEnd(version);
        logger.debug(String.format("tableLoadEnd(version=%s) = %d", StringUtil.charArrayToHexString(version), result));
        return result;
    }

    public int tableLoadRec(char[] input) {
        char[] version = this.getVersion();
        int result = this.pinpad.tableLoadRec(version, input);
        logger.debug(String.format("tableLoadRec(version=%s, input=%s) = %d", StringUtil.charArrayToHexString(version), StringUtil.charArrayToHexString(input), result));
        return result;
    }

    public int startGenericCmd(char[] input) {
        char[] version = this.getVersion();
        int result = this.pinpad.startGenericCmd(version, input);
        logger.debug(String.format("startGenericCmd(version=%s, input=%s) = %d", StringUtil.charArrayToHexString(version), StringUtil.charArrayToHexString(input), result));
        return result;
    }

    public SaidaGenericCmdEMV genericCmd() {
        char[] version = this.getVersion();
        SaidaGenericCmdEMV result = this.pinpad.genericCmd(version);
        logger.debug(String.format("genericCmd(version=%s) = %s", StringUtil.charArrayToHexString(version), result));
        return result;
    }

    public int startCheckEvent(Integer checkKEY, Integer checkMAG, Integer checkICC, Integer checkCTLS) {
        char[] input = this.buildStartCheckEventParameters(checkKEY, checkMAG, checkICC, checkCTLS);
        char[] version = this.getVersion();
        int result = this.pinpad.startCheckEvent(version, input);
        logger.debug(String.format("startCheckEvent(version=%s, input=%s) = %d", StringUtil.charArrayToHexString(version), StringUtil.charArrayToHexString(input), result));
        return result;
    }

    public SaidaCheckEventEMV checkEvent() {
        char[] version = this.getVersion();
        SaidaCheckEventEMV saidaCheckEventEMV = this.pinpad.checkEvent(version);
        logger.debug(String.format("checkEvent(version=%s) = %s", StringUtil.charArrayToHexString(version), saidaCheckEventEMV));
        return saidaCheckEventEMV;
    }

    protected int openSerial(char[] port) {
        char[] version = this.getVersion();
        int result = this.pinpad.openSerial(version, 1, port);
        logger.debug(String.format("openSerial(version=%s, tipoBiblioteca=%s, port=%s) = %s", StringUtil.charArrayToHexString(version), 1, StringUtil.charArrayToHexString(port), result));
        logger.info("Retorno 'openSerial': " + result);
        return result;
    }

    protected int open() {
        char[] version = this.getVersion();
        int result = this.pinpad.open(version);
        logger.debug(String.format("open(version=%s) = %s", StringUtil.charArrayToHexString(version), result));
        wkpan = null;
        logger.info("Retorno 'open': " + result);
        return result;
    }

    protected synchronized int close(char[] input) {
        char[] version = this.getVersion();
        int result = this.pinpad.close(version, input);
        logger.debug(String.format("close(version=%s, input=%s) = %s", StringUtil.charArrayToHexString(version), StringUtil.charArrayToHexString(input), result));
        wkpan = null;
        logger.info("Retorno 'close': " + result);
        return result;
    }

    protected synchronized void closeSerial() {
        char[] version = this.getVersion();
        int response = this.pinpad.closeSerial(version);
        logger.debug(String.format("closeSerial(version=%s) = %s", StringUtil.charArrayToHexString(version), response));
        if (response == EMVResponseCode.PP_OK.getId()) {
            this.serialOpened = false;
        }
        logger.info("Retorno 'closeSerial': " + response);
    }

    protected int startGetPIN(char[] input) {
        char[] version = this.getVersion();
        int result = this.pinpad.startGetPIN(version, input);
        logger.debug(String.format("startGetPIN(version=%s, input=%s) = %s", StringUtil.charArrayToHexString(version), StringUtil.charArrayToHexString(input), result));
        return result;
    }

    protected SaidaGetPinEMV getPin() {
        char[] version = this.getVersion();
        SaidaGetPinEMV result = this.pinpad.getPin(version);
        logger.debug(String.format("getPin(version=%s) = %s", StringUtil.charArrayToHexString(version), result));
        return result;
    }

    protected int startGoOnChip(BibliotecaPinpad pinpadLibrary) {
        char[] version = this.getVersion();
        char[] input = this.buildGoOnChipParameters(pinpadLibrary);
        char[] mandatoryTags = this.buildMandatoryTags(pinpadLibrary);
        char[] optionalTags = this.buildOptionalTags(pinpadLibrary);
        int result = this.pinpad.startGoOnChip(version, input, mandatoryTags, optionalTags);
        logger.debug(String.format("startGoOnChip(version=%s, input=%s, mandatoryTags=%s, optionalTags=%s) = %d", StringUtil.charArrayToHexString(version), StringUtil.charArrayToHexString(input), StringUtil.charArrayToHexString(mandatoryTags), StringUtil.charArrayToHexString(optionalTags), result));
        return result;
    }

    protected SaidaGoOnChipEMV goOnChip() {
        char[] version = this.getVersion();
        SaidaGoOnChipEMV result = this.pinpad.goOnChip(version);
        logger.debug(String.format("goOnChip(version=%s) = %s", StringUtil.charArrayToHexString(version), result));
        return result;
    }

    protected int startRemoveCard(char[] message) {
        char[] version = this.getVersion();
        int result = this.pinpad.startRemoveCard(version, message);
        logger.debug(String.format("startRemoveCard(version=%s, message=%s) = %d", StringUtil.charArrayToHexString(version), StringUtil.charArrayToHexString(message), result));
        return result;
    }

    protected SaidaRemoveCardEMV removeCard() {
        char[] version = this.getVersion();
        SaidaRemoveCardEMV result = this.pinpad.removeCard(version);
        logger.debug(String.format("removeCard(version=%s) = %s", StringUtil.charArrayToHexString(version), result));
        return result;
    }

    protected int startGetKey() {
        char[] version = this.getVersion();
        int result = this.pinpad.startGetKey(version);
        logger.debug(String.format("startGetKey(version=%s) = %d", StringUtil.charArrayToHexString(version), result));
        return result;
    }

    protected int getKey() {
        char[] version = this.getVersion();
        int result = this.pinpad.getKey(version);
        logger.debug(String.format("getKey(version=%s) = %d", StringUtil.charArrayToHexString(version), result));
        return result;
    }

    protected int startFinishChip(BibliotecaPinpad pinpadLibrary) {
        char[] version = this.getVersion();
        char[] input = this.buildFinishChipParameters(pinpadLibrary);
        char[] mandatoryTags = this.buildMandatoryTags(pinpadLibrary);
        int result = this.pinpad.startFinishChip(version, input, mandatoryTags);
        logger.debug(String.format("startFinishChip(version=%s, input=%s, mandatoryTags=%s) = %d", StringUtil.charArrayToHexString(version), StringUtil.charArrayToHexString(input), StringUtil.charArrayToHexString(mandatoryTags), result));
        return result;
    }

    protected SaidaFinishChipEMV finishChip() {
        char[] version = this.getVersion();
        SaidaFinishChipEMV result = this.pinpad.finishChip(version);
        logger.debug(String.format("finishChip(version=%s) = %s", StringUtil.charArrayToHexString(version), result));
        return result;
    }

    protected SaidaGetDUKPTEMV getDUKPT(char[] input) {
        SaidaGetDUKPTEMV result = this.pinpad.getDUKPT(BC_VERSION, input);
        logger.debug(String.format("getDUKPT(version=%s, input=%s) = %s", StringUtil.charArrayToHexString(BC_VERSION), StringUtil.charArrayToHexString(input), result));
        return result;
    }

    protected SaidaEncryptBufferEMV encryptBuffer(char[] input) {
        char[] version = this.getVersion();
        SaidaEncryptBufferEMV result = this.pinpad.encryptBuffer(version, input);
        logger.debug(String.format("encryptBuffer(version=%s) = %s", StringUtil.charArrayToHexString(version), result));
        return result;
    }

    protected SaidaEncryptBufferEMV encryptBuffer2(int encryptationType, int masterKeyIndex, char[] workingKey, byte[] data) {
        char[] version = this.getVersion();
        SaidaEncryptBufferEMV result = this.pinpad.encryptBuffer2(version, encryptationType, masterKeyIndex, workingKey, StringUtil.byteArrayToCharArray(data));
        logger.debug(String.format("encryptBuffer2(version=%s, encryptionType=%d, masterkeyIndex=%d) = %s", StringUtil.charArrayToHexString(version), encryptationType, masterKeyIndex, result));
        return result;
    }

    protected SaidaGetInfoEMV getInfo(char[] input) {
        char[] version = this.getVersion();
        SaidaGetInfoEMV result = this.pinpad.getInfo(version, input);
        logger.debug(String.format("getInfo(version=%s, input=%s) = %s", StringUtil.charArrayToHexString(version), StringUtil.charArrayToHexString(input), result));
        return result;
    }

    protected SaidaGetInfoVisanetEMV getInfoVisanet() {
        SaidaGetInfoVisanetEMV result = this.pinpad.getInfoVisanet(BC_VERSION);
        logger.debug(String.format("getInfoVisanet(version=%s) = %s", StringUtil.charArrayToHexString(BC_VERSION), result));
        return result;
    }

    protected SaidaGetInfoRedecardEMV getInfoRedecard() {
        SaidaGetInfoRedecardEMV result = this.pinpad.getInfoRedecard(BC_VERSION);
        logger.debug(String.format("getInfoRedecard(version=%s) = %s", StringUtil.charArrayToHexString(BC_VERSION), result));
        return result;
    }

    protected DadosGetInfoRedeEMV getInfoRedeEMV(int rede) {
        DadosGetInfoRedeEMV result = this.pinpad.getInfoRedeEMV(rede, BC_VERSION);
        logger.debug(String.format("getInfoRedeEMV(rede=%s, version=%s) = %s", rede, StringUtil.charArrayToHexString(BC_VERSION), result));
        return result;
    }

    protected SaidaGetTimeStampEMV getTimeStamp(char[] input) {
        char[] version = this.getVersion();
        SaidaGetTimeStampEMV result = this.pinpad.getTimeStamp(version, input);
        logger.debug(String.format("getTimeStamp(version=%s, input=%s) = %s", StringUtil.charArrayToHexString(version), StringUtil.charArrayToHexString(input), result));
        return result;
    }

    @Deprecated
    protected void setPPTimeout(int defaultTimeout, int blockingTimeout, int noBlockingTimeout) {
        char[] version = this.getVersion();
        this.pinpad.setPPTimeout(version, defaultTimeout, blockingTimeout, noBlockingTimeout);
        logger.debug(String.format("setPPTimeout(version=%s, defaultTimeout=%s, blockingTimeout=%s, noBlockingTimeout=%s)", StringUtil.charArrayToHexString(version), defaultTimeout, blockingTimeout, noBlockingTimeout));
    }

    protected void setPPTimeout(int defaultTimeout, int blockingTimeout, int noBlockingTimeout, int standardTimeout) {
        char[] version = this.getVersion();
        this.pinpad.setPPTimeoutExt(version, defaultTimeout, blockingTimeout, noBlockingTimeout, standardTimeout);
        logger.debug(String.format("setPPTimeout(version=%s, defaultTimeout=%s, blockingTimeout=%s, noBlockingTimeout=%s)", StringUtil.charArrayToHexString(version), defaultTimeout, blockingTimeout, noBlockingTimeout));
    }

    protected int changeParameter(char[] psInput) {
        char[] version = this.getVersion();
        int result = this.pinpad.changeParameter(version, psInput);
        logger.debug(String.format("changeParameter(version=%s, input=%s) = %d", StringUtil.charArrayToHexString(version), StringUtil.charArrayToHexString(psInput), result));
        return result;
    }

    public SaidaGetCardQualidade getCardQualidade() {
        char[] version = this.getVersion();
        SaidaGetCardQualidade result = this.pinpad.getCardQualidade(version);
        logger.debug(String.format("getCardQualidade(version=%s) = %s", StringUtil.charArrayToHexString(version), result));
        return result;
    }

    protected static boolean isNecessarioReleituraComRedeEIndice(LeitorCartao cardReader) {
        return cardReader.getIdRedeAdquirente() > 0 && StringUtils.isNotBlank(cardReader.getIndiceAID());
    }

    protected static boolean isNecessarioReleituraComRedeSemIndice(LeitorCartao cardReader) {
        return cardReader.getIdRedeAdquirente() > 0 && StringUtils.isBlank(cardReader.getIndiceAID());
    }

    static class ParamsReleituraGetCard {
        private int redeAdq;
        private int tipoAplicacao;
        private String idsAceitos;

        public ParamsReleituraGetCard(int redeAdq, int tipoAplicacao, String idsAceitos) {
            this.redeAdq = redeAdq;
            this.tipoAplicacao = tipoAplicacao;
            this.idsAceitos = idsAceitos;
        }

        public int getRedeAdq() {
            return this.redeAdq;
        }

        public int getTipoAplicacao() {
            return this.tipoAplicacao;
        }

        public String getIdsAceitos() {
            return this.idsAceitos;
        }
    }
}

