/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emvfull;

import br.com.auttar.AuttarLogger;
import br.com.auttar.util.factories.PinpadDriverFactory;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.config.ConfPeriferico;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import java.io.File;
import java.util.Objects;

public class ControladorDetectaPinpad {
    private static ControladorDetectaPinpad controlador = null;
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(ControladorDetectaPinpad.class);

    private ControladorDetectaPinpad() {
    }

    public static ControladorDetectaPinpad getInstancia() {
        if (controlador == null) {
            controlador = new ControladorDetectaPinpad();
        }
        return controlador;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String detectaPinpad(ControladorPerifericos perifericos) throws ExcecaoPerifericos {
        try {
            File fileSERCFG;
            this.logger.info("iniciando rotina de verificacao de pinpad");
            File fileCSICFG = new File("CSICFG");
            if (fileCSICFG.exists() && !fileCSICFG.delete()) {
                this.logger.error("Erro ao deletar arquivo: {}", fileCSICFG.getName());
            }
            if ((fileSERCFG = new File("SERCFG")).exists() && !fileSERCFG.delete()) {
                this.logger.error("Erro ao deletar arquivo: {}", fileSERCFG.getName());
            }
            String osName = System.getProperty("os.name");
            String tipoPorta = "";
            String portaSerial = "";
            int portaInicial = 0;
            if (osName.toUpperCase().contains("WIN")) {
                tipoPorta = "COM";
                portaInicial = 1;
            } else {
                try {
                    ConfCTFClient configClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
                    ConfPeriferico confPeriferico = configClient.getPinPad();
                    String[] params = confPeriferico.getParametros();
                    tipoPorta = params[0].substring(0, params[0].length() - 1);
                }
                catch (Exception ignored) {
                    this.logger.warn("N\u00e3o foi possivel recuperar config CTFClient");
                }
            }
            int i = portaInicial;
            int pausa = 0;
            while (i <= 99) {
                if (pausa == 10) {
                    LayoutMenu layoutMenu;
                    EventoTeclado eventoTeclado;
                    do {
                        layoutMenu = new LayoutMenu("CONTINUAR VERIFICACAO?", true);
                        layoutMenu.addItem(new ItemMenu("SIM", "1"));
                        layoutMenu.addItem(new ItemMenu("NAO", "2"));
                    } while ((eventoTeclado = perifericos.imprimeMenu(layoutMenu, new String[0], null)).getTeclaFinalizadora().equals("VOLTA"));
                    if (!eventoTeclado.getStringLida().equals("1")) break;
                    pausa = 0;
                }
                portaSerial = tipoPorta + i;
                this.logger.info("Verificando pinpad na porta: " + portaSerial);
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha("VERIFICANDO PINPAD"));
                layoutDisplay.addLinha(new Linha("NA PORTA: " + portaSerial));
                layoutDisplay.addLinha(new Linha("AGUARDE..."));
                perifericos.imprimeDisplay(layoutDisplay);
                try {
                    ProtocoloBibliotecaCompartilhada protocolo = new ProtocoloBibliotecaCompartilhada(portaSerial, "com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhadaC");
                    protocolo.testCommunication();
                    layoutDisplay = new LayoutDisplay();
                    layoutDisplay.setDelay(1500L);
                    layoutDisplay.addLinha(new Linha("PINPAD DETECTADO"));
                    layoutDisplay.addLinha(new Linha("NA PORTA: " + portaSerial));
                    perifericos.imprimeDisplay(layoutDisplay);
                    this.logger.info("pinpad localizado na porta: " + portaSerial);
                    break;
                }
                catch (Exception e) {
                    this.logger.error("pinpad nao localizado na porta " + portaSerial);
                    layoutDisplay = new LayoutDisplay();
                    layoutDisplay.setDelay(500L);
                    layoutDisplay.addLinha(new Linha("VERIFICANDO PINPAD"));
                    layoutDisplay.addLinha(new Linha("NA PORTA: " + portaSerial));
                    layoutDisplay.addLinha(new Linha("NAO DETECTADO!"));
                    perifericos.imprimeDisplay(layoutDisplay);
                    portaSerial = null;
                }
                finally {
                    PinpadDriverFactory.terminateInstance();
                }
                ++i;
                ++pausa;
            }
            this.logger.info("porta retornada:  " + portaSerial);
            return portaSerial;
        }
        catch (ExcecaoNaoLocal e) {
            throw new ExcecaoPerifericos("CDP01", "Erro na deteccao do pinpad", e.getMessage());
        }
    }
}

