/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emvfull;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.EMVResponseCode;
import br.com.auttar.util.emv.CryptoKeyType;
import br.com.auttar.util.factories.PinpadDriverFactory;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.excecoes.InvalidDataException;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.devices.emv.DadosGetInfoRedeEMV;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaCheckEventEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaEncryptBufferEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaFinishChipEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGenericCmdEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetCardQualidade;
import com.csi.ctfclient.tools.devices.emv.SaidaGetClearData;
import com.csi.ctfclient.tools.devices.emv.SaidaGetDUKPTEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoRedecardEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoVisanetEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetPinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetTracks;
import com.csi.ctfclient.tools.devices.emv.SaidaGoOnChipEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaRemoveCardEMV;
import com.csi.ctfclient.tools.devices.emvfull.GenericPinpadController;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloAbecs;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.events.EventBuilder;
import com.csi.ctfclient.tools.util.StringUtil;
import java.util.Vector;

public class BibliotecaPinpad
extends PinEMV
implements Runnable {
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(BibliotecaPinpad.class);
    public static final int BIBLIOTECA_EMV = 1;
    private final GenericPinpadController protocolo;
    Thread pinThread;
    private boolean emLeitura;

    public BibliotecaPinpad(String serial, String msgPrompt, String msgSenha, String msgAguardo) throws ExcecaoPerifericos {
        this.setMsgPrompt(msgPrompt);
        this.setMsgAguardo(msgAguardo);
        this.protocolo = PinpadDriverFactory.getInstance(serial);
    }

    public BibliotecaPinpad(String serial, String msgPrompt) throws ExcecaoPerifericos {
        this.setMsgPrompt(msgPrompt);
        this.protocolo = PinpadDriverFactory.getInstance(serial);
    }

    public static String formatReadTagCommand(int network, int function, String cardTag) throws ExcecaoApiAc {
        if (network != 4 && network != 3) {
            throw new ExcecaoApiAc("BP01", "Apenas \u00e9 poss\u00edvel ler as tags para as redes 3 e 4", "rede = " + network);
        }
        StringBuilder command = new StringBuilder();
        command.append(String.format("%02d", network));
        String commandData = network == 4 ? String.format("%02d%03d%s", function, cardTag.length() / 2, cardTag) : String.format("%02d%s", function, cardTag);
        command.append(String.format("%03d%s", commandData.length(), commandData));
        return command.toString();
    }

    @Override
    public boolean isLeitura() {
        return this.emLeitura;
    }

    @Override
    public void setMsgDisplay(String msg) throws ExcecaoPerifericos {
        if (!this.getHabilitado()) {
            this.protocolo.openCommunication();
        }
        this.protocolo.display(msg.toCharArray());
    }

    @Override
    public String getKey() {
        return this.getWorkingKey();
    }

    @Override
    public void desabilita() throws ExcecaoPerifericos {
        this.logger.debug("desabilita: desabilitando ");
        this.setHabilitado(false);
        this.logger.trace("desabilita: desabilitado");
    }

    @Deprecated
    public synchronized void desabilita(boolean liberaBBComp) throws ExcecaoPerifericos {
        this.logger.debug("desabilita: liberaBBComp: " + liberaBBComp);
        this.desabilita();
        this.logger.trace("desabilita: liberaBBComp: notifyAll()...");
        this.notifyAll();
    }

    @Override
    public synchronized void habilita() throws ExcecaoPerifericos {
        this.logger.debug(this.getClass().getName() + " -> Habilitando periferico...");
        this.protocolo.openCommunication();
        this.setHabilitado(true);
        this.logger.debug(this.getClass().getName() + " -> Periferico habilitado!");
        this.pinThread = new Thread(this);
        this.pinThread.start();
        this.notifyAll();
    }

    @Override
    @Deprecated
    public synchronized void liberaRecursos() throws ExcecaoPerifericos {
        this.logger.trace("liberaRecursos: Inicio()...");
        this.liberaRecursos(true);
        this.logger.trace("liberaRecursos: Finalizado");
    }

    public synchronized void liberaRecursos(boolean liberaBBComp) throws ExcecaoPerifericos {
        this.logger.trace("liberaRecursos: liberaBBComp: " + liberaBBComp);
        if (this.protocolo != null && this.protocolo.isCommunicationOpened()) {
            this.logger.trace("liberaRecursos: liberaBBComp: desabilita()...");
            this.desabilita(true);
            this.logger.trace("liberaRecursos: liberaBBComp: closeConnection()...");
            this.protocolo.closeConnection(liberaBBComp, this.getMsgPrompt().toCharArray());
        }
        if (liberaBBComp) {
            super.liberaRecursos();
        }
    }

    @Override
    public String getCardQualidade() throws ExcecaoPerifericos {
        this.logger.trace("getCardQualidade: abrindo comunicacao com leitor");
        this.protocolo.openCommunication();
        this.logger.trace("getCardQualidade: chamando getCardQualidade()...");
        SaidaGetCardQualidade result = this.protocolo.getCardQualidade();
        this.logger.trace("getCardQualidade: getCardQualidade validateReturn()...");
        ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "getCardQualidade");
        return result.getCardIdentifier();
    }

    @Override
    public String getDUKPT(int modoCriptografia, int indMKey) throws ExcecaoPerifericos {
        this.logger.trace("getDUKPT: abrindo comunicacao com leitor");
        this.protocolo.openCommunication();
        String cmdGetDUKPT = StringUtil.sprintf("%d%02d", new Object[]{modoCriptografia, indMKey});
        this.logger.trace("getDUKPT: chamando getDUKPT()...");
        SaidaGetDUKPTEMV result = this.protocolo.getDUKPT(cmdGetDUKPT.toCharArray());
        this.logger.trace("getDUKPT: getDUKPT validateReturn()...");
        ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "getDUKPT");
        return result.getKeySerialNumber();
    }

    @Override
    public String getTimeStampTabelas() throws ExcecaoPerifericos {
        this.logger.trace("getTimeStampTabelas: abrindo comunicacao com leitor");
        this.protocolo.openCommunication();
        this.logger.trace("getTimeStampTabelas: getTableVersionPinpad()...");
        return this.protocolo.getTableVersionPinpad();
    }

    public synchronized SaidaEncryptBufferEMV encryptBuffer(int tipoCriptografia, int indiceMasterKey, String workingKey, byte[] dados, byte[] initializationVector) throws ExcecaoPerifericos {
        this.logger.trace("encryptBuffer: abrindo comunicacao com leitor");
        this.protocolo.openCommunication();
        this.logger.trace("encryptBuffer: chamando encryptBuffer()...");
        SaidaEncryptBufferEMV saida = this.protocolo.encryptBuffer(tipoCriptografia, indiceMasterKey, workingKey, dados, initializationVector);
        this.logger.trace("encryptBuffer: encryptBuffer validateReturn()...");
        ProtocoloBibliotecaCompartilhada.validateReturn(saida.getRetorno(), "encryptBuffer");
        return saida;
    }

    private void executaLeitura() {
        this.emLeitura = true;
        this.logger.trace("executaLeitura: cmdLeitura: " + this.cmdLeitura);
        switch (this.cmdLeitura) {
            case 1: {
                this.esperaGoOnChip();
                break;
            }
            case 3: {
                this.esperaGetKey();
                break;
            }
            case 4: {
                this.esperaGenericCommand();
                break;
            }
            default: {
                this.esperaGetPin();
            }
        }
        this.emLeitura = false;
    }

    @Override
    public void run() {
        this.executaLeitura();
    }

    private char[] parmsGetPin() {
        Vector<Object> v = this.getParmsPedido();
        StringBuilder dados = new StringBuilder("" + v.size());
        for (int i = 0; i < v.size(); ++i) {
            dados.append(StringUtil.sprintf("%02d%02d%-32s", new Object[]{((DadoSolicitaPin)v.elementAt(i)).getTamMin(), ((DadoSolicitaPin)v.elementAt(i)).getTamMax(), ((DadoSolicitaPin)v.elementAt(i)).getMensagemSolicitacao()}));
        }
        this.resetParms();
        String numeroCartao = this.getNumeroCartaoCripto() != null && this.getNumeroCartaoCripto().trim().length() > 0 ? this.getNumeroCartaoCripto() : this.getNumeroCartao();
        String cmdGetPin = StringUtil.sprintf("%d%02d%-32s%02d%-19s%s", new Object[]{this.getTipoCriptografia(), this.getIndiceMasterKey(), this.getWorkingKey(), numeroCartao.trim().length(), numeroCartao, dados.toString()});
        return cmdGetPin.toCharArray();
    }

    private char[] parmsGetGenericCommand() throws ExcecaoApiAc {
        String cmdGetGenericCommand = this.hasReadTagData() ? BibliotecaPinpad.formatReadTagCommand(this.getTagNetwork(), this.getTagFunction(), this.getTagIndex()) : this.getBufferGenericCommand();
        return cmdGetGenericCommand.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeCard(String msg) throws ExcecaoPerifericos {
        SaidaRemoveCardEMV result;
        try {
            this.logger.trace("removeCard: abrindo comunicacao com leitor");
            this.protocolo.openCommunication();
            this.logger.trace("removeCard: chamando startRemoveCard()...");
            int retorno = this.protocolo.startRemoveCard(StringUtil.completaString(msg, 32, ' ', false).toCharArray());
            this.logger.trace("removeCard: startRemoveCard validateReturn()...");
            ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startRemoveCard");
            do {
                this.esperaSeEmSuspensao();
                this.logger.trace("removeCard: chamando removeCard()...");
                result = this.protocolo.removeCard();
                this.logger.trace("removeCard: removeCard validateReturn()...");
                ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "removeCard");
                if (result.getRetorno() != EMVResponseCode.PP_NOTIFY.getId().intValue() || result.getMsgNotify() == null || result.getMsgNotify().trim().length() <= 0) continue;
                this.logger.debug("removeCard: Notify 'removecar': " + result.getRetorno() + " - " + result.getMsgNotify() + ".");
                this.eventoOcorrido(EventBuilder.buildMessageEvent(this, result.getMsgNotify()));
            } while (result.getRetorno() == EMVResponseCode.PP_PROCESSING.getId().intValue() || result.getRetorno() == EMVResponseCode.PP_NOTIFY.getId().intValue());
        }
        finally {
            this.logger.trace("removeCard: chamando abort()...");
            int abort = this.protocolo.abort();
            this.logger.info("removeCard: abort:  " + abort);
        }
        ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "removeCard");
    }

    private synchronized void esperaGetPin() {
        try {
            SaidaGetPinEMV result;
            String functionName;
            int retorno;
            ProtocoloAbecs abecsProtocol;
            if (!this.getHabilitado()) {
                this.logger.trace("esperaGetPin: Nao habilitada");
                return;
            }
            if (this.protocolo instanceof ProtocoloAbecs && !this.isCapturaSenha() && this.isParmsPedidoValido()) {
                abecsProtocol = (ProtocoloAbecs)this.protocolo;
                DadoSolicitaPin dado = (DadoSolicitaPin)this.getParmsPedido().get(0);
                this.logger.trace("esperaGetPin: chamando startGetClearData()...");
                retorno = abecsProtocol.startGetClearData(ProtocoloAbecs.buildGetClearDataParameters(dado));
                this.logger.trace("esperaGetPin: startGetClearData validateReturn()...");
                ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startGetClearData");
                functionName = "getClearData";
            } else {
                this.logger.trace("esperaGetPin: chamando startGetPIN()...");
                retorno = this.protocolo.startGetPIN(this.parmsGetPin());
                this.logger.trace("esperaGetPin: startGetPin validateReturn()...");
                ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startGetPin");
                functionName = "getPin";
            }
            do {
                if (!this.getHabilitado()) {
                    this.logger.trace("esperaGetPin: chamando abort()...");
                    int abort = this.protocolo.abort();
                    this.logger.info("esperaGetPin: abort:  " + abort);
                    return;
                }
                if (this.protocolo instanceof ProtocoloAbecs && !this.isCapturaSenha() && functionName.equalsIgnoreCase("getClearData")) {
                    abecsProtocol = (ProtocoloAbecs)this.protocolo;
                    this.esperaSeEmSuspensao();
                    this.logger.trace("esperaGetPin: chamando getClearData()...");
                    SaidaGetClearData saidaGCD = abecsProtocol.getClearData();
                    String keySN = "                    ";
                    result = new SaidaGetPinEMV(saidaGCD.getRetorno(), saidaGCD.getValor(), keySN);
                    result.setRetorno(saidaGCD.getRetorno());
                    this.logger.info("esperaGetPin: Retorno 'getClearData()': " + result.getRetorno());
                } else {
                    this.esperaSeEmSuspensao();
                    this.logger.trace("esperaGetPin: chamando getPin()...");
                    result = this.protocolo.getPin();
                    this.logger.info("esperaGetPin: Retorno 'getPin()': " + result.getRetorno());
                }
                if (!this.emLeitura) {
                    this.logger.error("esperaGetKey: N\u00e3o esta em Leitura");
                    result = new SaidaGetPinEMV();
                    result.setRetorno(EMVResponseCode.PP_CANCEL.getId());
                    break;
                }
                this.logger.info("esperaGetKey: retorno " + functionName + " = " + result.getRetorno());
                if (result.getRetorno() != EMVResponseCode.PP_NOTIFY.getId().intValue()) continue;
                this.logger.debug("esperaGetKey: Notify " + functionName + ": " + result.getRetorno() + " - " + result.getMsgNotify() + ".");
                this.eventoOcorrido(EventBuilder.buildMessageEvent(this, result.getMsgNotify()));
            } while ((result.getRetorno() == EMVResponseCode.PP_PROCESSING.getId().intValue() || result.getRetorno() == EMVResponseCode.PP_NOTIFY.getId().intValue()) && this.getHabilitado());
            if (this.getHabilitado()) {
                this.setHabilitado(false);
                this.eventoOcorrido(EventBuilder.buildPinEvent(this, result.getRetorno() == EMVResponseCode.PP_CANCEL.getId().intValue(), result.getRetorno() != EMVResponseCode.PP_CANCEL.getId().intValue() && result.getRetorno() != EMVResponseCode.PP_OK.getId().intValue(), result.getRetorno(), this.getTipoCriptografia(), result));
            }
        }
        catch (InvalidDataException | ExcecaoPerifericos e) {
            this.setHabilitado(false);
            this.logger.error("Erro em 'esperaGetPin()': " + e.getMessage());
            this.eventoOcorrido(EventBuilder.buildPinEvent(this, false, true, 999, this.getTipoCriptografia(), null));
        }
    }

    private synchronized void esperaGetKey() {
        try {
            int result;
            if (!this.getHabilitado()) {
                this.logger.trace("esperaGetKey: Nao habilitada");
                return;
            }
            if (this.protocolo.isPinpadAbecs()) {
                int retorno = this.startCheckEvent();
                this.logger.trace("esperaGetKey: startCheckEvent validateReturn()...");
                ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startCheckEvent");
            } else {
                this.logger.trace("esperaGetKey: chamando startGetKey()...");
                int retorno = this.protocolo.startGetKey();
                this.logger.trace("esperaGetKey: startGetKey validateReturn()...");
                ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startGetKey");
            }
            do {
                if (!this.getHabilitado()) {
                    this.logger.trace("esperaGetKey: chamando abort()...");
                    int abort = this.protocolo.abort();
                    this.logger.info("esperaGetKey: abort:  " + abort);
                    return;
                }
                this.esperaSeEmSuspensao();
                if (this.protocolo.isPinpadAbecs()) {
                    this.logger.trace("esperaGetKey: chamando checkEvent()...");
                    SaidaCheckEventEMV saidaCEX = this.protocolo.checkEvent();
                    result = saidaCEX.getRetorno();
                    if (result == EMVResponseCode.PP_OK.getId()) {
                        result = Integer.parseInt(saidaCEX.getKeyboardEvent().getKey());
                    }
                } else {
                    this.logger.trace("esperaGetKey: chamando getKey()...");
                    result = this.protocolo.getKey();
                }
                this.logger.debug("Em 'esperaGetKey()'.");
                if (!this.emLeitura) {
                    this.logger.error("esperaGetKey: N\u00e3o esta em Leitura");
                    result = EMVResponseCode.PP_CANCEL.getId();
                    break;
                }
                this.logger.info("esperaGetKey: retorno: " + result);
            } while ((result == EMVResponseCode.PP_PROCESSING.getId() || result == EMVResponseCode.PP_NOTIFY.getId()) && this.getHabilitado());
            if (this.getHabilitado()) {
                this.setHabilitado(false);
                this.eventoOcorrido(EventBuilder.buildKeyEvent(this, result == EMVResponseCode.PP_CANCEL.getId(), result != EMVResponseCode.PP_CANCEL.getId() && result != EMVResponseCode.PP_OK.getId() && result != EMVResponseCode.PP_F1.getId() && result != EMVResponseCode.PP_F2.getId() && result != EMVResponseCode.PP_F3.getId() && result != EMVResponseCode.PP_F4.getId() && result != EMVResponseCode.PP_BACKSP.getId(), result, this.getTipoCriptografia()));
            }
        }
        catch (ExcecaoPerifericos e) {
            this.setHabilitado(false);
            this.eventoOcorrido(EventBuilder.buildPinEvent(this, false, true, 999, this.getTipoCriptografia(), null));
        }
        finally {
            this.setHabilitado(false);
        }
    }

    private synchronized void esperaGenericCommand() {
        try {
            SaidaGenericCmdEMV result;
            if (!this.getHabilitado()) {
                this.logger.trace("esperaGenericCommand: Nao habilitada");
                return;
            }
            this.logger.trace("esperaGenericCommand: chamando startGenericCmd()..");
            int retorno = this.protocolo.startGenericCmd(this.parmsGetGenericCommand());
            this.logger.trace("esperaGenericCommand: startGenericCmd validateReturn()..");
            ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startGetGenericCommand");
            do {
                if (!this.getHabilitado()) {
                    this.logger.trace("esperaGenericCommand: chamando abort()...");
                    int abort = this.protocolo.abort();
                    this.logger.info("esperaGenericCommand: abort:  " + abort);
                    return;
                }
                this.esperaSeEmSuspensao();
                this.logger.trace("esperaGenericCommand: chamando genericCmd()...");
                result = this.protocolo.genericCmd();
                if (!this.emLeitura) {
                    this.logger.error("esperaGenericCommand: N\u00e3o esta em Leitura");
                    result = new SaidaGenericCmdEMV();
                    result.setRetorno(EMVResponseCode.PP_CANCEL.getId());
                    break;
                }
                this.logger.info("esperaGenericCommand: retorno genericCmd: " + result.getRetorno());
                if (result.getRetorno() != EMVResponseCode.PP_NOTIFY.getId().intValue()) continue;
                this.logger.debug("esperaGenericCommand: Notify 'genericCmd': " + result.getRetorno() + " - " + result.getMsgNotify() + ".");
                this.eventoOcorrido(EventBuilder.buildMessageEvent(this, result.getMsgNotify()));
            } while ((result.getRetorno() == EMVResponseCode.PP_PROCESSING.getId().intValue() || result.getRetorno() == EMVResponseCode.PP_NOTIFY.getId().intValue()) && this.getHabilitado());
            if (this.getHabilitado()) {
                this.setHabilitado(false);
                this.eventoOcorrido(EventBuilder.buildGenericCommandEvent(this, result.getRetorno() == EMVResponseCode.PP_CANCEL.getId().intValue(), result.getRetorno() != EMVResponseCode.PP_CANCEL.getId().intValue() && result.getRetorno() != EMVResponseCode.PP_OK.getId().intValue(), result.getRetorno(), result));
            }
        }
        catch (ExcecaoApiAc e) {
            this.setHabilitado(false);
            this.logger.error("Erro em 'esperaGenericCommand': " + e.getMessage());
            this.eventoOcorrido(EventBuilder.buildPinEvent(this, false, true, 999, this.getTipoCriptografia(), null));
        }
    }

    private synchronized void esperaGoOnChip() {
        try {
            SaidaGoOnChipEMV result;
            if (!this.getHabilitado()) {
                this.logger.trace("esperaGoOnChip: Nao habilitada");
                return;
            }
            this.logger.trace("esperaGoOnChip: chamando startGoOnChip()...");
            int retorno = this.protocolo.startGoOnChip(this);
            this.logger.trace("esperaGoOnChip: validateReturn()...");
            ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startGoOnChip");
            do {
                if (!this.getHabilitado()) {
                    this.logger.trace("esperaGoOnChip: chamando abort()...");
                    int abort = this.protocolo.abort();
                    this.logger.info("esperaGoOnChip: abort:  " + abort);
                    return;
                }
                this.esperaSeEmSuspensao();
                this.logger.trace("esperaGoOnChip: chamando goOnChip()...");
                result = this.protocolo.goOnChip();
                if (!this.emLeitura) {
                    this.logger.error("esperaGoOnChip: N\u00e3o esta em Leitura");
                    result = new SaidaGoOnChipEMV();
                    result.setRetorno(EMVResponseCode.PP_CANCEL.getId());
                    break;
                }
                this.logger.info("esperaGoOnChip: retorno goOnChip: " + result.getRetorno());
                if (result.getRetorno() != EMVResponseCode.PP_NOTIFY.getId().intValue()) continue;
                this.logger.debug("esperaGoOnChip: Notify 'GoOnChip': " + result.getRetorno() + " - " + result.getMsgNotify() + ".");
                this.eventoOcorrido(EventBuilder.buildMessageEvent(this, result.getMsgNotify()));
            } while ((result.getRetorno() == EMVResponseCode.PP_PROCESSING.getId().intValue() || result.getRetorno() == EMVResponseCode.PP_NOTIFY.getId().intValue()) && this.getHabilitado());
            if (result.getRetorno() == EMVResponseCode.PP_OK.getId().intValue()) {
                this.esperaSeEmSuspensao();
            }
            if (this.getHabilitado()) {
                this.setHabilitado(false);
                this.eventoOcorrido(EventBuilder.buildReadChipEvent(this, result.getRetorno() == EMVResponseCode.PP_CANCEL.getId().intValue(), result.getRetorno() != EMVResponseCode.PP_CANCEL.getId().intValue() && result.getRetorno() != EMVResponseCode.PP_OK.getId().intValue(), result.getRetorno(), this.getTipoCriptografia(), result));
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.error((Object)("Erro em 'esperaGoOnChip()': " + e.getMessage()), e);
            this.setHabilitado(false);
            this.eventoOcorrido(EventBuilder.buildReadChipEvent(this, false, true, 999, this.getTipoCriptografia(), null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SaidaFinishChipEMV finishChip() {
        SaidaFinishChipEMV result;
        try {
            this.emLeitura = true;
            this.setHabilitado(true);
            BibliotecaPinpad bibliotecaPinpad = this;
            synchronized (bibliotecaPinpad) {
                if (!this.getHabilitado()) {
                    throw new ExcecaoPerifericos("BP03", "Pinpad nao habilitado na finish chip.");
                }
                this.logger.trace("finishChip: chamando startFinishChip()...");
                int retorno = this.protocolo.startFinishChip(this);
                this.logger.trace("finishChip: startFinishChip: validateReturn()...");
                ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startFinishChip");
            }
            do {
                bibliotecaPinpad = this;
                synchronized (bibliotecaPinpad) {
                    if (!this.getHabilitado()) {
                        this.logger.error("finishChip: chamando abort()...");
                        this.protocolo.abort();
                        this.logger.error("finishChip: retornando abort()");
                        throw new ExcecaoPerifericos("BP04", "Pinpad nao habilitado na finish chip.");
                    }
                    this.esperaSeEmSuspensao();
                    this.logger.trace("finishChip: chamando finishChip()...");
                    result = this.protocolo.finishChip();
                    this.logger.trace("finishChip: retorno finishChip(): " + result);
                    if (!this.emLeitura) {
                        this.logger.error("finishChip(): N\u00e3o esta em Leitura");
                        result = new SaidaFinishChipEMV();
                        result.setRetorno(EMVResponseCode.PP_CANCEL.getId());
                        break;
                    }
                }
                this.logger.trace("finishChip: startFinishChip validateReturn()...");
                ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "startFinishChip");
                if (result.getRetorno() != EMVResponseCode.PP_NOTIFY.getId().intValue()) continue;
                this.logger.debug("Notify 'finishChip': " + result.getRetorno() + " - " + result.getMsgNotify() + ".");
                this.eventoOcorrido(EventBuilder.buildMessageEvent(this, result.getMsgNotify()));
            } while ((result.getRetorno() == EMVResponseCode.PP_PROCESSING.getId().intValue() || result.getRetorno() == EMVResponseCode.PP_NOTIFY.getId().intValue()) && this.getHabilitado());
        }
        catch (ExcecaoPerifericos e) {
            this.logger.error((Object)"Erro em 'esperafinishChip()'!", e);
            result = new SaidaFinishChipEMV();
            result.setRetorno(EMVResponseCode.PP_ERROCARTAOABORT.getId());
        }
        finally {
            this.emLeitura = false;
            this.setHabilitado(false);
        }
        return result;
    }

    @Override
    public SaidaGetInfoEMV getInfo() throws ExcecaoPerifericos {
        this.protocolo.openCommunication();
        this.logger.trace("getInfo: chamando getInfoEMV()...");
        SaidaGetInfoEMV result = this.protocolo.getInfoEMV();
        this.logger.trace("getInfo: getInfoEMV validateReturn()...");
        ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "getInfoEMV");
        return result;
    }

    @Override
    public SaidaGetInfoVisanetEMV getInfoVisanet() {
        SaidaGetInfoVisanetEMV result;
        try {
            this.logger.debug("getInfoVisanet: abrindo comunicacao com leitor");
            this.protocolo.openCommunication();
            this.logger.trace("getInfoVisanet: chamando getInfoCieloEMV()...");
            result = this.protocolo.getInfoCieloEMV();
            this.logger.trace("getInfoVisanet: getInfoCieloEMV validateReturn()...");
            ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "getInfoCieloEMV");
        }
        catch (Exception e) {
            this.logger.warn("Erro em getInfoVisanet: " + e.getMessage());
            result = null;
        }
        return result;
    }

    @Override
    public SaidaGetInfoRedecardEMV getInfoRedecard() throws ExcecaoPerifericos {
        SaidaGetInfoRedecardEMV result;
        try {
            this.logger.debug("getInfoRedecard: abrindo comunicacao com leitor");
            this.protocolo.openCommunication();
            this.logger.trace("getInfoRedecard: chamando getInfoRedecardEMV()...");
            result = this.protocolo.getInfoRedecardEMV();
            this.logger.trace("getInfoRedecard: getInfoRedecardEMV validateReturn()...");
            ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "getInfoRedecardEMV");
            this.protocolo.display(this.getMsgPrompt().toCharArray());
        }
        catch (Exception e) {
            this.logger.warn("Erro em getInfoRedecard: " + e.getMessage());
            result = null;
        }
        return result;
    }

    @Override
    public DadosGetInfoRedeEMV getInfoRedeEMV(int rede) {
        DadosGetInfoRedeEMV result;
        try {
            this.logger.debug("getInfoRedeEMV: abrindo comunicacao com leitor");
            this.protocolo.openCommunication();
            this.logger.trace("getInfoRedeEMV: chamando getInfoAcquire()...");
            result = this.protocolo.getInfoAcquire(rede);
            String function = String.format("getInfoRedeEMV(%d)", rede);
            this.logger.trace("getInfoRedeEMV: getInfoRedeEMV validateReturn()...");
            ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), function);
        }
        catch (Exception e) {
            this.logger.warn("Erro em getInfoRedeEMV: " + e.getMessage());
            result = null;
        }
        return result;
    }

    @Override
    public int changeParameter(String parametrosTLV) throws ExcecaoPerifericos {
        this.logger.debug("changeParameter: abrindo comunicacao com leitor");
        this.protocolo.openCommunication();
        this.logger.trace("changeParameter: chamando changeParameter()...");
        int retorno = this.protocolo.changeParameter(parametrosTLV.toCharArray());
        this.logger.trace("changeParameter: changeParameter validateReturn()...");
        ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "changeParameter");
        return retorno;
    }

    @Override
    public SaidaGetTracks getTracks(String tracks, Integer ctfCryptoType, Integer keyIndex, String workingKey, byte[] initializationVector, byte[] rsaModule, byte[] rsaExponent, Integer openDigits) {
        if (!(this.protocolo instanceof ProtocoloAbecs)) {
            return null;
        }
        this.logger.trace("getTracks: chamando getTracks()...");
        return ((ProtocoloAbecs)this.protocolo).getTracks(tracks, ctfCryptoType, keyIndex, workingKey, initializationVector, rsaModule, rsaExponent, openDigits);
    }

    @Override
    public SaidaGetClearData getClearData() {
        try {
            if (!(this.protocolo instanceof ProtocoloAbecs)) {
                return null;
            }
            this.logger.debug("getClearData: abrindo comunicacao com leitor");
            this.protocolo.openCommunication();
            this.logger.trace("getClearData: chamando getClearData()...");
            SaidaGetClearData result = ((ProtocoloAbecs)this.protocolo).getClearData();
            this.logger.trace("getClearData: changeParameter getClearData()...");
            ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "getClearData");
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int startCheckEvent() {
        try {
            this.logger.trace("startCheckEvent: abrindo comunicacao com leitor");
            this.protocolo.openCommunication();
            this.logger.trace("startCheckEvent: chamando startCheckEvent()...");
            int result = this.protocolo.startCheckEvent(1, 0, 0, 0);
            this.logger.info("startCheckEvent: Retorno 'startCheckEvent()': " + result);
            this.logger.info("startCheckEvent: Retorno 'startCheckEvent()': " + result);
            return result;
        }
        catch (Throwable t) {
            return -1;
        }
    }

    @Override
    public SaidaCheckEventEMV checkEvent() {
        try {
            this.logger.trace("checkEvent: abrindo comunicacao com leitor");
            this.protocolo.openCommunication();
            this.logger.trace("checkEvent: chamando checkEvent()...");
            SaidaCheckEventEMV result = this.protocolo.checkEvent();
            this.logger.info("checkEvent: Retorno 'checkEvent()': " + result);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean containsKey(int keyType, CryptoKeyType cryptoKeyType, int keyIndex) throws ExcecaoPerifericos, ExcecaoNaoLocal {
        return this.protocolo.containsKey(keyType, cryptoKeyType, keyIndex);
    }

    public boolean isPinpadAbecs() {
        return this.protocolo.isPinpadAbecs();
    }
}

