/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emv;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.emv.ConstantesAbecs;
import com.csi.ctfclient.tools.devices.emv.SaidaCheckEventEMV;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloAbecs;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.emvfull.TLVProtocol;
import com.csi.ctfclient.tools.devices.generic.Ansi98Crypto;
import com.csi.ctfclient.tools.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public class SaidaGetCardEMV {
    public static final SimpleDateFormat sdfExpirationDate = new SimpleDateFormat("ddMMyy");
    private static final char delimitadorTrilha1 = '^';
    private static final char delimitadorTrilha2 = '=';
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(SaidaGetCardEMV.class);
    private int retorno;
    private int libUtilizada;
    private String trilha1 = "";
    private String trilha2 = "";
    private String trilha3 = "";
    private boolean cartaoComErro;
    private String erroCodigo;
    private String dadosEspecificosTrilha1 = "";
    private String numeroExternoCartao = "";
    private int tipoCartao = 0;
    private int statusUltLeitura = 0;
    private int tipoAplSelecionada = 0;
    private String aidSelecionado = "";
    private int idRedeAdquirente = 0;
    private String indRegistro = null;
    private int tamTrilha1 = 0;
    private int tamTrilha2 = 0;
    private int tamTrilha3 = 0;
    private int tamPAN = 0;
    private String PAN = "";
    private String PANCripto = "";
    private int tamPANTrilha1 = 0;
    private String PANTrilha1 = "";
    private int tamPANTrilha2 = 0;
    private String PANTrilha2 = "";
    private int appPANSequenceNumber = 0;
    private String appLabel = "";
    private int serviceCode = 0;
    private String cardholderName = "";
    private String appExpirationDate;
    private int tamNumeroExternoCartao = 0;
    private long saldo = 0L;
    private int issuerCountryCode = 0;
    private int tamDadosRestantes = 0;
    private String dadosRestantes = "";
    private String srvErrMsg;
    private int wCardType;
    private String wFlags = "";
    private int wPix;
    private int bIdCred;
    private boolean trilhasSemDelimitadores;
    private String msgNotify;
    private String tipoDispositivoCartao;
    private String ksnDadosTapOnPhone;
    private String trilha2CriptoTapOnPhone;
    private String panCriptoTapOnPhone;
    private String dataVencCriptoTapOnPhone;

    public SaidaGetCardEMV() {
    }

    public SaidaGetCardEMV(int retorno, char[] respostaDLL, char[] srvErrMsg, char[] msgNotify) {
        this.setRetorno(retorno);
        this.setRespostaDLL(new String(respostaDLL));
        this.setSrvErrMsg(new String(srvErrMsg));
        this.setMsgNotify(new String(msgNotify));
    }

    @Deprecated
    public SaidaGetCardEMV(boolean comErro, String erroCod, int tipoCartao, int statusUltLeitura, int tipoAplSelecionada, int idRedeAdquirente, String indRegistro, int tamTrilha1, String trilha1, int tamTrilha2, String trilha2, int tamTrilha3, String trilha3, int tamPAN, String PAN, int appPANSequenceNumber, String appLabel, int serviceCode, String cardholderName, Date appExpirationDate, int tamNumExternoCartao, String numExternoCartao, long saldo, int issuerCountryCode, int tamDadosRestantes, String dadosRestantes, String tipoDispositivoCartao) {
        this(comErro, erroCod, tipoCartao, statusUltLeitura, tipoAplSelecionada, idRedeAdquirente, indRegistro, tamTrilha1, trilha1, tamTrilha2, trilha2, tamTrilha3, trilha3, tamPAN, PAN, appPANSequenceNumber, appLabel, serviceCode, cardholderName, appExpirationDate, tamNumExternoCartao, numExternoCartao, saldo, issuerCountryCode, tamDadosRestantes, dadosRestantes, tipoDispositivoCartao, 0);
    }

    public SaidaGetCardEMV(boolean comErro, String erroCod, int tipoCartao, int statusUltLeitura, int tipoAplSelecionada, int idRedeAdquirente, String indRegistro, int tamTrilha1, String trilha1, int tamTrilha2, String trilha2, int tamTrilha3, String trilha3, int tamPAN, String PAN, int appPANSequenceNumber, String appLabel, int serviceCode, String cardholderName, Date appExpirationDate, int tamNumExternoCartao, String numExternoCartao, long saldo, int issuerCountryCode, int tamDadosRestantes, String dadosRestantes, String tipoDispositivoCartao, int libUtilizada) {
        this.tipoCartao = tipoCartao;
        this.statusUltLeitura = statusUltLeitura;
        this.tipoAplSelecionada = tipoAplSelecionada;
        this.idRedeAdquirente = idRedeAdquirente;
        this.indRegistro = indRegistro;
        this.tamTrilha1 = tamTrilha1;
        this.trilha1 = trilha1;
        this.tamTrilha2 = tamTrilha2;
        this.trilha2 = trilha2;
        this.tamTrilha3 = tamTrilha3;
        this.trilha3 = trilha3;
        this.tamPAN = tamPAN;
        this.PAN = PAN;
        this.appPANSequenceNumber = appPANSequenceNumber;
        this.appLabel = appLabel;
        this.serviceCode = serviceCode;
        this.cardholderName = cardholderName;
        this.tipoDispositivoCartao = tipoDispositivoCartao;
        this.tamNumeroExternoCartao = tamNumExternoCartao;
        this.numeroExternoCartao = numExternoCartao;
        this.saldo = saldo;
        this.issuerCountryCode = issuerCountryCode;
        this.tamDadosRestantes = tamDadosRestantes;
        this.dadosRestantes = dadosRestantes;
        this.cartaoComErro = comErro;
        this.erroCodigo = erroCod;
        if (appExpirationDate != null) {
            this.appExpirationDate = sdfExpirationDate.format(appExpirationDate);
        }
        this.libUtilizada = libUtilizada;
    }

    public int strResposta2Int(String array, int posIni, int posFim) {
        String tmp = array.substring(posIni, posFim);
        return Integer.parseInt(tmp);
    }

    public void setSrvErrMsg(String srvErrMsg) {
        this.srvErrMsg = srvErrMsg;
    }

    public String searchPanOfTrack(String track, char delimiter, int numberOfTrack) {
        int i = 0;
        StringBuilder bufferPAN = new StringBuilder();
        boolean foundTrack = false;
        if (numberOfTrack == 1 && track.charAt(0) != delimiter) {
            ++i;
        }
        while (i < track.length()) {
            if (track.charAt(i) == delimiter) {
                if (bufferPAN.length() <= 0) break;
                foundTrack = true;
                break;
            }
            bufferPAN.append(track.charAt(i));
            ++i;
        }
        return foundTrack ? bufferPAN.toString() : null;
    }

    public void setMagneticCheckEventAbecs(String t1, String t2, String t3) {
        String track;
        this.retorno = 0;
        this.tipoCartao = 0;
        int found = 0;
        this.trilha1 = t1;
        this.trilha2 = t2;
        this.trilha3 = t3;
        this.tamTrilha1 = t1 == null ? 0 : t1.length();
        if (this.tamTrilha1 > 0 && (track = this.searchPanOfTrack(this.trilha1, '^', 1)) != null) {
            this.PAN = this.PANTrilha1 = track;
            this.tamPAN = this.tamPANTrilha1 = track.length();
            found = 1;
        }
        this.tamTrilha2 = t2 == null ? 0 : t2.length();
        if (this.tamTrilha2 > 0 && (track = this.searchPanOfTrack(this.trilha2, '=', 2)) != null) {
            this.PAN = this.PANTrilha2 = track;
            this.tamPAN = this.tamPANTrilha2 = track.length();
            found = 2;
        }
        this.tamTrilha3 = t3 == null ? 0 : t3.length();
        if (found == 0) {
            String trilhaSemEspacos;
            if (this.trilha2 != null) {
                trilhaSemEspacos = this.trilha2.trim();
                found = 2;
            } else if (this.trilha1 != null) {
                trilhaSemEspacos = this.trilha1.trim();
                found = 1;
            } else {
                return;
            }
            if (trilhaSemEspacos.length() <= 19) {
                this.PAN = trilhaSemEspacos;
            } else {
                this.trilhasSemDelimitadores = true;
                this.PAN = trilhaSemEspacos.substring(0, 19);
            }
            this.PAN = this.PAN.trim();
            this.tamPAN = this.PAN.length();
            if (found == 2) {
                this.PANTrilha2 = this.PAN;
                this.tamPANTrilha2 = this.tamPAN;
            } else {
                this.PANTrilha1 = this.PAN;
                this.tamPANTrilha1 = this.tamPAN;
            }
        }
    }

    public void setMagneticCheckEvent(String strResp) {
        this.retorno = 0;
        this.tipoCartao = 0;
        this.tamTrilha1 = this.strResposta2Int(strResp, 1, 3);
        if (this.tamTrilha1 > 76) {
            this.tamTrilha1 = 76;
        }
        this.trilha1 = strResp.substring(3, 3 + this.tamTrilha1);
        this.tamTrilha2 = this.strResposta2Int(strResp, 79, 81);
        if (this.tamTrilha2 > 40) {
            this.tamTrilha2 = 40;
        }
        this.trilha2 = strResp.substring(81, 81 + this.tamTrilha2);
        this.tamTrilha3 = 104;
        this.trilha3 = strResp.substring(121, 121 + this.tamTrilha3).trim();
        int i = 0;
        StringBuilder bufferPAN = new StringBuilder();
        boolean achouDelimitadorTrilha1 = false;
        boolean achouDelimitadorTrilha2 = false;
        if (this.tamTrilha1 > 0) {
            if (this.trilha1.charAt(0) != '^') {
                ++i;
            }
            while (i < this.trilha1.length()) {
                if (this.trilha1.charAt(i) == '^') {
                    if (bufferPAN.length() <= 0) break;
                    achouDelimitadorTrilha1 = true;
                    break;
                }
                bufferPAN.append(this.trilha1.charAt(i));
                ++i;
            }
            if (achouDelimitadorTrilha1) {
                this.PANTrilha1 = bufferPAN.toString();
                this.tamPANTrilha1 = this.PAN.length();
            }
        }
        bufferPAN = new StringBuilder();
        if (this.tamTrilha2 > 0) {
            for (i = 0; i < this.trilha2.length(); ++i) {
                if (this.trilha2.charAt(i) == '=') {
                    achouDelimitadorTrilha2 = true;
                    break;
                }
                bufferPAN.append(this.trilha2.charAt(i));
            }
            if (achouDelimitadorTrilha2) {
                this.PANTrilha2 = bufferPAN.toString();
                this.tamPANTrilha2 = this.PANTrilha2.length();
            }
        }
        if (achouDelimitadorTrilha2) {
            this.PAN = this.PANTrilha2;
            this.tamPAN = this.tamPANTrilha2;
        } else if (achouDelimitadorTrilha1) {
            this.PAN = this.PANTrilha1;
            this.tamPAN = this.tamPANTrilha1;
        } else {
            String trilhaSemEspacos = this.trilha2.trim();
            if (trilhaSemEspacos.length() <= 19) {
                this.PAN = trilhaSemEspacos;
            } else {
                this.trilhasSemDelimitadores = true;
                if (ProtocoloBibliotecaCompartilhada.isSecureCommunication()) {
                    if (KeyFactory.isChaveLocal()) {
                        this.PAN = trilhaSemEspacos.substring(trilhaSemEspacos.length() - 19);
                    }
                } else {
                    this.PAN = trilhaSemEspacos.substring(0, 19);
                }
            }
            this.PAN = this.PAN.trim();
            this.tamPAN = this.PAN.length();
            this.PANTrilha2 = this.PAN;
            this.tamPANTrilha2 = this.tamPAN;
        }
    }

    public void setRespostaDLLAbecs(byte[] resp) {
        try {
            if (resp.length != 0) {
                logger.debug("Buffer SaidaGetCardEMV: " + StringUtil.byteArrayToSpacedHexStr(resp));
                this.libUtilizada = 48;
                String strTemp = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_CARDTYPE, resp);
                this.tipoCartao = Integer.parseInt(Objects.requireNonNull(strTemp));
                strTemp = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_ICCSTAT, resp);
                if (strTemp != null) {
                    this.statusUltLeitura = Integer.parseInt(strTemp);
                }
                if (this.tipoCartao != 0) {
                    strTemp = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_AIDTABINFO, resp);
                    this.idRedeAdquirente = Integer.parseInt(Objects.requireNonNull(strTemp).substring(0, 2));
                    this.indRegistro = strTemp.substring(2, 4);
                    this.tipoAplSelecionada = Integer.parseInt(strTemp.substring(4, 6));
                }
                this.trilha1 = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_TRK1INC, resp);
                if (this.trilha1 == null) {
                    this.tamTrilha1 = 0;
                    this.trilha1 = "";
                } else {
                    this.tamTrilha1 = this.trilha1.length();
                }
                this.trilha2 = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_TRK2INC, resp);
                if (this.trilha2 == null) {
                    this.tamTrilha2 = 0;
                    this.trilha2 = "";
                } else {
                    this.tamTrilha2 = this.trilha2.length();
                }
                this.trilha3 = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_TRK3INC, resp);
                if (this.trilha3 == null) {
                    this.tamTrilha3 = 0;
                    this.trilha3 = "";
                } else {
                    this.tamTrilha3 = this.trilha3.length();
                }
                this.PAN = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_PAN, resp);
                this.tamPAN = this.PAN != null ? this.PAN.length() : 0;
                strTemp = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_PANSEQNO, resp);
                this.appPANSequenceNumber = strTemp != null ? Integer.parseInt(strTemp) : 0;
                this.appLabel = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_LABEL, resp);
                this.cardholderName = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_CHNAME, resp);
                this.appExpirationDate = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_CARDEXP, resp);
                strTemp = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_ISSCNTRY, resp);
                if (strTemp != null) {
                    this.issuerCountryCode = Integer.parseInt(strTemp);
                }
                if ((strTemp = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_EMVDATA, resp)) != null) {
                    char[] appUsageControl;
                    char[] appIdentifier;
                    TLVProtocol tlvProtocol = new TLVProtocol(strTemp.toCharArray());
                    byte[] value = tlvProtocol.getTLVData(appIdentifier = new char[]{'\u0084'});
                    if (value != null) {
                        this.aidSelecionado = Ansi98Crypto.chaveBin2StrHex(value, value.length);
                    }
                    if ((value = tlvProtocol.getTLVData(appUsageControl = new char[]{'\u009f', '\u0007'})) != null) {
                        this.dadosRestantes = "9F0702" + Ansi98Crypto.chaveBin2StrHex(value, value.length);
                    }
                }
                this.tipoDispositivoCartao = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_DEVTYPE, resp);
                this.tamDadosRestantes = 0;
            } else {
                logger.warn("Buffer 'SaidaGetCardEMV' em branco!");
            }
        }
        catch (Throwable t) {
            logger.error("Nao foi poss\u00edvel montar SaidaGetCardEMV (ABECS): " + t.getMessage());
        }
    }

    public void setRespostaDLL(String strResp) {
        try {
            String PANRetornoPinpad;
            logger.debug("SaidaGetCardEMV :: setRespostaDLL :: strResp: " + strResp);
            this.libUtilizada = strResp.charAt(0);
            this.tipoCartao = this.strResposta2Int(strResp, 1, 3);
            this.statusUltLeitura = this.strResposta2Int(strResp, 3, 4);
            this.tipoAplSelecionada = this.strResposta2Int(strResp, 4, 6);
            this.idRedeAdquirente = this.strResposta2Int(strResp, 6, 8);
            this.indRegistro = strResp.substring(8, 10);
            this.tamTrilha1 = this.strResposta2Int(strResp, 10, 12);
            if (this.tamTrilha1 > 76) {
                this.tamTrilha1 = 76;
            }
            this.trilha1 = strResp.substring(12, 12 + this.tamTrilha1);
            this.tamTrilha2 = this.strResposta2Int(strResp, 88, 90);
            if (this.tamTrilha2 > 40) {
                this.tamTrilha2 = 40;
            }
            this.trilha2 = strResp.substring(90, 90 + this.tamTrilha2);
            this.tamTrilha3 = 104;
            this.trilha3 = strResp.substring(130, 130 + this.tamTrilha3).trim();
            this.tamPAN = this.strResposta2Int(strResp, 234, 236);
            if (this.tamPAN > 19) {
                this.tamPAN = 19;
            }
            this.PAN = PANRetornoPinpad = strResp.substring(236, 236 + this.tamPAN);
            int i = 0;
            StringBuilder bufferPAN = new StringBuilder();
            boolean achouDelimitadorTrilha1 = false;
            boolean achouDelimitadorTrilha2 = false;
            if (this.tamTrilha1 > 0) {
                if (this.trilha1.charAt(0) != '^') {
                    ++i;
                }
                while (i < this.trilha1.length()) {
                    if (this.trilha1.charAt(i) == '^') {
                        if (bufferPAN.length() <= 0) break;
                        achouDelimitadorTrilha1 = true;
                        break;
                    }
                    bufferPAN.append(this.trilha1.charAt(i));
                    ++i;
                }
                if (achouDelimitadorTrilha1) {
                    this.PANTrilha1 = bufferPAN.toString();
                    this.tamPANTrilha1 = this.PAN.length();
                }
            }
            bufferPAN = new StringBuilder();
            if (this.tamTrilha2 > 0) {
                for (i = 0; i < this.trilha2.length(); ++i) {
                    if (this.trilha2.charAt(i) == '=') {
                        achouDelimitadorTrilha2 = true;
                        break;
                    }
                    bufferPAN.append(this.trilha2.charAt(i));
                }
                if (achouDelimitadorTrilha2) {
                    this.PANTrilha2 = bufferPAN.toString();
                    this.tamPANTrilha2 = this.PANTrilha2.length();
                }
            }
            if (achouDelimitadorTrilha2) {
                this.PAN = this.PANTrilha2;
                this.tamPAN = this.tamPANTrilha2;
            } else if (achouDelimitadorTrilha1) {
                this.PAN = this.PANTrilha1;
                this.tamPAN = this.tamPANTrilha1;
            } else {
                String trilhaSemEspacos = this.trilha2.trim();
                if (trilhaSemEspacos.length() <= 19) {
                    this.PAN = trilhaSemEspacos;
                } else {
                    this.trilhasSemDelimitadores = true;
                    if (ProtocoloBibliotecaCompartilhada.isSecureCommunication()) {
                        if (KeyFactory.isChaveLocal()) {
                            this.PAN = trilhaSemEspacos.substring(trilhaSemEspacos.length() - 19);
                        }
                    } else {
                        this.PAN = trilhaSemEspacos.substring(0, 19);
                    }
                }
                this.PAN = this.PAN.trim();
                this.tamPAN = this.PAN.length();
                this.PANTrilha2 = this.PAN;
                this.tamPANTrilha2 = this.tamPAN;
            }
            if (PANRetornoPinpad.trim().length() != 0) {
                this.PAN = PANRetornoPinpad;
            }
            try {
                this.appPANSequenceNumber = Integer.parseInt(strResp.substring(255, 257));
            }
            catch (NumberFormatException e) {
                this.appPANSequenceNumber = 0;
            }
            this.appLabel = strResp.substring(257, 273);
            this.serviceCode = this.strResposta2Int(strResp, 273, 276);
            this.cardholderName = strResp.substring(276, 302);
            this.appExpirationDate = strResp.substring(302, 308);
            this.tamNumeroExternoCartao = this.strResposta2Int(strResp, 308, 310);
            if (this.tamNumeroExternoCartao > 19) {
                this.tamNumeroExternoCartao = 19;
            }
            this.numeroExternoCartao = strResp.substring(310, 310 + this.tamNumeroExternoCartao);
            this.saldo = this.strResposta2Int(strResp, 329, 337);
            try {
                this.issuerCountryCode = this.strResposta2Int(strResp, 337, 340);
            }
            catch (NumberFormatException e) {
                this.issuerCountryCode = 0;
            }
            this.tamDadosRestantes = this.strResposta2Int(strResp, 340, 343);
            if (this.tamDadosRestantes > 0) {
                this.dadosRestantes = strResp.substring(343, 343 + this.tamDadosRestantes);
            } else {
                this.tamDadosRestantes = 0;
            }
            if (this.tamDadosRestantes > 0) {
                try {
                    this.wCardType = this.strResposta2Int(strResp, 343 + this.tamDadosRestantes, 347 + this.tamDadosRestantes);
                    this.wFlags = strResp.substring(347 + this.tamDadosRestantes, 351 + this.tamDadosRestantes);
                    this.wPix = this.strResposta2Int(strResp, 351 + this.tamDadosRestantes, 355 + this.tamDadosRestantes);
                    this.bIdCred = this.strResposta2Int(strResp, 355 + this.tamDadosRestantes, 357 + this.tamDadosRestantes);
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable t) {
            logger.error("Nao foi possivel montar SaidaGetCardEMV: " + t.getMessage());
        }
    }

    public boolean getCartaoComErro() {
        return this.cartaoComErro;
    }

    public String getDadosEspecificosTrilha1() {
        return this.dadosEspecificosTrilha1;
    }

    public String getErroCodigo() {
        return this.erroCodigo;
    }

    public int getRetorno() {
        return this.retorno;
    }

    public void setRetorno(int retorno) {
        this.retorno = retorno;
    }

    public int getStatusUltLeitura() {
        return this.statusUltLeitura;
    }

    public void setStatusUltLeitura(int statusUltLeitura) {
        this.statusUltLeitura = statusUltLeitura;
    }

    public int getTipoAppSelecionada() {
        return this.tipoAplSelecionada;
    }

    public int getIdRedeAdquirente() {
        return this.idRedeAdquirente;
    }

    public String getIndRegistro() {
        return this.indRegistro;
    }

    public int getTamTrilha1() {
        return this.tamTrilha1;
    }

    public int getTamTrilha2() {
        return this.tamTrilha2;
    }

    public int getTamTrilha3() {
        return this.tamTrilha3;
    }

    public int getTamPAN() {
        return this.tamPAN;
    }

    public String getPAN() {
        return this.PAN;
    }

    public void setPAN(String pan) {
        this.PAN = pan;
    }

    public String getPANCripto() {
        return this.PANCripto;
    }

    public void setPANCripto(String panCripto) {
        this.PANCripto = panCripto;
    }

    public String getPANTrilha1() {
        return this.PANTrilha1;
    }

    public void setPANTrilha1(String panTrilha1) {
        this.PANTrilha1 = panTrilha1;
    }

    public String getPANTrilha2() {
        return this.PANTrilha2;
    }

    public void setPANTrilha2(String panTrilha2) {
        this.PANTrilha2 = panTrilha2;
    }

    public int getAppPANSequenceNumber() {
        return this.appPANSequenceNumber;
    }

    public int getCardType() {
        return this.wCardType;
    }

    public String getFlags() {
        return this.wFlags;
    }

    public int getPix() {
        return this.wPix;
    }

    public int getIdCred() {
        return this.bIdCred;
    }

    public String getAppLabel() {
        return this.appLabel;
    }

    public int getServiceCode() {
        return this.serviceCode;
    }

    public String getCardholderName() {
        return this.cardholderName;
    }

    public String getAppExpirationDate() {
        return this.appExpirationDate;
    }

    public int getTamNumeroExternoCartao() {
        return this.tamNumeroExternoCartao;
    }

    public long getSaldo() {
        return this.saldo;
    }

    public int getIssuerCountryCode() {
        return this.issuerCountryCode;
    }

    public int getTamDadosRestantes() {
        return this.tamDadosRestantes;
    }

    public String getDadosRestantes() {
        return this.dadosRestantes;
    }

    public String getNumeroExternoCartao() {
        return this.numeroExternoCartao;
    }

    public int getTipoCartao() {
        return this.tipoCartao;
    }

    public String getTrilha1() {
        return this.trilha1;
    }

    public void setTrilha1(String trilha1) {
        this.trilha1 = trilha1;
    }

    public String getTrilha2() {
        return this.trilha2;
    }

    public void setTrilha2(String trilha2) {
        this.trilha2 = trilha2;
    }

    public String getTrilha3() {
        return this.trilha3;
    }

    public void setTrilha3(String trilha3) {
        this.trilha3 = trilha3;
    }

    public String getMsgNotify() {
        return this.msgNotify;
    }

    public void setMsgNotify(String msgNotify) {
        this.msgNotify = msgNotify;
    }

    public boolean isTrilhasSemDelimitadores() {
        return this.trilhasSemDelimitadores;
    }

    public String getAidSelecionado() {
        return this.aidSelecionado;
    }

    public void setAidSelecionado(String aidSelecionado) {
        this.aidSelecionado = aidSelecionado;
    }

    public String getKsnDadosTapOnPhone() {
        return this.ksnDadosTapOnPhone;
    }

    public void setKsnDadosTapOnPhone(String ksnDadosTapOnPhone) {
        this.ksnDadosTapOnPhone = ksnDadosTapOnPhone;
    }

    public void setTrilha2CriptoTapOnPhone(String trilha2CriptoTapOnPhone) {
        this.trilha2CriptoTapOnPhone = trilha2CriptoTapOnPhone;
    }

    public String getPanCriptoTapOnPhone() {
        return this.panCriptoTapOnPhone;
    }

    public void setPanCriptoTapOnPhone(String panCriptoTapOnPhone) {
        this.panCriptoTapOnPhone = panCriptoTapOnPhone;
    }

    public String getDataVencCriptoTapOnPhone() {
        return this.dataVencCriptoTapOnPhone;
    }

    public void setDataVencCriptoTapOnPhone(String dataVencCriptoTapOnPhone) {
        this.dataVencCriptoTapOnPhone = dataVencCriptoTapOnPhone;
    }

    public String getTrilha2CriptoTapOnPhone() {
        return this.trilha2CriptoTapOnPhone;
    }

    public String toString() {
        return String.format("retorno=%d, libUtilizada=%s, cartaoComErro=%s, erroCodigo=%s, tipoCartao=%s, statusUltLeitura=%s, tipoAplSelecionada=%s, aidSelecionado=%s, idRedeAdquirente=%s, indRegistro=%s, tamTrilha1=%s, tamTrilha2=%s, tamTrilha3=%s, tamPAN=%s, tamPANTrilha1=%s, tamPANTrilha2=%s, appLabel=%s, serviceCode=%s, tamNumeroExternoCartao=%s, issuerCountryCode=%s, tamDadosRestantes=%s, srvErrMsg=%s, wCardType=%s, wFlags=%s, wPix=%s, bIdCred=%s, trilhasSemDelimitadores=%s, msgNotify=%s,tipoDispositivoCartao=%s", this.retorno, this.libUtilizada, this.cartaoComErro, this.erroCodigo, this.tipoCartao, this.statusUltLeitura, this.tipoAplSelecionada, this.aidSelecionado, this.idRedeAdquirente, this.indRegistro, this.tamTrilha1, this.tamTrilha2, this.tamTrilha3, this.tamPAN, this.tamPANTrilha1, this.tamPANTrilha2, this.appLabel, this.serviceCode, this.tamNumeroExternoCartao, this.issuerCountryCode, this.tamDadosRestantes, this.srvErrMsg, this.wCardType, this.wFlags, this.wPix, this.bIdCred, this.trilhasSemDelimitadores, this.msgNotify, this.tipoDispositivoCartao);
    }

    public String getTipoDispositivoCartao() {
        return this.tipoDispositivoCartao;
    }

    public static SaidaGetCardEMV buildWithMagneticCheckEvent(SaidaCheckEventEMV saidaCheckEventEMV) {
        SaidaGetCardEMV saidaGetCardEMV = new SaidaGetCardEMV();
        logger.trace("Criando saidaGetCardEMV a partir da saidaCheckEventEMV");
        if (saidaCheckEventEMV.getBufferResposta() != null) {
            logger.trace("SaidaGetCardEMV: BufferResposta: setMagneticCheckEvent");
            saidaGetCardEMV.setMagneticCheckEvent(saidaCheckEventEMV.getBufferResposta());
        } else {
            logger.trace("SaidaGetCardEMV: setMagneticCheckEventAbecs");
            saidaGetCardEMV.setMagneticCheckEventAbecs(saidaCheckEventEMV.getTrilha1Incompleta(), saidaCheckEventEMV.getTrilha2Incompleta(), saidaCheckEventEMV.getTrilha3Incompleta());
        }
        return saidaGetCardEMV;
    }
}

