/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emv;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.emv.ConstantesAbecs;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloAbecs;
import com.csi.ctfclient.tools.util.StringUtil;
import java.io.Serializable;

public class SaidaFinishChipEMV
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    private int retorno;
    private int decisao;
    private int tamDadosFinais;
    private String dadosFinais;
    private int tamIssuerScriptResults;
    private String IssuerScriptResults;
    private int tamDadosRestantes;
    private String dadosRestantes;
    private String msgNotify;

    public SaidaFinishChipEMV(int retorno, int decisao, int tamDadosFinais, String dadosFinais, int tamIssuerScriptResults, String issuerScriptResults, int tamDadosRestantes, String dadosRestantes, char[] msgNotify) {
        this.retorno = retorno;
        this.decisao = decisao;
        this.dadosFinais = dadosFinais;
        this.tamIssuerScriptResults = tamIssuerScriptResults;
        this.IssuerScriptResults = issuerScriptResults;
        this.tamDadosRestantes = tamDadosRestantes;
        this.dadosRestantes = dadosRestantes;
        this.msgNotify = new String(msgNotify);
    }

    public SaidaFinishChipEMV(int retorno, char[] resposta) {
        this.setRetorno(retorno);
        this.setRespostaDLL(new String(resposta));
    }

    public SaidaFinishChipEMV() {
    }

    public int getDecisao() {
        return this.decisao;
    }

    public int getTamDadosFinais() {
        return this.tamDadosFinais;
    }

    public String getDadosFinais() {
        return this.dadosFinais;
    }

    public int getTamIssuerScriptResults() {
        return this.tamIssuerScriptResults;
    }

    public String getIssuerScriptResults() {
        return this.IssuerScriptResults;
    }

    public int getTamDadosRestantes() {
        return this.tamDadosRestantes;
    }

    public String getDadosRestantes() {
        return this.dadosRestantes;
    }

    public int strResposta2Int(String array, int posIni, int tam) {
        String tmp = array.substring(posIni, tam);
        return Integer.parseInt(tmp);
    }

    public int getRetorno() {
        return this.retorno;
    }

    public void setRetorno(int retorno) {
        this.retorno = retorno;
    }

    public String getMsgNotify() {
        return this.msgNotify;
    }

    public void setMsgNotify(String msgNotify) {
        this.msgNotify = msgNotify;
    }

    public void setRespostaDLL(String strResp) {
        try {
            if (strResp != null && strResp.length() > 0) {
                this.decisao = strResp.charAt(0) - 48;
                this.tamDadosFinais = Integer.parseInt(strResp.substring(1, 4)) * 2;
                this.dadosFinais = strResp.substring(4, 4 + this.tamDadosFinais);
                int idx = 4 + this.tamDadosFinais;
                this.tamIssuerScriptResults = Integer.parseInt(strResp.substring(idx, idx + 2)) * 2;
                this.IssuerScriptResults = strResp.substring(idx += 2, idx + this.tamIssuerScriptResults);
                this.tamDadosRestantes = Integer.parseInt(strResp.substring(idx += this.tamIssuerScriptResults, idx + 3));
                this.dadosRestantes = strResp.substring(idx += 3);
            }
        }
        catch (Throwable t) {
            this.logger.error("Nao foi poss\u00edvel montar SaidaFinishChipEMV (BC): " + t.getMessage());
        }
    }

    public void setRespostaDLLAbecs(byte[] resp) {
        try {
            if (resp.length != 0) {
                byte[] dadosFinaisByte;
                this.logger.debug("Buffer SaidaFinishChipEMV: " + StringUtil.byteArrayToSpacedHexStr(resp));
                String fcxRes = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_FCXRES, resp);
                if (fcxRes != null) {
                    this.decisao = fcxRes.charAt(0) - 48;
                }
                if ((dadosFinaisByte = ProtocoloAbecs.getByteTag(ConstantesAbecs.PP_EMVDATA, resp)) != null) {
                    this.dadosFinais = StringUtil.byteArrayToHexString(dadosFinaisByte);
                    this.tamDadosFinais = this.dadosFinais.length();
                } else {
                    this.tamDadosFinais = 0;
                }
                byte[] issuerScriptsResultsByte = ProtocoloAbecs.getByteTag(ConstantesAbecs.PP_ISRESULTS, resp);
                if (issuerScriptsResultsByte != null) {
                    this.IssuerScriptResults = StringUtil.byteArrayToHexString(issuerScriptsResultsByte);
                    this.tamIssuerScriptResults = this.IssuerScriptResults.length();
                } else {
                    this.tamIssuerScriptResults = 0;
                }
                this.tamDadosRestantes = 0;
            } else {
                this.logger.warn("Buffer 'SaidaFinishChipEMV' em branco!");
            }
        }
        catch (Throwable t) {
            this.logger.error("Nao foi possivel montar SaidaFinishChipEMV (ABECS): " + t.getMessage());
        }
    }

    public String toString() {
        return String.format("retorno=%s, decisao=%s, tamDadosFinais=%s, dadosFinais=%s, tamIssuerScriptResults=%s, IssuerScriptResults=%s, tamDadosRestantes=%s, msgNotify=%s", this.retorno, this.decisao, this.tamDadosFinais, this.dadosFinais, this.tamIssuerScriptResults, this.IssuerScriptResults, this.tamDadosRestantes, this.msgNotify);
    }
}

