/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emv;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.emv.ConstantesAbecs;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloAbecs;
import com.csi.ctfclient.tools.util.ByteUtil;
import com.csi.ctfclient.tools.util.StringUtil;

public class SaidaEncryptBufferEMV {
    private AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    private int retorno;
    private String dadosCriptografados;
    private String keySerialNumber;

    public SaidaEncryptBufferEMV(int retorno, String dadosCriptografados) {
        this.retorno = retorno;
        this.dadosCriptografados = dadosCriptografados;
    }

    public SaidaEncryptBufferEMV(int retorno, char[] resposta) {
        this.setRespostaDLL(new String(resposta));
        this.setRetorno(retorno);
    }

    public SaidaEncryptBufferEMV() {
    }

    public int getRetorno() {
        return this.retorno;
    }

    public void setRetorno(int retorno) {
        this.retorno = retorno;
    }

    public String getDadosCriptografados() {
        return this.dadosCriptografados;
    }

    public void setDadosCriptografados(String value) {
        this.dadosCriptografados = value;
    }

    public void setRespostaDLL(String resposta) {
        this.dadosCriptografados = resposta;
    }

    public void setRespostaDLLAbecs(byte[] resp) {
        if (resp.length == 0) {
            this.logger.warn("Buffer 'SaidaEncryptBufferEMV' em branco!");
            return;
        }
        try {
            String dataOut = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_DATAOUT, resp);
            this.dadosCriptografados = ByteUtil.byteArrayToHex(StringUtil.stringToByteArray(dataOut));
            this.keySerialNumber = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_KSN, resp);
            if (this.keySerialNumber != null) {
                this.keySerialNumber = StringUtil.byteArrayToHexString(StringUtil.stringToByteArray(this.keySerialNumber));
            }
        }
        catch (Throwable t) {
            this.logger.error("Nao foi possivel montar SaidaEncryptBufferEMV: " + t.getMessage());
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.dadosCriptografados != null) {
            result.append("dadosCriptografados.length=").append(this.dadosCriptografados.length());
        }
        if (this.keySerialNumber != null) {
            result.append(" keySerialNumber.length=").append(this.keySerialNumber.length());
        }
        return result.toString();
    }

    public String getKeySerialNumber() {
        return this.keySerialNumber;
    }
}

