/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emv;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.emv.CardTechnologyType;
import com.csi.ctfclient.tools.devices.emv.ConstantesAbecs;
import com.csi.ctfclient.tools.devices.emv.PinpadKeyboardEventType;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloAbecs;
import com.csi.ctfclient.tools.util.StringUtil;

public class SaidaCheckEventEMV {
    private AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    private int retorno;
    private PinpadKeyboardEventType keyboardEvent;
    private CardTechnologyType cardTechnology;
    private String trilha1Incompleta;
    private String trilha2Incompleta;
    private String trilha3Incompleta;
    private String bufferResposta;

    public SaidaCheckEventEMV() {
    }

    public SaidaCheckEventEMV(int retorno, char[] resposta) {
        this.setRetorno(retorno);
        this.setBufferResposta(new String(resposta));
    }

    public void setRespostaDLLAbecs(byte[] resp) {
        try {
            if (resp.length != 0) {
                this.logger.debug("Buffer SaidaCheckEvent: " + StringUtil.byteArrayToSpacedHexStr(resp));
                this.keyboardEvent = PinpadKeyboardEventType.getEnumByCode(ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_EVENT, resp));
                if (this.keyboardEvent == null) {
                    String rawEvent = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_EVENT, resp);
                    if (rawEvent == null) {
                        this.logger.error("Nao foi possivel montar SaidaCheckEvent: Tag PP_EVENT ausente.");
                        return;
                    }
                    switch (rawEvent) {
                        case "90": {
                            this.cardTechnology = CardTechnologyType.MAGNETIC_STRIPE;
                            break;
                        }
                        case "91": {
                            this.cardTechnology = CardTechnologyType.CHIP_CARD_REMOVED;
                            break;
                        }
                        case "92": {
                            this.cardTechnology = CardTechnologyType.CHIP_CARD_INSERTED;
                            break;
                        }
                        case "93": {
                            this.cardTechnology = CardTechnologyType.CTLS_TIMEOUT;
                            break;
                        }
                        case "94": {
                            this.cardTechnology = CardTechnologyType.CTLS_DETECTED;
                        }
                    }
                }
                this.trilha1Incompleta = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_TRK1INC, resp);
                this.trilha2Incompleta = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_TRK2INC, resp);
                this.trilha3Incompleta = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_TRK3INC, resp);
            }
        }
        catch (Throwable t) {
            this.logger.error("Nao foi possivel montar SaidaCheckEvent: " + t.getMessage());
        }
    }

    public int getRetorno() {
        return this.retorno;
    }

    public void setRetorno(int retorno) {
        this.retorno = retorno;
    }

    public PinpadKeyboardEventType getKeyboardEvent() {
        return this.keyboardEvent;
    }

    public String getTrilha1Incompleta() {
        return this.trilha1Incompleta;
    }

    public String getTrilha2Incompleta() {
        return this.trilha2Incompleta;
    }

    public String getTrilha3Incompleta() {
        return this.trilha3Incompleta;
    }

    public String getBufferResposta() {
        return this.bufferResposta;
    }

    public void setBufferResposta(String bufferResposta) {
        if (bufferResposta.length() > 0) {
            this.bufferResposta = bufferResposta;
            switch (bufferResposta.charAt(0)) {
                case '0': {
                    this.keyboardEvent = PinpadKeyboardEventType.getEnumByCode(bufferResposta.substring(1, 3));
                    break;
                }
                case '1': {
                    this.cardTechnology = CardTechnologyType.MAGNETIC_STRIPE;
                    break;
                }
                case '2': {
                    if (bufferResposta.charAt(1) == '1') {
                        this.cardTechnology = CardTechnologyType.CHIP_CARD_INSERTED;
                        break;
                    }
                    this.cardTechnology = CardTechnologyType.CHIP_CARD_REMOVED;
                    break;
                }
                case '3': {
                    this.cardTechnology = bufferResposta.charAt(1) == '1' ? CardTechnologyType.CTLS_DETECTED : CardTechnologyType.CTLS_TIMEOUT;
                }
            }
        }
    }

    public CardTechnologyType getCardTechnology() {
        return this.cardTechnology;
    }

    public String toString() {
        return String.format("retorno=%s, keyboardEvent=%s, cardTechnology=%s", new Object[]{this.retorno, this.keyboardEvent, this.cardTechnology});
    }
}

