/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emv;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.EMVResponseCode;
import br.com.auttar.model.constants.LeituraCartaoEnum;
import br.com.auttar.model.constants.TipoTransacaoEfetuada;
import br.com.auttar.util.emv.AidUtils;
import br.com.auttar.util.emv.CheckEventResult;
import br.com.auttar.util.emv.CheckEventUtil;
import com.csi.ctfclient.apitef.model.Aid;
import com.csi.ctfclient.apitef.model.IdRedeIndiceTabela;
import com.csi.ctfclient.excecoes.ExcecaoInteiroInvalido;
import com.csi.ctfclient.operacoes.constantes.AidListType;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.DadosLeitorCartao;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDados;
import com.csi.ctfclient.tools.devices.emv.CardTechnologyType;
import com.csi.ctfclient.tools.devices.emv.EventoLeitorCartao;
import com.csi.ctfclient.tools.devices.emv.LeitorCartaoUtil;
import com.csi.ctfclient.tools.devices.emv.PinpadKeyboardEventType;
import com.csi.ctfclient.tools.devices.emv.SaidaCheckEventEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetCardEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetCardQualidade;
import com.csi.ctfclient.tools.devices.emvfull.GenericPinpadController;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.events.EventBuilder;
import com.csi.ctfclient.tools.util.AuttarSecurity;
import com.csi.ctfclient.tools.util.ClassUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.DisplayFisicoCSILanguage;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;

public class LeitorCartao
extends PerifericoEntradaDados
implements DadosLeitorCartao,
Runnable {
    public static int CARGA_TABELA_OK = 0;
    public static int CARGA_TABELA_TABEXP = 1;
    public static int CARGA_TABELA_SOLICITADA = 2;
    public static int ERRO_SOLICITA_CARGA_TABELA = 3;
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(LeitorCartao.class);
    private static GenericPinpadController protocolo;
    protected boolean trilha1Habilitada = true;
    protected boolean trilha2Habilitada = true;
    protected boolean trilha3Habilitada = true;
    protected String trilha1 = "";
    protected String trilha2 = "";
    protected String trilha3 = "";
    protected boolean rereading;
    private LeituraCartaoEnum actionLeituraCartao = null;
    private int idRedeAdquirente;
    private String indiceAID;
    private int tipoAplicacao;
    private TipoTransacaoEfetuada tipoTransacaoEfetuada;
    private long valorInicialTransacao;
    private Date dataTransacao;
    private String timeStamp;
    private List<IdRedeIndiceTabela> idsRedeIndTab;
    private boolean habilitaContactless;
    private int atualizandoTabelas = CARGA_TABELA_OK;
    private String priorityList;
    private String notPriorityList;
    private String fullList;
    private AidListType aidListType;
    private boolean emLeitura;
    private boolean activeContactless;
    private SaidaGetCardQualidade saidaCartaoMagneticoCheckEventQualidade;
    private final Object lockHabDesab = new Object();
    private boolean finalizado = false;
    private int lastGetCardResult;
    private int modalidadePagamento;
    private static LeitorCartao leitorCartao;
    private Map<IdRedeIndiceTabela, Aid> mapIdRedeIndiceAid;

    public static LeitorCartao getInstance(GenericPinpadController protocolo) {
        logger.trace("Instanciando LeitorCartao ");
        if (leitorCartao == null) {
            leitorCartao = new LeitorCartao(protocolo);
        } else if (ObjectUtils.notEqual(LeitorCartao.protocolo, protocolo)) {
            LeitorCartao.protocolo = protocolo;
        }
        leitorCartao.redefinirContextoLeitorCartao();
        logger.trace(MessageFormat.format("Retornando Instancia LeitorCartao  {0} {1} ", leitorCartao, LeitorCartao.protocolo));
        return leitorCartao;
    }

    @Override
    public synchronized void liberaRecursos() throws ExcecaoPerifericos {
        String thisSimpleClassName = ClassUtil.getSimpleClassName(this);
        logger.debug("{}: liberando recursos...", thisSimpleClassName);
        if (this.getHabilitado()) {
            this.desabilita();
        } else {
            logger.debug("{}: estava desabilitado", thisSimpleClassName);
        }
        logger.warn("{}: Thread de eventos nao finalizada pois leitor cartao \u00e9 um singleton", thisSimpleClassName);
    }

    private void redefinirContextoLeitorCartao() {
        logger.trace("resetContextLeitorCartao: Inicio");
        this.setIdRedeAdquirente(0);
        this.setTipoAplicacao(0);
        this.setTipoTransacaoEfetuada(null);
        this.setRereading(false);
        this.setIndiceAID(null);
        this.aidListType = null;
        this.setIdsRedeIndTab(null);
        this.setValorInicialTransacao(100L);
        this.setDataTransacao(new GregorianCalendar(2006, 0, 16).getTime());
        this.setTimeStamp("1602200602");
        this.setActionLeituraCartao(LeituraCartaoEnum.EMV);
        this.setActiveContactless(false);
        this.setSolicitaCargaTabelas(CARGA_TABELA_OK);
        this.lastGetCardResult = 0;
        logger.trace("resetContextLeitorCartao: Fim");
    }

    private LeitorCartao(GenericPinpadController protocolo) {
        LeitorCartao.protocolo = protocolo;
        new Thread(this).start();
    }

    public static String descriptografaPAN(String panCripto, boolean formatarEspacos) throws Exception {
        String panAberto;
        logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
        logger.debug("descriptografaPAN: inicio");
        int tamanhoPan = panCripto.length();
        logger.debug("descriptografaPAN: tamanhoPan: " + tamanhoPan);
        String panCripto16 = tamanhoPan > 16 ? panCripto.substring(tamanhoPan - 16, tamanhoPan) : panCripto;
        try {
            panAberto = AuttarSecurity.decrypt3DES(ProtocoloBibliotecaCompartilhada.getWkpan(), panCripto16);
        }
        catch (Exception e) {
            logger.error("descriptografaPAN: erro ao descriptografar 3DES - " + e.getMessage());
            throw e;
        }
        if (panAberto == null) {
            logger.error("descriptografaPAN: PAN nulo. WKPAN='" + ProtocoloBibliotecaCompartilhada.getWkpan() + "', lenght PAN cripto=" + panCripto16.length());
        }
        if (formatarEspacos && panAberto != null) {
            panAberto = LeitorCartao.desconverterPan(panAberto);
        }
        logger.debug("descriptografaPAN: fim");
        return panAberto;
    }

    public static String atualizaTrilha(String trilha, String panAntigo, String panNovo) {
        int index;
        String retorno = trilha;
        logger.trace("atualizaTrilha: Inicio");
        if (trilha != null && trilha.trim().length() > 0 && (index = trilha.indexOf(panAntigo)) != -1) {
            retorno = trilha.substring(0, index) + panNovo + trilha.substring(index + panAntigo.length());
        }
        logger.trace("atualizaTrilha: Fim");
        return retorno;
    }

    private static String desconverterPan(String pan) {
        int i;
        logger.debug("desconverterPan: Inicio");
        String panTemp = pan.replace('E', ' ');
        for (i = panTemp.length(); i > 0 && pan.startsWith("F", i - 1); --i) {
        }
        logger.debug("desconverterPan: Fim");
        return panTemp.substring(0, i);
    }

    public LeituraCartaoEnum getActionLeituraCartao() {
        return this.actionLeituraCartao;
    }

    @Override
    public void setActionLeituraCartao(LeituraCartaoEnum actionLeituraCartao) {
        this.actionLeituraCartao = actionLeituraCartao;
    }

    public boolean isActiveContactless() {
        return this.activeContactless;
    }

    @Override
    public void setActiveContactless(boolean activeContactless) {
        this.activeContactless = activeContactless;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug("Thread: inicio");
        while (!this.finalizado) {
            this.emLeitura = false;
            Object object = this.lockHabDesab;
            synchronized (object) {
                try {
                    logger.debug("Thread: aguardando habilitacao");
                    this.lockHabDesab.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.getHabilitado() || this.finalizado) {
                    continue;
                }
            }
            logger.debug("Thread: iniciando leitura");
            if (!protocolo.isCommunicationOpened()) {
                try {
                    logger.debug("Thread: abrindo comunicacao com leitor");
                    protocolo.openCommunication();
                }
                catch (Throwable t) {
                    logger.error("Thread: erro abrindo comunicacao com leitor!");
                    logger.error(t);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
            }
            this.emLeitura = true;
            try {
                if (this.actionLeituraCartao == LeituraCartaoEnum.QUALIDADE) {
                    logger.debug("Thread: chamando esperaGetCardQualidade()...");
                    this.esperaGetCardQualidade();
                    logger.debug("Thread: esperaGetCardQualidade() retornou");
                    continue;
                }
                logger.debug("Thread: chamando setAidLists()...");
                this.setAidLists();
                logger.debug("Thread: chamando tryUpdateContactlessByAids()...");
                this.tryUpdateContactlessByAids();
                logger.debug("Thread: iniciando loop leitura");
                CheckEventResult checkEventResult = null;
                do {
                    logger.debug("Thread: chamando callCheckEvent()...");
                    SaidaCheckEventEMV saidaCheckEventEMV = this.callCheckEvent(this.getCheckEventLabel(), 1, 1, 1, this.getCheckEventActivateContactless());
                    logger.debug(MessageFormat.format("Leitor cartao (thread): callCheckEvent() retornou {0}", saidaCheckEventEMV));
                    if (saidaCheckEventEMV != null) {
                        SaidaGetCardEMV saidaCartaoMagneticoCheckEvent = null;
                        if (CardTechnologyType.MAGNETIC_STRIPE == saidaCheckEventEMV.getCardTechnology()) {
                            saidaCartaoMagneticoCheckEvent = SaidaGetCardEMV.buildWithMagneticCheckEvent(saidaCheckEventEMV);
                        }
                        if ((checkEventResult = CheckEventUtil.getCheckEventResult(saidaCheckEventEMV, saidaCartaoMagneticoCheckEvent)) == CheckEventResult.CANCEL && CardTechnologyType.MAGNETIC_STRIPE == saidaCheckEventEMV.getCardTechnology()) {
                            protocolo.display(new DisplayFisicoCSILanguage().getMessage(MessageEnum.ERROR_MCDATA).toCharArray());
                            this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, EMVResponseCode.PP_MCDATAERR.getId()));
                        } else if (CardTechnologyType.CTLS_DETECTED == saidaCheckEventEMV.getCardTechnology()) {
                            this.aidListType = AidListType.ALL_AIDS;
                        }
                        if (checkEventResult != CheckEventResult.SUCCESS) continue;
                        logger.debug("Thread: chamando esperaGetCard()...");
                        this.esperaGetCard(Objects.requireNonNull(saidaCheckEventEMV).getCardTechnology(), saidaCartaoMagneticoCheckEvent);
                        logger.debug("Thread: esperaGetCard() retornou");
                        continue;
                    }
                    logger.warn("getCheckEventResult: cancelamento ou erro de pinpad");
                } while (checkEventResult == CheckEventResult.REDO);
                logger.debug("Thread: loop leitura encerrado");
            }
            catch (Throwable t) {
                logger.error("Thread: erro em processo de leitura!");
                logger.error(t);
            }
        }
        logger.debug("Leitor cartao (thread): fim");
    }

    public boolean isLeitura() {
        logger.trace("isEmLeitura " + this.emLeitura);
        return this.emLeitura;
    }

    public int getIdRedeAdquirente() {
        return this.idRedeAdquirente;
    }

    public void setIdRedeAdquirente(int idRede) {
        this.idRedeAdquirente = idRede;
    }

    public String getIndiceAID() {
        return this.indiceAID;
    }

    public void setIndiceAID(String indiceAID) {
        this.indiceAID = indiceAID;
    }

    public int getTipoAplicacao() {
        return this.tipoAplicacao;
    }

    @Override
    public void setTipoAplicacao(int tipoAplicacao) {
        this.tipoAplicacao = tipoAplicacao;
    }

    public TipoTransacaoEfetuada getTipoTransacaoEfetuada() {
        return this.tipoTransacaoEfetuada;
    }

    public void setTipoTransacaoEfetuada(TipoTransacaoEfetuada tipoTransacaoEfetuada) {
        this.tipoTransacaoEfetuada = tipoTransacaoEfetuada;
    }

    public long getValorInicialTransacao() {
        return this.valorInicialTransacao;
    }

    @Override
    public void setValorInicialTransacao(long valorInicial) {
        this.valorInicialTransacao = valorInicial;
    }

    public Date getDataTransacao() {
        return this.dataTransacao;
    }

    @Override
    public void setDataTransacao(Date dt) {
        this.dataTransacao = dt;
    }

    public SaidaGetCardQualidade getSaidaCartaoMagneticoCheckEventQualidade() {
        return this.saidaCartaoMagneticoCheckEventQualidade;
    }

    public void setSaidaCartaoMagneticoCheckEventQualidade(SaidaGetCardQualidade saidaCartaoMagneticoCheckEventQualidade) {
        this.saidaCartaoMagneticoCheckEventQualidade = saidaCartaoMagneticoCheckEventQualidade;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public boolean hasIdsRedIndTab() {
        return this.idsRedeIndTab != null && !this.idsRedeIndTab.isEmpty();
    }

    public List<IdRedeIndiceTabela> getIdsRedeIndTab(AidListType listType) {
        if (null == this.idsRedeIndTab || listType.equals((Object)AidListType.ALL_AIDS)) {
            return this.idsRedeIndTab;
        }
        boolean priority = listType.equals((Object)AidListType.PRIORITY_AIDS);
        ArrayList<IdRedeIndiceTabela> aidList = new ArrayList<IdRedeIndiceTabela>();
        for (IdRedeIndiceTabela idRedeIndTab : this.idsRedeIndTab) {
            Aid aid = this.getAidByIdRedeIndTab(idRedeIndTab);
            if (aid == null || aid.isPrioritario() != priority) continue;
            aidList.add(idRedeIndTab);
        }
        return aidList;
    }

    public void setIdsRedeIndTab(List<IdRedeIndiceTabela> ids) {
        this.idsRedeIndTab = ids;
    }

    public int getSolicitaCargaTabelas() {
        return this.atualizandoTabelas;
    }

    public void setSolicitaCargaTabelas(int atualizandoTabelas) {
        this.atualizandoTabelas = atualizandoTabelas;
    }

    public boolean isHabilitaContactless() {
        return this.habilitaContactless;
    }

    public void setHabilitaContactless(boolean habilitaContactless) {
        this.habilitaContactless = habilitaContactless;
    }

    public String getAidList() {
        switch (this.aidListType) {
            case PRIORITY_AIDS: {
                return this.priorityList;
            }
            case NOT_PRIORITY_AIDS: {
                return this.notPriorityList;
            }
            case ALL_AIDS: {
                return this.fullList;
            }
        }
        return null;
    }

    public int iniciaCargaTabelas(String timeStamp) throws ExcecaoPerifericos {
        logger.trace("Executa iniciaCargaTabelas - Inicio");
        protocolo.openCommunication();
        String cmdTableInit = "00" + timeStamp;
        logger.debug("rodando o comando com tableLoadInit " + cmdTableInit);
        int retorno = protocolo.tableLoadInit(cmdTableInit.toCharArray());
        ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "tableLoadInit");
        logger.trace("Executa iniciaCargaTabelas - fim");
        return retorno;
    }

    public int executaCargaTabelas(String tabela) throws ExcecaoPerifericos {
        logger.trace("Executa carga de tabelas - Inicio");
        int retorno = protocolo.tableLoadRec(tabela.toCharArray());
        ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "tableLoadRec");
        logger.trace("Executa carga de tabelas - fim");
        return retorno;
    }

    public int finalizaCargaTabelas() throws ExcecaoPerifericos {
        logger.trace("Finalizando carga de tabelas - Inicio");
        int retorno = protocolo.tableLoadEnd();
        ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "tableLoadEnd");
        logger.trace("Finalizando carga de tabelas - Fim");
        return retorno;
    }

    @Override
    public void desabilita() throws ExcecaoPerifericos {
        if (!this.getHabilitado() || this.finalizado) {
            logger.warn("desabilita: leitor ja' desabilitado ou finalizado");
            return;
        }
        logger.info("desabilita: inicio");
        this.setHabilitado(false);
        leitorCartao.redefinirContextoLeitorCartao();
        super.desabilita();
        if (protocolo.isCommunicationOpened() && this.emLeitura) {
            logger.debug("desabilita: em leitura, chamando abort");
            protocolo.abort();
        }
        logger.info("desabilita: leitor foi desabilitado");
    }

    public void resetSerial() {
        try {
            this.desabilita();
        }
        catch (Exception exception) {
            // empty catch block
        }
        protocolo.resetSerial();
        this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, EMVResponseCode.PP_COMMERR.getId()));
    }

    public void desabilitaTrilha(int numTrilha) throws ExcecaoInteiroInvalido {
        logger.debug("desabilitaTrilha: numTrilha: " + numTrilha);
        switch (numTrilha) {
            case 1: {
                this.trilha1Habilitada = false;
                break;
            }
            case 2: {
                this.trilha2Habilitada = false;
                break;
            }
            case 3: {
                this.trilha3Habilitada = false;
                break;
            }
            default: {
                throw new ExcecaoInteiroInvalido("PER62");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void habilita() throws ExcecaoPerifericos {
        if (this.getHabilitado() || this.finalizado) {
            logger.warn("habilita: leitor ja' habilitado ou finalizado");
            return;
        }
        logger.info("habilita: inicio");
        this.setHabilitado(true);
        Object object = this.lockHabDesab;
        synchronized (object) {
            logger.debug("habilita: notificando thread");
            this.lockHabDesab.notifyAll();
        }
        logger.info("habilita: leitor foi habilitado");
    }

    public void habilitaTrilha(int numTrilha) throws ExcecaoInteiroInvalido {
        logger.debug("habilitaTrilha: numTrilha: " + numTrilha);
        switch (numTrilha) {
            case 1: {
                this.trilha1Habilitada = true;
                break;
            }
            case 2: {
                this.trilha2Habilitada = true;
                break;
            }
            case 3: {
                this.trilha3Habilitada = true;
                break;
            }
            default: {
                throw new ExcecaoInteiroInvalido("PER62");
            }
        }
    }

    private void tryUpdateContactlessByAids() {
        List<IdRedeIndiceTabela> listIdRedIndTab = this.getIdsRedeIndTab(AidListType.ALL_AIDS);
        int listIdRedIndTabSize = listIdRedIndTab != null ? listIdRedIndTab.size() : 0;
        logger.debug("tryActiveContactlessByAids: listIdRedIndTabSize={}", listIdRedIndTabSize);
        if (listIdRedIndTabSize > 0) {
            logger.debug("tryActiveContactlessByAids: suportaContactless={}, habilitaContactless={}", protocolo.getInfoEMV().isSuportaContactless(), this.isHabilitaContactless());
            if (!protocolo.getInfoEMV().isSuportaContactless() || !this.isHabilitaContactless()) {
                this.activeContactless = false;
            } else if (!this.activeContactless) {
                this.activeContactless = this.hasAidValidForContacless();
            }
        }
        logger.debug("tryActiveContactlessByAids: activeContactless={}", this.activeContactless);
    }

    public boolean hasAidValidForContacless() {
        List<IdRedeIndiceTabela> listIdRedIndTab = this.getIdsRedeIndTab(AidListType.ALL_AIDS);
        BigDecimal transactionAmount = new BigDecimal(this.getValorInicialTransacao());
        logger.debug("hasAidValidForContacless: transactionAmount={}", transactionAmount);
        for (IdRedeIndiceTabela idRedIndTab : listIdRedIndTab) {
            logger.trace("Valida se ativa o contactless: idRedIndTab={}", idRedIndTab.getIdRedIndTab());
            if (!AidUtils.isContaclessOkForAmount(this.getAidByIdRedeIndTab(idRedIndTab), transactionAmount)) continue;
            logger.trace("Ativ\u00e1vel para idRedIndTab={}", idRedIndTab.getIdRedIndTab());
            return true;
        }
        return false;
    }

    private String formataIdsRedeIndTabs(AidListType listType) {
        logger.debug("formataIdsRedeIndTabs: listType={}", new Object[]{listType});
        List<IdRedeIndiceTabela> listIdRedIndTab = this.getIdsRedeIndTab(listType);
        AidUtils.hasIdRedeIndConflicts(listIdRedIndTab);
        return AidUtils.formatIdRedeIndTabListAsString(listIdRedIndTab);
    }

    private SaidaCheckEventEMV callCheckEvent(MessageEnum messageEnum, Integer checkKEY, Integer checkMAG, Integer checkICC, Integer checkCTLS) {
        logger.info("callCheckEvent: inicio");
        SaidaCheckEventEMV saidaCheckEventEMV = null;
        try {
            protocolo.display(new DisplayFisicoCSILanguage().getMessage(messageEnum).toCharArray());
            logger.debug("callCheckEvent: chamando startCheckEvent");
            int response = protocolo.startCheckEvent(checkKEY, checkMAG, checkICC, checkCTLS);
            logger.debug("callCheckEvent: chamando validateReturn");
            ProtocoloBibliotecaCompartilhada.validateReturn(response, "startCheckEvent");
            do {
                if (!this.getHabilitado()) {
                    logger.info("callCheckEvent: leitor desabilitado, abortando");
                    protocolo.abort();
                    return null;
                }
                this.esperaSeEmSuspensao();
                logger.debug("callCheckEvent: chamando checkEvent");
                saidaCheckEventEMV = protocolo.checkEvent();
                logger.info("callCheckEvent: retorno checkEvent = " + saidaCheckEventEMV.getRetorno());
                switch (EMVResponseCode.getEnumByKey(saidaCheckEventEMV.getRetorno())) {
                    case PP_CANCEL: {
                        this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, EMVResponseCode.PP_CANCEL.getId()));
                        return null;
                    }
                    case PP_MCDATAERR: {
                        this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, EMVResponseCode.PP_MCDATAERR.getId()));
                        return null;
                    }
                    case PP_COMMERR: 
                    case PP_NOTOPEN: 
                    case PP_RSPERR: {
                        this.resetSerial();
                        break;
                    }
                    case PP_OK: {
                        if (saidaCheckEventEMV.getKeyboardEvent() != PinpadKeyboardEventType.KEYBOARD_CANCEL) break;
                        this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, EMVResponseCode.PP_CANCEL.getId()));
                        break;
                    }
                }
            } while (saidaCheckEventEMV.getRetorno() == EMVResponseCode.PP_PROCESSING.getId().intValue());
        }
        catch (Exception e) {
            logger.error("callCheckEvent: erro! - " + e.getMessage());
            try {
                this.desabilita();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, 999));
        }
        logger.info("callCheckEvent: fim");
        return saidaCheckEventEMV;
    }

    private void esperaGetCardQualidade() {
        logger.info("esperaGetCardQualidade: inicio");
        try {
            SaidaGetCardQualidade result = this.getCardSyncQualidade();
            if (null == result) {
                logger.info("esperaGetCardQualidade: retorno getCardSyncQualidade e' nulo");
                return;
            }
            try {
                this.desabilita();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.eventoOcorrido(EventBuilder.buildCardReaderEvent((Periferico)this, result, result.getRetorno() != EMVResponseCode.PP_OK.getId().intValue(), result.getRetorno()));
        }
        catch (Exception e) {
            logger.error((Object)("esperaGetCardQualidade: erro! - Wkpan:'" + ProtocoloBibliotecaCompartilhada.getWkpan() + "', for\u00e7ando erro: 900"), e);
            try {
                this.desabilita();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, 900));
        }
        logger.info("esperaGetCardQualidade: fim");
    }

    private void esperaGetCard(CardTechnologyType cardTechnologyType, SaidaGetCardEMV saidaCartaoMagneticoCheckEvent) {
        block47: {
            boolean entradaCartaoMagnetico = cardTechnologyType == CardTechnologyType.MAGNETIC_STRIPE;
            logger.info("esperaGetCard: inicio");
            try {
                SaidaGetCardEMV result;
                if (entradaCartaoMagnetico) {
                    logger.trace("esperaGetCard: entradaCartaoMagnetico");
                    result = saidaCartaoMagneticoCheckEvent;
                    result.setStatusUltLeitura(this.getLastReadingStatus());
                } else {
                    result = this.getCardSync();
                    if (result != null) {
                        this.lastGetCardResult = result.getRetorno();
                    }
                }
                if (null == result) {
                    return;
                }
                if (!this.getHabilitado()) break block47;
                if (ProtocoloBibliotecaCompartilhada.isSecureCommunication()) {
                    if (KeyFactory.isChaveLocal()) {
                        if (result.getPAN().trim().length() > 12) {
                            String panAbertoParaReverter;
                            String panAbertoCompleto;
                            String panCripto16Trilha2;
                            String panCripto16Trilha1;
                            String panCripto = result.getPAN();
                            String panCriptoTrilha1 = result.getPANTrilha1();
                            String panCriptoTrilha2 = result.getPANTrilha2();
                            String panAberto = "";
                            try {
                                logger.trace("esperaGetCard: descriptografaPAN: panCripto");
                                panAberto = LeitorCartao.descriptografaPAN(panCripto, true);
                            }
                            catch (Exception e) {
                                logger.error("esperaGetCard: erro na descriptografia do pan");
                            }
                            String panAbertoTrilha1 = "";
                            String panAbertoTrilha2 = "";
                            if (panCriptoTrilha1 != null && !panCriptoTrilha1.equals("")) {
                                try {
                                    logger.trace("esperaGetCard: descriptografaPAN: panCriptoTrilha1");
                                    panAbertoTrilha1 = LeitorCartao.descriptografaPAN(panCriptoTrilha1, true);
                                }
                                catch (Exception e) {
                                    logger.error("esperaGetCard: erro na descriptografia do pan da trilha 1");
                                }
                            }
                            if (panCriptoTrilha2 != null && !panCriptoTrilha2.equals("")) {
                                try {
                                    logger.trace("esperaGetCard: descriptografaPAN: panCriptoTrilha2");
                                    panAbertoTrilha2 = LeitorCartao.descriptografaPAN(panCriptoTrilha2, true);
                                }
                                catch (Exception e) {
                                    logger.error("esperaGetCard: erro na descriptografia do pan da trilha 1");
                                }
                            }
                            if (!(panAbertoTrilha1 != null && panAbertoTrilha1.length() != 0 || panAbertoTrilha2 != null && panAbertoTrilha2.length() != 0)) {
                                logger.error(String.format("esperaGetCard: erro, nenhuma trilha foi descritografadas. Wkpan:'%s', for\u00e7ando erro: 68", ProtocoloBibliotecaCompartilhada.getWkpan()));
                                try {
                                    this.desabilita();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, 68));
                            }
                            if (panCriptoTrilha1 != null && panCriptoTrilha1.length() > 16) {
                                logger.trace("esperaGetCard: panCripto16Trilha1: panCriptoTrilha1 maior que 16");
                                panCripto16Trilha1 = panCriptoTrilha1.substring(panCriptoTrilha1.length() - 16);
                            } else {
                                logger.trace("esperaGetCard: panCripto16Trilha1: panCriptoTrilha1 menor que 16");
                                panCripto16Trilha1 = panCriptoTrilha1;
                            }
                            if (panCriptoTrilha2 != null && panCriptoTrilha2.length() > 16) {
                                logger.trace("esperaGetCard: panCripto16Trilha2: panCriptoTrilha2 maior que 16");
                                panCripto16Trilha2 = panCriptoTrilha2.substring(panCriptoTrilha2.length() - 16);
                            } else {
                                logger.trace("esperaGetCard: panCripto16Trilha2: panCriptoTrilha2 menor que 16");
                                panCripto16Trilha2 = panCriptoTrilha2;
                            }
                            if (panCripto16Trilha1.length() > 0) {
                                logger.trace("esperaGetCard: atualizaTrilha: Trilha1");
                                result.setTrilha1(LeitorCartao.atualizaTrilha(result.getTrilha1(), panCripto16Trilha1, panAbertoTrilha1));
                            }
                            if (panCripto16Trilha2.length() > 0) {
                                logger.trace("esperaGetCard: atualizaTrilha: Trilha2");
                                result.setTrilha2(LeitorCartao.atualizaTrilha(result.getTrilha2(), panCripto16Trilha2, panAbertoTrilha2));
                            }
                            if (panCripto.length() > 16) {
                                String restantePan = panCripto.substring(0, panCripto.length() - 16);
                                logger.debug("esperaGetCard: restante PAN = " + restantePan);
                                panAbertoCompleto = restantePan + panAberto;
                            } else {
                                logger.trace("esperaGetCard: panCripto menor que 16");
                                panAbertoCompleto = panAberto;
                            }
                            panAbertoCompleto = this.retiraEspacosPAN(panAbertoCompleto);
                            if (result.isTrilhasSemDelimitadores()) {
                                logger.info("esperaGetCard: delimitadores de trilhas nao encontrados, obtendo PAN do inicio da trilha...");
                                StringBuilder bufferPAN = new StringBuilder();
                                for (int i = 0; i < result.getTrilha2().length(); ++i) {
                                    if (Character.isDigit(result.getTrilha2().charAt(i))) {
                                        bufferPAN.append(result.getTrilha2().charAt(i));
                                    }
                                    if (bufferPAN.length() == 19) break;
                                }
                                panAbertoCompleto = bufferPAN.toString();
                                logger.info(String.format("esperaGetCard: obtidos os %d primeiros d\u00edgitos da trilha 2 para constituir o PAN", panAbertoCompleto.length()));
                            }
                            if (panAbertoCompleto.length() < 16) {
                                logger.trace("esperaGetCard: panAbertoParaReverter: panAbertoCompleto menor que 16");
                                panAbertoParaReverter = StringUtil.completaString(panAbertoCompleto, 16, 'F', 4);
                            } else if (panAbertoCompleto.length() > 16) {
                                logger.trace("esperaGetCard: panAbertoParaReverter: panAbertoCompleto maior que 16");
                                panAbertoParaReverter = panAbertoCompleto.substring(0, 16);
                            } else {
                                panAbertoParaReverter = panAbertoCompleto;
                            }
                            String pan3DESReverso = LeitorCartao.descriptografaPAN(panAbertoParaReverter, false);
                            if (panAbertoCompleto.length() > 16) {
                                String restantePan = panAbertoCompleto.substring(16);
                                logger.debug("esperaGetCard: restante PAN = " + restantePan);
                                pan3DESReverso = pan3DESReverso + restantePan;
                                logger.debug("esperaGetCard: PAN 3DES reverso = " + pan3DESReverso);
                            }
                            result.setPANCripto(pan3DESReverso);
                            result.setPAN(panAbertoCompleto);
                            logger.debug("esperaGetCard: descriptografia realizada com sucesso");
                        } else if (result.getRetorno() == 0) {
                            logger.debug("esperaGetCard: PAN < 13 digitos, trilhas nao serao descriptografadas");
                        }
                    }
                } else {
                    logger.trace("esperaGetCard: Tirando os espa\u00e7os do PAN");
                    result.setPAN(this.retiraEspacosPAN(result.getPAN()));
                }
                try {
                    this.desabilita();
                }
                catch (Exception panCripto) {
                    // empty catch block
                }
                if (protocolo.isPinpadAbecs() && result.getRetorno() == EMVResponseCode.PP_OK.getId().intValue() && result.getTipoCartao() == 0 && result.getTamTrilha1() == 0 && result.getTamTrilha2() == 0 && result.getTamTrilha3() == 0) {
                    logger.error("esperaGetCard: Erro na leitura das trilhas magneticas na GCX: PP_MCDATAERR: " + (Object)((Object)EMVResponseCode.PP_MCDATAERR));
                    protocolo.display(new DisplayFisicoCSILanguage().getMessage(MessageEnum.ERROR_MCDATA).toCharArray());
                    this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, EMVResponseCode.PP_MCDATAERR.getId()));
                    return;
                }
                this.eventoOcorrido(EventBuilder.buildCardReaderEvent((Periferico)this, result, result.getRetorno() != EMVResponseCode.PP_OK.getId().intValue() && result.getRetorno() != EMVResponseCode.PP_CANCEL.getId().intValue(), result.getRetorno()));
            }
            catch (ExcecaoPerifericos e) {
                logger.error("esperaGetCard: erro! - " + e.getMessage());
                try {
                    this.desabilita();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, 999));
            }
            catch (Exception e) {
                logger.error(String.format("esperaGetCard: erro! - Wkpan:'%s', for\u00e7ando erro: 900. Erro: %s", ProtocoloBibliotecaCompartilhada.getWkpan(), e.getMessage()));
                try {
                    this.desabilita();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, 900));
            }
        }
        logger.info("esperaGetCard: fim");
    }

    private synchronized SaidaGetCardQualidade getCardSyncQualidade() {
        if (!this.getHabilitado()) {
            logger.warn("getCardSyncQualidade: leitor desabilitado");
            return null;
        }
        logger.info("getCardSyncQualidade: inicio");
        SaidaGetCardQualidade retorno = this.callStartGetCardQualidade();
        if (!this.getHabilitado()) {
            logger.debug("getCardSyncQualidade: leitor desabilitado, chamando abort");
            protocolo.abort();
            return null;
        }
        logger.info("getCardSyncQualidade: retorno = " + (retorno != null ? Integer.valueOf(retorno.getRetorno()) : null));
        return retorno;
    }

    private synchronized SaidaGetCardEMV getCardSync() throws ExcecaoPerifericos {
        boolean doAgain;
        SaidaGetCardEMV retorno;
        if (!this.getHabilitado()) {
            logger.warn("getCardSync: leitor desabilitado");
            return null;
        }
        logger.info("getCardSync: inicio");
        this.callStartGetCard();
        do {
            doAgain = false;
            if (!this.getHabilitado()) {
                logger.info("getCardSync: leitor desabilitado, chamando abort");
                protocolo.abort();
                return null;
            }
            this.esperaSeEmSuspensao();
            logger.debug("getCardSync: chamando getCard");
            retorno = protocolo.getCard();
            logger.info("getCardSync: retorno getCard = " + retorno.getRetorno());
            this.esperaSeEmSuspensao();
            switch (EMVResponseCode.getEnumByKey(retorno.getRetorno())) {
                case PP_CANCEL: {
                    this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, EMVResponseCode.PP_CANCEL.getId()));
                    return null;
                }
                case PP_NOTIFY: {
                    this.eventoOcorrido(EventBuilder.buildMessageEvent(this, retorno.getMsgNotify()));
                    break;
                }
                case PP_TABEXP: {
                    this.setSolicitaCargaTabelas(CARGA_TABELA_TABEXP);
                    break;
                }
                case PP_COMMERR: 
                case PP_NOTOPEN: 
                case PP_RSPERR: {
                    this.resetSerial();
                    break;
                }
                case PP_CARDAPPNAV: {
                    if (this.aidListType != AidListType.PRIORITY_AIDS) break;
                    this.aidListType = AidListType.NOT_PRIORITY_AIDS;
                    if (Integer.parseInt(this.getAidList().substring(0, 2)) <= 0) break;
                    this.callStartGetCard();
                    doAgain = true;
                    break;
                }
                case PP_OK: {
                    if (protocolo.isPinpadAbecs()) break;
                    this.setSelectedAidByGetCard(retorno);
                    break;
                }
            }
        } while (retorno.getRetorno() == EMVResponseCode.PP_PROCESSING.getId().intValue() || retorno.getRetorno() == EMVResponseCode.PP_NOTIFY.getId().intValue() || doAgain);
        logger.info("getCardSync: fim");
        return retorno;
    }

    public void setSelectedAidByGetCard(SaidaGetCardEMV saidaGetCardEMV) {
        logger.debug("setSelectedAidByGetCard: inicio");
        String indice = saidaGetCardEMV.getIndRegistro();
        if (indice == null || saidaGetCardEMV.getIdRedeAdquirente() <= 0 || saidaGetCardEMV.getIdRedeAdquirente() > 99) {
            logger.info("setSelectedAidByGetCard: captura do AID abortada - dados insuficientes ou incorretos");
        } else {
            String idRede = String.format("%02d", saidaGetCardEMV.getIdRedeAdquirente());
            Aid aidAdicionado = this.getAidByIdRedeIndTab(IdRedeIndiceTabela.getInstance(idRede, indice));
            String selectedAID = aidAdicionado != null ? aidAdicionado.getApplicationId() : null;
            saidaGetCardEMV.setAidSelecionado(selectedAID);
            logger.info("setSelectedAidByGetCard: AID selecionado = " + selectedAID);
        }
        logger.debug("setSelectedAidByGetCard: fim");
    }

    private void callStartGetCard() throws ExcecaoPerifericos {
        int retorno;
        logger.info("callStartGetCard: inicio");
        if (this.getSolicitaCargaTabelas() == CARGA_TABELA_OK) {
            logger.info("callStartGetCard: AIDs selecionadas (" + this.aidListType.toString() + "): " + this.getAidList());
            retorno = protocolo.startGetCard(protocolo.buildStartGetCardParameters(this));
            if (LeitorCartaoUtil.isErrCommPinpad(retorno)) {
                this.resetSerial();
                return;
            }
        } else {
            retorno = 999;
        }
        ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startGetCard");
        logger.info("callStartGetCard: fim");
    }

    private SaidaGetCardQualidade callStartGetCardQualidade() {
        logger.info("callStartGetCardQualidade: inicio");
        SaidaCheckEventEMV saidaCheckEventEMV = this.callCheckEvent(MessageEnum.LEICAR_TITLE2, 1, 0, 1, 0);
        if (!Objects.isNull(saidaCheckEventEMV) && saidaCheckEventEMV.getCardTechnology() == CardTechnologyType.CHIP_CARD_INSERTED) {
            logger.info("callStartGetCardQualidade: fim");
            return protocolo.getCardQualidade();
        }
        logger.info("callStartGetCardQualidade: fim com nulo");
        return null;
    }

    private String retiraEspacosPAN(String pan) {
        logger.trace("retiraEspacosPAN: Inicio");
        if (pan != null) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < pan.length(); ++i) {
                if (pan.charAt(i) == ' ') continue;
                buffer.append(pan.charAt(i));
            }
            logger.trace("retiraEspacosPAN: Fim");
            return buffer.toString();
        }
        logger.trace("retiraEspacosPAN: Fim Nulo");
        return pan;
    }

    private void setAidLists() {
        logger.debug("setAidLists: inicio");
        this.fullList = this.formataIdsRedeIndTabs(AidListType.ALL_AIDS);
        this.tryUpdateContactlessByAids();
        logger.debug("setAidLists: AIDs={}", this.fullList);
        if (this.isRereading()) {
            this.aidListType = AidListType.ALL_AIDS;
            logger.debug("setAidLists: aidListType={}", new Object[]{this.aidListType});
        } else {
            this.priorityList = this.formataIdsRedeIndTabs(AidListType.PRIORITY_AIDS);
            logger.debug("setAidLists: AIDs priorit\u00e1rios={}", this.priorityList);
            this.notPriorityList = this.formataIdsRedeIndTabs(AidListType.NOT_PRIORITY_AIDS);
            logger.debug("setAidLists: AIDs n\u00e3o priorit\u00e1rios={}", this.notPriorityList);
            this.aidListType = AidListType.PRIORITY_AIDS;
            logger.debug("setAidLists: aidListType={}", new Object[]{this.aidListType});
        }
        logger.debug("setAidLists: fim");
    }

    private int getLastReadingStatus() {
        logger.debug("getLastReadingStatus: lastGetCardResult: " + this.lastGetCardResult);
        switch (EMVResponseCode.getEnumByKey(this.lastGetCardResult)) {
            case PP_DUMBCARD: 
            case PP_ERRCARD: 
            case PP_SAMERR: 
            case PPC_ERRFALBACK: {
                return 1;
            }
            case PP_CARDAPPNAV: {
                return 2;
            }
        }
        return 0;
    }

    public synchronized void erroOcorrido(int erro) {
        logger.trace("erroOcorrido: Inicio");
        if (!this.getHabilitado()) {
            logger.warn("erroOcorrido: leitor desabilitado");
            return;
        }
        EventoLeitorCartao evt = new EventoLeitorCartao(this, this.trilha1, this.trilha2, this.trilha3, true, erro);
        this.eventoOcorrido(evt);
        logger.trace("erroOcorrido: Evento Inserido");
    }

    @Override
    public long getTipoPeriferico() {
        return 8L;
    }

    public synchronized void cartaoLido(String trilha1, String trilha2, String trilha3, String dadosEspTr1, String flags, String nomePortCart, String numExtCart, int pix, int tipoCartao) {
        if (!this.getHabilitado()) {
            logger.warn("cartaoLido: leitor desabilitado");
            return;
        }
        EventoLeitorCartao evt = new EventoLeitorCartao(this, false, dadosEspTr1, 0, flags, nomePortCart, numExtCart, pix, tipoCartao, trilha1, trilha2, trilha3);
        this.eventoOcorrido(evt);
    }

    public int getModalidadePagamento() {
        return this.modalidadePagamento;
    }

    public synchronized void setModalidadePagamento(int newModalidadePagamento) {
        this.modalidadePagamento = newModalidadePagamento;
    }

    public boolean isRereading() {
        return this.rereading;
    }

    public void setRereading(boolean rereading) {
        this.rereading = rereading;
    }

    private MessageEnum getCheckEventLabel() {
        return this.activeContactless ? MessageEnum.LEICAR_TITLE_CONTACTLESS1 : MessageEnum.LEICAR_TITLE1;
    }

    private int getCheckEventActivateContactless() {
        return this.activeContactless ? 1 : 0;
    }

    public void finalizar() {
        this.finalizado = true;
        try {
            this.desabilita();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void buildMapIdRedeIndiceAid(List<Aid> aidsList) {
        logger.debug("setMapIritAidAdicinado: aidsList: " + aidsList);
        if (aidsList == null) {
            this.mapIdRedeIndiceAid = null;
        } else {
            this.mapIdRedeIndiceAid = new HashMap<IdRedeIndiceTabela, Aid>();
            for (Aid aid : aidsList) {
                for (Aid aidSimilar : aid.getAidSimilares()) {
                    this.mapIdRedeIndiceAid.put(aidSimilar.convertToIdRedIndTab(), aidSimilar);
                }
                this.mapIdRedeIndiceAid.put(aid.convertToIdRedIndTab(), aid);
            }
            logger.debug("setMapIritAidAdicinado: mapIritAidAdicinado : " + this.mapIdRedeIndiceAid);
        }
    }

    public Aid getAidByIdRedeIndTab(IdRedeIndiceTabela idRedeIndTab) {
        logger.debug("Tenta localizar idRedeIndTab {} dentre os AIDs adicionados na carga de tabelas", idRedeIndTab.getIdRedIndTab());
        if (this.mapIdRedeIndiceAid != null) {
            return this.mapIdRedeIndiceAid.get(idRedeIndTab);
        }
        return null;
    }
}

