/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emv;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.emv.ConstantesAbecs;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloAbecs;
import java.util.Arrays;

public class DadosGetInfoRedeEMV {
    public static final int AMEX = 1;
    public static final int REDECARD = 2;
    public static final int VISA = 3;
    public static final int OUTRAS = 4;
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(DadosGetInfoRedeEMV.class);
    private int retorno;
    private String resposta;
    private String redeCaptura;
    private String nomeRedeAdquirente;
    private String versaoAplicacao;
    private String informacoesProprietarias;
    private String identificacaoSAM;

    public DadosGetInfoRedeEMV() {
    }

    public DadosGetInfoRedeEMV(int retorno, char[] resposta) {
        this.retorno = retorno;
        this.resposta = new String(resposta);
        if (this.resposta.length() > 2) {
            this.redeCaptura = this.resposta.substring(0, 2);
        }
    }

    public String getRedeCaptura() {
        return this.redeCaptura;
    }

    public int getRetorno() {
        return this.retorno;
    }

    public void setRetorno(int retorno) {
        this.retorno = retorno;
    }

    public void setRespostaDLLAbecs(byte[] resp) {
        this.resposta = Arrays.toString(resp);
        if (resp.length == 0) {
            this.setRespostaDLL("");
            return;
        }
        try {
            this.nomeRedeAdquirente = "Abecs               ";
            String managerVersionTag = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_MANVERS, resp);
            this.versaoAplicacao = managerVersionTag != null ? managerVersionTag.trim() : null;
            this.informacoesProprietarias = String.format("%7s", ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_SPECVER, resp));
            this.identificacaoSAM = "";
        }
        catch (Throwable t) {
            this.logger.error("N\u00e3o foi possivel montar DadosGetInfoRedeEMV: " + t.getMessage());
        }
    }

    public String getRespostaDLL() {
        return this.resposta;
    }

    public void setRespostaDLL(String resposta) {
        this.resposta = resposta;
        try {
            if (resposta.length() == 0) {
                this.logger.warn("Pinpad n\u00e3o possui aplicacao da rede informada, ignorando...");
                resposta = "                                        00";
            }
            this.nomeRedeAdquirente = resposta.substring(0, 20);
            this.versaoAplicacao = resposta.substring(20, 33);
            this.informacoesProprietarias = resposta.substring(33, 40);
            int tamSAM = Integer.parseInt(resposta.substring(40, 42));
            this.identificacaoSAM = resposta.substring(42, 42 + tamSAM);
        }
        catch (Exception e) {
            this.logger.error("N\u00e3o foi possivel montar DadosGetInfoRedeEMV: " + e.getMessage());
        }
    }

    public String getNomeRedeAdquirente() {
        return this.nomeRedeAdquirente;
    }

    public void setNomeRedeAdquirente(String nomeRedeAdquirente) {
        this.nomeRedeAdquirente = nomeRedeAdquirente;
    }

    public String getVersaoAplicacao() {
        return this.versaoAplicacao;
    }

    public void setVersaoAplicacao(String versaoAplicacao) {
        this.versaoAplicacao = versaoAplicacao;
    }

    public String getInformacoesProprietarias() {
        return this.informacoesProprietarias;
    }

    public void setInformacoesProprietarias(String informacoesProprietarias) {
        this.informacoesProprietarias = informacoesProprietarias;
    }

    public String getIdentificacaoSAM() {
        return this.identificacaoSAM;
    }

    public void setIdentificacaoSAM(String identificacaoSAM) {
        this.identificacaoSAM = identificacaoSAM;
    }

    public String toString() {
        return String.format("retorno=%s, resposta=%s, redeCaptura=%s, nomeRedeAdquirente=%s, versaoAplicacao=%s, informacoesProprietarias=%s, identificacaoSam=%s", this.retorno, this.resposta, this.redeCaptura, this.nomeRedeAdquirente, this.versaoAplicacao, this.informacoesProprietarias, this.identificacaoSAM);
    }
}

