/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.config;

import com.csi.ctfclient.info.tiposgerais.Chave;
import com.csi.ctfclient.info.tiposgerais.ChaveString;
import com.csi.ctfclient.tools.devices.config.TeclaLayout;
import java.io.IOException;
import java.io.PrintWriter;

public class TecladoLayout {
    private boolean possuiShift;
    private String tipoTeclado;
    private String descricao;
    private TeclaLayout[] teclas;
    private Chave chave;

    public TecladoLayout(boolean possuiShift, String tipoTeclado, String descricao, TeclaLayout[] teclas) {
        this.possuiShift = possuiShift;
        this.tipoTeclado = tipoTeclado;
        this.descricao = descricao;
        this.teclas = teclas;
    }

    public Chave getChave() {
        if (this.chave != null) {
            this.chave = new ChaveString(this.descricao);
        }
        return this.chave;
    }

    public String getChaveString() {
        return this.descricao;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public boolean getPossuiShift() {
        return this.possuiShift;
    }

    public TeclaLayout[] getTeclas() {
        return this.teclas;
    }

    public String getTipoTeclado() {
        return this.tipoTeclado;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TecladoLayout[" + this.descricao + ", shift=" + this.possuiShift + "]\n");
        for (int i = 0; i < this.teclas.length; ++i) {
            sb.append("   ");
            sb.append(this.teclas[i].toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    public void toXML(int ident, PrintWriter writer) throws IOException {
        int i;
        for (i = 0; i < ident; ++i) {
            writer.print(' ');
        }
        writer.println("<TecladoLayout nome=\"" + this.descricao + "\" shift=" + this.possuiShift);
        for (i = 0; i < ident; ++i) {
            writer.print(' ');
        }
        writer.println("               tipo=\"" + this.tipoTeclado + "\">");
        for (i = 0; i < this.teclas.length; ++i) {
            this.teclas[i].toXML(ident + 3, writer);
        }
        for (i = 0; i < ident; ++i) {
            writer.print(' ');
        }
        writer.println("</TecladoLayout>");
    }
}

